/*
 * Decompiled with CFR 0.152.
 */
package sun.security.krb5.internal;

import java.io.IOException;
import sun.security.krb5.Asn1Exception;
import sun.security.krb5.internal.KerberosTime;
import sun.security.util.DerOutputStream;
import sun.security.util.DerValue;

public class LastReqEntry {
    private int lrType;
    private KerberosTime lrValue;

    private LastReqEntry() {
    }

    public LastReqEntry(int Type2, KerberosTime time) {
        this.lrType = Type2;
        this.lrValue = time;
    }

    public LastReqEntry(DerValue encoding) throws Asn1Exception, IOException {
        if (encoding.getTag() != 48) {
            throw new Asn1Exception(906);
        }
        DerValue der = encoding.getData().getDerValue();
        if ((der.getTag() & 0x1F) != 0) {
            throw new Asn1Exception(906);
        }
        this.lrType = der.getData().getBigInteger().intValue();
        this.lrValue = KerberosTime.parse(encoding.getData(), (byte)1, false);
        if (encoding.getData().available() > 0) {
            throw new Asn1Exception(906);
        }
    }

    public byte[] asn1Encode() throws Asn1Exception, IOException {
        DerOutputStream bytes = new DerOutputStream();
        DerOutputStream temp = new DerOutputStream();
        temp.putInteger(this.lrType);
        bytes.write(DerValue.createTag((byte)-128, true, (byte)0), temp);
        bytes.write(DerValue.createTag((byte)-128, true, (byte)1), this.lrValue.asn1Encode());
        temp = new DerOutputStream();
        temp.write((byte)48, bytes);
        return temp.toByteArray();
    }

    public Object clone() {
        LastReqEntry newEntry = new LastReqEntry();
        newEntry.lrType = this.lrType;
        newEntry.lrValue = this.lrValue;
        return newEntry;
    }
}

