/*
 * Decompiled with CFR 0.152.
 */
package sun.security.util;

import java.security.AccessController;
import java.security.AlgorithmConstraints;
import java.security.Security;
import java.util.Map;
import java.util.Set;
import sun.security.util.AlgorithmDecomposer;

public abstract class AbstractAlgorithmConstraints
implements AlgorithmConstraints {
    protected final AlgorithmDecomposer decomposer;

    protected AbstractAlgorithmConstraints(AlgorithmDecomposer decomposer) {
        this.decomposer = decomposer;
    }

    private static void loadAlgorithmsMap(Map<String, String[]> algorithmsMap, String propertyName) {
        String property = AccessController.doPrivileged(() -> Security.getProperty(propertyName));
        String[] algorithmsInProperty = null;
        if (property != null && !property.isEmpty()) {
            if (property.length() >= 2 && property.charAt(0) == '\"' && property.charAt(property.length() - 1) == '\"') {
                property = property.substring(1, property.length() - 1);
            }
            algorithmsInProperty = property.split(",");
            for (int i = 0; i < algorithmsInProperty.length; ++i) {
                algorithmsInProperty[i] = algorithmsInProperty[i].trim();
            }
        }
        if (algorithmsInProperty == null) {
            algorithmsInProperty = new String[]{};
        }
        algorithmsMap.put(propertyName, algorithmsInProperty);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static String[] getAlgorithms(Map<String, String[]> algorithmsMap, String propertyName) {
        Map<String, String[]> map = algorithmsMap;
        synchronized (map) {
            if (!algorithmsMap.containsKey(propertyName)) {
                AbstractAlgorithmConstraints.loadAlgorithmsMap(algorithmsMap, propertyName);
            }
            return algorithmsMap.get(propertyName);
        }
    }

    static boolean checkAlgorithm(String[] algorithms, String algorithm, AlgorithmDecomposer decomposer) {
        if (algorithm == null || algorithm.length() == 0) {
            throw new IllegalArgumentException("No algorithm name specified");
        }
        Set<String> elements = null;
        for (String item : algorithms) {
            if (item == null || item.isEmpty()) continue;
            if (item.equalsIgnoreCase(algorithm)) {
                return false;
            }
            if (elements == null) {
                elements = decomposer.decompose(algorithm);
            }
            for (String element : elements) {
                if (!item.equalsIgnoreCase(element)) continue;
                return false;
            }
        }
        return true;
    }
}

