/*
 * Decompiled with CFR 0.152.
 */
package com.sun.crypto.provider;

import java.security.ProviderException;

final class GHASH {
    private static final int AES_BLOCK_SIZE = 16;
    private final long subkeyH0;
    private final long subkeyH1;
    private long state0;
    private long state1;
    private long stateSave0;
    private long stateSave1;

    private static long getLong(byte[] buffer, int offset) {
        long result = 0L;
        int end = offset + 8;
        for (int i = offset; i < end; ++i) {
            result = (result << 8) + (long)(buffer[i] & 0xFF);
        }
        return result;
    }

    private static void putLong(byte[] buffer, int offset, long value) {
        int end = offset + 8;
        for (int i = end - 1; i >= offset; --i) {
            buffer[i] = (byte)value;
            value >>= 8;
        }
    }

    private void blockMult(long V0, long V1) {
        long carry;
        long mask;
        int i;
        long Z0 = 0L;
        long Z1 = 0L;
        long X = this.state0;
        for (i = 0; i < 64; ++i) {
            mask = X >> 63;
            Z0 ^= V0 & mask;
            Z1 ^= V1 & mask;
            mask = V1 << 63 >> 63;
            carry = V0 & 1L;
            V0 >>>= 1;
            V1 = V1 >>> 1 | carry << 63;
            V0 ^= 0xE100000000000000L & mask;
            X <<= 1;
        }
        X = this.state1;
        for (i = 64; i < 127; ++i) {
            mask = X >> 63;
            Z0 ^= V0 & mask;
            Z1 ^= V1 & mask;
            mask = V1 << 63 >> 63;
            carry = V0 & 1L;
            V0 >>>= 1;
            V1 = V1 >>> 1 | carry << 63;
            V0 ^= 0xE100000000000000L & mask;
            X <<= 1;
        }
        long mask2 = X >> 63;
        this.state0 = Z0 ^= V0 & mask2;
        this.state1 = Z1 ^= V1 & mask2;
    }

    GHASH(byte[] subkeyH) throws ProviderException {
        if (subkeyH == null || subkeyH.length != 16) {
            throw new ProviderException("Internal error");
        }
        this.subkeyH0 = GHASH.getLong(subkeyH, 0);
        this.subkeyH1 = GHASH.getLong(subkeyH, 8);
    }

    void reset() {
        this.state0 = 0L;
        this.state1 = 0L;
    }

    void save() {
        this.stateSave0 = this.state0;
        this.stateSave1 = this.state1;
    }

    void restore() {
        this.state0 = this.stateSave0;
        this.state1 = this.stateSave1;
    }

    private void processBlock(byte[] data, int ofs) {
        if (data.length - ofs < 16) {
            throw new RuntimeException("need complete block");
        }
        this.state0 ^= GHASH.getLong(data, ofs);
        this.state1 ^= GHASH.getLong(data, ofs + 8);
        this.blockMult(this.subkeyH0, this.subkeyH1);
    }

    void update(byte[] in) {
        this.update(in, 0, in.length);
    }

    void update(byte[] in, int inOfs, int inLen) {
        if (inLen - inOfs > in.length) {
            throw new RuntimeException("input length out of bound");
        }
        if (inLen % 16 != 0) {
            throw new RuntimeException("input length unsupported");
        }
        for (int i = inOfs; i < inOfs + inLen; i += 16) {
            this.processBlock(in, i);
        }
    }

    byte[] digest() {
        byte[] result = new byte[16];
        GHASH.putLong(result, 0, this.state0);
        GHASH.putLong(result, 8, this.state1);
        this.reset();
        return result;
    }
}

