/*
 * Decompiled with CFR 0.152.
 */
package sun.security.pkcs11;

import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.InvalidParameterException;
import java.security.ProviderException;
import java.security.SecureRandom;
import java.security.spec.AlgorithmParameterSpec;
import javax.crypto.KeyGeneratorSpi;
import javax.crypto.SecretKey;
import javax.crypto.spec.SecretKeySpec;
import sun.security.internal.spec.TlsPrfParameterSpec;
import sun.security.pkcs11.P11Key;
import sun.security.pkcs11.P11SecretKeyFactory;
import sun.security.pkcs11.P11Util;
import sun.security.pkcs11.Session;
import sun.security.pkcs11.Token;
import sun.security.pkcs11.wrapper.CK_MECHANISM;
import sun.security.pkcs11.wrapper.CK_TLS_MAC_PARAMS;
import sun.security.pkcs11.wrapper.CK_TLS_PRF_PARAMS;
import sun.security.pkcs11.wrapper.Functions;
import sun.security.pkcs11.wrapper.PKCS11Exception;

final class P11TlsPrfGenerator
extends KeyGeneratorSpi {
    private static final String MSG = "TlsPrfGenerator must be initialized using a TlsPrfParameterSpec";
    private final Token token;
    private final String algorithm;
    private final long mechanism;
    private TlsPrfParameterSpec spec;
    private P11Key p11Key;
    private static final SecretKey NULL_KEY = new SecretKey(){

        @Override
        public byte[] getEncoded() {
            return new byte[0];
        }

        @Override
        public String getFormat() {
            return "RAW";
        }

        @Override
        public String getAlgorithm() {
            return "Generic";
        }
    };

    P11TlsPrfGenerator(Token token, String algorithm, long mechanism) throws PKCS11Exception {
        this.token = token;
        this.algorithm = algorithm;
        this.mechanism = mechanism;
    }

    @Override
    protected void engineInit(SecureRandom random) {
        throw new InvalidParameterException(MSG);
    }

    @Override
    protected void engineInit(AlgorithmParameterSpec params, SecureRandom random) throws InvalidAlgorithmParameterException {
        if (!(params instanceof TlsPrfParameterSpec)) {
            throw new InvalidAlgorithmParameterException(MSG);
        }
        this.spec = (TlsPrfParameterSpec)params;
        SecretKey key = this.spec.getSecret();
        if (key == null) {
            key = NULL_KEY;
        }
        try {
            this.p11Key = P11SecretKeyFactory.convertKey(this.token, key, null);
        }
        catch (InvalidKeyException e) {
            throw new InvalidAlgorithmParameterException("init() failed", e);
        }
    }

    @Override
    protected void engineInit(int keysize, SecureRandom random) {
        throw new InvalidParameterException(MSG);
    }

    @Override
    protected SecretKey engineGenerateKey() {
        if (this.spec == null) {
            throw new IllegalStateException("TlsPrfGenerator must be initialized");
        }
        byte[] seed = this.spec.getSeed();
        if (this.mechanism == 996L) {
            SecretKeySpec k = null;
            int ulServerOrClient = 0;
            if (this.spec.getLabel().equals("server finished")) {
                ulServerOrClient = 1;
            }
            if (this.spec.getLabel().equals("client finished")) {
                ulServerOrClient = 2;
            }
            if (ulServerOrClient != 0) {
                CK_TLS_MAC_PARAMS params = new CK_TLS_MAC_PARAMS(Functions.getHashMechId(this.spec.getPRFHashAlg()), this.spec.getOutputLength(), ulServerOrClient);
                Session session2 = null;
                try {
                    session2 = this.token.getOpSession();
                    this.token.p11.C_SignInit(session2.id(), new CK_MECHANISM(this.mechanism, params), this.p11Key.keyID);
                    this.token.p11.C_SignUpdate(session2.id(), 0L, seed, 0, seed.length);
                    byte[] out = this.token.p11.C_SignFinal(session2.id(), this.spec.getOutputLength());
                    k = new SecretKeySpec(out, "TlsPrf");
                }
                catch (PKCS11Exception e) {
                    throw new ProviderException("Could not calculate PRF", e);
                }
                finally {
                    this.token.releaseSession(session2);
                }
            } else {
                throw new ProviderException("Only Finished message authentication code generation supported for TLS 1.2.");
            }
            return k;
        }
        byte[] label = P11Util.getBytesUTF8(this.spec.getLabel());
        if (this.mechanism == 2147484531L) {
            Session session = null;
            try {
                session = this.token.getOpSession();
                this.token.p11.C_SignInit(session.id(), new CK_MECHANISM(this.mechanism), this.p11Key.keyID);
                this.token.p11.C_SignUpdate(session.id(), 0L, label, 0, label.length);
                this.token.p11.C_SignUpdate(session.id(), 0L, seed, 0, seed.length);
                byte[] out = this.token.p11.C_SignFinal(session.id(), this.spec.getOutputLength());
                SecretKeySpec session2 = new SecretKeySpec(out, "TlsPrf");
                return session2;
            }
            catch (PKCS11Exception e) {
                throw new ProviderException("Could not calculate PRF", e);
            }
            finally {
                this.token.releaseSession(session);
            }
        }
        byte[] out = new byte[this.spec.getOutputLength()];
        CK_TLS_PRF_PARAMS params = new CK_TLS_PRF_PARAMS(seed, label, out);
        Session session = null;
        try {
            session = this.token.getOpSession();
            long keyID = this.token.p11.C_DeriveKey(session.id(), new CK_MECHANISM(this.mechanism, params), this.p11Key.keyID, null);
            SecretKeySpec secretKeySpec = new SecretKeySpec(out, "TlsPrf");
            return secretKeySpec;
        }
        catch (PKCS11Exception e) {
            throw new ProviderException("Could not calculate PRF", e);
        }
        finally {
            this.token.releaseSession(session);
        }
    }
}

