/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jmx.mbeanserver;

import com.sun.jmx.mbeanserver.Introspector;
import com.sun.jmx.mbeanserver.MBeanIntrospector;
import com.sun.jmx.mbeanserver.Util;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.management.NotCompliantMBeanException;

class MBeanAnalyzer<M> {
    private Map<String, List<M>> opMap = Util.newInsertionOrderMap();
    private Map<String, AttrMethods<M>> attrMap = Util.newInsertionOrderMap();

    void visit(MBeanVisitor<M> visitor) {
        for (Map.Entry<String, AttrMethods<M>> entry : this.attrMap.entrySet()) {
            String name = entry.getKey();
            AttrMethods<M> am = entry.getValue();
            visitor.visitAttribute(name, am.getter, am.setter);
        }
        for (Map.Entry<String, Object> entry : this.opMap.entrySet()) {
            for (Object m : (List)entry.getValue()) {
                visitor.visitOperation(entry.getKey(), m);
            }
        }
    }

    static <M> MBeanAnalyzer<M> analyzer(Class<?> mbeanType, MBeanIntrospector<M> introspector) throws NotCompliantMBeanException {
        return new MBeanAnalyzer<M>(mbeanType, introspector);
    }

    private MBeanAnalyzer(Class<?> mbeanType, MBeanIntrospector<M> introspector) throws NotCompliantMBeanException {
        if (!mbeanType.isInterface()) {
            throw new NotCompliantMBeanException("Not an interface: " + mbeanType.getName());
        }
        if (!Modifier.isPublic(mbeanType.getModifiers()) && !Introspector.ALLOW_NONPUBLIC_MBEAN) {
            throw new NotCompliantMBeanException("Interface is not public: " + mbeanType.getName());
        }
        try {
            this.initMaps(mbeanType, introspector);
        }
        catch (Exception x) {
            throw Introspector.throwException(mbeanType, x);
        }
    }

    private void initMaps(Class<?> mbeanType, MBeanIntrospector<M> introspector) throws Exception {
        List<Method> methods1 = introspector.getMethods(mbeanType);
        List<Method> methods = MBeanAnalyzer.eliminateCovariantMethods(methods1);
        for (Method method : methods) {
            AttrMethods<M> am;
            String name = method.getName();
            int nParams = method.getParameterTypes().length;
            Object cm = introspector.mFrom(method);
            String attrName = "";
            if (name.startsWith("get")) {
                attrName = name.substring(3);
            } else if (name.startsWith("is") && method.getReturnType() == Boolean.TYPE) {
                attrName = name.substring(2);
            }
            if (attrName.length() != 0 && nParams == 0 && method.getReturnType() != Void.TYPE) {
                am = this.attrMap.get(attrName);
                if (am == null) {
                    am = new AttrMethods();
                } else if (am.getter != null) {
                    String msg = "Attribute " + attrName + " has more than one getter";
                    throw new NotCompliantMBeanException(msg);
                }
                am.getter = cm;
                this.attrMap.put(attrName, am);
                continue;
            }
            if (name.startsWith("set") && name.length() > 3 && nParams == 1 && method.getReturnType() == Void.TYPE) {
                attrName = name.substring(3);
                am = this.attrMap.get(attrName);
                if (am == null) {
                    am = new AttrMethods();
                } else if (am.setter != null) {
                    String msg = "Attribute " + attrName + " has more than one setter";
                    throw new NotCompliantMBeanException(msg);
                }
                am.setter = cm;
                this.attrMap.put(attrName, am);
                continue;
            }
            List<Object> cms = this.opMap.get(name);
            if (cms == null) {
                cms = Util.newList();
            }
            cms.add(cm);
            this.opMap.put(name, cms);
        }
        for (Map.Entry entry : this.attrMap.entrySet()) {
            AttrMethods am = (AttrMethods)entry.getValue();
            if (introspector.consistent(am.getter, am.setter)) continue;
            String msg = "Getter and setter for " + (String)entry.getKey() + " have inconsistent types";
            throw new NotCompliantMBeanException(msg);
        }
    }

    static List<Method> eliminateCovariantMethods(List<Method> startMethods) {
        int len = startMethods.size();
        Method[] sorted = startMethods.toArray(new Method[len]);
        Arrays.sort(sorted, MethodOrder.instance);
        Set<Method> overridden = Util.newSet();
        for (int i = 1; i < len; ++i) {
            Method m0 = sorted[i - 1];
            Method m1 = sorted[i];
            if (!m0.getName().equals(m1.getName()) || !Arrays.equals(m0.getParameterTypes(), m1.getParameterTypes()) || overridden.add(m0)) continue;
            throw new RuntimeException("Internal error: duplicate Method");
        }
        List<Method> methods = Util.newList(startMethods);
        methods.removeAll(overridden);
        return methods;
    }

    private static class MethodOrder
    implements Comparator<Method> {
        public static final MethodOrder instance = new MethodOrder();

        private MethodOrder() {
        }

        @Override
        public int compare(Method a, Method b) {
            Class<?> bret;
            Object[] bparams;
            int cmp = a.getName().compareTo(b.getName());
            if (cmp != 0) {
                return cmp;
            }
            Object[] aparams = a.getParameterTypes();
            if (aparams.length != (bparams = b.getParameterTypes()).length) {
                return aparams.length - bparams.length;
            }
            if (!Arrays.equals(aparams, bparams)) {
                return Arrays.toString(aparams).compareTo(Arrays.toString(bparams));
            }
            Class<?> aret = a.getReturnType();
            if (aret == (bret = b.getReturnType())) {
                return 0;
            }
            if (aret.isAssignableFrom(bret)) {
                return -1;
            }
            return 1;
        }
    }

    private static class AttrMethods<M> {
        M getter;
        M setter;

        private AttrMethods() {
        }
    }

    static interface MBeanVisitor<M> {
        public void visitAttribute(String var1, M var2, M var3);

        public void visitOperation(String var1, M var2);
    }
}

