/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jndi.toolkit.url;

import com.sun.jndi.toolkit.url.UrlUtil;
import java.net.MalformedURLException;
import java.util.Hashtable;
import javax.naming.Binding;
import javax.naming.CannotProceedException;
import javax.naming.CompositeName;
import javax.naming.Context;
import javax.naming.InvalidNameException;
import javax.naming.Name;
import javax.naming.NameClassPair;
import javax.naming.NameParser;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.OperationNotSupportedException;
import javax.naming.spi.NamingManager;
import javax.naming.spi.ResolveResult;

public abstract class GenericURLContext
implements Context {
    protected Hashtable<String, Object> myEnv = null;

    public GenericURLContext(Hashtable<?, ?> env) {
        this.myEnv = (Hashtable)(env == null ? null : env.clone());
    }

    @Override
    public void close() throws NamingException {
        this.myEnv = null;
    }

    @Override
    public String getNameInNamespace() throws NamingException {
        return "";
    }

    protected abstract ResolveResult getRootURLContext(String var1, Hashtable<?, ?> var2) throws NamingException;

    protected Name getURLSuffix(String prefix, String url) throws NamingException {
        String suffix = url.substring(prefix.length());
        if (suffix.length() == 0) {
            return new CompositeName();
        }
        if (suffix.charAt(0) == '/') {
            suffix = suffix.substring(1);
        }
        try {
            return new CompositeName().add(UrlUtil.decode(suffix));
        }
        catch (MalformedURLException e) {
            throw new InvalidNameException(e.getMessage());
        }
    }

    protected String getURLPrefix(String url) throws NamingException {
        int start = url.indexOf(":");
        if (start < 0) {
            throw new OperationNotSupportedException("Invalid URL: " + url);
        }
        if (url.startsWith("//", ++start)) {
            int posn = url.indexOf("/", start += 2);
            start = posn >= 0 ? posn : url.length();
        }
        return url.substring(0, start);
    }

    protected boolean urlEquals(String url1, String url2) {
        return url1.equals(url2);
    }

    protected Context getContinuationContext(Name n) throws NamingException {
        Object obj = this.lookup(n.get(0));
        CannotProceedException cpe = new CannotProceedException();
        cpe.setResolvedObj(obj);
        cpe.setEnvironment(this.myEnv);
        return NamingManager.getContinuationContext(cpe);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object lookup(String name) throws NamingException {
        ResolveResult res = this.getRootURLContext(name, this.myEnv);
        try (Context ctx = (Context)res.getResolvedObj();){
            Object object = ctx.lookup(res.getRemainingName());
            return object;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object lookup(Name name) throws NamingException {
        if (name.size() == 1) {
            return this.lookup(name.get(0));
        }
        try (Context ctx = this.getContinuationContext(name);){
            Object object = ctx.lookup(name.getSuffix(1));
            return object;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void bind(String name, Object obj) throws NamingException {
        ResolveResult res = this.getRootURLContext(name, this.myEnv);
        try (Context ctx = (Context)res.getResolvedObj();){
            ctx.bind(res.getRemainingName(), obj);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void bind(Name name, Object obj) throws NamingException {
        if (name.size() == 1) {
            this.bind(name.get(0), obj);
        } else {
            try (Context ctx = this.getContinuationContext(name);){
                ctx.bind(name.getSuffix(1), obj);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void rebind(String name, Object obj) throws NamingException {
        ResolveResult res = this.getRootURLContext(name, this.myEnv);
        try (Context ctx = (Context)res.getResolvedObj();){
            ctx.rebind(res.getRemainingName(), obj);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void rebind(Name name, Object obj) throws NamingException {
        if (name.size() == 1) {
            this.rebind(name.get(0), obj);
        } else {
            try (Context ctx = this.getContinuationContext(name);){
                ctx.rebind(name.getSuffix(1), obj);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void unbind(String name) throws NamingException {
        ResolveResult res = this.getRootURLContext(name, this.myEnv);
        try (Context ctx = (Context)res.getResolvedObj();){
            ctx.unbind(res.getRemainingName());
        }
    }

    @Override
    public void unbind(Name name) throws NamingException {
        if (name.size() == 1) {
            this.unbind(name.get(0));
        } else {
            try (Context ctx = this.getContinuationContext(name);){
                ctx.unbind(name.getSuffix(1));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void rename(String oldName, String newName) throws NamingException {
        String newPrefix;
        String oldPrefix = this.getURLPrefix(oldName);
        if (!this.urlEquals(oldPrefix, newPrefix = this.getURLPrefix(newName))) {
            throw new OperationNotSupportedException("Renaming using different URL prefixes not supported : " + oldName + " " + newName);
        }
        ResolveResult res = this.getRootURLContext(oldName, this.myEnv);
        try (Context ctx = (Context)res.getResolvedObj();){
            ctx.rename(res.getRemainingName(), this.getURLSuffix(newPrefix, newName));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void rename(Name name, Name newName) throws NamingException {
        if (name.size() == 1) {
            if (newName.size() != 1) {
                throw new OperationNotSupportedException("Renaming to a Name with more components not supported: " + newName);
            }
            this.rename(name.get(0), newName.get(0));
        } else {
            if (!this.urlEquals(name.get(0), newName.get(0))) {
                throw new OperationNotSupportedException("Renaming using different URLs as first components not supported: " + name + " " + newName);
            }
            try (Context ctx = this.getContinuationContext(name);){
                ctx.rename(name.getSuffix(1), newName.getSuffix(1));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public NamingEnumeration<NameClassPair> list(String name) throws NamingException {
        ResolveResult res = this.getRootURLContext(name, this.myEnv);
        try (Context ctx = (Context)res.getResolvedObj();){
            NamingEnumeration<NameClassPair> namingEnumeration = ctx.list(res.getRemainingName());
            return namingEnumeration;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public NamingEnumeration<NameClassPair> list(Name name) throws NamingException {
        if (name.size() == 1) {
            return this.list(name.get(0));
        }
        try (Context ctx = this.getContinuationContext(name);){
            NamingEnumeration<NameClassPair> namingEnumeration = ctx.list(name.getSuffix(1));
            return namingEnumeration;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public NamingEnumeration<Binding> listBindings(String name) throws NamingException {
        ResolveResult res = this.getRootURLContext(name, this.myEnv);
        try (Context ctx = (Context)res.getResolvedObj();){
            NamingEnumeration<Binding> namingEnumeration = ctx.listBindings(res.getRemainingName());
            return namingEnumeration;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public NamingEnumeration<Binding> listBindings(Name name) throws NamingException {
        if (name.size() == 1) {
            return this.listBindings(name.get(0));
        }
        try (Context ctx = this.getContinuationContext(name);){
            NamingEnumeration<Binding> namingEnumeration = ctx.listBindings(name.getSuffix(1));
            return namingEnumeration;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void destroySubcontext(String name) throws NamingException {
        ResolveResult res = this.getRootURLContext(name, this.myEnv);
        try (Context ctx = (Context)res.getResolvedObj();){
            ctx.destroySubcontext(res.getRemainingName());
        }
    }

    @Override
    public void destroySubcontext(Name name) throws NamingException {
        if (name.size() == 1) {
            this.destroySubcontext(name.get(0));
        } else {
            try (Context ctx = this.getContinuationContext(name);){
                ctx.destroySubcontext(name.getSuffix(1));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Context createSubcontext(String name) throws NamingException {
        ResolveResult res = this.getRootURLContext(name, this.myEnv);
        try (Context ctx = (Context)res.getResolvedObj();){
            Context context = ctx.createSubcontext(res.getRemainingName());
            return context;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Context createSubcontext(Name name) throws NamingException {
        if (name.size() == 1) {
            return this.createSubcontext(name.get(0));
        }
        try (Context ctx = this.getContinuationContext(name);){
            Context context = ctx.createSubcontext(name.getSuffix(1));
            return context;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object lookupLink(String name) throws NamingException {
        ResolveResult res = this.getRootURLContext(name, this.myEnv);
        try (Context ctx = (Context)res.getResolvedObj();){
            Object object = ctx.lookupLink(res.getRemainingName());
            return object;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object lookupLink(Name name) throws NamingException {
        if (name.size() == 1) {
            return this.lookupLink(name.get(0));
        }
        try (Context ctx = this.getContinuationContext(name);){
            Object object = ctx.lookupLink(name.getSuffix(1));
            return object;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public NameParser getNameParser(String name) throws NamingException {
        ResolveResult res = this.getRootURLContext(name, this.myEnv);
        try (Context ctx = (Context)res.getResolvedObj();){
            NameParser nameParser = ctx.getNameParser(res.getRemainingName());
            return nameParser;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public NameParser getNameParser(Name name) throws NamingException {
        if (name.size() == 1) {
            return this.getNameParser(name.get(0));
        }
        try (Context ctx = this.getContinuationContext(name);){
            NameParser nameParser = ctx.getNameParser(name.getSuffix(1));
            return nameParser;
        }
    }

    @Override
    public String composeName(String name, String prefix) throws NamingException {
        if (prefix.equals("")) {
            return name;
        }
        if (name.equals("")) {
            return prefix;
        }
        return prefix + "/" + name;
    }

    @Override
    public Name composeName(Name name, Name prefix) throws NamingException {
        Name result = (Name)prefix.clone();
        result.addAll(name);
        return result;
    }

    @Override
    public Object removeFromEnvironment(String propName) throws NamingException {
        if (this.myEnv == null) {
            return null;
        }
        return this.myEnv.remove(propName);
    }

    @Override
    public Object addToEnvironment(String propName, Object propVal) throws NamingException {
        if (this.myEnv == null) {
            this.myEnv = new Hashtable(11, 0.75f);
        }
        return this.myEnv.put(propName, propVal);
    }

    public Hashtable<String, Object> getEnvironment() throws NamingException {
        if (this.myEnv == null) {
            return new Hashtable<String, Object>(5, 0.75f);
        }
        return (Hashtable)this.myEnv.clone();
    }
}

