/*
 * Decompiled with CFR 0.152.
 */
package java.lang.reflect;

import java.io.Serializable;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Modifier;
import java.lang.reflect.ReflectPermission;
import java.security.AccessController;
import java.security.Permission;
import java.security.PrivilegedAction;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;
import sun.misc.ProxyGenerator;
import sun.reflect.CallerSensitive;
import sun.reflect.Reflection;
import sun.reflect.misc.ReflectUtil;
import sun.security.util.SecurityConstants;

public class Proxy
implements Serializable {
    private static final long serialVersionUID = -2222568056686623797L;
    private static final String proxyClassNamePrefix = "$Proxy";
    private static final Class[] constructorParams = new Class[]{InvocationHandler.class};
    private static Map<ClassLoader, Map<List<String>, Object>> loaderToCache = new WeakHashMap<ClassLoader, Map<List<String>, Object>>();
    private static Object pendingGenerationMarker = new Object();
    private static long nextUniqueNumber = 0L;
    private static Object nextUniqueNumberLock = new Object();
    private static Map<Class<?>, Void> proxyClasses = Collections.synchronizedMap(new WeakHashMap());
    protected InvocationHandler h;

    private Proxy() {
    }

    protected Proxy(InvocationHandler h) {
        this.doNewInstanceCheck();
        this.h = h;
    }

    private void doNewInstanceCheck() {
        SecurityManager sm = System.getSecurityManager();
        Class<?> proxyClass = this.getClass();
        if (sm != null && ProxyAccessHelper.needsNewInstanceCheck(proxyClass)) {
            try {
                sm.checkPermission(ProxyAccessHelper.PROXY_PERMISSION);
            }
            catch (SecurityException e) {
                throw new SecurityException("Not allowed to construct a Proxy instance that implements a non-public interface", e);
            }
        }
    }

    @CallerSensitive
    public static Class<?> getProxyClass(ClassLoader loader, Class<?> ... interfaces) throws IllegalArgumentException {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            Proxy.checkProxyAccess(Reflection.getCallerClass(), loader, interfaces);
        }
        return Proxy.getProxyClass0(loader, interfaces);
    }

    private static void checkProxyAccess(Class<?> caller, ClassLoader loader, Class<?> ... interfaces) {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            ClassLoader ccl = caller.getClassLoader();
            if (loader == null && ccl != null && !ProxyAccessHelper.allowNullLoader) {
                sm.checkPermission(SecurityConstants.GET_CLASSLOADER_PERMISSION);
            }
            ReflectUtil.checkProxyPackageAccess(ccl, interfaces);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Class<?> getProxyClass0(ClassLoader loader, Class<?> ... interfaces) {
        Map<List<String>, Object> cache;
        Map<List<String>, Object> interfaceClass;
        if (interfaces.length > 65535) {
            throw new IllegalArgumentException("interface limit exceeded");
        }
        Class proxyClass = null;
        String[] interfaceNames = new String[interfaces.length];
        HashSet<Map<List<String>, Object>> interfaceSet = new HashSet<Map<List<String>, Object>>();
        for (int i = 0; i < interfaces.length; ++i) {
            String interfaceName = interfaces[i].getName();
            interfaceClass = null;
            try {
                interfaceClass = Class.forName(interfaceName, false, loader);
            }
            catch (ClassNotFoundException e) {
                // empty catch block
            }
            if (interfaceClass != interfaces[i]) {
                throw new IllegalArgumentException(interfaces[i] + " is not visible from class loader");
            }
            if (!((Class)((Object)interfaceClass)).isInterface()) {
                throw new IllegalArgumentException(((Class)((Object)interfaceClass)).getName() + " is not an interface");
            }
            if (interfaceSet.contains(interfaceClass)) {
                throw new IllegalArgumentException("repeated interface: " + ((Class)((Object)interfaceClass)).getName());
            }
            interfaceSet.add(interfaceClass);
            interfaceNames[i] = interfaceName;
        }
        List<String> key = Arrays.asList(interfaceNames);
        interfaceClass = loaderToCache;
        synchronized (interfaceClass) {
            cache = loaderToCache.get(loader);
            if (cache == null) {
                cache = new HashMap<List<String>, Object>();
                loaderToCache.put(loader, cache);
            }
        }
        interfaceClass = cache;
        synchronized (interfaceClass) {
            while (true) {
                Object value;
                if ((value = cache.get(key)) instanceof Reference) {
                    proxyClass = (Class)((Reference)value).get();
                }
                if (proxyClass != null) {
                    return proxyClass;
                }
                if (value != pendingGenerationMarker) break;
                try {
                    cache.wait();
                }
                catch (InterruptedException e) {}
            }
            cache.put(key, pendingGenerationMarker);
        }
        try {
            long num;
            Object name;
            String proxyPkg = null;
            for (int i = 0; i < interfaces.length; ++i) {
                String pkg;
                int flags = interfaces[i].getModifiers();
                if (Modifier.isPublic(flags)) continue;
                name = interfaces[i].getName();
                int n = ((String)name).lastIndexOf(46);
                String string = pkg = n == -1 ? "" : ((String)name).substring(0, n + 1);
                if (proxyPkg == null) {
                    proxyPkg = pkg;
                    continue;
                }
                if (pkg.equals(proxyPkg)) continue;
                throw new IllegalArgumentException("non-public interfaces from different packages");
            }
            if (proxyPkg == null) {
                proxyPkg = "com.sun.proxy.";
            }
            name = nextUniqueNumberLock;
            synchronized (name) {
                num = nextUniqueNumber++;
            }
            String proxyName = proxyPkg + proxyClassNamePrefix + num;
            byte[] proxyClassFile = ProxyGenerator.generateProxyClass(proxyName, interfaces);
            try {
                proxyClass = Proxy.defineClass0(loader, proxyName, proxyClassFile, 0, proxyClassFile.length);
            }
            catch (ClassFormatError e) {
                throw new IllegalArgumentException(e.toString());
            }
            proxyClasses.put(proxyClass, null);
        }
        finally {
            Map<List<String>, Object> map = cache;
            synchronized (map) {
                if (proxyClass != null) {
                    cache.put(key, new WeakReference<Class>(proxyClass));
                } else {
                    cache.remove(key);
                }
                cache.notifyAll();
            }
        }
        return proxyClass;
    }

    @CallerSensitive
    public static Object newProxyInstance(ClassLoader loader, Class<?>[] interfaces, InvocationHandler h) throws IllegalArgumentException {
        if (h == null) {
            throw new NullPointerException();
        }
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            Proxy.checkProxyAccess(Reflection.getCallerClass(), loader, interfaces);
        }
        Class<?> cl = Proxy.getProxyClass0(loader, interfaces);
        try {
            final Constructor<?> cons = cl.getConstructor(constructorParams);
            final InvocationHandler ih = h;
            if (sm != null && ProxyAccessHelper.needsNewInstanceCheck(cl)) {
                return AccessController.doPrivileged(new PrivilegedAction<Object>(){

                    @Override
                    public Object run() {
                        return Proxy.newInstance(cons, ih);
                    }
                });
            }
            return Proxy.newInstance(cons, ih);
        }
        catch (NoSuchMethodException e) {
            throw new InternalError(e.toString());
        }
    }

    private static Object newInstance(Constructor<?> cons, InvocationHandler h) {
        try {
            return cons.newInstance(h);
        }
        catch (IllegalAccessException | InstantiationException e) {
            throw new InternalError(e.toString());
        }
        catch (InvocationTargetException e) {
            Throwable t = e.getCause();
            if (t instanceof RuntimeException) {
                throw (RuntimeException)t;
            }
            throw new InternalError(t.toString());
        }
    }

    public static boolean isProxyClass(Class<?> cl) {
        if (cl == null) {
            throw new NullPointerException();
        }
        return proxyClasses.containsKey(cl);
    }

    @CallerSensitive
    public static InvocationHandler getInvocationHandler(Object proxy) throws IllegalArgumentException {
        if (!Proxy.isProxyClass(proxy.getClass())) {
            throw new IllegalArgumentException("not a proxy instance");
        }
        Proxy p = (Proxy)proxy;
        InvocationHandler ih = p.h;
        if (System.getSecurityManager() != null) {
            Class<?> ihClass = ih.getClass();
            Class caller = Reflection.getCallerClass();
            if (ReflectUtil.needsPackageAccessCheck(caller.getClassLoader(), ihClass.getClassLoader())) {
                ReflectUtil.checkPackageAccess(ihClass);
            }
        }
        return ih;
    }

    private static native Class defineClass0(ClassLoader var0, String var1, byte[] var2, int var3, int var4);

    private static class ProxyAccessHelper {
        static final Permission PROXY_PERMISSION = new ReflectPermission("proxyConstructorNewInstance");
        static final boolean allowNewInstance = ProxyAccessHelper.getBooleanProperty("sun.reflect.proxy.allowsNewInstance");
        static final boolean allowNullLoader = ProxyAccessHelper.getBooleanProperty("sun.reflect.proxy.allowsNullLoader");

        private ProxyAccessHelper() {
        }

        private static boolean getBooleanProperty(final String key) {
            String s = AccessController.doPrivileged(new PrivilegedAction<String>(){

                @Override
                public String run() {
                    return System.getProperty(key);
                }
            });
            return Boolean.valueOf(s);
        }

        static boolean needsNewInstanceCheck(Class<?> proxyClass) {
            if (!Proxy.isProxyClass(proxyClass) || allowNewInstance) {
                return false;
            }
            if (ReflectUtil.isNonPublicProxyClass(proxyClass)) {
                for (Class<?> intf : proxyClass.getInterfaces()) {
                    if (Modifier.isPublic(intf.getModifiers())) continue;
                    return true;
                }
            }
            return false;
        }
    }
}

