/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.plaf.basic;

import java.awt.AWTEvent;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FocusTraversalPolicy;
import java.awt.Insets;
import java.awt.KeyboardFocusManager;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.text.AttributedCharacterIterator;
import java.text.DateFormat;
import java.text.Format;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Map;
import javax.swing.AbstractAction;
import javax.swing.ButtonModel;
import javax.swing.InputMap;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JFormattedTextField;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.LookAndFeel;
import javax.swing.SpinnerDateModel;
import javax.swing.SpinnerModel;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.border.CompoundBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.SpinnerUI;
import javax.swing.plaf.UIResource;
import javax.swing.plaf.basic.BasicArrowButton;
import javax.swing.plaf.basic.LazyActionMap;
import javax.swing.text.InternationalFormatter;
import sun.swing.DefaultLookup;

public class BasicSpinnerUI
extends SpinnerUI {
    protected JSpinner spinner;
    private Handler handler;
    private static final ArrowButtonHandler nextButtonHandler = new ArrowButtonHandler("increment", true);
    private static final ArrowButtonHandler previousButtonHandler = new ArrowButtonHandler("decrement", false);
    private PropertyChangeListener propertyChangeListener;
    private static final Dimension zeroSize = new Dimension(0, 0);

    public static ComponentUI createUI(JComponent c) {
        return new BasicSpinnerUI();
    }

    private void maybeAdd(Component c, String s) {
        if (c != null) {
            this.spinner.add(c, s);
        }
    }

    @Override
    public void installUI(JComponent c) {
        this.spinner = (JSpinner)c;
        this.installDefaults();
        this.installListeners();
        this.maybeAdd(this.createNextButton(), "Next");
        this.maybeAdd(this.createPreviousButton(), "Previous");
        this.maybeAdd(this.createEditor(), "Editor");
        this.updateEnabledState();
        this.installKeyboardActions();
    }

    @Override
    public void uninstallUI(JComponent c) {
        this.uninstallDefaults();
        this.uninstallListeners();
        this.spinner = null;
        c.removeAll();
    }

    protected void installListeners() {
        JFormattedTextField tf;
        JComponent editor;
        this.propertyChangeListener = this.createPropertyChangeListener();
        this.spinner.addPropertyChangeListener(this.propertyChangeListener);
        if (DefaultLookup.getBoolean(this.spinner, this, "Spinner.disableOnBoundaryValues", false)) {
            this.spinner.addChangeListener(this.getHandler());
        }
        if ((editor = this.spinner.getEditor()) != null && editor instanceof JSpinner.DefaultEditor && (tf = ((JSpinner.DefaultEditor)editor).getTextField()) != null) {
            tf.addFocusListener(nextButtonHandler);
            tf.addFocusListener(previousButtonHandler);
        }
    }

    protected void uninstallListeners() {
        JFormattedTextField tf;
        this.spinner.removePropertyChangeListener(this.propertyChangeListener);
        this.spinner.removeChangeListener(this.handler);
        JComponent editor = this.spinner.getEditor();
        this.removeEditorBorderListener(editor);
        if (editor instanceof JSpinner.DefaultEditor && (tf = ((JSpinner.DefaultEditor)editor).getTextField()) != null) {
            tf.removeFocusListener(nextButtonHandler);
            tf.removeFocusListener(previousButtonHandler);
        }
        this.propertyChangeListener = null;
        this.handler = null;
    }

    protected void installDefaults() {
        this.spinner.setLayout(this.createLayout());
        LookAndFeel.installBorder(this.spinner, "Spinner.border");
        LookAndFeel.installColorsAndFont(this.spinner, "Spinner.background", "Spinner.foreground", "Spinner.font");
        LookAndFeel.installProperty(this.spinner, "opaque", Boolean.TRUE);
    }

    protected void uninstallDefaults() {
        this.spinner.setLayout(null);
    }

    private Handler getHandler() {
        if (this.handler == null) {
            this.handler = new Handler();
        }
        return this.handler;
    }

    protected void installNextButtonListeners(Component c) {
        this.installButtonListeners(c, nextButtonHandler);
    }

    protected void installPreviousButtonListeners(Component c) {
        this.installButtonListeners(c, previousButtonHandler);
    }

    private void installButtonListeners(Component c, ArrowButtonHandler handler) {
        if (c instanceof JButton) {
            ((JButton)c).addActionListener(handler);
        }
        c.addMouseListener(handler);
    }

    protected LayoutManager createLayout() {
        return this.getHandler();
    }

    protected PropertyChangeListener createPropertyChangeListener() {
        return this.getHandler();
    }

    protected Component createPreviousButton() {
        Component c = this.createArrowButton(5);
        c.setName("Spinner.previousButton");
        this.installPreviousButtonListeners(c);
        return c;
    }

    protected Component createNextButton() {
        Component c = this.createArrowButton(1);
        c.setName("Spinner.nextButton");
        this.installNextButtonListeners(c);
        return c;
    }

    private Component createArrowButton(int direction) {
        BasicArrowButton b = new BasicArrowButton(direction);
        Border buttonBorder = UIManager.getBorder("Spinner.arrowButtonBorder");
        if (buttonBorder instanceof UIResource) {
            b.setBorder(new CompoundBorder(buttonBorder, null));
        } else {
            b.setBorder(buttonBorder);
        }
        b.setInheritsPopupMenu(true);
        return b;
    }

    protected JComponent createEditor() {
        JComponent editor = this.spinner.getEditor();
        this.maybeRemoveEditorBorder(editor);
        this.installEditorBorderListener(editor);
        editor.setInheritsPopupMenu(true);
        this.updateEditorAlignment(editor);
        return editor;
    }

    protected void replaceEditor(JComponent oldEditor, JComponent newEditor) {
        this.spinner.remove(oldEditor);
        this.maybeRemoveEditorBorder(newEditor);
        this.installEditorBorderListener(newEditor);
        newEditor.setInheritsPopupMenu(true);
        this.spinner.add((Component)newEditor, "Editor");
    }

    private void updateEditorAlignment(JComponent editor) {
        if (editor instanceof JSpinner.DefaultEditor) {
            int alignment = UIManager.getInt("Spinner.editorAlignment");
            JFormattedTextField text = ((JSpinner.DefaultEditor)editor).getTextField();
            text.setHorizontalAlignment(alignment);
        }
    }

    private void maybeRemoveEditorBorder(JComponent editor) {
        if (!UIManager.getBoolean("Spinner.editorBorderPainted")) {
            if (editor instanceof JPanel && editor.getBorder() == null && editor.getComponentCount() > 0) {
                editor = (JComponent)editor.getComponent(0);
            }
            if (editor != null && editor.getBorder() instanceof UIResource) {
                editor.setBorder(null);
            }
        }
    }

    private void installEditorBorderListener(JComponent editor) {
        if (!UIManager.getBoolean("Spinner.editorBorderPainted")) {
            if (editor instanceof JPanel && editor.getBorder() == null && editor.getComponentCount() > 0) {
                editor = (JComponent)editor.getComponent(0);
            }
            if (editor != null && (editor.getBorder() == null || editor.getBorder() instanceof UIResource)) {
                editor.addPropertyChangeListener(this.getHandler());
            }
        }
    }

    private void removeEditorBorderListener(JComponent editor) {
        if (!UIManager.getBoolean("Spinner.editorBorderPainted")) {
            if (editor instanceof JPanel && editor.getComponentCount() > 0) {
                editor = (JComponent)editor.getComponent(0);
            }
            if (editor != null) {
                editor.removePropertyChangeListener(this.getHandler());
            }
        }
    }

    private void updateEnabledState() {
        this.updateEnabledState(this.spinner, this.spinner.isEnabled());
    }

    private void updateEnabledState(Container c, boolean enabled) {
        for (int counter = c.getComponentCount() - 1; counter >= 0; --counter) {
            Component child = c.getComponent(counter);
            if (DefaultLookup.getBoolean(this.spinner, this, "Spinner.disableOnBoundaryValues", false)) {
                SpinnerModel model = this.spinner.getModel();
                if (child.getName() == "Spinner.nextButton" && model.getNextValue() == null) {
                    child.setEnabled(false);
                } else if (child.getName() == "Spinner.previousButton" && model.getPreviousValue() == null) {
                    child.setEnabled(false);
                } else {
                    child.setEnabled(enabled);
                }
            } else {
                child.setEnabled(enabled);
            }
            if (!(child instanceof Container)) continue;
            this.updateEnabledState((Container)child, enabled);
        }
    }

    protected void installKeyboardActions() {
        InputMap iMap = this.getInputMap(1);
        SwingUtilities.replaceUIInputMap(this.spinner, 1, iMap);
        LazyActionMap.installLazyActionMap(this.spinner, BasicSpinnerUI.class, "Spinner.actionMap");
    }

    private InputMap getInputMap(int condition) {
        if (condition == 1) {
            return (InputMap)DefaultLookup.get(this.spinner, this, "Spinner.ancestorInputMap");
        }
        return null;
    }

    static void loadActionMap(LazyActionMap map) {
        map.put("increment", nextButtonHandler);
        map.put("decrement", previousButtonHandler);
    }

    @Override
    public int getBaseline(JComponent c, int width, int height) {
        int baseline;
        super.getBaseline(c, width, height);
        JComponent editor = this.spinner.getEditor();
        Insets insets = this.spinner.getInsets();
        width = width - insets.left - insets.right;
        height = height - insets.top - insets.bottom;
        if (width >= 0 && height >= 0 && (baseline = editor.getBaseline(width, height)) >= 0) {
            return insets.top + baseline;
        }
        return -1;
    }

    @Override
    public Component.BaselineResizeBehavior getBaselineResizeBehavior(JComponent c) {
        super.getBaselineResizeBehavior(c);
        return this.spinner.getEditor().getBaselineResizeBehavior();
    }

    private static class Handler
    implements LayoutManager,
    PropertyChangeListener,
    ChangeListener {
        private Component nextButton = null;
        private Component previousButton = null;
        private Component editor = null;

        private Handler() {
        }

        @Override
        public void addLayoutComponent(String name, Component c) {
            if ("Next".equals(name)) {
                this.nextButton = c;
            } else if ("Previous".equals(name)) {
                this.previousButton = c;
            } else if ("Editor".equals(name)) {
                this.editor = c;
            }
        }

        @Override
        public void removeLayoutComponent(Component c) {
            if (c == this.nextButton) {
                this.nextButton = null;
            } else if (c == this.previousButton) {
                this.previousButton = null;
            } else if (c == this.editor) {
                this.editor = null;
            }
        }

        private Dimension preferredSize(Component c) {
            return c == null ? zeroSize : c.getPreferredSize();
        }

        @Override
        public Dimension preferredLayoutSize(Container parent) {
            Dimension nextD = this.preferredSize(this.nextButton);
            Dimension previousD = this.preferredSize(this.previousButton);
            Dimension editorD = this.preferredSize(this.editor);
            editorD.height = (editorD.height + 1) / 2 * 2;
            Dimension size = new Dimension(editorD.width, editorD.height);
            size.width += Math.max(nextD.width, previousD.width);
            Insets insets = parent.getInsets();
            size.width += insets.left + insets.right;
            size.height += insets.top + insets.bottom;
            return size;
        }

        @Override
        public Dimension minimumLayoutSize(Container parent) {
            return this.preferredLayoutSize(parent);
        }

        private void setBounds(Component c, int x, int y, int width, int height) {
            if (c != null) {
                c.setBounds(x, y, width, height);
            }
        }

        @Override
        public void layoutContainer(Container parent) {
            int buttonsX;
            int editorWidth;
            int editorX;
            int width = parent.getWidth();
            int height = parent.getHeight();
            Insets insets = parent.getInsets();
            if (this.nextButton == null && this.previousButton == null) {
                this.setBounds(this.editor, insets.left, insets.top, width - insets.left - insets.right, height - insets.top - insets.bottom);
                return;
            }
            Dimension nextD = this.preferredSize(this.nextButton);
            Dimension previousD = this.preferredSize(this.previousButton);
            int buttonsWidth = Math.max(nextD.width, previousD.width);
            int editorHeight = height - (insets.top + insets.bottom);
            Insets buttonInsets = UIManager.getInsets("Spinner.arrowButtonInsets");
            if (buttonInsets == null) {
                buttonInsets = insets;
            }
            if (parent.getComponentOrientation().isLeftToRight()) {
                editorX = insets.left;
                editorWidth = width - insets.left - buttonsWidth - buttonInsets.right;
                buttonsX = width - buttonsWidth - buttonInsets.right;
            } else {
                buttonsX = buttonInsets.left;
                editorX = buttonsX + buttonsWidth;
                editorWidth = width - buttonInsets.left - buttonsWidth - insets.right;
            }
            int nextY = buttonInsets.top;
            int nextHeight = height / 2 + height % 2 - nextY;
            int previousY = buttonInsets.top + nextHeight;
            int previousHeight = height - previousY - buttonInsets.bottom;
            this.setBounds(this.editor, editorX, insets.top, editorWidth, editorHeight);
            this.setBounds(this.nextButton, buttonsX, nextY, buttonsWidth, nextHeight);
            this.setBounds(this.previousButton, buttonsX, previousY, buttonsWidth, previousHeight);
        }

        @Override
        public void propertyChange(PropertyChangeEvent e) {
            JSpinner spinner;
            SpinnerUI spinnerUI;
            JComponent c;
            String propertyName = e.getPropertyName();
            if (e.getSource() instanceof JSpinner) {
                JSpinner spinner2 = (JSpinner)e.getSource();
                SpinnerUI spinnerUI2 = spinner2.getUI();
                if (spinnerUI2 instanceof BasicSpinnerUI) {
                    BasicSpinnerUI ui = (BasicSpinnerUI)spinnerUI2;
                    if ("editor".equals(propertyName)) {
                        JFormattedTextField tf;
                        JComponent oldEditor = (JComponent)e.getOldValue();
                        JComponent newEditor = (JComponent)e.getNewValue();
                        ui.replaceEditor(oldEditor, newEditor);
                        ui.updateEnabledState();
                        if (oldEditor instanceof JSpinner.DefaultEditor && (tf = ((JSpinner.DefaultEditor)oldEditor).getTextField()) != null) {
                            tf.removeFocusListener(nextButtonHandler);
                            tf.removeFocusListener(previousButtonHandler);
                        }
                        if (newEditor instanceof JSpinner.DefaultEditor && (tf = ((JSpinner.DefaultEditor)newEditor).getTextField()) != null) {
                            if (tf.getFont() instanceof UIResource) {
                                tf.setFont(spinner2.getFont());
                            }
                            tf.addFocusListener(nextButtonHandler);
                            tf.addFocusListener(previousButtonHandler);
                        }
                    } else if ("enabled".equals(propertyName) || "model".equals(propertyName)) {
                        ui.updateEnabledState();
                    } else if ("font".equals(propertyName)) {
                        JFormattedTextField tf;
                        JComponent editor = spinner2.getEditor();
                        if (editor != null && editor instanceof JSpinner.DefaultEditor && (tf = ((JSpinner.DefaultEditor)editor).getTextField()) != null && tf.getFont() instanceof UIResource) {
                            tf.setFont(spinner2.getFont());
                        }
                    } else if ("ToolTipText".equals(propertyName)) {
                        this.updateToolTipTextForChildren(spinner2);
                    }
                }
            } else if (e.getSource() instanceof JComponent && (c = (JComponent)e.getSource()).getParent() instanceof JPanel && c.getParent().getParent() instanceof JSpinner && "border".equals(propertyName) && (spinnerUI = (spinner = (JSpinner)c.getParent().getParent()).getUI()) instanceof BasicSpinnerUI) {
                BasicSpinnerUI ui = (BasicSpinnerUI)spinnerUI;
                ui.maybeRemoveEditorBorder(c);
            }
        }

        private void updateToolTipTextForChildren(JComponent spinner) {
            String toolTipText = spinner.getToolTipText();
            Component[] children = spinner.getComponents();
            for (int i = 0; i < children.length; ++i) {
                if (children[i] instanceof JSpinner.DefaultEditor) {
                    JFormattedTextField tf = ((JSpinner.DefaultEditor)children[i]).getTextField();
                    if (tf == null) continue;
                    tf.setToolTipText(toolTipText);
                    continue;
                }
                if (!(children[i] instanceof JComponent)) continue;
                ((JComponent)children[i]).setToolTipText(spinner.getToolTipText());
            }
        }

        @Override
        public void stateChanged(ChangeEvent e) {
            SpinnerUI spinnerUI;
            JSpinner spinner;
            if (e.getSource() instanceof JSpinner && DefaultLookup.getBoolean(spinner = (JSpinner)e.getSource(), spinnerUI = spinner.getUI(), "Spinner.disableOnBoundaryValues", false) && spinnerUI instanceof BasicSpinnerUI) {
                BasicSpinnerUI ui = (BasicSpinnerUI)spinnerUI;
                ui.updateEnabledState();
            }
        }
    }

    private static class ArrowButtonHandler
    extends AbstractAction
    implements FocusListener,
    MouseListener,
    UIResource {
        final Timer autoRepeatTimer;
        final boolean isNext;
        JSpinner spinner = null;
        JButton arrowButton = null;

        ArrowButtonHandler(String name, boolean isNext) {
            super(name);
            this.isNext = isNext;
            this.autoRepeatTimer = new Timer(60, this);
            this.autoRepeatTimer.setInitialDelay(300);
        }

        private JSpinner eventToSpinner(AWTEvent e) {
            Object src = e.getSource();
            while (src instanceof Component && !(src instanceof JSpinner)) {
                src = ((Component)src).getParent();
            }
            return src instanceof JSpinner ? (JSpinner)src : null;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            JSpinner spinner = this.spinner;
            if (!(e.getSource() instanceof Timer)) {
                spinner = this.eventToSpinner(e);
                if (e.getSource() instanceof JButton) {
                    this.arrowButton = (JButton)e.getSource();
                }
            } else if (this.arrowButton != null && !this.arrowButton.getModel().isPressed() && this.autoRepeatTimer.isRunning()) {
                this.autoRepeatTimer.stop();
                spinner = null;
                this.arrowButton = null;
            }
            if (spinner != null) {
                try {
                    Object value;
                    int calendarField = this.getCalendarField(spinner);
                    spinner.commitEdit();
                    if (calendarField != -1) {
                        ((SpinnerDateModel)spinner.getModel()).setCalendarField(calendarField);
                    }
                    Object object = value = this.isNext ? spinner.getNextValue() : spinner.getPreviousValue();
                    if (value != null) {
                        spinner.setValue(value);
                        this.select(spinner);
                    }
                }
                catch (IllegalArgumentException iae) {
                    UIManager.getLookAndFeel().provideErrorFeedback(spinner);
                }
                catch (ParseException pe) {
                    UIManager.getLookAndFeel().provideErrorFeedback(spinner);
                }
            }
        }

        private void select(JSpinner spinner) {
            JComponent editor = spinner.getEditor();
            if (editor instanceof JSpinner.DateEditor) {
                SpinnerDateModel model;
                DateFormat.Field field;
                Object value;
                JSpinner.DateEditor dateEditor = (JSpinner.DateEditor)editor;
                JFormattedTextField ftf = dateEditor.getTextField();
                SimpleDateFormat format = dateEditor.getFormat();
                if (format != null && (value = spinner.getValue()) != null && (field = DateFormat.Field.ofCalendarField((model = dateEditor.getModel()).getCalendarField())) != null) {
                    try {
                        AttributedCharacterIterator iterator = ((Format)format).formatToCharacterIterator(value);
                        if (!this.select(ftf, iterator, field) && field == DateFormat.Field.HOUR0) {
                            this.select(ftf, iterator, DateFormat.Field.HOUR1);
                        }
                    }
                    catch (IllegalArgumentException iae) {
                        // empty catch block
                    }
                }
            }
        }

        private boolean select(JFormattedTextField ftf, AttributedCharacterIterator iterator, DateFormat.Field field) {
            int max = ftf.getDocument().getLength();
            iterator.first();
            do {
                Map<AttributedCharacterIterator.Attribute, Object> attrs;
                if ((attrs = iterator.getAttributes()) == null || !attrs.containsKey(field)) continue;
                int start = iterator.getRunStart(field);
                int end = iterator.getRunLimit(field);
                if (start != -1 && end != -1 && start <= max && end <= max) {
                    ftf.select(start, end);
                }
                return true;
            } while (iterator.next() != '\uffff');
            return false;
        }

        private int getCalendarField(JSpinner spinner) {
            JComponent editor = spinner.getEditor();
            if (editor instanceof JSpinner.DateEditor) {
                JSpinner.DateEditor dateEditor = (JSpinner.DateEditor)editor;
                JFormattedTextField ftf = dateEditor.getTextField();
                int start = ftf.getSelectionStart();
                JFormattedTextField.AbstractFormatter formatter = ftf.getFormatter();
                if (formatter instanceof InternationalFormatter) {
                    Format.Field[] fields = ((InternationalFormatter)formatter).getFields(start);
                    for (int counter = 0; counter < fields.length; ++counter) {
                        int calendarField;
                        if (!(fields[counter] instanceof DateFormat.Field) || (calendarField = fields[counter] == DateFormat.Field.HOUR1 ? 10 : ((DateFormat.Field)fields[counter]).getCalendarField()) == -1) continue;
                        return calendarField;
                    }
                }
            }
            return -1;
        }

        @Override
        public void mousePressed(MouseEvent e) {
            if (SwingUtilities.isLeftMouseButton(e) && e.getComponent().isEnabled()) {
                this.spinner = this.eventToSpinner(e);
                this.autoRepeatTimer.start();
                this.focusSpinnerIfNecessary();
            }
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            this.autoRepeatTimer.stop();
            this.arrowButton = null;
            this.spinner = null;
        }

        @Override
        public void mouseClicked(MouseEvent e) {
        }

        @Override
        public void mouseEntered(MouseEvent e) {
            if (this.spinner != null && !this.autoRepeatTimer.isRunning() && this.spinner == this.eventToSpinner(e)) {
                this.autoRepeatTimer.start();
            }
        }

        @Override
        public void mouseExited(MouseEvent e) {
            if (this.autoRepeatTimer.isRunning()) {
                this.autoRepeatTimer.stop();
            }
        }

        private void focusSpinnerIfNecessary() {
            Component fo = KeyboardFocusManager.getCurrentKeyboardFocusManager().getFocusOwner();
            if (this.spinner.isRequestFocusEnabled() && (fo == null || !SwingUtilities.isDescendingFrom(fo, this.spinner))) {
                FocusTraversalPolicy ftp;
                Component child;
                Container root = this.spinner;
                if (!root.isFocusCycleRoot()) {
                    root = root.getFocusCycleRootAncestor();
                }
                if (root != null && (child = (ftp = root.getFocusTraversalPolicy()).getComponentAfter(root, this.spinner)) != null && SwingUtilities.isDescendingFrom(child, this.spinner)) {
                    child.requestFocus();
                }
            }
        }

        @Override
        public void focusGained(FocusEvent e) {
        }

        @Override
        public void focusLost(FocusEvent e) {
            if (this.spinner == this.eventToSpinner(e)) {
                if (this.autoRepeatTimer.isRunning()) {
                    this.autoRepeatTimer.stop();
                }
                this.spinner = null;
                if (this.arrowButton != null) {
                    ButtonModel model = this.arrowButton.getModel();
                    model.setPressed(false);
                    model.setArmed(false);
                    this.arrowButton = null;
                }
            }
        }
    }
}

