/*
 * Decompiled with CFR 0.152.
 */
package sun.net.www;

import java.io.IOException;
import java.net.URL;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import sun.net.www.MessageHeader;

public abstract class URLConnection
extends java.net.URLConnection {
    private String contentType;
    private int contentLength = -1;
    protected MessageHeader properties = new MessageHeader();
    private static HashMap<String, Void> proxiedHosts = new HashMap();

    public URLConnection(URL u) {
        super(u);
    }

    public MessageHeader getProperties() {
        return this.properties;
    }

    public void setProperties(MessageHeader properties) {
        this.properties = properties;
    }

    @Override
    public void setRequestProperty(String key, String value) {
        if (this.connected) {
            throw new IllegalAccessError("Already connected");
        }
        if (key == null) {
            throw new NullPointerException("key cannot be null");
        }
        this.properties.set(key, value);
    }

    @Override
    public void addRequestProperty(String key, String value) {
        if (this.connected) {
            throw new IllegalStateException("Already connected");
        }
        if (key == null) {
            throw new NullPointerException("key is null");
        }
    }

    @Override
    public String getRequestProperty(String key) {
        if (this.connected) {
            throw new IllegalStateException("Already connected");
        }
        return null;
    }

    @Override
    public Map<String, List<String>> getRequestProperties() {
        if (this.connected) {
            throw new IllegalStateException("Already connected");
        }
        return Collections.EMPTY_MAP;
    }

    @Override
    public String getHeaderField(String name) {
        try {
            this.getInputStream();
        }
        catch (Exception e) {
            return null;
        }
        return this.properties == null ? null : this.properties.findValue(name);
    }

    @Override
    public String getHeaderFieldKey(int n) {
        try {
            this.getInputStream();
        }
        catch (Exception e) {
            return null;
        }
        MessageHeader props = this.properties;
        return props == null ? null : props.getKey(n);
    }

    @Override
    public String getHeaderField(int n) {
        try {
            this.getInputStream();
        }
        catch (Exception e) {
            return null;
        }
        MessageHeader props = this.properties;
        return props == null ? null : props.getValue(n);
    }

    @Override
    public String getContentType() {
        if (this.contentType == null) {
            this.contentType = this.getHeaderField("content-type");
        }
        if (this.contentType == null) {
            String ct = null;
            try {
                ct = URLConnection.guessContentTypeFromStream(this.getInputStream());
            }
            catch (IOException e) {
                // empty catch block
            }
            String ce = this.properties.findValue("content-encoding");
            if (ct == null && (ct = this.properties.findValue("content-type")) == null) {
                ct = this.url.getFile().endsWith("/") ? "text/html" : URLConnection.guessContentTypeFromName(this.url.getFile());
            }
            if (ct == null || ce != null && !ce.equalsIgnoreCase("7bit") && !ce.equalsIgnoreCase("8bit") && !ce.equalsIgnoreCase("binary")) {
                ct = "content/unknown";
            }
            this.setContentType(ct);
        }
        return this.contentType;
    }

    public void setContentType(String type) {
        this.contentType = type;
        this.properties.set("content-type", type);
    }

    @Override
    public int getContentLength() {
        try {
            this.getInputStream();
        }
        catch (Exception e) {
            return -1;
        }
        int l = this.contentLength;
        if (l < 0) {
            try {
                l = Integer.parseInt(this.properties.findValue("content-length"));
                this.setContentLength(l);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return l;
    }

    protected void setContentLength(int length) {
        this.contentLength = length;
        this.properties.set("content-length", String.valueOf(length));
    }

    public boolean canCache() {
        return this.url.getFile().indexOf(63) < 0;
    }

    public void close() {
        this.url = null;
    }

    public static synchronized void setProxiedHost(String host) {
        proxiedHosts.put(host.toLowerCase(), null);
    }

    public static synchronized boolean isProxiedHost(String host) {
        return proxiedHosts.containsKey(host.toLowerCase());
    }
}

