/*
 * Decompiled with CFR 0.152.
 */
package sun.security.x509;

import java.io.IOException;
import java.security.InvalidKeyException;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.Signature;
import java.security.SignatureException;
import java.security.cert.CertificateEncodingException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.Date;
import java.util.Random;
import sun.security.pkcs.PKCS10;
import sun.security.x509.AlgorithmId;
import sun.security.x509.CertificateAlgorithmId;
import sun.security.x509.CertificateExtensions;
import sun.security.x509.CertificateIssuerName;
import sun.security.x509.CertificateSerialNumber;
import sun.security.x509.CertificateSubjectName;
import sun.security.x509.CertificateValidity;
import sun.security.x509.CertificateVersion;
import sun.security.x509.CertificateX509Key;
import sun.security.x509.X500Name;
import sun.security.x509.X509CertImpl;
import sun.security.x509.X509CertInfo;
import sun.security.x509.X509Key;

public final class CertAndKeyGen {
    private SecureRandom prng;
    private String sigAlg;
    private KeyPairGenerator keyGen;
    private PublicKey publicKey;
    private PrivateKey privateKey;

    public CertAndKeyGen(String keyType, String sigAlg) throws NoSuchAlgorithmException {
        this.keyGen = KeyPairGenerator.getInstance(keyType);
        this.sigAlg = sigAlg;
    }

    public CertAndKeyGen(String keyType, String sigAlg, String providerName) throws NoSuchAlgorithmException, NoSuchProviderException {
        if (providerName == null) {
            this.keyGen = KeyPairGenerator.getInstance(keyType);
        } else {
            try {
                this.keyGen = KeyPairGenerator.getInstance(keyType, providerName);
            }
            catch (Exception e) {
                this.keyGen = KeyPairGenerator.getInstance(keyType);
            }
        }
        this.sigAlg = sigAlg;
    }

    public void setRandom(SecureRandom generator) {
        this.prng = generator;
    }

    public void generate(int keyBits) throws InvalidKeyException {
        KeyPair pair;
        try {
            if (this.prng == null) {
                this.prng = new SecureRandom();
            }
            this.keyGen.initialize(keyBits, this.prng);
            pair = this.keyGen.generateKeyPair();
        }
        catch (Exception e) {
            throw new IllegalArgumentException(e.getMessage());
        }
        this.publicKey = pair.getPublic();
        this.privateKey = pair.getPrivate();
        if (!"X.509".equalsIgnoreCase(this.publicKey.getFormat())) {
            throw new IllegalArgumentException("publicKey's is not X.509, but " + this.publicKey.getFormat());
        }
    }

    public X509Key getPublicKey() {
        if (!(this.publicKey instanceof X509Key)) {
            return null;
        }
        return (X509Key)this.publicKey;
    }

    public PublicKey getPublicKeyAnyway() {
        return this.publicKey;
    }

    public PrivateKey getPrivateKey() {
        return this.privateKey;
    }

    public X509Certificate getSelfCertificate(X500Name myname, Date firstDate, long validity) throws CertificateException, InvalidKeyException, SignatureException, NoSuchAlgorithmException, NoSuchProviderException {
        return this.getSelfCertificate(myname, firstDate, validity, null);
    }

    public X509Certificate getSelfCertificate(X500Name myname, Date firstDate, long validity, CertificateExtensions ext) throws CertificateException, InvalidKeyException, SignatureException, NoSuchAlgorithmException, NoSuchProviderException {
        try {
            Date lastDate = new Date();
            lastDate.setTime(firstDate.getTime() + validity * 1000L);
            CertificateValidity interval = new CertificateValidity(firstDate, lastDate);
            X509CertInfo info = new X509CertInfo();
            info.set("version", new CertificateVersion(2));
            info.set("serialNumber", new CertificateSerialNumber(new Random().nextInt() & Integer.MAX_VALUE));
            AlgorithmId algID = AlgorithmId.getAlgorithmId(this.sigAlg);
            info.set("algorithmID", new CertificateAlgorithmId(algID));
            info.set("subject", new CertificateSubjectName(myname));
            info.set("key", new CertificateX509Key(this.publicKey));
            info.set("validity", interval);
            info.set("issuer", new CertificateIssuerName(myname));
            if (ext != null) {
                info.set("extensions", ext);
            }
            X509CertImpl cert = new X509CertImpl(info);
            cert.sign(this.privateKey, this.sigAlg);
            return cert;
        }
        catch (IOException e) {
            throw new CertificateEncodingException("getSelfCert: " + e.getMessage());
        }
    }

    public X509Certificate getSelfCertificate(X500Name myname, long validity) throws CertificateException, InvalidKeyException, SignatureException, NoSuchAlgorithmException, NoSuchProviderException {
        return this.getSelfCertificate(myname, new Date(), validity);
    }

    public PKCS10 getCertRequest(X500Name myname) throws InvalidKeyException, SignatureException {
        PKCS10 req = new PKCS10(this.publicKey);
        try {
            Signature signature = Signature.getInstance(this.sigAlg);
            signature.initSign(this.privateKey);
            req.encodeAndSign(myname, signature);
        }
        catch (CertificateException e) {
            throw new SignatureException(this.sigAlg + " CertificateException");
        }
        catch (IOException e) {
            throw new SignatureException(this.sigAlg + " IOException");
        }
        catch (NoSuchAlgorithmException e) {
            throw new SignatureException(this.sigAlg + " unavailable?");
        }
        return req;
    }
}

