/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jndi.dns;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.StreamCorruptedException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.NoSuchElementException;
import javax.naming.CompositeName;
import javax.naming.InvalidNameException;
import javax.naming.Name;

public final class DnsName
implements Name {
    private String domain = "";
    private ArrayList labels = new ArrayList();
    private short octets = 1;
    private static final long serialVersionUID = 7040187611324710271L;

    public DnsName() {
    }

    public DnsName(String name) throws InvalidNameException {
        this.parse(name);
    }

    private DnsName(DnsName n, int beg, int end) {
        int b = n.size() - end;
        int e = n.size() - beg;
        this.labels.addAll(n.labels.subList(b, e));
        if (this.size() == n.size()) {
            this.domain = n.domain;
            this.octets = n.octets;
        } else {
            for (String label : this.labels) {
                if (label.length() <= 0) continue;
                this.octets = (short)(this.octets + (short)(label.length() + 1));
            }
        }
    }

    public String toString() {
        if (this.domain == null) {
            StringBuffer buf = new StringBuffer();
            for (String label : this.labels) {
                if (buf.length() > 0 || label.length() == 0) {
                    buf.append('.');
                }
                DnsName.escape(buf, label);
            }
            this.domain = buf.toString();
        }
        return this.domain;
    }

    public boolean isHostName() {
        Iterator iter = this.labels.iterator();
        while (iter.hasNext()) {
            if (DnsName.isHostNameLabel((String)iter.next())) continue;
            return false;
        }
        return true;
    }

    public short getOctets() {
        return this.octets;
    }

    @Override
    public int size() {
        return this.labels.size();
    }

    @Override
    public boolean isEmpty() {
        return this.size() == 0;
    }

    public int hashCode() {
        int h = 0;
        for (int i = 0; i < this.size(); ++i) {
            h = 31 * h + this.getKey(i).hashCode();
        }
        return h;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof Name) || obj instanceof CompositeName) {
            return false;
        }
        Name n = (Name)obj;
        return this.size() == n.size() && this.compareTo(obj) == 0;
    }

    @Override
    public int compareTo(Object obj) {
        Name n = (Name)obj;
        return this.compareRange(0, this.size(), n);
    }

    @Override
    public boolean startsWith(Name n) {
        return this.size() >= n.size() && this.compareRange(0, n.size(), n) == 0;
    }

    @Override
    public boolean endsWith(Name n) {
        return this.size() >= n.size() && this.compareRange(this.size() - n.size(), this.size(), n) == 0;
    }

    @Override
    public String get(int pos) {
        if (pos < 0 || pos >= this.size()) {
            throw new ArrayIndexOutOfBoundsException();
        }
        int i = this.size() - pos - 1;
        return (String)this.labels.get(i);
    }

    public Enumeration getAll() {
        return new Enumeration(){
            int pos = 0;

            @Override
            public boolean hasMoreElements() {
                return this.pos < DnsName.this.size();
            }

            public Object nextElement() {
                if (this.pos < DnsName.this.size()) {
                    return DnsName.this.get(this.pos++);
                }
                throw new NoSuchElementException();
            }
        };
    }

    @Override
    public Name getPrefix(int pos) {
        return new DnsName(this, 0, pos);
    }

    @Override
    public Name getSuffix(int pos) {
        return new DnsName(this, pos, this.size());
    }

    @Override
    public Object clone() {
        return new DnsName(this, 0, this.size());
    }

    @Override
    public Object remove(int pos) {
        if (pos < 0 || pos >= this.size()) {
            throw new ArrayIndexOutOfBoundsException();
        }
        int i = this.size() - pos - 1;
        String label = (String)this.labels.remove(i);
        int len = label.length();
        if (len > 0) {
            this.octets = (short)(this.octets - (short)(len + 1));
        }
        this.domain = null;
        return label;
    }

    @Override
    public Name add(String comp) throws InvalidNameException {
        return this.add(this.size(), comp);
    }

    @Override
    public Name add(int pos, String comp) throws InvalidNameException {
        if (pos < 0 || pos > this.size()) {
            throw new ArrayIndexOutOfBoundsException();
        }
        int len = comp.length();
        if (pos > 0 && len == 0 || pos == 0 && this.hasRootLabel()) {
            throw new InvalidNameException("Empty label must be the last label in a domain name");
        }
        if (len > 0) {
            if (this.octets + len + 1 >= 256) {
                throw new InvalidNameException("Name too long");
            }
            this.octets = (short)(this.octets + (short)(len + 1));
        }
        int i = this.size() - pos;
        DnsName.verifyLabel(comp);
        this.labels.add(i, comp);
        this.domain = null;
        return this;
    }

    @Override
    public Name addAll(Name suffix) throws InvalidNameException {
        return this.addAll(this.size(), suffix);
    }

    @Override
    public Name addAll(int pos, Name n) throws InvalidNameException {
        if (n instanceof DnsName) {
            DnsName dn = (DnsName)n;
            if (dn.isEmpty()) {
                return this;
            }
            if (pos > 0 && dn.hasRootLabel() || pos == 0 && this.hasRootLabel()) {
                throw new InvalidNameException("Empty label must be the last label in a domain name");
            }
            short newOctets = (short)(this.octets + dn.octets - 1);
            if (newOctets > 255) {
                throw new InvalidNameException("Name too long");
            }
            this.octets = newOctets;
            int i = this.size() - pos;
            this.labels.addAll(i, dn.labels);
            this.domain = this.isEmpty() ? dn.domain : (this.domain == null || dn.domain == null ? null : (pos == 0 ? this.domain + (dn.domain.equals(".") ? "" : ".") + dn.domain : (pos == this.size() ? dn.domain + (this.domain.equals(".") ? "" : ".") + this.domain : null)));
        } else if (n instanceof CompositeName) {
            n = (DnsName)n;
        } else {
            for (int i = n.size() - 1; i >= 0; --i) {
                this.add(pos, n.get(i));
            }
        }
        return this;
    }

    boolean hasRootLabel() {
        return !this.isEmpty() && this.get(0).equals("");
    }

    private int compareRange(int beg, int end, Name n) {
        if (n instanceof CompositeName) {
            n = (DnsName)n;
        }
        int minSize = Math.min(end - beg, n.size());
        for (int i = 0; i < minSize; ++i) {
            String label1 = this.get(i + beg);
            String label2 = n.get(i);
            int j = this.size() - (i + beg) - 1;
            int c = DnsName.compareLabels(label1, label2);
            if (c == 0) continue;
            return c;
        }
        return end - beg - n.size();
    }

    String getKey(int i) {
        return DnsName.keyForLabel(this.get(i));
    }

    private void parse(String name) throws InvalidNameException {
        StringBuffer label = new StringBuffer();
        for (int i = 0; i < name.length(); ++i) {
            char c = name.charAt(i);
            if (c == '\\') {
                c = DnsName.getEscapedOctet(name, i++);
                if (DnsName.isDigit(name.charAt(i))) {
                    i += 2;
                }
                label.append(c);
                continue;
            }
            if (c != '.') {
                label.append(c);
                continue;
            }
            this.add(0, label.toString());
            label.delete(0, i);
        }
        if (!name.equals("") && !name.equals(".")) {
            this.add(0, label.toString());
        }
        this.domain = name;
    }

    private static char getEscapedOctet(String name, int pos) throws InvalidNameException {
        try {
            char c1 = name.charAt(++pos);
            if (DnsName.isDigit(c1)) {
                char c2 = name.charAt(++pos);
                char c3 = name.charAt(++pos);
                if (DnsName.isDigit(c2) && DnsName.isDigit(c3)) {
                    return (char)((c1 - 48) * 100 + (c2 - 48) * 10 + (c3 - 48));
                }
                throw new InvalidNameException("Invalid escape sequence in " + name);
            }
            return c1;
        }
        catch (IndexOutOfBoundsException e) {
            throw new InvalidNameException("Invalid escape sequence in " + name);
        }
    }

    private static void verifyLabel(String label) throws InvalidNameException {
        if (label.length() > 63) {
            throw new InvalidNameException("Label exceeds 63 octets: " + label);
        }
        for (int i = 0; i < label.length(); ++i) {
            char c = label.charAt(i);
            if ((c & 0xFF00) == 0) continue;
            throw new InvalidNameException("Label has two-byte char: " + label);
        }
    }

    private static boolean isHostNameLabel(String label) {
        for (int i = 0; i < label.length(); ++i) {
            char c = label.charAt(i);
            if (DnsName.isHostNameChar(c)) continue;
            return false;
        }
        return !label.startsWith("-") && !label.endsWith("-");
    }

    private static boolean isHostNameChar(char c) {
        return c == '-' || c >= 'a' && c <= 'z' || c >= 'A' && c <= 'Z' || c >= '0' && c <= '9';
    }

    private static boolean isDigit(char c) {
        return c >= '0' && c <= '9';
    }

    private static void escape(StringBuffer buf, String label) {
        for (int i = 0; i < label.length(); ++i) {
            char c = label.charAt(i);
            if (c == '.' || c == '\\') {
                buf.append('\\');
            }
            buf.append(c);
        }
    }

    private static int compareLabels(String label1, String label2) {
        int min = Math.min(label1.length(), label2.length());
        for (int i = 0; i < min; ++i) {
            char c1 = label1.charAt(i);
            char c2 = label2.charAt(i);
            if (c1 >= 'A' && c1 <= 'Z') {
                c1 = (char)(c1 + 32);
            }
            if (c2 >= 'A' && c2 <= 'Z') {
                c2 = (char)(c2 + 32);
            }
            if (c1 == c2) continue;
            return c1 - c2;
        }
        return label1.length() - label2.length();
    }

    private static String keyForLabel(String label) {
        StringBuffer buf = new StringBuffer(label.length());
        for (int i = 0; i < label.length(); ++i) {
            char c = label.charAt(i);
            if (c >= 'A' && c <= 'Z') {
                c = (char)(c + 32);
            }
            buf.append(c);
        }
        return buf.toString();
    }

    private void writeObject(ObjectOutputStream s) throws IOException {
        s.writeObject(this.toString());
    }

    private void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
        try {
            this.parse((String)s.readObject());
        }
        catch (InvalidNameException e) {
            throw new StreamCorruptedException("Invalid name: " + this.domain);
        }
    }
}

