/*
 * Decompiled with CFR 0.152.
 */
package com.sun.org.apache.xml.internal.security.algorithms.implementations;

import com.sun.org.apache.xml.internal.security.algorithms.JCEMapper;
import com.sun.org.apache.xml.internal.security.algorithms.MessageDigestAlgorithm;
import com.sun.org.apache.xml.internal.security.algorithms.SignatureAlgorithmSpi;
import com.sun.org.apache.xml.internal.security.signature.XMLSignatureException;
import com.sun.org.apache.xml.internal.security.utils.XMLUtils;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.spec.AlgorithmParameterSpec;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.crypto.Mac;
import javax.crypto.SecretKey;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Text;

public abstract class IntegrityHmac
extends SignatureAlgorithmSpi {
    static Logger log = Logger.getLogger(IntegrityHmacSHA1.class.getName());
    private Mac _macAlgorithm = null;
    private boolean _HMACOutputLengthSet = false;
    int _HMACOutputLength = 0;

    @Override
    public abstract String engineGetURI();

    abstract int getDigestLength();

    public IntegrityHmac() throws XMLSignatureException {
        String algorithmID = JCEMapper.translateURItoJCEID(this.engineGetURI());
        if (log.isLoggable(Level.FINE)) {
            log.log(Level.FINE, "Created IntegrityHmacSHA1 using " + algorithmID);
        }
        try {
            this._macAlgorithm = Mac.getInstance(algorithmID);
        }
        catch (NoSuchAlgorithmException ex) {
            Object[] exArgs = new Object[]{algorithmID, ex.getLocalizedMessage()};
            throw new XMLSignatureException("algorithms.NoSuchAlgorithm", exArgs);
        }
    }

    @Override
    protected void engineSetParameter(AlgorithmParameterSpec params) throws XMLSignatureException {
        throw new XMLSignatureException("empty");
    }

    @Override
    public void reset() {
        this._HMACOutputLength = 0;
        this._HMACOutputLengthSet = false;
        this._macAlgorithm.reset();
    }

    @Override
    protected boolean engineVerify(byte[] signature) throws XMLSignatureException {
        try {
            if (this._HMACOutputLengthSet && this._HMACOutputLength < this.getDigestLength()) {
                if (log.isLoggable(Level.FINE)) {
                    log.log(Level.FINE, "HMACOutputLength must not be less than " + this.getDigestLength());
                }
                throw new XMLSignatureException("errorMessages.XMLSignatureException");
            }
            byte[] completeResult = this._macAlgorithm.doFinal();
            return MessageDigestAlgorithm.isEqual(completeResult, signature);
        }
        catch (IllegalStateException ex) {
            throw new XMLSignatureException("empty", ex);
        }
    }

    @Override
    protected void engineInitVerify(Key secretKey) throws XMLSignatureException {
        if (!(secretKey instanceof SecretKey)) {
            String supplied = secretKey.getClass().getName();
            String needed = SecretKey.class.getName();
            Object[] exArgs = new Object[]{supplied, needed};
            throw new XMLSignatureException("algorithms.WrongKeyForThisOperation", exArgs);
        }
        try {
            this._macAlgorithm.init(secretKey);
        }
        catch (InvalidKeyException ex) {
            Mac mac = this._macAlgorithm;
            try {
                this._macAlgorithm = Mac.getInstance(this._macAlgorithm.getAlgorithm());
            }
            catch (Exception e) {
                if (log.isLoggable(Level.FINE)) {
                    log.log(Level.FINE, "Exception when reinstantiating Mac:" + e);
                }
                this._macAlgorithm = mac;
            }
            throw new XMLSignatureException("empty", ex);
        }
    }

    @Override
    protected byte[] engineSign() throws XMLSignatureException {
        try {
            if (this._HMACOutputLengthSet && this._HMACOutputLength < this.getDigestLength()) {
                if (log.isLoggable(Level.FINE)) {
                    log.log(Level.FINE, "HMACOutputLength must not be less than " + this.getDigestLength());
                }
                throw new XMLSignatureException("errorMessages.XMLSignatureException");
            }
            return this._macAlgorithm.doFinal();
        }
        catch (IllegalStateException ex) {
            throw new XMLSignatureException("empty", ex);
        }
    }

    private static byte[] reduceBitLength(byte[] completeResult, int length) {
        int bytes = length / 8;
        int abits = length % 8;
        byte[] strippedResult = new byte[bytes + (abits == 0 ? 0 : 1)];
        System.arraycopy(completeResult, 0, strippedResult, 0, bytes);
        if (abits > 0) {
            byte[] MASK = new byte[]{0, -128, -64, -32, -16, -8, -4, -2};
            strippedResult[bytes] = (byte)(completeResult[bytes] & MASK[abits]);
        }
        return strippedResult;
    }

    @Override
    protected void engineInitSign(Key secretKey) throws XMLSignatureException {
        if (!(secretKey instanceof SecretKey)) {
            String supplied = secretKey.getClass().getName();
            String needed = SecretKey.class.getName();
            Object[] exArgs = new Object[]{supplied, needed};
            throw new XMLSignatureException("algorithms.WrongKeyForThisOperation", exArgs);
        }
        try {
            this._macAlgorithm.init(secretKey);
        }
        catch (InvalidKeyException ex) {
            throw new XMLSignatureException("empty", ex);
        }
    }

    @Override
    protected void engineInitSign(Key secretKey, AlgorithmParameterSpec algorithmParameterSpec) throws XMLSignatureException {
        if (!(secretKey instanceof SecretKey)) {
            String supplied = secretKey.getClass().getName();
            String needed = SecretKey.class.getName();
            Object[] exArgs = new Object[]{supplied, needed};
            throw new XMLSignatureException("algorithms.WrongKeyForThisOperation", exArgs);
        }
        try {
            this._macAlgorithm.init(secretKey, algorithmParameterSpec);
        }
        catch (InvalidKeyException ex) {
            throw new XMLSignatureException("empty", ex);
        }
        catch (InvalidAlgorithmParameterException ex) {
            throw new XMLSignatureException("empty", ex);
        }
    }

    @Override
    protected void engineInitSign(Key secretKey, SecureRandom secureRandom) throws XMLSignatureException {
        throw new XMLSignatureException("algorithms.CannotUseSecureRandomOnMAC");
    }

    @Override
    protected void engineUpdate(byte[] input) throws XMLSignatureException {
        try {
            this._macAlgorithm.update(input);
        }
        catch (IllegalStateException ex) {
            throw new XMLSignatureException("empty", ex);
        }
    }

    @Override
    protected void engineUpdate(byte input) throws XMLSignatureException {
        try {
            this._macAlgorithm.update(input);
        }
        catch (IllegalStateException ex) {
            throw new XMLSignatureException("empty", ex);
        }
    }

    @Override
    protected void engineUpdate(byte[] buf, int offset, int len) throws XMLSignatureException {
        try {
            this._macAlgorithm.update(buf, offset, len);
        }
        catch (IllegalStateException ex) {
            throw new XMLSignatureException("empty", ex);
        }
    }

    @Override
    protected String engineGetJCEAlgorithmString() {
        log.log(Level.FINE, "engineGetJCEAlgorithmString()");
        return this._macAlgorithm.getAlgorithm();
    }

    @Override
    protected String engineGetJCEProviderName() {
        return this._macAlgorithm.getProvider().getName();
    }

    @Override
    protected void engineSetHMACOutputLength(int HMACOutputLength) {
        this._HMACOutputLength = HMACOutputLength;
        this._HMACOutputLengthSet = true;
    }

    @Override
    protected void engineGetContextFromElement(Element element) {
        super.engineGetContextFromElement(element);
        if (element == null) {
            throw new IllegalArgumentException("element null");
        }
        Text hmaclength = XMLUtils.selectDsNodeText(element.getFirstChild(), "HMACOutputLength", 0);
        if (hmaclength != null) {
            this._HMACOutputLength = Integer.parseInt(hmaclength.getData());
            this._HMACOutputLengthSet = true;
        }
    }

    public void engineAddContextToElement(Element element) {
        if (element == null) {
            throw new IllegalArgumentException("null element");
        }
        if (this._HMACOutputLengthSet) {
            Document doc = element.getOwnerDocument();
            Element HMElem = XMLUtils.createElementInSignatureSpace(doc, "HMACOutputLength");
            Text HMText = doc.createTextNode(new Integer(this._HMACOutputLength).toString());
            HMElem.appendChild(HMText);
            XMLUtils.addReturnToElement(element);
            element.appendChild(HMElem);
            XMLUtils.addReturnToElement(element);
        }
    }

    public static class IntegrityHmacMD5
    extends IntegrityHmac {
        @Override
        public String engineGetURI() {
            return "http://www.w3.org/2001/04/xmldsig-more#hmac-md5";
        }

        @Override
        int getDigestLength() {
            return 128;
        }
    }

    public static class IntegrityHmacRIPEMD160
    extends IntegrityHmac {
        @Override
        public String engineGetURI() {
            return "http://www.w3.org/2001/04/xmldsig-more#hmac-ripemd160";
        }

        @Override
        int getDigestLength() {
            return 160;
        }
    }

    public static class IntegrityHmacSHA512
    extends IntegrityHmac {
        @Override
        public String engineGetURI() {
            return "http://www.w3.org/2001/04/xmldsig-more#hmac-sha512";
        }

        @Override
        int getDigestLength() {
            return 512;
        }
    }

    public static class IntegrityHmacSHA384
    extends IntegrityHmac {
        @Override
        public String engineGetURI() {
            return "http://www.w3.org/2001/04/xmldsig-more#hmac-sha384";
        }

        @Override
        int getDigestLength() {
            return 384;
        }
    }

    public static class IntegrityHmacSHA256
    extends IntegrityHmac {
        @Override
        public String engineGetURI() {
            return "http://www.w3.org/2001/04/xmldsig-more#hmac-sha256";
        }

        @Override
        int getDigestLength() {
            return 256;
        }
    }

    public static class IntegrityHmacSHA1
    extends IntegrityHmac {
        @Override
        public String engineGetURI() {
            return "http://www.w3.org/2000/09/xmldsig#hmac-sha1";
        }

        @Override
        int getDigestLength() {
            return 160;
        }
    }
}

