/*
 * Decompiled with CFR 0.152.
 */
package sun.java2d.cmm;

import java.awt.color.CMMException;
import java.awt.color.ColorSpace;
import java.awt.color.ICC_Profile;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Iterator;
import java.util.ServiceLoader;
import sun.java2d.cmm.ColorTransform;
import sun.java2d.cmm.PCMM;
import sun.security.action.GetPropertyAction;

public class CMSManager {
    public static ColorSpace GRAYspace;
    public static ColorSpace LINEAR_RGBspace;
    private static PCMM cmmImpl;

    public static synchronized PCMM getModule() {
        if (cmmImpl != null) {
            return cmmImpl;
        }
        cmmImpl = (PCMM)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                String cmmClass = System.getProperty("sun.java2d.cmm", "sun.java2d.cmm.kcms.CMM");
                ServiceLoader<PCMM> cmmLoader = ServiceLoader.loadInstalled(PCMM.class);
                PCMM service = null;
                Iterator<PCMM> i$ = cmmLoader.iterator();
                while (i$.hasNext()) {
                    PCMM cmm;
                    service = cmm = i$.next();
                    if (!cmm.getClass().getName().equals(cmmClass)) continue;
                    break;
                }
                return service;
            }
        });
        if (cmmImpl == null) {
            throw new CMMException("Cannot initialize Color Management System.No CM module found");
        }
        GetPropertyAction gpa = new GetPropertyAction("sun.java2d.cmm.trace");
        String cmmTrace = AccessController.doPrivileged(gpa);
        if (cmmTrace != null) {
            cmmImpl = new CMMTracer(cmmImpl);
        }
        return cmmImpl;
    }

    static {
        cmmImpl = null;
    }

    public static class CMMTracer
    implements PCMM {
        PCMM tcmm;
        String cName;

        public CMMTracer(PCMM tcmm) {
            this.tcmm = tcmm;
            this.cName = tcmm.getClass().getName();
        }

        @Override
        public long loadProfile(byte[] data) {
            System.err.print(this.cName + ".loadProfile");
            long profileID = this.tcmm.loadProfile(data);
            System.err.printf("(ID=%x)\n", profileID);
            return profileID;
        }

        @Override
        public void freeProfile(long profileID) {
            System.err.printf(this.cName + ".freeProfile(ID=%x)\n", profileID);
            this.tcmm.freeProfile(profileID);
        }

        @Override
        public int getProfileSize(long profileID) {
            System.err.print(this.cName + ".getProfileSize(ID=" + profileID + ")");
            int size = this.tcmm.getProfileSize(profileID);
            System.err.println("=" + size);
            return size;
        }

        @Override
        public void getProfileData(long profileID, byte[] data) {
            System.err.print(this.cName + ".getProfileData(ID=" + profileID + ") ");
            System.err.println("requested " + data.length + " byte(s)");
            this.tcmm.getProfileData(profileID, data);
        }

        @Override
        public int getTagSize(long profileID, int tagSignature) {
            System.err.printf(this.cName + ".getTagSize(ID=%x, TagSig=%s)", profileID, CMMTracer.signatureToString(tagSignature));
            int size = this.tcmm.getTagSize(profileID, tagSignature);
            System.err.println("=" + size);
            return size;
        }

        @Override
        public void getTagData(long profileID, int tagSignature, byte[] data) {
            System.err.printf(this.cName + ".getTagData(ID=%x, TagSig=%s)", profileID, CMMTracer.signatureToString(tagSignature));
            System.err.println(" requested " + data.length + " byte(s)");
            this.tcmm.getTagData(profileID, tagSignature, data);
        }

        @Override
        public void setTagData(long profileID, int tagSignature, byte[] data) {
            System.err.print(this.cName + ".setTagData(ID=" + profileID + ", TagSig=" + tagSignature + ")");
            System.err.println(" sending " + data.length + " byte(s)");
            this.tcmm.setTagData(profileID, tagSignature, data);
        }

        @Override
        public ColorTransform createTransform(ICC_Profile profile, int renderType, int transformType) {
            System.err.println(this.cName + ".createTransform(ICC_Profile,int,int)");
            return this.tcmm.createTransform(profile, renderType, transformType);
        }

        @Override
        public ColorTransform createTransform(ColorTransform[] transforms) {
            System.err.println(this.cName + ".createTransform(ColorTransform[])");
            return this.tcmm.createTransform(transforms);
        }

        private static String signatureToString(int sig) {
            return String.format("%c%c%c%c", Character.valueOf((char)(0xFF & sig >> 24)), Character.valueOf((char)(0xFF & sig >> 16)), Character.valueOf((char)(0xFF & sig >> 8)), Character.valueOf((char)(0xFF & sig)));
        }
    }
}

