/*
 * Decompiled with CFR 0.152.
 */
package sun.security.x509;

import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import sun.security.util.DerOutputStream;
import sun.security.util.DerValue;
import sun.security.x509.AccessDescription;
import sun.security.x509.AttributeNameEnumeration;
import sun.security.x509.CertAttrSet;
import sun.security.x509.Extension;
import sun.security.x509.PKIXExtensions;

public class SubjectInfoAccessExtension
extends Extension
implements CertAttrSet<String> {
    public static final String IDENT = "x509.info.extensions.SubjectInfoAccess";
    public static final String NAME = "SubjectInfoAccess";
    public static final String DESCRIPTIONS = "descriptions";
    private List<AccessDescription> accessDescriptions;

    public SubjectInfoAccessExtension(List<AccessDescription> accessDescriptions) throws IOException {
        this.extensionId = PKIXExtensions.SubjectInfoAccess_Id;
        this.critical = false;
        this.accessDescriptions = accessDescriptions;
        this.encodeThis();
    }

    public SubjectInfoAccessExtension(Boolean critical, Object value) throws IOException {
        this.extensionId = PKIXExtensions.SubjectInfoAccess_Id;
        this.critical = critical;
        if (!(value instanceof byte[])) {
            throw new IOException("Illegal argument type");
        }
        this.extensionValue = (byte[])value;
        DerValue val = new DerValue(this.extensionValue);
        if (val.tag != 48) {
            throw new IOException("Invalid encoding for SubjectInfoAccessExtension.");
        }
        this.accessDescriptions = new ArrayList<AccessDescription>();
        while (val.data.available() != 0) {
            DerValue seq = val.data.getDerValue();
            AccessDescription accessDescription = new AccessDescription(seq);
            this.accessDescriptions.add(accessDescription);
        }
    }

    public List<AccessDescription> getAccessDescriptions() {
        return this.accessDescriptions;
    }

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    public void encode(OutputStream out) throws IOException {
        DerOutputStream tmp = new DerOutputStream();
        if (this.extensionValue == null) {
            this.extensionId = PKIXExtensions.SubjectInfoAccess_Id;
            this.critical = false;
            this.encodeThis();
        }
        super.encode(tmp);
        out.write(tmp.toByteArray());
    }

    @Override
    public void set(String name, Object obj) throws IOException {
        if (name.equalsIgnoreCase(DESCRIPTIONS)) {
            if (!(obj instanceof List)) {
                throw new IOException("Attribute value should be of type List.");
            }
        } else {
            throw new IOException("Attribute name [" + name + "] not recognized by " + "CertAttrSet:SubjectInfoAccessExtension.");
        }
        this.accessDescriptions = (List)obj;
        this.encodeThis();
    }

    @Override
    public Object get(String name) throws IOException {
        if (name.equalsIgnoreCase(DESCRIPTIONS)) {
            return this.accessDescriptions;
        }
        throw new IOException("Attribute name [" + name + "] not recognized by " + "CertAttrSet:SubjectInfoAccessExtension.");
    }

    @Override
    public void delete(String name) throws IOException {
        if (!name.equalsIgnoreCase(DESCRIPTIONS)) {
            throw new IOException("Attribute name [" + name + "] not recognized by " + "CertAttrSet:SubjectInfoAccessExtension.");
        }
        this.accessDescriptions = new ArrayList<AccessDescription>();
        this.encodeThis();
    }

    @Override
    public Enumeration<String> getElements() {
        AttributeNameEnumeration elements = new AttributeNameEnumeration();
        elements.addElement(DESCRIPTIONS);
        return elements.elements();
    }

    private void encodeThis() throws IOException {
        if (this.accessDescriptions.isEmpty()) {
            this.extensionValue = null;
        } else {
            DerOutputStream ads = new DerOutputStream();
            for (AccessDescription accessDescription : this.accessDescriptions) {
                accessDescription.encode(ads);
            }
            DerOutputStream seq = new DerOutputStream();
            seq.write((byte)48, ads);
            this.extensionValue = seq.toByteArray();
        }
    }

    @Override
    public String toString() {
        return super.toString() + "SubjectInfoAccess [\n  " + this.accessDescriptions + "\n]\n";
    }
}

