/*
 * Decompiled with CFR 0.152.
 */
package sun.security.ec;

import java.security.GeneralSecurityException;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.ProviderException;
import java.security.SecureRandom;
import java.security.interfaces.ECPrivateKey;
import java.security.interfaces.ECPublicKey;
import java.security.spec.AlgorithmParameterSpec;
import java.security.spec.ECParameterSpec;
import java.security.spec.ECPoint;
import java.security.spec.EllipticCurve;
import javax.crypto.KeyAgreementSpi;
import javax.crypto.SecretKey;
import javax.crypto.ShortBufferException;
import javax.crypto.spec.SecretKeySpec;
import sun.security.ec.ECKeyFactory;
import sun.security.ec.ECParameters;
import sun.security.ec.ECPublicKeyImpl;

public final class ECDHKeyAgreement
extends KeyAgreementSpi {
    private ECPrivateKey privateKey;
    private byte[] publicValue;
    private int secretLen;

    @Override
    protected void engineInit(Key key, SecureRandom random) throws InvalidKeyException {
        if (!(key instanceof PrivateKey)) {
            throw new InvalidKeyException("Key must be instance of PrivateKey");
        }
        this.privateKey = (ECPrivateKey)ECKeyFactory.toECKey(key);
        this.publicValue = null;
    }

    @Override
    protected void engineInit(Key key, AlgorithmParameterSpec params, SecureRandom random) throws InvalidKeyException, InvalidAlgorithmParameterException {
        if (params != null) {
            throw new InvalidAlgorithmParameterException("Parameters not supported");
        }
        this.engineInit(key, random);
    }

    @Override
    protected Key engineDoPhase(Key key, boolean lastPhase) throws InvalidKeyException, IllegalStateException {
        if (this.privateKey == null) {
            throw new IllegalStateException("Not initialized");
        }
        if (this.publicValue != null) {
            throw new IllegalStateException("Phase already executed");
        }
        if (!lastPhase) {
            throw new IllegalStateException("Only two party agreement supported, lastPhase must be true");
        }
        if (!(key instanceof ECPublicKey)) {
            throw new InvalidKeyException("Key must be a PublicKey with algorithm EC");
        }
        ECPublicKey ecKey = (ECPublicKey)key;
        ECParameterSpec params = ecKey.getParams();
        this.publicValue = ecKey instanceof ECPublicKeyImpl ? ((ECPublicKeyImpl)ecKey).getEncodedPublicValue() : ECParameters.encodePoint((ECPoint)ecKey.getW(), (EllipticCurve)params.getCurve());
        int keyLenBits = params.getCurve().getField().getFieldSize();
        this.secretLen = keyLenBits + 7 >> 3;
        return null;
    }

    @Override
    protected byte[] engineGenerateSecret() throws IllegalStateException {
        if (this.privateKey == null || this.publicValue == null) {
            throw new IllegalStateException("Not initialized correctly");
        }
        byte[] s = this.privateKey.getS().toByteArray();
        byte[] encodedParams = ECParameters.encodeParameters((ECParameterSpec)this.privateKey.getParams());
        try {
            return ECDHKeyAgreement.deriveKey(s, this.publicValue, encodedParams);
        }
        catch (GeneralSecurityException e) {
            throw new ProviderException("Could not derive key", e);
        }
    }

    @Override
    protected int engineGenerateSecret(byte[] sharedSecret, int offset) throws IllegalStateException, ShortBufferException {
        if (offset + this.secretLen > sharedSecret.length) {
            throw new ShortBufferException("Need " + this.secretLen + " bytes, only " + (sharedSecret.length - offset) + " available");
        }
        byte[] secret = this.engineGenerateSecret();
        System.arraycopy(secret, 0, sharedSecret, offset, secret.length);
        return secret.length;
    }

    @Override
    protected SecretKey engineGenerateSecret(String algorithm) throws IllegalStateException, NoSuchAlgorithmException, InvalidKeyException {
        if (algorithm == null) {
            throw new NoSuchAlgorithmException("Algorithm must not be null");
        }
        if (!algorithm.equals("TlsPremasterSecret")) {
            throw new NoSuchAlgorithmException("Only supported for algorithm TlsPremasterSecret");
        }
        return new SecretKeySpec(this.engineGenerateSecret(), "TlsPremasterSecret");
    }

    private static native byte[] deriveKey(byte[] var0, byte[] var1, byte[] var2) throws GeneralSecurityException;
}

