/*
 * Decompiled with CFR 0.152.
 */
package sun.security.ec;

import java.math.BigInteger;
import java.security.GeneralSecurityException;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidParameterException;
import java.security.KeyPair;
import java.security.KeyPairGeneratorSpi;
import java.security.ProviderException;
import java.security.SecureRandom;
import java.security.spec.AlgorithmParameterSpec;
import java.security.spec.ECGenParameterSpec;
import java.security.spec.ECParameterSpec;
import java.security.spec.ECPoint;
import java.security.spec.EllipticCurve;
import sun.security.ec.ECParameters;
import sun.security.ec.ECPrivateKeyImpl;
import sun.security.ec.ECPublicKeyImpl;
import sun.security.ec.NamedCurve;
import sun.security.jca.JCAUtil;

public final class ECKeyPairGenerator
extends KeyPairGeneratorSpi {
    private static final int KEY_SIZE_MIN = 112;
    private static final int KEY_SIZE_MAX = 571;
    private static final int KEY_SIZE_DEFAULT = 256;
    private SecureRandom random;
    private int keySize;
    private AlgorithmParameterSpec params = null;

    public ECKeyPairGenerator() {
        this.initialize(256, null);
    }

    @Override
    public void initialize(int keySize, SecureRandom random) {
        this.checkKeySize(keySize);
        this.params = NamedCurve.getECParameterSpec((int)keySize);
        if (this.params == null) {
            throw new InvalidParameterException("No EC parameters available for key size " + keySize + " bits");
        }
        this.random = random;
    }

    @Override
    public void initialize(AlgorithmParameterSpec params, SecureRandom random) throws InvalidAlgorithmParameterException {
        if (params instanceof ECParameterSpec) {
            this.params = ECParameters.getNamedCurve((ECParameterSpec)((ECParameterSpec)params));
            if (this.params == null) {
                throw new InvalidAlgorithmParameterException("Unsupported curve: " + params);
            }
        } else if (params instanceof ECGenParameterSpec) {
            String name = ((ECGenParameterSpec)params).getName();
            this.params = NamedCurve.getECParameterSpec((String)name);
            if (this.params == null) {
                throw new InvalidAlgorithmParameterException("Unknown curve name: " + name);
            }
        } else {
            throw new InvalidAlgorithmParameterException("ECParameterSpec or ECGenParameterSpec required for EC");
        }
        this.keySize = ((ECParameterSpec)this.params).getCurve().getField().getFieldSize();
        this.random = random;
    }

    @Override
    public KeyPair generateKeyPair() {
        byte[] encodedParams = ECParameters.encodeParameters((ECParameterSpec)((ECParameterSpec)this.params));
        byte[] seed = new byte[((this.keySize + 7 >> 3) + 1) * 2];
        if (this.random == null) {
            this.random = JCAUtil.getSecureRandom();
        }
        this.random.nextBytes(seed);
        try {
            Object[] keyBytes = ECKeyPairGenerator.generateECKeyPair(this.keySize, encodedParams, seed);
            BigInteger s = new BigInteger(1, (byte[])keyBytes[0]);
            ECPrivateKeyImpl privateKey = new ECPrivateKeyImpl(s, (ECParameterSpec)this.params);
            ECPoint w = ECParameters.decodePoint((byte[])((byte[])keyBytes[1]), (EllipticCurve)((ECParameterSpec)this.params).getCurve());
            ECPublicKeyImpl publicKey = new ECPublicKeyImpl(w, (ECParameterSpec)this.params);
            return new KeyPair(publicKey, privateKey);
        }
        catch (Exception e) {
            throw new ProviderException(e);
        }
    }

    private void checkKeySize(int keySize) throws InvalidParameterException {
        if (keySize < 112) {
            throw new InvalidParameterException("Key size must be at least 112 bits");
        }
        if (keySize > 571) {
            throw new InvalidParameterException("Key size must be at most 571 bits");
        }
        this.keySize = keySize;
    }

    private static native Object[] generateECKeyPair(int var0, byte[] var1, byte[] var2) throws GeneralSecurityException;
}

