/*
 * Decompiled with CFR 0.152.
 */
package javax.naming.spi;

import com.sun.naming.internal.FactoryEnumeration;
import com.sun.naming.internal.ResourceManager;
import java.util.Hashtable;
import javax.naming.CannotProceedException;
import javax.naming.Context;
import javax.naming.Name;
import javax.naming.NamingException;
import javax.naming.Reference;
import javax.naming.Referenceable;
import javax.naming.directory.Attributes;
import javax.naming.directory.DirContext;
import javax.naming.spi.ContinuationDirContext;
import javax.naming.spi.DirObjectFactory;
import javax.naming.spi.DirStateFactory;
import javax.naming.spi.NamingManager;
import javax.naming.spi.ObjectFactory;
import javax.naming.spi.ObjectFactoryBuilder;
import javax.naming.spi.StateFactory;

public class DirectoryManager
extends NamingManager {
    DirectoryManager() {
    }

    public static DirContext getContinuationDirContext(CannotProceedException cpe) throws NamingException {
        Hashtable<String, CannotProceedException> env = cpe.getEnvironment();
        env = env == null ? new Hashtable<String, CannotProceedException>(7) : (Hashtable<String, CannotProceedException>)env.clone();
        env.put("java.naming.spi.CannotProceedException", cpe);
        return new ContinuationDirContext(cpe, env);
    }

    public static Object getObjectInstance(Object refInfo, Name name, Context nameCtx, Hashtable<?, ?> environment, Attributes attrs) throws Exception {
        Object answer;
        ObjectFactoryBuilder builder = DirectoryManager.getObjectFactoryBuilder();
        if (builder != null) {
            ObjectFactory factory = builder.createObjectFactory(refInfo, environment);
            if (factory instanceof DirObjectFactory) {
                return ((DirObjectFactory)factory).getObjectInstance(refInfo, name, nameCtx, environment, attrs);
            }
            return factory.getObjectInstance(refInfo, name, nameCtx, environment);
        }
        Reference ref = null;
        if (refInfo instanceof Reference) {
            ref = (Reference)refInfo;
        } else if (refInfo instanceof Referenceable) {
            ref = ((Referenceable)refInfo).getReference();
        }
        if (ref != null) {
            String f = ref.getFactoryClassName();
            if (f != null) {
                ObjectFactory factory = DirectoryManager.getObjectFactoryFromReference(ref, f);
                if (factory instanceof DirObjectFactory) {
                    return ((DirObjectFactory)factory).getObjectInstance(ref, name, nameCtx, environment, attrs);
                }
                if (factory != null) {
                    return factory.getObjectInstance(ref, name, nameCtx, environment);
                }
                return refInfo;
            }
            answer = DirectoryManager.processURLAddrs(ref, name, nameCtx, environment);
            if (answer != null) {
                return answer;
            }
        }
        return (answer = DirectoryManager.createObjectFromFactories(refInfo, name, nameCtx, environment, attrs)) != null ? answer : refInfo;
    }

    private static Object createObjectFromFactories(Object obj, Name name, Context nameCtx, Hashtable environment, Attributes attrs) throws Exception {
        FactoryEnumeration factories = ResourceManager.getFactories("java.naming.factory.object", environment, nameCtx);
        if (factories == null) {
            return null;
        }
        Object answer = null;
        while (answer == null && factories.hasMore()) {
            ObjectFactory factory = (ObjectFactory)factories.next();
            if (factory instanceof DirObjectFactory) {
                answer = ((DirObjectFactory)factory).getObjectInstance(obj, name, nameCtx, environment, attrs);
                continue;
            }
            answer = factory.getObjectInstance(obj, name, nameCtx, environment);
        }
        return answer;
    }

    public static DirStateFactory.Result getStateToBind(Object obj, Name name, Context nameCtx, Hashtable<?, ?> environment, Attributes attrs) throws NamingException {
        FactoryEnumeration factories = ResourceManager.getFactories("java.naming.factory.state", environment, nameCtx);
        if (factories == null) {
            return new DirStateFactory.Result(obj, attrs);
        }
        DirStateFactory.Result answer = null;
        while (answer == null && factories.hasMore()) {
            StateFactory factory = (StateFactory)factories.next();
            if (factory instanceof DirStateFactory) {
                answer = ((DirStateFactory)factory).getStateToBind(obj, name, nameCtx, environment, attrs);
                continue;
            }
            Object objanswer = factory.getStateToBind(obj, name, nameCtx, environment);
            if (objanswer == null) continue;
            answer = new DirStateFactory.Result(objanswer, attrs);
        }
        return answer != null ? answer : new DirStateFactory.Result(obj, attrs);
    }
}

