/*
 * Decompiled with CFR 0.152.
 */
package com.sun.java.swing.plaf.gtk;

import java.awt.Font;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsEnvironment;
import java.awt.Toolkit;
import java.awt.geom.AffineTransform;
import java.util.StringTokenizer;
import javax.swing.plaf.FontUIResource;
import sun.font.FontManager;

class PangoFonts {
    public static final String CHARS_DIGITS = "0123456789";
    private static double fontScale = 1.0;

    PangoFonts() {
    }

    static Font lookupFont(String pangoName) {
        String fcFamilyLC;
        String family = "";
        int style = 0;
        int size = 10;
        StringTokenizer tok = new StringTokenizer(pangoName);
        while (tok.hasMoreTokens()) {
            String word = tok.nextToken();
            if (word.equalsIgnoreCase("italic")) {
                style |= 2;
                continue;
            }
            if (word.equalsIgnoreCase("bold")) {
                style |= 1;
                continue;
            }
            if (CHARS_DIGITS.indexOf(word.charAt(0)) != -1) {
                try {
                    size = Integer.parseInt(word);
                }
                catch (NumberFormatException ex) {}
                continue;
            }
            if (family.length() > 0) {
                family = family + " ";
            }
            family = family + word;
        }
        double dsize = size;
        int dpi = 96;
        Object value = Toolkit.getDefaultToolkit().getDesktopProperty("gnome.Xft/DPI");
        if (value instanceof Integer) {
            dpi = (Integer)value / 1024;
            if (dpi == -1) {
                dpi = 96;
            }
            if (dpi < 50) {
                dpi = 50;
            }
            dsize = (double)(dpi * size) / 72.0;
        } else {
            dsize = (double)size * fontScale;
        }
        size = (int)(dsize + 0.5);
        if (size < 1) {
            size = 1;
        }
        if (FontManager.mapFcName(fcFamilyLC = family.toLowerCase()) != null) {
            Font font = FontManager.getFontConfigFUIR(fcFamilyLC, style, size);
            font = font.deriveFont(style, (float)dsize);
            return new FontUIResource(font);
        }
        Font font = new Font(family, style, size);
        font = font.deriveFont(style, (float)dsize);
        FontUIResource fuir = new FontUIResource(font);
        return FontManager.getCompositeFontUIResource(fuir);
    }

    static int getFontSize(String pangoName) {
        int size = 10;
        StringTokenizer tok = new StringTokenizer(pangoName);
        while (tok.hasMoreTokens()) {
            String word = tok.nextToken();
            if (CHARS_DIGITS.indexOf(word.charAt(0)) == -1) continue;
            try {
                size = Integer.parseInt(word);
            }
            catch (NumberFormatException ex) {}
        }
        return size;
    }

    static {
        GraphicsEnvironment ge = GraphicsEnvironment.getLocalGraphicsEnvironment();
        if (!ge.isHeadless()) {
            GraphicsConfiguration gc = ge.getDefaultScreenDevice().getDefaultConfiguration();
            AffineTransform at = gc.getNormalizingTransform();
            fontScale = at.getScaleY();
        }
    }
}

