/*
 * Decompiled with CFR 0.152.
 */
package com.sun.java.swing.plaf.motif;

import com.sun.java.swing.plaf.motif.MotifGraphicsUtils;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import javax.swing.AbstractButton;
import javax.swing.ButtonModel;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JInternalFrame;
import javax.swing.JMenuBar;
import javax.swing.JPopupMenu;
import javax.swing.UIManager;
import javax.swing.border.AbstractBorder;
import javax.swing.plaf.UIResource;
import sun.swing.SwingUtilities2;

public class MotifBorders {
    public static void drawBezel(Graphics g, int x, int y, int w, int h, boolean isPressed, boolean hasFocus, Color shadow, Color highlight, Color darkShadow, Color focus) {
        Color oldColor = g.getColor();
        g.translate(x, y);
        if (isPressed) {
            if (hasFocus) {
                g.setColor(focus);
                g.drawRect(0, 0, w - 1, h - 1);
            }
            g.setColor(shadow);
            g.drawRect(1, 1, w - 3, h - 3);
            g.setColor(highlight);
            g.drawLine(2, h - 3, w - 3, h - 3);
            g.drawLine(w - 3, 2, w - 3, h - 4);
        } else {
            if (hasFocus) {
                g.setColor(focus);
                g.drawRect(0, 0, w - 1, h - 1);
                g.setColor(highlight);
                g.drawLine(1, 1, 1, h - 3);
                g.drawLine(2, 1, w - 4, 1);
                g.setColor(shadow);
                g.drawLine(2, h - 3, w - 3, h - 3);
                g.drawLine(w - 3, 1, w - 3, h - 4);
                g.setColor(darkShadow);
                g.drawLine(1, h - 2, w - 2, h - 2);
                g.drawLine(w - 2, h - 2, w - 2, 1);
            } else {
                g.setColor(highlight);
                g.drawLine(1, 1, 1, h - 3);
                g.drawLine(2, 1, w - 4, 1);
                g.setColor(shadow);
                g.drawLine(2, h - 3, w - 3, h - 3);
                g.drawLine(w - 3, 1, w - 3, h - 4);
                g.setColor(darkShadow);
                g.drawLine(1, h - 2, w - 2, h - 2);
                g.drawLine(w - 2, h - 2, w - 2, 0);
            }
            g.translate(-x, -y);
        }
        g.setColor(oldColor);
    }

    public static class MotifPopupMenuBorder
    extends AbstractBorder
    implements UIResource {
        protected Font font;
        protected Color background;
        protected Color foreground;
        protected Color shadowColor;
        protected Color highlightColor;
        protected static final int TEXT_SPACING = 2;
        protected static final int GROOVE_HEIGHT = 2;

        public MotifPopupMenuBorder(Font titleFont, Color bgColor, Color fgColor, Color shadow, Color highlight) {
            this.font = titleFont;
            this.background = bgColor;
            this.foreground = fgColor;
            this.shadowColor = shadow;
            this.highlightColor = highlight;
        }

        @Override
        public void paintBorder(Component c, Graphics g, int x, int y, int width, int height) {
            Font origFont = g.getFont();
            Color origColor = g.getColor();
            JPopupMenu popup = (JPopupMenu)c;
            String title = popup.getLabel();
            if (title == null) {
                return;
            }
            g.setFont(this.font);
            FontMetrics fm = SwingUtilities2.getFontMetrics(popup, g, this.font);
            int fontHeight = fm.getHeight();
            int descent = fm.getDescent();
            int ascent = fm.getAscent();
            Point textLoc = new Point();
            int stringWidth = SwingUtilities2.stringWidth(popup, fm, title);
            textLoc.y = y + ascent + 2;
            textLoc.x = x + (width - stringWidth) / 2;
            g.setColor(this.background);
            g.fillRect(textLoc.x - 2, textLoc.y - (fontHeight - descent), stringWidth + 4, fontHeight - descent);
            g.setColor(this.foreground);
            SwingUtilities2.drawString((JComponent)popup, g, title, textLoc.x, textLoc.y);
            MotifGraphicsUtils.drawGroove(g, x, textLoc.y + 2, width, 2, this.shadowColor, this.highlightColor);
            g.setFont(origFont);
            g.setColor(origColor);
        }

        @Override
        public Insets getBorderInsets(Component c) {
            return this.getBorderInsets(c, new Insets(0, 0, 0, 0));
        }

        @Override
        public Insets getBorderInsets(Component c, Insets insets) {
            int descent = 0;
            int ascent = 16;
            String title = ((JPopupMenu)c).getLabel();
            if (title == null) {
                insets.bottom = 0;
                insets.right = 0;
                insets.top = 0;
                insets.left = 0;
                return insets;
            }
            FontMetrics fm = c.getFontMetrics(this.font);
            if (fm != null) {
                descent = fm.getDescent();
                ascent = fm.getAscent();
            }
            insets.top += ascent + descent + 2 + 2;
            return insets;
        }
    }

    public static class InternalFrameBorder
    extends FrameBorder {
        JInternalFrame frame;
        public static final int CORNER_SIZE = 24;

        public InternalFrameBorder(JInternalFrame aFrame) {
            super(aFrame);
            this.frame = aFrame;
        }

        public void setFrame(JInternalFrame aFrame) {
            this.frame = aFrame;
        }

        public JInternalFrame frame() {
            return this.frame;
        }

        public int resizePartWidth() {
            if (!this.frame.isResizable()) {
                return 0;
            }
            return 5;
        }

        @Override
        protected boolean drawTopBorder(Component c, Graphics g, int x, int y, int width, int height) {
            if (super.drawTopBorder(c, g, x, y, width, height) && this.frame.isResizable()) {
                g.setColor(this.getFrameShadow());
                g.drawLine(23, y + 1, 23, y + 4);
                g.drawLine(width - 24 - 1, y + 1, width - 24 - 1, y + 4);
                g.setColor(this.getFrameHighlight());
                g.drawLine(24, y, 24, y + 4);
                g.drawLine(width - 24, y, width - 24, y + 4);
                return true;
            }
            return false;
        }

        @Override
        protected boolean drawLeftBorder(Component c, Graphics g, int x, int y, int width, int height) {
            if (super.drawLeftBorder(c, g, x, y, width, height) && this.frame.isResizable()) {
                g.setColor(this.getFrameHighlight());
                int topY = y + 24;
                g.drawLine(x, topY, x + 4, topY);
                int bottomY = height - 24;
                g.drawLine(x + 1, bottomY, x + 5, bottomY);
                g.setColor(this.getFrameShadow());
                g.drawLine(x + 1, topY - 1, x + 5, topY - 1);
                g.drawLine(x + 1, bottomY - 1, x + 5, bottomY - 1);
                return true;
            }
            return false;
        }

        @Override
        protected boolean drawRightBorder(Component c, Graphics g, int x, int y, int width, int height) {
            if (super.drawRightBorder(c, g, x, y, width, height) && this.frame.isResizable()) {
                int startX = width - this.getBorderInsets((Component)c).right;
                g.setColor(this.getFrameHighlight());
                int topY = y + 24;
                g.drawLine(startX, topY, width - 2, topY);
                int bottomY = height - 24;
                g.drawLine(startX + 1, bottomY, startX + 3, bottomY);
                g.setColor(this.getFrameShadow());
                g.drawLine(startX + 1, topY - 1, width - 2, topY - 1);
                g.drawLine(startX + 1, bottomY - 1, startX + 3, bottomY - 1);
                return true;
            }
            return false;
        }

        @Override
        protected boolean drawBottomBorder(Component c, Graphics g, int x, int y, int width, int height) {
            if (super.drawBottomBorder(c, g, x, y, width, height) && this.frame.isResizable()) {
                int startY = height - this.getBorderInsets((Component)c).bottom;
                g.setColor(this.getFrameShadow());
                g.drawLine(23, startY + 1, 23, height - 1);
                g.drawLine(width - 24, startY + 1, width - 24, height - 1);
                g.setColor(this.getFrameHighlight());
                g.drawLine(24, startY, 24, height - 2);
                g.drawLine(width - 24 + 1, startY, width - 24 + 1, height - 2);
                return true;
            }
            return false;
        }

        @Override
        protected boolean isActiveFrame() {
            return this.frame.isSelected();
        }
    }

    public static class FrameBorder
    extends AbstractBorder
    implements UIResource {
        JComponent jcomp;
        Color frameHighlight;
        Color frameColor;
        Color frameShadow;
        public static final int BORDER_SIZE = 5;
        static Insets insets = new Insets(5, 5, 5, 5);

        public FrameBorder(JComponent comp) {
            this.jcomp = comp;
        }

        public void setComponent(JComponent comp) {
            this.jcomp = comp;
        }

        public JComponent component() {
            return this.jcomp;
        }

        protected Color getFrameHighlight() {
            return this.frameHighlight;
        }

        protected Color getFrameColor() {
            return this.frameColor;
        }

        protected Color getFrameShadow() {
            return this.frameShadow;
        }

        @Override
        public Insets getBorderInsets(Component c) {
            return insets;
        }

        @Override
        public Insets getBorderInsets(Component c, Insets newInsets) {
            newInsets.top = FrameBorder.insets.top;
            newInsets.left = FrameBorder.insets.left;
            newInsets.bottom = FrameBorder.insets.bottom;
            newInsets.right = FrameBorder.insets.right;
            return newInsets;
        }

        protected boolean drawTopBorder(Component c, Graphics g, int x, int y, int width, int height) {
            Rectangle titleBarRect = new Rectangle(x, y, width, 5);
            if (!g.getClipBounds().intersects(titleBarRect)) {
                return false;
            }
            int maxX = width - 1;
            int maxY = 4;
            g.setColor(this.frameColor);
            g.drawLine(x, y + 2, maxX - 2, y + 2);
            g.drawLine(x, y + 3, maxX - 2, y + 3);
            g.drawLine(x, y + 4, maxX - 2, y + 4);
            g.setColor(this.frameHighlight);
            g.drawLine(x, y, maxX, y);
            g.drawLine(x, y + 1, maxX, y + 1);
            g.drawLine(x, y + 2, x, y + 4);
            g.drawLine(x + 1, y + 2, x + 1, y + 4);
            g.setColor(this.frameShadow);
            g.drawLine(x + 4, y + 4, maxX - 4, y + 4);
            g.drawLine(maxX, y + 1, maxX, maxY);
            g.drawLine(maxX - 1, y + 2, maxX - 1, maxY);
            return true;
        }

        protected boolean drawLeftBorder(Component c, Graphics g, int x, int y, int width, int height) {
            Rectangle borderRect = new Rectangle(0, 0, this.getBorderInsets((Component)c).left, height);
            if (!g.getClipBounds().intersects(borderRect)) {
                return false;
            }
            int startY = 5;
            g.setColor(this.frameHighlight);
            g.drawLine(x, startY, x, height - 1);
            g.drawLine(x + 1, startY, x + 1, height - 2);
            g.setColor(this.frameColor);
            g.fillRect(x + 2, startY, x + 2, height - 3);
            g.setColor(this.frameShadow);
            g.drawLine(x + 4, startY, x + 4, height - 5);
            return true;
        }

        protected boolean drawRightBorder(Component c, Graphics g, int x, int y, int width, int height) {
            Rectangle borderRect = new Rectangle(width - this.getBorderInsets((Component)c).right, 0, this.getBorderInsets((Component)c).right, height);
            if (!g.getClipBounds().intersects(borderRect)) {
                return false;
            }
            int startX = width - this.getBorderInsets((Component)c).right;
            int startY = 5;
            g.setColor(this.frameColor);
            g.fillRect(startX + 1, startY, 2, height - 1);
            g.setColor(this.frameShadow);
            g.fillRect(startX + 3, startY, 2, height - 1);
            g.setColor(this.frameHighlight);
            g.drawLine(startX, startY, startX, height - 1);
            return true;
        }

        protected boolean drawBottomBorder(Component c, Graphics g, int x, int y, int width, int height) {
            Rectangle borderRect = new Rectangle(0, height - this.getBorderInsets((Component)c).bottom, width, this.getBorderInsets((Component)c).bottom);
            if (!g.getClipBounds().intersects(borderRect)) {
                return false;
            }
            int startY = height - this.getBorderInsets((Component)c).bottom;
            g.setColor(this.frameShadow);
            g.drawLine(x + 1, height - 1, width - 1, height - 1);
            g.drawLine(x + 2, height - 2, width - 2, height - 2);
            g.setColor(this.frameColor);
            g.fillRect(x + 2, startY + 1, width - 4, 2);
            g.setColor(this.frameHighlight);
            g.drawLine(x + 5, startY, width - 5, startY);
            return true;
        }

        protected boolean isActiveFrame() {
            return this.jcomp.hasFocus();
        }

        @Override
        public void paintBorder(Component c, Graphics g, int x, int y, int width, int height) {
            this.frameColor = this.isActiveFrame() ? UIManager.getColor("activeCaptionBorder") : UIManager.getColor("inactiveCaptionBorder");
            this.frameHighlight = this.frameColor.brighter();
            this.frameShadow = this.frameColor.darker().darker();
            this.drawTopBorder(c, g, x, y, width, height);
            this.drawLeftBorder(c, g, x, y, width, height);
            this.drawRightBorder(c, g, x, y, width, height);
            this.drawBottomBorder(c, g, x, y, width, height);
        }
    }

    public static class MenuBarBorder
    extends ButtonBorder {
        public MenuBarBorder(Color shadow, Color highlight, Color darkShadow, Color focus) {
            super(shadow, highlight, darkShadow, focus);
        }

        @Override
        public void paintBorder(Component c, Graphics g, int x, int y, int width, int height) {
            JMenuBar menuBar = (JMenuBar)c;
            if (menuBar.isBorderPainted()) {
                Dimension size = menuBar.getSize();
                MotifBorders.drawBezel(g, x, y, size.width, size.height, false, false, this.shadow, this.highlight, this.darkShadow, this.focus);
            }
        }

        @Override
        public Insets getBorderInsets(Component c) {
            return this.getBorderInsets(c, new Insets(0, 0, 0, 0));
        }

        @Override
        public Insets getBorderInsets(Component c, Insets insets) {
            insets.right = 6;
            insets.bottom = 6;
            insets.left = 6;
            insets.top = 6;
            return insets;
        }
    }

    public static class ToggleButtonBorder
    extends ButtonBorder {
        public ToggleButtonBorder(Color shadow, Color highlight, Color darkShadow, Color focus) {
            super(shadow, highlight, darkShadow, focus);
        }

        @Override
        public void paintBorder(Component c, Graphics g, int x, int y, int width, int height) {
            if (c instanceof AbstractButton) {
                AbstractButton b = (AbstractButton)c;
                ButtonModel model = b.getModel();
                if (model.isArmed() && model.isPressed() || model.isSelected()) {
                    MotifBorders.drawBezel(g, x, y, width, height, model.isPressed() || model.isSelected(), b.isFocusPainted() && b.hasFocus(), this.shadow, this.highlight, this.darkShadow, this.focus);
                } else {
                    MotifBorders.drawBezel(g, x, y, width, height, false, b.isFocusPainted() && b.hasFocus(), this.shadow, this.highlight, this.darkShadow, this.focus);
                }
            } else {
                MotifBorders.drawBezel(g, x, y, width, height, false, false, this.shadow, this.highlight, this.darkShadow, this.focus);
            }
        }

        @Override
        public Insets getBorderInsets(Component c) {
            return new Insets(2, 2, 3, 3);
        }

        @Override
        public Insets getBorderInsets(Component c, Insets insets) {
            insets.left = 2;
            insets.top = 2;
            insets.right = 3;
            insets.bottom = 3;
            return insets;
        }
    }

    public static class ButtonBorder
    extends AbstractBorder
    implements UIResource {
        protected Color focus = UIManager.getColor("activeCaptionBorder");
        protected Color shadow = UIManager.getColor("Button.shadow");
        protected Color highlight = UIManager.getColor("Button.light");
        protected Color darkShadow;

        public ButtonBorder(Color shadow, Color highlight, Color darkShadow, Color focus) {
            this.shadow = shadow;
            this.highlight = highlight;
            this.darkShadow = darkShadow;
            this.focus = focus;
        }

        @Override
        public void paintBorder(Component c, Graphics g, int x, int y, int w, int h) {
            boolean isPressed = false;
            boolean hasFocus = false;
            boolean canBeDefault = false;
            boolean isDefault = false;
            if (c instanceof AbstractButton) {
                AbstractButton b = (AbstractButton)c;
                ButtonModel model = b.getModel();
                isPressed = model.isArmed() && model.isPressed();
                boolean bl = hasFocus = model.isArmed() && isPressed || b.isFocusPainted() && b.hasFocus();
                if (b instanceof JButton) {
                    canBeDefault = ((JButton)b).isDefaultCapable();
                    isDefault = ((JButton)b).isDefaultButton();
                }
            }
            int bx1 = x + 1;
            int by1 = y + 1;
            int bx2 = x + w - 2;
            int by2 = y + h - 2;
            if (canBeDefault) {
                if (isDefault) {
                    g.setColor(this.shadow);
                    g.drawLine(x + 3, y + 3, x + 3, y + h - 4);
                    g.drawLine(x + 3, y + 3, x + w - 4, y + 3);
                    g.setColor(this.highlight);
                    g.drawLine(x + 4, y + h - 4, x + w - 4, y + h - 4);
                    g.drawLine(x + w - 4, y + 3, x + w - 4, y + h - 4);
                }
                bx1 += 6;
                by1 += 6;
                bx2 -= 6;
                by2 -= 6;
            }
            if (hasFocus) {
                g.setColor(this.focus);
                if (isDefault) {
                    g.drawRect(x, y, w - 1, h - 1);
                } else {
                    g.drawRect(bx1 - 1, by1 - 1, bx2 - bx1 + 2, by2 - by1 + 2);
                }
            }
            g.setColor(isPressed ? this.shadow : this.highlight);
            g.drawLine(bx1, by1, bx2, by1);
            g.drawLine(bx1, by1, bx1, by2);
            g.setColor(isPressed ? this.highlight : this.shadow);
            g.drawLine(bx2, by1 + 1, bx2, by2);
            g.drawLine(bx1 + 1, by2, bx2, by2);
        }

        @Override
        public Insets getBorderInsets(Component c) {
            return this.getBorderInsets(c, new Insets(0, 0, 0, 0));
        }

        @Override
        public Insets getBorderInsets(Component c, Insets insets) {
            int thickness;
            insets.bottom = insets.right = (thickness = c instanceof JButton && ((JButton)c).isDefaultCapable() ? 8 : 2);
            insets.left = insets.right;
            insets.top = insets.right;
            return insets;
        }
    }

    public static class FocusBorder
    extends AbstractBorder
    implements UIResource {
        private Color focus;
        private Color control;

        public FocusBorder(Color control, Color focus) {
            this.control = control;
            this.focus = focus;
        }

        @Override
        public void paintBorder(Component c, Graphics g, int x, int y, int w, int h) {
            if (((JComponent)c).hasFocus()) {
                g.setColor(this.focus);
                g.drawRect(x, y, w - 1, h - 1);
            } else {
                g.setColor(this.control);
                g.drawRect(x, y, w - 1, h - 1);
            }
        }

        @Override
        public Insets getBorderInsets(Component c) {
            return this.getBorderInsets(c, new Insets(0, 0, 0, 0));
        }

        @Override
        public Insets getBorderInsets(Component c, Insets insets) {
            insets.right = 1;
            insets.bottom = 1;
            insets.left = 1;
            insets.top = 1;
            return insets;
        }
    }

    public static class BevelBorder
    extends AbstractBorder
    implements UIResource {
        private Color darkShadow = UIManager.getColor("controlShadow");
        private Color lightShadow = UIManager.getColor("controlLtHighlight");
        private boolean isRaised;

        public BevelBorder(boolean isRaised, Color darkShadow, Color lightShadow) {
            this.isRaised = isRaised;
            this.darkShadow = darkShadow;
            this.lightShadow = lightShadow;
        }

        @Override
        public void paintBorder(Component c, Graphics g, int x, int y, int w, int h) {
            g.setColor(this.isRaised ? this.lightShadow : this.darkShadow);
            g.drawLine(x, y, x + w - 1, y);
            g.drawLine(x, y + h - 1, x, y + 1);
            g.setColor(this.isRaised ? this.darkShadow : this.lightShadow);
            g.drawLine(x + 1, y + h - 1, x + w - 1, y + h - 1);
            g.drawLine(x + w - 1, y + h - 1, x + w - 1, y + 1);
        }

        @Override
        public Insets getBorderInsets(Component c) {
            return this.getBorderInsets(c, new Insets(0, 0, 0, 0));
        }

        @Override
        public Insets getBorderInsets(Component c, Insets insets) {
            insets.right = 1;
            insets.bottom = 1;
            insets.left = 1;
            insets.top = 1;
            return insets;
        }

        public boolean isOpaque(Component c) {
            return true;
        }
    }
}

