/*
 * Decompiled with CFR 0.152.
 */
package java.awt;

import java.awt.Component;
import java.awt.Container;
import java.awt.FocusTraversalPolicy;
import java.awt.MutableBoolean;
import java.awt.Window;
import java.io.Serializable;
import java.util.logging.Level;
import java.util.logging.Logger;

public class ContainerOrderFocusTraversalPolicy
extends FocusTraversalPolicy
implements Serializable {
    private static final MutableBoolean found = new MutableBoolean();
    private static final Logger log = Logger.getLogger("java.awt.ContainerOrderFocusTraversalPolicy");
    private static final long serialVersionUID = 486933713763926351L;
    private boolean implicitDownCycleTraversal = true;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Component getComponentAfter(Container aContainer, Component aComponent) {
        if (log.isLoggable(Level.FINE)) {
            log.fine("Looking for next component in " + aContainer + " for " + aComponent);
        }
        if (aContainer == null || aComponent == null) {
            throw new IllegalArgumentException("aContainer and aComponent cannot be null");
        }
        if (!aContainer.isFocusTraversalPolicyProvider() && !aContainer.isFocusCycleRoot()) {
            throw new IllegalArgumentException("aContainer should be focus cycle root or focus traversal policy provider");
        }
        if (aContainer.isFocusCycleRoot() && !aComponent.isFocusCycleRoot(aContainer)) {
            throw new IllegalArgumentException("aContainer is not a focus cycle root of aComponent");
        }
        Object object = aContainer.getTreeLock();
        synchronized (object) {
            ContainerOrderFocusTraversalPolicy.found.value = false;
            Component retval = this.getComponentAfter(aContainer, aComponent, found);
            if (retval != null) {
                if (log.isLoggable(Level.FINE)) {
                    log.fine("After component is " + retval);
                }
                return retval;
            }
            if (ContainerOrderFocusTraversalPolicy.found.value) {
                if (log.isLoggable(Level.FINE)) {
                    log.fine("Didn't find next component in " + aContainer + " - falling back to the first ");
                }
                return this.getFirstComponent(aContainer);
            }
            if (log.isLoggable(Level.FINE)) {
                log.fine("After component is null");
            }
            return null;
        }
    }

    private Component getComponentAfter(Container aContainer, Component aComponent, MutableBoolean found) {
        if (!aContainer.isVisible() || !aContainer.isDisplayable()) {
            return null;
        }
        if (found.value) {
            if (this.accept(aContainer)) {
                return aContainer;
            }
        } else if (aContainer == aComponent) {
            found.value = true;
        }
        for (int i = 0; i < aContainer.getComponentCount(); ++i) {
            Container cont;
            Component retval;
            Component comp = aContainer.getComponent(i);
            if (comp instanceof Container && !((Container)comp).isFocusCycleRoot()) {
                Component retval2 = null;
                if (((Container)comp).isFocusTraversalPolicyProvider()) {
                    if (log.isLoggable(Level.FINE)) {
                        log.fine("Entering FTP " + comp);
                    }
                    Container cont2 = (Container)comp;
                    FocusTraversalPolicy policy = cont2.getFocusTraversalPolicy();
                    if (log.isLoggable(Level.FINE)) {
                        log.fine("FTP contains " + aComponent + ": " + cont2.isAncestorOf(aComponent));
                    }
                    if (found.value) {
                        retval2 = policy.getDefaultComponent(cont2);
                        if (log.isLoggable(Level.FINE)) {
                            log.fine("Used FTP for getting default component: " + retval2);
                        }
                    } else {
                        found.value = cont2.isAncestorOf(aComponent);
                        if (found.value) {
                            if (aComponent == policy.getLastComponent(cont2)) {
                                retval2 = null;
                            } else {
                                retval2 = policy.getComponentAfter(cont2, aComponent);
                                if (log.isLoggable(Level.FINE)) {
                                    log.fine("FTP found next for the component : " + retval2);
                                }
                            }
                        }
                    }
                } else {
                    retval2 = this.getComponentAfter((Container)comp, aComponent, found);
                }
                if (retval2 != null) {
                    return retval2;
                }
            } else if (found.value) {
                if (this.accept(comp)) {
                    return comp;
                }
            } else if (comp == aComponent) {
                found.value = true;
            }
            if (!found.value || !this.getImplicitDownCycleTraversal() || !(comp instanceof Container) || !((Container)comp).isFocusCycleRoot() || (retval = (cont = (Container)comp).getFocusTraversalPolicy().getDefaultComponent(cont)) == null) continue;
            return retval;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Component getComponentBefore(Container aContainer, Component aComponent) {
        if (aContainer == null || aComponent == null) {
            throw new IllegalArgumentException("aContainer and aComponent cannot be null");
        }
        if (!aContainer.isFocusTraversalPolicyProvider() && !aContainer.isFocusCycleRoot()) {
            throw new IllegalArgumentException("aContainer should be focus cycle root or focus traversal policy provider");
        }
        if (aContainer.isFocusCycleRoot() && !aComponent.isFocusCycleRoot(aContainer)) {
            throw new IllegalArgumentException("aContainer is not a focus cycle root of aComponent");
        }
        Object object = aContainer.getTreeLock();
        synchronized (object) {
            ContainerOrderFocusTraversalPolicy.found.value = false;
            Component retval = this.getComponentBefore(aContainer, aComponent, found);
            if (retval != null) {
                if (log.isLoggable(Level.FINE)) {
                    log.fine("Before component is " + retval);
                }
                return retval;
            }
            if (ContainerOrderFocusTraversalPolicy.found.value) {
                if (log.isLoggable(Level.FINE)) {
                    log.fine("Didn't find before component in " + aContainer + " - falling back to the first ");
                }
                return this.getLastComponent(aContainer);
            }
            if (log.isLoggable(Level.FINE)) {
                log.fine("Before component is null");
            }
            return null;
        }
    }

    private Component getComponentBefore(Container aContainer, Component aComponent, MutableBoolean found) {
        if (!aContainer.isVisible() || !aContainer.isDisplayable()) {
            return null;
        }
        for (int i = aContainer.getComponentCount() - 1; i >= 0; --i) {
            Component comp = aContainer.getComponent(i);
            if (comp == aComponent) {
                found.value = true;
                continue;
            }
            if (comp instanceof Container && !((Container)comp).isFocusCycleRoot()) {
                Component retval = null;
                if (((Container)comp).isFocusTraversalPolicyProvider()) {
                    if (log.isLoggable(Level.FINE)) {
                        log.fine("Entering FTP " + comp);
                    }
                    Container cont = (Container)comp;
                    FocusTraversalPolicy policy = cont.getFocusTraversalPolicy();
                    if (log.isLoggable(Level.FINE)) {
                        log.fine("FTP contains " + aComponent + ": " + cont.isAncestorOf(aComponent));
                    }
                    if (found.value) {
                        retval = policy.getLastComponent(cont);
                        if (log.isLoggable(Level.FINE)) {
                            log.fine("Used FTP for getting last component: " + retval);
                        }
                    } else {
                        found.value = cont.isAncestorOf(aComponent);
                        if (found.value) {
                            if (aComponent == policy.getFirstComponent(cont)) {
                                retval = null;
                            } else {
                                retval = policy.getComponentBefore(cont, aComponent);
                                if (log.isLoggable(Level.FINE)) {
                                    log.fine("FTP found previous for the component : " + retval);
                                }
                            }
                        }
                    }
                } else {
                    retval = this.getComponentBefore((Container)comp, aComponent, found);
                }
                if (retval == null) continue;
                return retval;
            }
            if (!found.value || !this.accept(comp)) continue;
            return comp;
        }
        if (found.value) {
            if (this.accept(aContainer)) {
                return aContainer;
            }
        } else if (aContainer == aComponent) {
            found.value = true;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Component getFirstComponent(Container aContainer) {
        if (aContainer == null) {
            throw new IllegalArgumentException("aContainer cannot be null");
        }
        Object object = aContainer.getTreeLock();
        synchronized (object) {
            if (!aContainer.isVisible() || !aContainer.isDisplayable()) {
                return null;
            }
            if (this.accept(aContainer)) {
                return aContainer;
            }
            for (int i = 0; i < aContainer.getComponentCount(); ++i) {
                Component comp = aContainer.getComponent(i);
                if (comp instanceof Container && !((Container)comp).isFocusCycleRoot()) {
                    Component retval = null;
                    Container cont = (Container)comp;
                    if (cont.isFocusTraversalPolicyProvider()) {
                        FocusTraversalPolicy policy = cont.getFocusTraversalPolicy();
                        retval = policy.getDefaultComponent(cont);
                    } else {
                        retval = this.getFirstComponent((Container)comp);
                    }
                    if (retval == null) continue;
                    return retval;
                }
                if (!this.accept(comp)) continue;
                return comp;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Component getLastComponent(Container aContainer) {
        if (aContainer == null) {
            throw new IllegalArgumentException("aContainer cannot be null");
        }
        if (log.isLoggable(Level.FINE)) {
            log.fine("Looking for the last component in " + aContainer);
        }
        Object object = aContainer.getTreeLock();
        synchronized (object) {
            if (!aContainer.isVisible() || !aContainer.isDisplayable()) {
                return null;
            }
            for (int i = aContainer.getComponentCount() - 1; i >= 0; --i) {
                Component comp = aContainer.getComponent(i);
                if (comp instanceof Container && !((Container)comp).isFocusCycleRoot()) {
                    Component retval = null;
                    Container cont = (Container)comp;
                    if (cont.isFocusTraversalPolicyProvider()) {
                        if (log.isLoggable(Level.FINE)) {
                            log.fine("\tEntering FTP " + cont);
                        }
                        FocusTraversalPolicy policy = cont.getFocusTraversalPolicy();
                        retval = policy.getLastComponent(cont);
                    } else {
                        if (log.isLoggable(Level.FINE)) {
                            log.fine("\tEntering sub-container");
                        }
                        retval = this.getLastComponent((Container)comp);
                    }
                    if (retval == null) continue;
                    if (log.isLoggable(Level.FINE)) {
                        log.fine("\tFound last component : " + retval);
                    }
                    return retval;
                }
                if (!this.accept(comp)) continue;
                return comp;
            }
            if (this.accept(aContainer)) {
                return aContainer;
            }
        }
        return null;
    }

    public Component getDefaultComponent(Container aContainer) {
        return this.getFirstComponent(aContainer);
    }

    public void setImplicitDownCycleTraversal(boolean implicitDownCycleTraversal) {
        this.implicitDownCycleTraversal = implicitDownCycleTraversal;
    }

    public boolean getImplicitDownCycleTraversal() {
        return this.implicitDownCycleTraversal;
    }

    protected boolean accept(Component aComponent) {
        if (!aComponent.canBeFocusOwner()) {
            return false;
        }
        if (!(aComponent instanceof Window)) {
            for (Container enableTest = aComponent.getParent(); enableTest != null; enableTest = enableTest.getParent()) {
                if (!enableTest.isEnabled() && !enableTest.isLightweight()) {
                    return false;
                }
                if (enableTest instanceof Window) break;
            }
        }
        return true;
    }
}

