/*
 * Decompiled with CFR 0.152.
 */
package java.awt;

import java.awt.AWTError;
import java.awt.Adjustable;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.GraphicsEnvironment;
import java.awt.HeadlessException;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Panel;
import java.awt.Point;
import java.awt.ScrollPaneAdjustable;
import java.awt.Toolkit;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import java.awt.event.MouseWheelEvent;
import java.awt.peer.ScrollPanePeer;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import javax.accessibility.Accessible;
import javax.accessibility.AccessibleContext;
import javax.accessibility.AccessibleRole;
import sun.awt.ScrollPaneWheelScroller;
import sun.awt.SunToolkit;

public class ScrollPane
extends Container
implements Accessible {
    public static final int SCROLLBARS_AS_NEEDED = 0;
    public static final int SCROLLBARS_ALWAYS = 1;
    public static final int SCROLLBARS_NEVER = 2;
    private int scrollbarDisplayPolicy;
    private ScrollPaneAdjustable vAdjustable;
    private ScrollPaneAdjustable hAdjustable;
    private static final String base = "scrollpane";
    private static int nameCounter;
    private static final boolean defaultWheelScroll = true;
    private boolean wheelScrollingEnabled = true;
    private static final long serialVersionUID = 7956609840827222915L;

    private static native void initIDs();

    public ScrollPane() throws HeadlessException {
        this(0);
    }

    public ScrollPane(int scrollbarDisplayPolicy) throws HeadlessException {
        GraphicsEnvironment.checkHeadless();
        this.layoutMgr = null;
        this.width = 100;
        this.height = 100;
        switch (scrollbarDisplayPolicy) {
            case 0: 
            case 1: 
            case 2: {
                this.scrollbarDisplayPolicy = scrollbarDisplayPolicy;
                break;
            }
            default: {
                throw new IllegalArgumentException("illegal scrollbar display policy");
            }
        }
        this.vAdjustable = new ScrollPaneAdjustable(this, new PeerFixer(this), 1);
        this.hAdjustable = new ScrollPaneAdjustable(this, new PeerFixer(this), 0);
        this.setWheelScrollingEnabled(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    String constructComponentName() {
        Class<ScrollPane> clazz = ScrollPane.class;
        synchronized (ScrollPane.class) {
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return base + nameCounter++;
        }
    }

    private void addToPanel(Component comp, Object constraints, int index) {
        Panel child = new Panel();
        child.setLayout(new BorderLayout());
        child.add(comp);
        super.addImpl(child, constraints, index);
        this.validate();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void addImpl(Component comp, Object constraints, int index) {
        Object object = this.getTreeLock();
        synchronized (object) {
            if (this.getComponentCount() > 0) {
                this.remove(0);
            }
            if (index > 0) {
                throw new IllegalArgumentException("position greater than 0");
            }
            if (!SunToolkit.isLightweightOrUnknown(comp)) {
                super.addImpl(comp, constraints, index);
            } else {
                this.addToPanel(comp, constraints, index);
            }
        }
    }

    public int getScrollbarDisplayPolicy() {
        return this.scrollbarDisplayPolicy;
    }

    public Dimension getViewportSize() {
        Insets i = this.getInsets();
        return new Dimension(this.width - i.right - i.left, this.height - i.top - i.bottom);
    }

    public int getHScrollbarHeight() {
        ScrollPanePeer peer;
        int h = 0;
        if (this.scrollbarDisplayPolicy != 2 && (peer = (ScrollPanePeer)this.peer) != null) {
            h = peer.getHScrollbarHeight();
        }
        return h;
    }

    public int getVScrollbarWidth() {
        ScrollPanePeer peer;
        int w = 0;
        if (this.scrollbarDisplayPolicy != 2 && (peer = (ScrollPanePeer)this.peer) != null) {
            w = peer.getVScrollbarWidth();
        }
        return w;
    }

    public Adjustable getVAdjustable() {
        return this.vAdjustable;
    }

    public Adjustable getHAdjustable() {
        return this.hAdjustable;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setScrollPosition(int x, int y) {
        Object object = this.getTreeLock();
        synchronized (object) {
            if (this.getComponentCount() == 0) {
                throw new NullPointerException("child is null");
            }
            this.hAdjustable.setValue(x);
            this.vAdjustable.setValue(y);
        }
    }

    public void setScrollPosition(Point p) {
        this.setScrollPosition(p.x, p.y);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Point getScrollPosition() {
        Object object = this.getTreeLock();
        synchronized (object) {
            if (this.getComponentCount() == 0) {
                throw new NullPointerException("child is null");
            }
            return new Point(this.hAdjustable.getValue(), this.vAdjustable.getValue());
        }
    }

    public final void setLayout(LayoutManager mgr) {
        throw new AWTError("ScrollPane controls layout");
    }

    public void doLayout() {
        this.layout();
    }

    Dimension calculateChildSize() {
        boolean hbarOn;
        boolean vbarOn;
        Dimension size = this.getSize();
        Insets insets = this.getInsets();
        int viewWidth = size.width - insets.left * 2;
        int viewHeight = size.height - insets.top * 2;
        Component child = this.getComponent(0);
        Dimension childSize = new Dimension(child.getPreferredSize());
        if (this.scrollbarDisplayPolicy == 0) {
            vbarOn = childSize.height > viewHeight;
            hbarOn = childSize.width > viewWidth;
        } else if (this.scrollbarDisplayPolicy == 1) {
            hbarOn = true;
            vbarOn = true;
        } else {
            hbarOn = false;
            vbarOn = false;
        }
        int vbarWidth = this.getVScrollbarWidth();
        int hbarHeight = this.getHScrollbarHeight();
        if (vbarOn) {
            viewWidth -= vbarWidth;
        }
        if (hbarOn) {
            viewHeight -= hbarHeight;
        }
        if (childSize.width < viewWidth) {
            childSize.width = viewWidth;
        }
        if (childSize.height < viewHeight) {
            childSize.height = viewHeight;
        }
        return childSize;
    }

    @Deprecated
    public void layout() {
        if (this.getComponentCount() == 0) {
            return;
        }
        Component c = this.getComponent(0);
        Point p = this.getScrollPosition();
        Dimension cs = this.calculateChildSize();
        Dimension vs = this.getViewportSize();
        Insets i = this.getInsets();
        c.reshape(i.left - p.x, i.top - p.y, cs.width, cs.height);
        ScrollPanePeer peer = (ScrollPanePeer)this.peer;
        if (peer != null) {
            peer.childResized(cs.width, cs.height);
        }
        vs = this.getViewportSize();
        this.hAdjustable.setSpan(0, cs.width, vs.width);
        this.vAdjustable.setSpan(0, cs.height, vs.height);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void printComponents(Graphics g) {
        if (this.getComponentCount() == 0) {
            return;
        }
        Component c = this.getComponent(0);
        Point p = c.getLocation();
        Dimension vs = this.getViewportSize();
        Insets i = this.getInsets();
        Graphics cg = g.create();
        try {
            cg.clipRect(i.left, i.top, vs.width, vs.height);
            cg.translate(p.x, p.y);
            c.printAll(cg);
        }
        finally {
            cg.dispose();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addNotify() {
        Object object = this.getTreeLock();
        synchronized (object) {
            int vAdjustableValue = 0;
            int hAdjustableValue = 0;
            if (this.getComponentCount() > 0) {
                vAdjustableValue = this.vAdjustable.getValue();
                hAdjustableValue = this.hAdjustable.getValue();
                this.vAdjustable.setValue(0);
                this.hAdjustable.setValue(0);
            }
            if (this.peer == null) {
                this.peer = this.getToolkit().createScrollPane(this);
            }
            super.addNotify();
            if (this.getComponentCount() > 0) {
                this.vAdjustable.setValue(vAdjustableValue);
                this.hAdjustable.setValue(hAdjustableValue);
            }
        }
    }

    public String paramString() {
        String sdpStr;
        switch (this.scrollbarDisplayPolicy) {
            case 0: {
                sdpStr = "as-needed";
                break;
            }
            case 1: {
                sdpStr = "always";
                break;
            }
            case 2: {
                sdpStr = "never";
                break;
            }
            default: {
                sdpStr = "invalid display policy";
            }
        }
        Point p = this.getComponentCount() > 0 ? this.getScrollPosition() : new Point(0, 0);
        Insets i = this.getInsets();
        return super.paramString() + ",ScrollPosition=(" + p.x + "," + p.y + ")" + ",Insets=(" + i.top + "," + i.left + "," + i.bottom + "," + i.right + ")" + ",ScrollbarDisplayPolicy=" + sdpStr + ",wheelScrollingEnabled=" + this.isWheelScrollingEnabled();
    }

    void autoProcessMouseWheel(MouseWheelEvent e) {
        this.processMouseWheelEvent(e);
    }

    protected void processMouseWheelEvent(MouseWheelEvent e) {
        if (this.isWheelScrollingEnabled()) {
            ScrollPaneWheelScroller.handleWheelScrolling(this, e);
            e.consume();
        }
        super.processMouseWheelEvent(e);
    }

    protected boolean eventTypeEnabled(int type) {
        if (type == 507 && this.isWheelScrollingEnabled()) {
            return true;
        }
        return super.eventTypeEnabled(type);
    }

    public void setWheelScrollingEnabled(boolean handleWheel) {
        this.wheelScrollingEnabled = handleWheel;
    }

    public boolean isWheelScrollingEnabled() {
        return this.wheelScrollingEnabled;
    }

    private void writeObject(ObjectOutputStream s) throws IOException {
        s.defaultWriteObject();
    }

    private void readObject(ObjectInputStream s) throws ClassNotFoundException, IOException, HeadlessException {
        GraphicsEnvironment.checkHeadless();
        ObjectInputStream.GetField f = s.readFields();
        this.scrollbarDisplayPolicy = f.get("scrollbarDisplayPolicy", 0);
        this.hAdjustable = (ScrollPaneAdjustable)f.get("hAdjustable", null);
        this.vAdjustable = (ScrollPaneAdjustable)f.get("vAdjustable", null);
        this.wheelScrollingEnabled = f.get("wheelScrollingEnabled", true);
    }

    public AccessibleContext getAccessibleContext() {
        if (this.accessibleContext == null) {
            this.accessibleContext = new AccessibleAWTScrollPane();
        }
        return this.accessibleContext;
    }

    static {
        Toolkit.loadLibraries();
        if (!GraphicsEnvironment.isHeadless()) {
            ScrollPane.initIDs();
        }
        nameCounter = 0;
    }

    protected class AccessibleAWTScrollPane
    extends Container.AccessibleAWTContainer {
        private static final long serialVersionUID = 6100703663886637L;

        protected AccessibleAWTScrollPane() {
            super(ScrollPane.this);
        }

        public AccessibleRole getAccessibleRole() {
            return AccessibleRole.SCROLL_PANE;
        }
    }

    class PeerFixer
    implements AdjustmentListener,
    Serializable {
        private static final long serialVersionUID = 1043664721353696630L;
        private ScrollPane scroller;

        PeerFixer(ScrollPane scroller) {
            this.scroller = scroller;
        }

        public void adjustmentValueChanged(AdjustmentEvent e) {
            Adjustable adj = e.getAdjustable();
            int value = e.getValue();
            ScrollPanePeer peer = (ScrollPanePeer)this.scroller.peer;
            if (peer != null) {
                peer.setValue(adj, value);
            }
            Component c = this.scroller.getComponent(0);
            switch (adj.getOrientation()) {
                case 1: {
                    c.move(c.getLocation().x, -value);
                    break;
                }
                case 0: {
                    c.move(-value, c.getLocation().y);
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Illegal adjustable orientation");
                }
            }
        }
    }
}

