/*
 * Decompiled with CFR 0.152.
 */
package javax.swing;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.beans.PropertyVetoException;
import java.io.Serializable;
import javax.swing.DesktopManager;
import javax.swing.JComponent;
import javax.swing.JDesktopPane;
import javax.swing.JInternalFrame;
import javax.swing.JLayeredPane;
import javax.swing.RepaintManager;
import javax.swing.SwingUtilities;

public class DefaultDesktopManager
implements DesktopManager,
Serializable {
    static final String HAS_BEEN_ICONIFIED_PROPERTY = "wasIconOnce";
    static final int DEFAULT_DRAG_MODE = 0;
    static final int OUTLINE_DRAG_MODE = 1;
    static final int FASTER_DRAG_MODE = 2;
    int dragMode = 0;
    private transient Rectangle currentBounds = null;
    private transient Graphics desktopGraphics = null;
    private transient Rectangle desktopBounds = null;
    private transient Rectangle[] floatingItems = new Rectangle[0];
    private transient boolean didDrag;
    private transient Point currentLoc = null;

    @Override
    public void openFrame(JInternalFrame f) {
        if (f.getDesktopIcon().getParent() != null) {
            f.getDesktopIcon().getParent().add(f);
            this.removeIconFor(f);
        }
    }

    @Override
    public void closeFrame(JInternalFrame f) {
        JDesktopPane d = f.getDesktopPane();
        if (d == null) {
            return;
        }
        boolean findNext = f.isSelected();
        Container c = f.getParent();
        JInternalFrame nextFrame = null;
        if (findNext) {
            nextFrame = d.getNextFrame(f);
            try {
                f.setSelected(false);
            }
            catch (PropertyVetoException e2) {
                // empty catch block
            }
        }
        if (c != null) {
            c.remove(f);
            c.repaint(f.getX(), f.getY(), f.getWidth(), f.getHeight());
        }
        this.removeIconFor(f);
        if (f.getNormalBounds() != null) {
            f.setNormalBounds(null);
        }
        if (this.wasIcon(f)) {
            this.setWasIcon(f, null);
        }
        if (nextFrame != null) {
            try {
                nextFrame.setSelected(true);
            }
            catch (PropertyVetoException e2) {}
        } else if (findNext && d.getComponentCount() == 0) {
            d.requestFocus();
        }
    }

    @Override
    public void maximizeFrame(JInternalFrame f) {
        if (f.isIcon()) {
            try {
                f.setIcon(false);
            }
            catch (PropertyVetoException e2) {}
        } else {
            f.setNormalBounds(f.getBounds());
            Rectangle desktopBounds = f.getParent().getBounds();
            this.setBoundsForFrame(f, 0, 0, desktopBounds.width, desktopBounds.height);
        }
        try {
            f.setSelected(true);
        }
        catch (PropertyVetoException propertyVetoException) {
            // empty catch block
        }
    }

    @Override
    public void minimizeFrame(JInternalFrame f) {
        if (f.isIcon()) {
            this.iconifyFrame(f);
            return;
        }
        if (f.getNormalBounds() != null) {
            Rectangle r = f.getNormalBounds();
            f.setNormalBounds(null);
            try {
                f.setSelected(true);
            }
            catch (PropertyVetoException propertyVetoException) {
                // empty catch block
            }
            this.setBoundsForFrame(f, r.x, r.y, r.width, r.height);
        }
    }

    @Override
    public void iconifyFrame(JInternalFrame f) {
        Container c = f.getParent();
        JDesktopPane d = f.getDesktopPane();
        boolean findNext = f.isSelected();
        JInternalFrame.JDesktopIcon desktopIcon = f.getDesktopIcon();
        if (!this.wasIcon(f)) {
            Rectangle r = this.getBoundsForIconOf(f);
            desktopIcon.setBounds(r.x, r.y, r.width, r.height);
            this.setWasIcon(f, Boolean.TRUE);
        }
        if (c == null || d == null) {
            return;
        }
        if (c instanceof JLayeredPane) {
            JLayeredPane lp = (JLayeredPane)c;
            int layer = JLayeredPane.getLayer(f);
            JLayeredPane.putLayer(desktopIcon, layer);
        }
        if (!f.isMaximum()) {
            f.setNormalBounds(f.getBounds());
        }
        d.setComponentOrderCheckingEnabled(false);
        c.remove(f);
        c.add(desktopIcon);
        d.setComponentOrderCheckingEnabled(true);
        c.repaint(f.getX(), f.getY(), f.getWidth(), f.getHeight());
        if (findNext && d.selectFrame(true) == null) {
            f.restoreSubcomponentFocus();
        }
    }

    @Override
    public void deiconifyFrame(JInternalFrame f) {
        JInternalFrame.JDesktopIcon desktopIcon = f.getDesktopIcon();
        Container c = desktopIcon.getParent();
        JDesktopPane d = f.getDesktopPane();
        if (c != null && d != null) {
            c.add(f);
            if (f.isMaximum()) {
                Rectangle desktopBounds = c.getBounds();
                if (f.getWidth() != desktopBounds.width || f.getHeight() != desktopBounds.height) {
                    this.setBoundsForFrame(f, 0, 0, desktopBounds.width, desktopBounds.height);
                }
            }
            this.removeIconFor(f);
            if (f.isSelected()) {
                f.moveToFront();
                f.restoreSubcomponentFocus();
            } else {
                try {
                    f.setSelected(true);
                }
                catch (PropertyVetoException e2) {
                    // empty catch block
                }
            }
        }
    }

    @Override
    public void activateFrame(JInternalFrame f) {
        JInternalFrame currentlyActiveFrame;
        Container p = f.getParent();
        JDesktopPane d = f.getDesktopPane();
        JInternalFrame jInternalFrame = currentlyActiveFrame = d == null ? null : d.getSelectedFrame();
        if (p == null && (p = f.getDesktopIcon().getParent()) == null) {
            return;
        }
        if (currentlyActiveFrame == null) {
            if (d != null) {
                d.setSelectedFrame(f);
            }
        } else if (currentlyActiveFrame != f) {
            if (currentlyActiveFrame.isSelected()) {
                try {
                    currentlyActiveFrame.setSelected(false);
                }
                catch (PropertyVetoException e2) {
                    // empty catch block
                }
            }
            if (d != null) {
                d.setSelectedFrame(f);
            }
        }
        f.moveToFront();
    }

    @Override
    public void deactivateFrame(JInternalFrame f) {
        JInternalFrame currentlyActiveFrame;
        JDesktopPane d = f.getDesktopPane();
        JInternalFrame jInternalFrame = currentlyActiveFrame = d == null ? null : d.getSelectedFrame();
        if (currentlyActiveFrame == f) {
            d.setSelectedFrame(null);
        }
    }

    @Override
    public void beginDraggingFrame(JComponent f) {
        this.setupDragMode(f);
        if (this.dragMode == 2) {
            Container desktop = f.getParent();
            this.floatingItems = this.findFloatingItems(f);
            this.currentBounds = f.getBounds();
            if (desktop instanceof JComponent) {
                this.desktopBounds = ((JComponent)desktop).getVisibleRect();
            } else {
                this.desktopBounds = desktop.getBounds();
                this.desktopBounds.y = 0;
                this.desktopBounds.x = 0;
            }
            this.desktopGraphics = JComponent.safelyGetGraphics(desktop);
            ((JInternalFrame)f).isDragging = true;
            this.didDrag = false;
        }
    }

    private void setupDragMode(JComponent f) {
        JDesktopPane p = this.getDesktopPane(f);
        Container parent = f.getParent();
        this.dragMode = 0;
        if (p != null) {
            String mode = (String)p.getClientProperty("JDesktopPane.dragMode");
            this.dragMode = mode != null && mode.equals("outline") ? 1 : (mode != null && mode.equals("faster") && f instanceof JInternalFrame && ((JInternalFrame)f).isOpaque() && (parent == null || parent.isOpaque()) ? 2 : (p.getDragMode() == 1 ? 1 : (p.getDragMode() == 0 && f instanceof JInternalFrame && ((JInternalFrame)f).isOpaque() ? 2 : 0)));
        }
    }

    @Override
    public void dragFrame(JComponent f, int newX, int newY) {
        if (this.dragMode == 1) {
            JDesktopPane desktopPane = this.getDesktopPane(f);
            if (desktopPane != null) {
                Graphics g = JComponent.safelyGetGraphics(desktopPane);
                g.setXORMode(Color.white);
                if (this.currentLoc != null) {
                    g.drawRect(this.currentLoc.x, this.currentLoc.y, f.getWidth() - 1, f.getHeight() - 1);
                }
                g.drawRect(newX, newY, f.getWidth() - 1, f.getHeight() - 1);
                this.currentLoc = new Point(newX, newY);
                g.dispose();
            }
        } else if (this.dragMode == 2) {
            this.dragFrameFaster(f, newX, newY);
        } else {
            this.setBoundsForFrame(f, newX, newY, f.getWidth(), f.getHeight());
        }
    }

    @Override
    public void endDraggingFrame(JComponent f) {
        if (this.dragMode == 1 && this.currentLoc != null) {
            this.setBoundsForFrame(f, this.currentLoc.x, this.currentLoc.y, f.getWidth(), f.getHeight());
            this.currentLoc = null;
        } else if (this.dragMode == 2) {
            this.currentBounds = null;
            if (this.desktopGraphics != null) {
                this.desktopGraphics.dispose();
                this.desktopGraphics = null;
            }
            this.desktopBounds = null;
            ((JInternalFrame)f).isDragging = false;
        }
    }

    @Override
    public void beginResizingFrame(JComponent f, int direction) {
        this.setupDragMode(f);
    }

    @Override
    public void resizeFrame(JComponent f, int newX, int newY, int newWidth, int newHeight) {
        if (this.dragMode == 0 || this.dragMode == 2) {
            this.setBoundsForFrame(f, newX, newY, newWidth, newHeight);
        } else {
            JDesktopPane desktopPane = this.getDesktopPane(f);
            if (desktopPane != null) {
                Graphics g = JComponent.safelyGetGraphics(desktopPane);
                g.setXORMode(Color.white);
                if (this.currentBounds != null) {
                    g.drawRect(this.currentBounds.x, this.currentBounds.y, this.currentBounds.width - 1, this.currentBounds.height - 1);
                }
                g.drawRect(newX, newY, newWidth - 1, newHeight - 1);
                this.currentBounds = new Rectangle(newX, newY, newWidth, newHeight);
                g.setPaintMode();
                g.dispose();
            }
        }
    }

    @Override
    public void endResizingFrame(JComponent f) {
        if (this.dragMode == 1 && this.currentBounds != null) {
            this.setBoundsForFrame(f, this.currentBounds.x, this.currentBounds.y, this.currentBounds.width, this.currentBounds.height);
            this.currentBounds = null;
        }
    }

    @Override
    public void setBoundsForFrame(JComponent f, int newX, int newY, int newWidth, int newHeight) {
        boolean didResize = f.getWidth() != newWidth || f.getHeight() != newHeight;
        f.setBounds(newX, newY, newWidth, newHeight);
        if (didResize) {
            f.validate();
        }
    }

    protected void removeIconFor(JInternalFrame f) {
        JInternalFrame.JDesktopIcon di = f.getDesktopIcon();
        Container c = di.getParent();
        if (c != null) {
            c.remove(di);
            c.repaint(di.getX(), di.getY(), di.getWidth(), di.getHeight());
        }
    }

    protected Rectangle getBoundsForIconOf(JInternalFrame f) {
        JInternalFrame.JDesktopIcon icon = f.getDesktopIcon();
        Dimension prefSize = icon.getPreferredSize();
        Container c = f.getParent();
        if (c == null) {
            c = f.getDesktopIcon().getParent();
        }
        if (c == null) {
            return new Rectangle(0, 0, prefSize.width, prefSize.height);
        }
        Rectangle parentBounds = c.getBounds();
        Component[] components = c.getComponents();
        Rectangle availableRectangle = null;
        Component currentIcon = null;
        int x = 0;
        int y = parentBounds.height - prefSize.height;
        int w = prefSize.width;
        int h = prefSize.height;
        boolean found = false;
        while (!found) {
            availableRectangle = new Rectangle(x, y, w, h);
            found = true;
            for (int i = 0; i < components.length; ++i) {
                if (components[i] instanceof JInternalFrame) {
                    currentIcon = ((JInternalFrame)components[i]).getDesktopIcon();
                } else {
                    if (!(components[i] instanceof JInternalFrame.JDesktopIcon)) continue;
                    currentIcon = (JInternalFrame.JDesktopIcon)components[i];
                }
                if (currentIcon.equals(icon) || !availableRectangle.intersects(currentIcon.getBounds())) continue;
                found = false;
                break;
            }
            if (currentIcon == null) {
                return availableRectangle;
            }
            if ((x += currentIcon.getBounds().width) + w <= parentBounds.width) continue;
            x = 0;
            y -= h;
        }
        return availableRectangle;
    }

    protected void setPreviousBounds(JInternalFrame f, Rectangle r) {
        f.setNormalBounds(r);
    }

    protected Rectangle getPreviousBounds(JInternalFrame f) {
        return f.getNormalBounds();
    }

    protected void setWasIcon(JInternalFrame f, Boolean value) {
        if (value != null) {
            f.putClientProperty(HAS_BEEN_ICONIFIED_PROPERTY, value);
        }
    }

    protected boolean wasIcon(JInternalFrame f) {
        return f.getClientProperty(HAS_BEEN_ICONIFIED_PROPERTY) == Boolean.TRUE;
    }

    JDesktopPane getDesktopPane(JComponent frame) {
        JDesktopPane pane = null;
        Container c = frame.getParent();
        while (pane == null) {
            if (c instanceof JDesktopPane) {
                pane = (JDesktopPane)c;
                continue;
            }
            if (c == null) break;
            c = c.getParent();
        }
        return pane;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void dragFrameFaster(JComponent f, int newX, int newY) {
        Rectangle previousBounds = new Rectangle(this.currentBounds.x, this.currentBounds.y, this.currentBounds.width, this.currentBounds.height);
        this.currentBounds.x = newX;
        this.currentBounds.y = newY;
        if (this.didDrag) {
            this.emergencyCleanup(f);
        } else {
            this.didDrag = true;
            ((JInternalFrame)f).danger = false;
        }
        boolean floaterCollision = this.isFloaterCollision(previousBounds, this.currentBounds);
        JComponent parent = (JComponent)f.getParent();
        Rectangle visBounds = previousBounds.intersection(this.desktopBounds);
        RepaintManager currentManager = RepaintManager.currentManager(f);
        currentManager.beginPaint();
        try {
            int i;
            if (!floaterCollision) {
                currentManager.copyArea(parent, this.desktopGraphics, visBounds.x, visBounds.y, visBounds.width, visBounds.height, newX - previousBounds.x, newY - previousBounds.y, true);
            }
            f.setBounds(this.currentBounds);
            if (floaterCollision) {
                ((JInternalFrame)f).isDragging = false;
                parent.paintImmediately(this.currentBounds);
                ((JInternalFrame)f).isDragging = true;
            }
            currentManager.markCompletelyClean(parent);
            currentManager.markCompletelyClean(f);
            Rectangle[] dirtyRects = null;
            dirtyRects = previousBounds.intersects(this.currentBounds) ? SwingUtilities.computeDifference(previousBounds, this.currentBounds) : new Rectangle[]{previousBounds};
            for (i = 0; i < dirtyRects.length; ++i) {
                parent.paintImmediately(dirtyRects[i]);
            }
            if (!visBounds.equals(previousBounds)) {
                dirtyRects = SwingUtilities.computeDifference(previousBounds, this.desktopBounds);
                for (i = 0; i < dirtyRects.length; ++i) {
                    dirtyRects[i].x += newX - previousBounds.x;
                    dirtyRects[i].y += newY - previousBounds.y;
                    ((JInternalFrame)f).isDragging = false;
                    parent.paintImmediately(dirtyRects[i]);
                    ((JInternalFrame)f).isDragging = true;
                }
            }
        }
        finally {
            currentManager.endPaint();
        }
    }

    private boolean isFloaterCollision(Rectangle moveFrom, Rectangle moveTo) {
        if (this.floatingItems.length == 0) {
            return false;
        }
        for (int i = 0; i < this.floatingItems.length; ++i) {
            boolean intersectsFrom = moveFrom.intersects(this.floatingItems[i]);
            if (intersectsFrom) {
                return true;
            }
            boolean intersectsTo = moveTo.intersects(this.floatingItems[i]);
            if (!intersectsTo) continue;
            return true;
        }
        return false;
    }

    private Rectangle[] findFloatingItems(JComponent f) {
        Container desktop = f.getParent();
        Component[] children = desktop.getComponents();
        int i = 0;
        for (i = 0; i < children.length && children[i] != f; ++i) {
        }
        Rectangle[] floaters = new Rectangle[i];
        for (i = 0; i < floaters.length; ++i) {
            floaters[i] = children[i].getBounds();
        }
        return floaters;
    }

    private void emergencyCleanup(final JComponent f) {
        if (((JInternalFrame)f).danger) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    ((JInternalFrame)f).isDragging = false;
                    f.paintImmediately(0, 0, f.getWidth(), f.getHeight());
                    ((JInternalFrame)f).isDragging = true;
                }
            });
            ((JInternalFrame)f).danger = false;
        }
    }
}

