/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.plaf.metal;

import java.awt.Component;
import java.awt.Graphics;
import java.awt.GraphicsEnvironment;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ContainerListener;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeListener;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JMenuBar;
import javax.swing.JRootPane;
import javax.swing.JToggleButton;
import javax.swing.JToolBar;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.event.MouseInputListener;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.UIResource;
import javax.swing.plaf.basic.BasicToolBarUI;
import javax.swing.plaf.metal.MetalLookAndFeel;
import javax.swing.plaf.metal.MetalUtils;

public class MetalToolBarUI
extends BasicToolBarUI {
    private static List components = new ArrayList();
    protected ContainerListener contListener;
    protected PropertyChangeListener rolloverListener;
    private static Border nonRolloverBorder;
    private JMenuBar lastMenuBar;

    static synchronized void register(JComponent c) {
        if (c == null) {
            throw new NullPointerException("JComponent must be non-null");
        }
        components.add(new WeakReference<JComponent>(c));
    }

    static synchronized void unregister(JComponent c) {
        for (int counter = components.size() - 1; counter >= 0; --counter) {
            WeakReference ref = (WeakReference)components.get(counter);
            Object target = ((WeakReference)components.get(counter)).get();
            if (target != c && target != null) continue;
            components.remove(counter);
        }
    }

    static synchronized Object findRegisteredComponentOfType(JComponent from, Class target) {
        JRootPane rp = SwingUtilities.getRootPane(from);
        if (rp != null) {
            for (int counter = components.size() - 1; counter >= 0; --counter) {
                Object component = ((WeakReference)components.get(counter)).get();
                if (component == null) {
                    components.remove(counter);
                    continue;
                }
                if (!target.isInstance(component) || SwingUtilities.getRootPane((Component)component) != rp) continue;
                return component;
            }
        }
        return null;
    }

    static boolean doesMenuBarBorderToolBar(JMenuBar c) {
        JToolBar tb = (JToolBar)MetalToolBarUI.findRegisteredComponentOfType(c, JToolBar.class);
        if (tb != null && tb.getOrientation() == 0) {
            JRootPane rp = SwingUtilities.getRootPane(c);
            Point point = new Point(0, 0);
            point = SwingUtilities.convertPoint(c, point, rp);
            int menuX = point.x;
            int menuY = point.y;
            point.y = 0;
            point.x = 0;
            point = SwingUtilities.convertPoint(tb, point, rp);
            return point.x == menuX && menuY + c.getHeight() == point.y && c.getWidth() == tb.getWidth();
        }
        return false;
    }

    public static ComponentUI createUI(JComponent c) {
        return new MetalToolBarUI();
    }

    @Override
    public void installUI(JComponent c) {
        super.installUI(c);
        MetalToolBarUI.register(c);
    }

    @Override
    public void uninstallUI(JComponent c) {
        super.uninstallUI(c);
        nonRolloverBorder = null;
        MetalToolBarUI.unregister(c);
    }

    @Override
    protected void installListeners() {
        super.installListeners();
        this.contListener = this.createContainerListener();
        if (this.contListener != null) {
            this.toolBar.addContainerListener(this.contListener);
        }
        this.rolloverListener = this.createRolloverListener();
        if (this.rolloverListener != null) {
            this.toolBar.addPropertyChangeListener(this.rolloverListener);
        }
    }

    @Override
    protected void uninstallListeners() {
        super.uninstallListeners();
        if (this.contListener != null) {
            this.toolBar.removeContainerListener(this.contListener);
        }
        this.rolloverListener = this.createRolloverListener();
        if (this.rolloverListener != null) {
            this.toolBar.removePropertyChangeListener(this.rolloverListener);
        }
    }

    @Override
    protected Border createRolloverBorder() {
        return super.createRolloverBorder();
    }

    @Override
    protected Border createNonRolloverBorder() {
        return super.createNonRolloverBorder();
    }

    private Border createNonRolloverToggleBorder() {
        return this.createNonRolloverBorder();
    }

    @Override
    protected void setBorderToNonRollover(Component c) {
        if (c instanceof JToggleButton && !(c instanceof JCheckBox)) {
            JToggleButton b = (JToggleButton)c;
            Border border = b.getBorder();
            super.setBorderToNonRollover(c);
            if (border instanceof UIResource) {
                if (nonRolloverBorder == null) {
                    nonRolloverBorder = this.createNonRolloverToggleBorder();
                }
                b.setBorder(nonRolloverBorder);
            }
        } else {
            super.setBorderToNonRollover(c);
        }
    }

    protected ContainerListener createContainerListener() {
        return null;
    }

    protected PropertyChangeListener createRolloverListener() {
        return null;
    }

    @Override
    protected MouseInputListener createDockingListener() {
        return new MetalDockingListener(this.toolBar);
    }

    protected void setDragOffset(Point p) {
        if (!GraphicsEnvironment.isHeadless()) {
            if (this.dragWindow == null) {
                this.dragWindow = this.createDragWindow(this.toolBar);
            }
            this.dragWindow.setOffset(p);
        }
    }

    @Override
    public void update(Graphics g, JComponent c) {
        if (g == null) {
            throw new NullPointerException("graphics must be non-null");
        }
        if (c.isOpaque() && c.getBackground() instanceof UIResource && ((JToolBar)c).getOrientation() == 0 && UIManager.get("MenuBar.gradient") != null) {
            JRootPane rp = SwingUtilities.getRootPane(c);
            JMenuBar mb = (JMenuBar)MetalToolBarUI.findRegisteredComponentOfType(c, JMenuBar.class);
            if (mb != null && mb.isOpaque() && mb.getBackground() instanceof UIResource) {
                Point point = new Point(0, 0);
                point = SwingUtilities.convertPoint(c, point, rp);
                int x = point.x;
                int y = point.y;
                point.y = 0;
                point.x = 0;
                point = SwingUtilities.convertPoint(mb, point, rp);
                if (point.x == x && y == point.y + mb.getHeight() && mb.getWidth() == c.getWidth() && MetalUtils.drawGradient(c, g, "MenuBar.gradient", 0, -mb.getHeight(), c.getWidth(), c.getHeight() + mb.getHeight(), true)) {
                    this.setLastMenuBar(mb);
                    this.paint(g, c);
                    return;
                }
            }
            if (MetalUtils.drawGradient(c, g, "MenuBar.gradient", 0, 0, c.getWidth(), c.getHeight(), true)) {
                this.setLastMenuBar(null);
                this.paint(g, c);
                return;
            }
        }
        this.setLastMenuBar(null);
        super.update(g, c);
    }

    private void setLastMenuBar(JMenuBar lastMenuBar) {
        if (MetalLookAndFeel.usingOcean() && this.lastMenuBar != lastMenuBar) {
            if (this.lastMenuBar != null) {
                this.lastMenuBar.repaint();
            }
            if (lastMenuBar != null) {
                lastMenuBar.repaint();
            }
            this.lastMenuBar = lastMenuBar;
        }
    }

    protected class MetalDockingListener
    extends BasicToolBarUI.DockingListener {
        private boolean pressedInBumps;

        public MetalDockingListener(JToolBar t) {
            super(t);
            this.pressedInBumps = false;
        }

        @Override
        public void mousePressed(MouseEvent e) {
            super.mousePressed(e);
            if (!this.toolBar.isEnabled()) {
                return;
            }
            this.pressedInBumps = false;
            Rectangle bumpRect = new Rectangle();
            if (this.toolBar.getOrientation() == 0) {
                int x = MetalUtils.isLeftToRight(this.toolBar) ? 0 : this.toolBar.getSize().width - 14;
                bumpRect.setBounds(x, 0, 14, this.toolBar.getSize().height);
            } else {
                bumpRect.setBounds(0, 0, this.toolBar.getSize().width, 14);
            }
            if (bumpRect.contains(e.getPoint())) {
                this.pressedInBumps = true;
                Point dragOffset = e.getPoint();
                if (!MetalUtils.isLeftToRight(this.toolBar)) {
                    dragOffset.x -= this.toolBar.getSize().width - this.toolBar.getPreferredSize().width;
                }
                MetalToolBarUI.this.setDragOffset(dragOffset);
            }
        }

        @Override
        public void mouseDragged(MouseEvent e) {
            if (this.pressedInBumps) {
                super.mouseDragged(e);
            }
        }
    }

    protected class MetalRolloverListener
    extends BasicToolBarUI.PropertyListener {
        protected MetalRolloverListener() {
        }
    }

    protected class MetalContainerListener
    extends BasicToolBarUI.ToolBarContListener {
        protected MetalContainerListener() {
        }
    }
}

