/*
 * Decompiled with CFR 0.152.
 */
package sun.awt.X11;

import sun.awt.X11.Native;
import sun.awt.X11.XExtData;
import sun.awt.X11.XWrapperBase;
import sun.awt.X11.XlibWrapper;
import sun.misc.Unsafe;

public class Visual
extends XWrapperBase {
    private Unsafe unsafe = XlibWrapper.unsafe;
    private final boolean should_free_memory;
    long pData;

    public static int getSize() {
        return 32;
    }

    public int getDataSize() {
        return Visual.getSize();
    }

    public long getPData() {
        return this.pData;
    }

    public Visual(long addr) {
        log.finest("Creating");
        this.pData = addr;
        this.should_free_memory = false;
    }

    public Visual() {
        log.finest("Creating");
        this.pData = this.unsafe.allocateMemory(Visual.getSize());
        this.should_free_memory = true;
    }

    public void dispose() {
        log.finest("Disposing");
        if (this.should_free_memory) {
            log.finest("freeing memory");
            this.unsafe.freeMemory(this.pData);
        }
    }

    public XExtData get_ext_data(int index) {
        log.finest("");
        return Native.getLong(this.pData + 0L) != 0L ? new XExtData(Native.getLong(this.pData + 0L) + (long)(index * 16)) : null;
    }

    public long get_ext_data() {
        log.finest("");
        return Native.getLong(this.pData + 0L);
    }

    public void set_ext_data(long v) {
        log.finest("");
        Native.putLong(this.pData + 0L, v);
    }

    public long get_visualid() {
        log.finest("");
        return Native.getLong(this.pData + 4L);
    }

    public void set_visualid(long v) {
        log.finest("");
        Native.putLong(this.pData + 4L, v);
    }

    public int get_class() {
        log.finest("");
        return Native.getInt(this.pData + 8L);
    }

    public void set_class(int v) {
        log.finest("");
        Native.putInt(this.pData + 8L, v);
    }

    public long get_red_mask() {
        log.finest("");
        return Native.getLong(this.pData + 12L);
    }

    public void set_red_mask(long v) {
        log.finest("");
        Native.putLong(this.pData + 12L, v);
    }

    public long get_green_mask() {
        log.finest("");
        return Native.getLong(this.pData + 16L);
    }

    public void set_green_mask(long v) {
        log.finest("");
        Native.putLong(this.pData + 16L, v);
    }

    public long get_blue_mask() {
        log.finest("");
        return Native.getLong(this.pData + 20L);
    }

    public void set_blue_mask(long v) {
        log.finest("");
        Native.putLong(this.pData + 20L, v);
    }

    public int get_bits_per_rgb() {
        log.finest("");
        return Native.getInt(this.pData + 24L);
    }

    public void set_bits_per_rgb(int v) {
        log.finest("");
        Native.putInt(this.pData + 24L, v);
    }

    public int get_map_entries() {
        log.finest("");
        return Native.getInt(this.pData + 28L);
    }

    public void set_map_entries(int v) {
        log.finest("");
        Native.putInt(this.pData + 28L, v);
    }

    String getName() {
        return "Visual";
    }

    String getFieldsAsString() {
        String ret = "";
        ret = ret + "ext_data = " + this.get_ext_data() + ", ";
        ret = ret + "visualid = " + this.get_visualid() + ", ";
        ret = ret + "class = " + this.get_class() + ", ";
        ret = ret + "red_mask = " + this.get_red_mask() + ", ";
        ret = ret + "green_mask = " + this.get_green_mask() + ", ";
        ret = ret + "blue_mask = " + this.get_blue_mask() + ", ";
        ret = ret + "bits_per_rgb = " + this.get_bits_per_rgb() + ", ";
        ret = ret + "map_entries = " + this.get_map_entries() + ", ";
        return ret;
    }
}

