/*
 * Decompiled with CFR 0.152.
 */
package sun.java2d.pisces;

import java.awt.BasicStroke;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.NoninvertibleTransformException;
import java.awt.geom.Path2D;
import java.awt.geom.PathIterator;
import java.util.Arrays;
import sun.awt.geom.PathConsumer2D;
import sun.java2d.pipe.AATileGenerator;
import sun.java2d.pipe.Region;
import sun.java2d.pipe.RenderingEngine;
import sun.java2d.pisces.Dasher;
import sun.java2d.pisces.PiscesTileGenerator;
import sun.java2d.pisces.Renderer;
import sun.java2d.pisces.Stroker;
import sun.java2d.pisces.TransformingPathConsumer2D;

public class PiscesRenderingEngine
extends RenderingEngine {
    public Shape createStrokedShape(Shape src, float width, int caps, int join, float miterlimit, float[] dashes, float dashphase) {
        final Path2D.Float p2d = new Path2D.Float();
        this.strokeTo(src, null, width, NormMode.OFF, caps, join, miterlimit, dashes, dashphase, new PathConsumer2D(){

            public void moveTo(float x0, float y0) {
                p2d.moveTo(x0, y0);
            }

            public void lineTo(float x1, float y1) {
                p2d.lineTo(x1, y1);
            }

            public void closePath() {
                p2d.closePath();
            }

            public void pathDone() {
            }

            public void curveTo(float x1, float y1, float x2, float y2, float x3, float y3) {
                p2d.curveTo(x1, y1, x2, y2, x3, y3);
            }

            public void quadTo(float x1, float y1, float x2, float y2) {
                p2d.quadTo(x1, y1, x2, y2);
            }

            public long getNativeConsumer() {
                throw new InternalError("Not using a native peer");
            }
        });
        return p2d;
    }

    public void strokeTo(Shape src, AffineTransform at, BasicStroke bs, boolean thin, boolean normalize, boolean antialias, PathConsumer2D consumer) {
        NormMode norm = normalize ? (antialias ? NormMode.ON_WITH_AA : NormMode.ON_NO_AA) : NormMode.OFF;
        this.strokeTo(src, at, bs, thin, norm, antialias, consumer);
    }

    void strokeTo(Shape src, AffineTransform at, BasicStroke bs, boolean thin, NormMode normalize, boolean antialias, PathConsumer2D pc2d) {
        float lw = thin ? (antialias ? this.userSpaceLineWidth(at, 0.5f) : this.userSpaceLineWidth(at, 1.0f)) : bs.getLineWidth();
        this.strokeTo(src, at, lw, normalize, bs.getEndCap(), bs.getLineJoin(), bs.getMiterLimit(), bs.getDashArray(), bs.getDashPhase(), pc2d);
    }

    private float userSpaceLineWidth(AffineTransform at, float lw) {
        double widthScale;
        if ((at.getType() & 0x24) != 0) {
            widthScale = Math.sqrt(at.getDeterminant());
        } else {
            double A = at.getScaleX();
            double C = at.getShearX();
            double B = at.getShearY();
            double D = at.getScaleY();
            double EA = A * A + B * B;
            double EB = 2.0 * (A * C + B * D);
            double EC = C * C + D * D;
            double hypot = Math.sqrt(EB * EB + (EA - EC) * (EA - EC));
            double widthsquared = (EA + EC + hypot) / 2.0;
            widthScale = Math.sqrt(widthsquared);
        }
        return (float)((double)lw / widthScale);
    }

    void strokeTo(Shape src, AffineTransform at, float width, NormMode normalize, int caps, int join, float miterlimit, float[] dashes, float dashphase, PathConsumer2D pc2d) {
        AffineTransform inat = null;
        AffineTransform outat = null;
        PathIterator pi = null;
        if (at != null && !at.isIdentity()) {
            double a = at.getScaleX();
            double b = at.getShearX();
            double c = at.getShearY();
            double d = at.getScaleY();
            double det = a * d - c * b;
            if (Math.abs(det) <= (double)2.8E-45f) {
                pc2d.moveTo(0.0f, 0.0f);
                pc2d.pathDone();
                return;
            }
            if (PiscesRenderingEngine.nearZero(a * b + c * d, 2) && PiscesRenderingEngine.nearZero(a * a + c * c - (b * b + d * d), 2)) {
                double scale = Math.sqrt(a * a + c * c);
                if (dashes != null) {
                    dashes = Arrays.copyOf(dashes, dashes.length);
                    for (int i = 0; i < dashes.length; ++i) {
                        dashes[i] = (float)(scale * (double)dashes[i]);
                    }
                    dashphase = (float)(scale * (double)dashphase);
                }
                width = (float)(scale * (double)width);
                pi = src.getPathIterator(at);
                if (normalize != NormMode.OFF) {
                    pi = new NormalizingPathIterator(pi, normalize);
                }
            } else {
                outat = at;
                if (normalize != NormMode.OFF) {
                    try {
                        inat = outat.createInverse();
                    }
                    catch (NoninvertibleTransformException e) {
                        e.printStackTrace();
                    }
                    pi = src.getPathIterator(at);
                    pi = new NormalizingPathIterator(pi, normalize);
                } else {
                    pi = src.getPathIterator(null);
                }
            }
        } else {
            pi = src.getPathIterator(null);
            if (normalize != NormMode.OFF) {
                pi = new NormalizingPathIterator(pi, normalize);
            }
        }
        pc2d = TransformingPathConsumer2D.transformConsumer(pc2d, outat);
        pc2d = new Stroker(pc2d, width, caps, join, miterlimit);
        if (dashes != null) {
            pc2d = new Dasher(pc2d, dashes, dashphase);
        }
        pc2d = TransformingPathConsumer2D.transformConsumer(pc2d, inat);
        PiscesRenderingEngine.pathTo(pi, pc2d);
    }

    private static boolean nearZero(double num, int nulps) {
        return Math.abs(num) < (double)nulps * Math.ulp(num);
    }

    static void pathTo(PathIterator pi, PathConsumer2D pc2d) {
        RenderingEngine.feedConsumer(pi, pc2d);
        pc2d.pathDone();
    }

    public AATileGenerator getAATileGenerator(Shape s, AffineTransform at, Region clip, BasicStroke bs, boolean thin, boolean normalize, int[] bbox) {
        Renderer r;
        NormMode norm;
        NormMode normMode = norm = normalize ? NormMode.ON_WITH_AA : NormMode.OFF;
        if (bs == null) {
            PathIterator pi = normalize ? new NormalizingPathIterator(s.getPathIterator(at), norm) : s.getPathIterator(at);
            r = new Renderer(3, 3, clip.getLoX(), clip.getLoY(), clip.getWidth(), clip.getHeight(), pi.getWindingRule());
            PiscesRenderingEngine.pathTo(pi, r);
        } else {
            r = new Renderer(3, 3, clip.getLoX(), clip.getLoY(), clip.getWidth(), clip.getHeight(), 1);
            this.strokeTo(s, at, bs, thin, norm, true, (PathConsumer2D)r);
        }
        r.endRendering();
        PiscesTileGenerator ptg = new PiscesTileGenerator(r, r.MAX_AA_ALPHA);
        ptg.getBbox(bbox);
        return ptg;
    }

    public AATileGenerator getAATileGenerator(double x, double y, double dx1, double dy1, double dx2, double dy2, double lw1, double lw2, Region clip, int[] bbox) {
        double ldy2;
        double ldx2;
        double ldy1;
        double ldx1;
        boolean innerpgram;
        boolean bl = innerpgram = lw1 > 0.0 && lw2 > 0.0;
        if (innerpgram) {
            ldx1 = dx1 * lw1;
            ldy1 = dy1 * lw1;
            ldx2 = dx2 * lw2;
            ldy2 = dy2 * lw2;
            x -= (ldx1 + ldx2) / 2.0;
            y -= (ldy1 + ldy2) / 2.0;
            dx1 += ldx1;
            dy1 += ldy1;
            dx2 += ldx2;
            dy2 += ldy2;
            if (lw1 > 1.0 && lw2 > 1.0) {
                innerpgram = false;
            }
        } else {
            ldy2 = 0.0;
            ldx2 = 0.0;
            ldy1 = 0.0;
            ldx1 = 0.0;
        }
        Renderer r = new Renderer(3, 3, clip.getLoX(), clip.getLoY(), clip.getWidth(), clip.getHeight(), 0);
        r.moveTo((float)x, (float)y);
        r.lineTo((float)(x + dx1), (float)(y + dy1));
        r.lineTo((float)(x + dx1 + dx2), (float)(y + dy1 + dy2));
        r.lineTo((float)(x + dx2), (float)(y + dy2));
        r.closePath();
        if (innerpgram) {
            r.moveTo((float)(x += ldx1 + ldx2), (float)(y += ldy1 + ldy2));
            r.lineTo((float)(x + (dx1 -= 2.0 * ldx1)), (float)(y + (dy1 -= 2.0 * ldy1)));
            r.lineTo((float)(x + dx1 + (dx2 -= 2.0 * ldx2)), (float)(y + dy1 + (dy2 -= 2.0 * ldy2)));
            r.lineTo((float)(x + dx2), (float)(y + dy2));
            r.closePath();
        }
        r.pathDone();
        r.endRendering();
        PiscesTileGenerator ptg = new PiscesTileGenerator(r, r.MAX_AA_ALPHA);
        ptg.getBbox(bbox);
        return ptg;
    }

    public float getMinimumAAPenSize() {
        return 0.5f;
    }

    private static class NormalizingPathIterator
    implements PathIterator {
        private final PathIterator src;
        private float curx_adjust;
        private float cury_adjust;
        private float movx_adjust;
        private float movy_adjust;
        private final float lval;
        private final float rval;

        NormalizingPathIterator(PathIterator src, NormMode mode) {
            this.src = src;
            switch (mode) {
                case ON_NO_AA: {
                    this.rval = 0.25f;
                    this.lval = 0.25f;
                    break;
                }
                case ON_WITH_AA: {
                    this.lval = 0.0f;
                    this.rval = 0.5f;
                    break;
                }
                case OFF: {
                    throw new InternalError("A NormalizingPathIterator should not be created if no normalization is being done");
                }
                default: {
                    throw new InternalError("Unrecognized normalization mode");
                }
            }
        }

        public int currentSegment(float[] coords) {
            int lastCoord;
            int type = this.src.currentSegment(coords);
            switch (type) {
                case 3: {
                    lastCoord = 4;
                    break;
                }
                case 2: {
                    lastCoord = 2;
                    break;
                }
                case 0: 
                case 1: {
                    lastCoord = 0;
                    break;
                }
                case 4: {
                    this.curx_adjust = this.movx_adjust;
                    this.cury_adjust = this.movy_adjust;
                    return type;
                }
                default: {
                    throw new InternalError("Unrecognized curve type");
                }
            }
            float x_adjust = (float)Math.floor(coords[lastCoord] + this.lval) + this.rval - coords[lastCoord];
            float y_adjust = (float)Math.floor(coords[lastCoord + 1] + this.lval) + this.rval - coords[lastCoord + 1];
            int n = lastCoord;
            coords[n] = coords[n] + x_adjust;
            int n2 = lastCoord + 1;
            coords[n2] = coords[n2] + y_adjust;
            switch (type) {
                case 3: {
                    coords[0] = coords[0] + this.curx_adjust;
                    coords[1] = coords[1] + this.cury_adjust;
                    coords[2] = coords[2] + x_adjust;
                    coords[3] = coords[3] + y_adjust;
                    break;
                }
                case 2: {
                    coords[0] = coords[0] + (this.curx_adjust + x_adjust) / 2.0f;
                    coords[1] = coords[1] + (this.cury_adjust + y_adjust) / 2.0f;
                    break;
                }
                case 1: {
                    break;
                }
                case 0: {
                    this.movx_adjust = x_adjust;
                    this.movy_adjust = y_adjust;
                    break;
                }
                case 4: {
                    throw new InternalError("This should be handled earlier.");
                }
            }
            this.curx_adjust = x_adjust;
            this.cury_adjust = y_adjust;
            return type;
        }

        public int currentSegment(double[] coords) {
            float[] tmp = new float[6];
            int type = this.currentSegment(tmp);
            for (int i = 0; i < 6; ++i) {
                coords[i] = tmp[i];
            }
            return type;
        }

        public int getWindingRule() {
            return this.src.getWindingRule();
        }

        public boolean isDone() {
            return this.src.isDone();
        }

        public void next() {
            this.src.next();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum NormMode {
        OFF,
        ON_NO_AA,
        ON_WITH_AA;

    }
}

