/*
 * Decompiled with CFR 0.152.
 */
package sun.java2d.pisces;

import java.util.Arrays;
import java.util.Iterator;
import sun.awt.geom.PathConsumer2D;
import sun.java2d.pisces.Curve;
import sun.java2d.pisces.Helpers;
import sun.java2d.pisces.PiscesCache;

public class Renderer
implements PathConsumer2D {
    private static final int YMIN = 0;
    private static final int YMAX = 1;
    private static final int CURX = 2;
    private static final int CURY = 3;
    private static final int OR = 4;
    private static final int SLOPE = 5;
    private static final int X0 = 5;
    private static final int Y0 = 6;
    private static final int XL = 7;
    private static final int COUNT = 8;
    private static final int CURSLOPE = 9;
    private static final int DX = 10;
    private static final int DY = 11;
    private static final int DDX = 12;
    private static final int DDY = 13;
    private static final int DDDX = 14;
    private static final int DDDY = 15;
    private float edgeMinY = Float.POSITIVE_INFINITY;
    private float edgeMaxY = Float.NEGATIVE_INFINITY;
    private float edgeMinX = Float.POSITIVE_INFINITY;
    private float edgeMaxX = Float.NEGATIVE_INFINITY;
    private static final int SIZEOF_EDGE = 6;
    private float[] edges = null;
    private int numEdges;
    private static final int SIZEOF_QUAD = 14;
    private float[] quads = null;
    private int numQuads;
    private static final int SIZEOF_CURVE = 16;
    private float[] curves = null;
    private int numCurves;
    private static final float DEC_BND = 20.0f;
    private static final float INC_BND = 8.0f;
    public static final int WIND_EVEN_ODD = 0;
    public static final int WIND_NON_ZERO = 1;
    private final int SUBPIXEL_LG_POSITIONS_X;
    private final int SUBPIXEL_LG_POSITIONS_Y;
    private final int SUBPIXEL_POSITIONS_X;
    private final int SUBPIXEL_POSITIONS_Y;
    private final int SUBPIXEL_MASK_X;
    private final int SUBPIXEL_MASK_Y;
    final int MAX_AA_ALPHA;
    PiscesCache cache;
    private final int boundsMinX;
    private final int boundsMinY;
    private final int boundsMaxX;
    private final int boundsMaxY;
    private final int windingRule;
    private float x0;
    private float y0;
    private float pix_sx0;
    private float pix_sy0;
    private final float[][] pts = new float[2][8];
    private final float[] ts = new float[4];
    Curve c = new Curve();

    private static void qsort(float[] data, int[] ptrs, int fieldForCmp, int first, int last) {
        if (last > first) {
            int p = Renderer.partition(data, ptrs, fieldForCmp, first, last);
            if (first < p - 1) {
                Renderer.qsort(data, ptrs, fieldForCmp, first, p - 1);
            }
            if (p < last) {
                Renderer.qsort(data, ptrs, fieldForCmp, p, last);
            }
        }
    }

    private static int partition(float[] data, int[] ptrs, int fieldForCmp, int i, int j) {
        int pivotValFieldForCmp = ptrs[i] + fieldForCmp;
        while (i <= j) {
            while (data[ptrs[i] + fieldForCmp] < data[pivotValFieldForCmp]) {
                ++i;
            }
            while (data[ptrs[j] + fieldForCmp] > data[pivotValFieldForCmp]) {
                --j;
            }
            if (i > j) continue;
            int tmp = ptrs[i];
            ptrs[i] = ptrs[j];
            ptrs[j] = tmp;
            ++i;
            --j;
        }
        return i;
    }

    private void edgeSetCurY(int idx, int y) {
        int n = idx + 2;
        this.edges[n] = this.edges[n] + ((float)y - this.edges[idx + 3]) * this.edges[idx + 5];
        this.edges[idx + 3] = y;
    }

    private void edgeGoToNextY(int idx) {
        int n = idx + 3;
        this.edges[n] = this.edges[n] + 1.0f;
        int n2 = idx + 2;
        this.edges[n2] = this.edges[n2] + this.edges[idx + 5];
    }

    private void quadSetCurY(int idx, int y) {
        assert ((float)y < this.quads[idx + 1]);
        assert (this.quads[idx + 3] > (float)y);
        assert ((double)this.quads[idx + 3] == Math.ceil(this.quads[idx + 3]));
        while (this.quads[idx + 3] < (float)y) {
            this.quadGoToNextY(idx);
        }
    }

    private void quadGoToNextY(int idx) {
        int n = idx + 3;
        this.quads[n] = this.quads[n] + 1.0f;
        int n2 = idx + 2;
        this.quads[n2] = this.quads[n2] + this.quads[idx + 9];
        int count = (int)this.quads[idx + 8];
        while (this.quads[idx + 3] >= this.quads[idx + 6] && count > 0) {
            float x0 = this.quads[idx + 5];
            float y0 = this.quads[idx + 6];
            count = this.executeQuadAFDIteration(idx);
            float x1 = this.quads[idx + 5];
            float y1 = this.quads[idx + 6];
            if (y1 == y0) continue;
            this.quads[idx + 9] = (x1 - x0) / (y1 - y0);
            this.quads[idx + 2] = x0 + (this.quads[idx + 3] - y0) * this.quads[idx + 9];
        }
    }

    private void curveSetCurY(int idx, int y) {
        assert ((float)y < this.curves[idx + 1]);
        assert (this.curves[idx + 3] > (float)y);
        assert ((double)this.curves[idx + 3] == Math.ceil(this.curves[idx + 3]));
        while (this.curves[idx + 3] < (float)y) {
            this.curveGoToNextY(idx);
        }
    }

    private void curveGoToNextY(int idx) {
        int n = idx + 3;
        this.curves[n] = this.curves[n] + 1.0f;
        int n2 = idx + 2;
        this.curves[n2] = this.curves[n2] + this.curves[idx + 9];
        int count = (int)this.curves[idx + 8];
        while (this.curves[idx + 3] >= this.curves[idx + 6] && count > 0) {
            float x0 = this.curves[idx + 5];
            float y0 = this.curves[idx + 6];
            count = this.executeCurveAFDIteration(idx);
            float x1 = this.curves[idx + 5];
            float y1 = this.curves[idx + 6];
            if (y1 == y0) continue;
            this.curves[idx + 9] = (x1 - x0) / (y1 - y0);
            this.curves[idx + 2] = x0 + (this.curves[idx + 3] - y0) * this.curves[idx + 9];
        }
    }

    private int executeQuadAFDIteration(int idx) {
        int count = (int)this.quads[idx + 8];
        float ddx = this.quads[idx + 12];
        float ddy = this.quads[idx + 13];
        float dx = this.quads[idx + 10];
        float dy = this.quads[idx + 11];
        while (Math.abs(ddx) > 20.0f || Math.abs(ddy) > 20.0f) {
            dx = (dx - (ddx /= 4.0f)) / 2.0f;
            dy = (dy - (ddy /= 4.0f)) / 2.0f;
            count <<= 1;
        }
        while (count % 2 == 0 && Math.abs(dx) <= 8.0f && Math.abs(dy) <= 8.0f) {
            dx = 2.0f * dx + ddx;
            dy = 2.0f * dy + ddy;
            ddx = 4.0f * ddx;
            ddy = 4.0f * ddy;
            count >>= 1;
        }
        if (--count > 0) {
            int n = idx + 5;
            this.quads[n] = this.quads[n] + dx;
            dx += ddx;
            int n2 = idx + 6;
            this.quads[n2] = this.quads[n2] + dy;
            dy += ddy;
        } else {
            this.quads[idx + 5] = this.quads[idx + 7];
            this.quads[idx + 6] = this.quads[idx + 1];
        }
        this.quads[idx + 8] = count;
        this.quads[idx + 12] = ddx;
        this.quads[idx + 13] = ddy;
        this.quads[idx + 10] = dx;
        this.quads[idx + 11] = dy;
        return count;
    }

    private int executeCurveAFDIteration(int idx) {
        int count = (int)this.curves[idx + 8];
        float ddx = this.curves[idx + 12];
        float ddy = this.curves[idx + 13];
        float dx = this.curves[idx + 10];
        float dy = this.curves[idx + 11];
        float dddx = this.curves[idx + 14];
        float dddy = this.curves[idx + 15];
        while (Math.abs(ddx) > 20.0f || Math.abs(ddy) > 20.0f) {
            ddx = ddx / 4.0f - (dddx /= 8.0f);
            ddy = ddy / 4.0f - (dddy /= 8.0f);
            dx = (dx - ddx) / 2.0f;
            dy = (dy - ddy) / 2.0f;
            count <<= 1;
        }
        while (count % 2 == 0 && Math.abs(dx) <= 8.0f && Math.abs(dy) <= 8.0f) {
            dx = 2.0f * dx + ddx;
            dy = 2.0f * dy + ddy;
            ddx = 4.0f * (ddx + dddx);
            ddy = 4.0f * (ddy + dddy);
            dddx = 8.0f * dddx;
            dddy = 8.0f * dddy;
            count >>= 1;
        }
        if (--count > 0) {
            int n = idx + 5;
            this.curves[n] = this.curves[n] + dx;
            dx += ddx;
            ddx += dddx;
            int n2 = idx + 6;
            this.curves[n2] = this.curves[n2] + dy;
            dy += ddy;
            ddy += dddy;
        } else {
            this.curves[idx + 5] = this.curves[idx + 7];
            this.curves[idx + 6] = this.curves[idx + 1];
        }
        this.curves[idx + 8] = count;
        this.curves[idx + 14] = dddx;
        this.curves[idx + 15] = dddy;
        this.curves[idx + 12] = ddx;
        this.curves[idx + 13] = ddy;
        this.curves[idx + 10] = dx;
        this.curves[idx + 11] = dy;
        return count;
    }

    private void initLine(int idx, float[] pts, int or) {
        this.edges[idx + 5] = (pts[2] - pts[0]) / (pts[3] - pts[1]);
        this.edges[idx + 2] = pts[0] + (this.edges[idx + 3] - pts[1]) * this.edges[idx + 5];
    }

    private void initQuad(int idx, float[] points, int or) {
        int countlg = 3;
        int count = 8;
        this.c.set(points, 6);
        float ddx = this.c.dbx / 64.0f;
        float ddy = this.c.dby / 64.0f;
        float dx = this.c.bx / 64.0f + this.c.cx / 8.0f;
        float dy = this.c.by / 64.0f + this.c.cy / 8.0f;
        this.quads[idx + 12] = ddx;
        this.quads[idx + 13] = ddy;
        this.quads[idx + 10] = dx;
        this.quads[idx + 11] = dy;
        this.quads[idx + 8] = 8.0f;
        this.quads[idx + 7] = points[4];
        this.quads[idx + 5] = points[0];
        this.quads[idx + 6] = points[1];
        this.executeQuadAFDIteration(idx);
        float x1 = this.quads[idx + 5];
        float y1 = this.quads[idx + 6];
        this.quads[idx + 9] = (x1 - points[0]) / (y1 - points[1]);
        this.quads[idx + 2] = points[0] + (this.quads[idx + 3] - points[1]) * this.quads[idx + 9];
    }

    private void initCurve(int idx, float[] points, int or) {
        int countlg = 3;
        int count = 8;
        this.c.set(points, 8);
        float dddx = 2.0f * this.c.dax / 512.0f;
        float dddy = 2.0f * this.c.day / 512.0f;
        float ddx = dddx + this.c.dbx / 64.0f;
        float ddy = dddy + this.c.dby / 64.0f;
        float dx = this.c.ax / 512.0f + this.c.bx / 64.0f + this.c.cx / 8.0f;
        float dy = this.c.ay / 512.0f + this.c.by / 64.0f + this.c.cy / 8.0f;
        this.curves[idx + 14] = dddx;
        this.curves[idx + 15] = dddy;
        this.curves[idx + 12] = ddx;
        this.curves[idx + 13] = ddy;
        this.curves[idx + 10] = dx;
        this.curves[idx + 11] = dy;
        this.curves[idx + 8] = 8.0f;
        this.curves[idx + 7] = points[6];
        this.curves[idx + 5] = points[0];
        this.curves[idx + 6] = points[1];
        this.executeCurveAFDIteration(idx);
        float x1 = this.curves[idx + 5];
        float y1 = this.curves[idx + 6];
        this.curves[idx + 9] = (x1 - points[0]) / (y1 - points[1]);
        this.curves[idx + 2] = points[0] + (this.curves[idx + 3] - points[1]) * this.curves[idx + 9];
    }

    private void addPathSegment(float[] pts, int type, int or) {
        int idx;
        switch (type) {
            case 4: {
                idx = this.numEdges * 6;
                this.edges = Helpers.widenArray(this.edges, this.numEdges * 6, 6);
                float[] addTo = this.edges;
                ++this.numEdges;
                break;
            }
            case 6: {
                idx = this.numQuads * 14;
                this.quads = Helpers.widenArray(this.quads, this.numQuads * 14, 14);
                float[] addTo = this.quads;
                ++this.numQuads;
                break;
            }
            case 8: {
                idx = this.numCurves * 16;
                this.curves = Helpers.widenArray(this.curves, this.numCurves * 16, 16);
                float[] addTo = this.curves;
                ++this.numCurves;
                break;
            }
            default: {
                throw new InternalError();
            }
        }
        addTo[idx + 0] = pts[1];
        addTo[idx + 1] = pts[type - 1];
        addTo[idx + 4] = or;
        addTo[idx + 3] = (float)Math.ceil(pts[1]);
        switch (type) {
            case 4: {
                this.initLine(idx, pts, or);
                break;
            }
            case 6: {
                this.initQuad(idx, pts, or);
                break;
            }
            case 8: {
                this.initCurve(idx, pts, or);
                break;
            }
            default: {
                throw new InternalError();
            }
        }
    }

    private void somethingTo(float[] pts, int type, int or) {
        this.x0 = or >= 0 ? pts[type - 2] : pts[0];
        this.y0 = or >= 0 ? pts[type - 1] : pts[1];
        float minY = pts[1];
        float maxY = pts[type - 1];
        if (Math.ceil(minY) >= Math.ceil(maxY) || Math.ceil(minY) >= (double)this.boundsMaxY || maxY < (float)this.boundsMinY) {
            return;
        }
        if (minY < this.edgeMinY) {
            this.edgeMinY = minY;
        }
        if (maxY > this.edgeMaxY) {
            this.edgeMaxY = maxY;
        }
        int minXidx = pts[0] < pts[type - 2] ? 0 : type - 2;
        float minX = pts[minXidx];
        float maxX = pts[type - 2 - minXidx];
        if (minX < this.edgeMinX) {
            this.edgeMinX = minX;
        }
        if (maxX > this.edgeMaxX) {
            this.edgeMaxX = maxX;
        }
        this.addPathSegment(pts, type, or);
    }

    public Renderer(int subpixelLgPositionsX, int subpixelLgPositionsY, int pix_boundsX, int pix_boundsY, int pix_boundsWidth, int pix_boundsHeight, int windingRule) {
        this.SUBPIXEL_LG_POSITIONS_X = subpixelLgPositionsX;
        this.SUBPIXEL_LG_POSITIONS_Y = subpixelLgPositionsY;
        this.SUBPIXEL_MASK_X = (1 << this.SUBPIXEL_LG_POSITIONS_X) - 1;
        this.SUBPIXEL_MASK_Y = (1 << this.SUBPIXEL_LG_POSITIONS_Y) - 1;
        this.SUBPIXEL_POSITIONS_X = 1 << this.SUBPIXEL_LG_POSITIONS_X;
        this.SUBPIXEL_POSITIONS_Y = 1 << this.SUBPIXEL_LG_POSITIONS_Y;
        this.MAX_AA_ALPHA = this.SUBPIXEL_POSITIONS_X * this.SUBPIXEL_POSITIONS_Y;
        this.windingRule = windingRule;
        this.boundsMinX = pix_boundsX * this.SUBPIXEL_POSITIONS_X;
        this.boundsMinY = pix_boundsY * this.SUBPIXEL_POSITIONS_Y;
        this.boundsMaxX = (pix_boundsX + pix_boundsWidth) * this.SUBPIXEL_POSITIONS_X;
        this.boundsMaxY = (pix_boundsY + pix_boundsHeight) * this.SUBPIXEL_POSITIONS_Y;
    }

    private float tosubpixx(float pix_x) {
        return pix_x * (float)this.SUBPIXEL_POSITIONS_X;
    }

    private float tosubpixy(float pix_y) {
        return pix_y * (float)this.SUBPIXEL_POSITIONS_Y;
    }

    public void moveTo(float pix_x0, float pix_y0) {
        this.closePath();
        this.pix_sx0 = pix_x0;
        this.pix_sy0 = pix_y0;
        this.y0 = this.tosubpixy(pix_y0);
        this.x0 = this.tosubpixx(pix_x0);
    }

    public void lineJoin() {
    }

    private static void invertPolyPoints(float[] pts, int off, int type) {
        int i = off;
        for (int j = off + type - 2; i < j; i += 2, j -= 2) {
            float tmp = pts[i];
            pts[i] = pts[j];
            pts[j] = tmp;
            tmp = pts[i + 1];
            pts[i + 1] = pts[j + 1];
            pts[j + 1] = tmp;
        }
    }

    private static int makeMonotonicCurveUpright(float[] pts, int off, int type) {
        float y0 = pts[off + 1];
        float y1 = pts[off + type - 1];
        if (y0 > y1) {
            Renderer.invertPolyPoints(pts, off, type);
            return -1;
        }
        if (y0 < y1) {
            return 1;
        }
        return 0;
    }

    public void lineTo(float pix_x1, float pix_y1) {
        this.pts[0][0] = this.x0;
        this.pts[0][1] = this.y0;
        this.pts[0][2] = this.tosubpixx(pix_x1);
        this.pts[0][3] = this.tosubpixy(pix_y1);
        int or = Renderer.makeMonotonicCurveUpright(this.pts[0], 0, 4);
        this.somethingTo(this.pts[0], 4, or);
    }

    private void curveOrQuadTo(int type) {
        this.c.set(this.pts[0], type);
        int numTs = this.c.dxRoots(this.ts, 0);
        numTs += this.c.dyRoots(this.ts, numTs);
        numTs = Helpers.filterOutNotInAB(this.ts, 0, numTs, 0.0f, 1.0f);
        Helpers.isort(this.ts, 0, numTs);
        Iterator<float[]> it = Curve.breakPtsAtTs(this.pts, type, this.ts, numTs);
        while (it.hasNext()) {
            float[] curCurve = it.next();
            int or = Renderer.makeMonotonicCurveUpright(curCurve, 0, type);
            this.somethingTo(curCurve, type, or);
        }
    }

    public void curveTo(float x1, float y1, float x2, float y2, float x3, float y3) {
        this.pts[0][0] = this.x0;
        this.pts[0][1] = this.y0;
        this.pts[0][2] = this.tosubpixx(x1);
        this.pts[0][3] = this.tosubpixy(y1);
        this.pts[0][4] = this.tosubpixx(x2);
        this.pts[0][5] = this.tosubpixy(y2);
        this.pts[0][6] = this.tosubpixx(x3);
        this.pts[0][7] = this.tosubpixy(y3);
        this.curveOrQuadTo(8);
    }

    public void quadTo(float x1, float y1, float x2, float y2) {
        this.pts[0][0] = this.x0;
        this.pts[0][1] = this.y0;
        this.pts[0][2] = this.tosubpixx(x1);
        this.pts[0][3] = this.tosubpixy(y1);
        this.pts[0][4] = this.tosubpixx(x2);
        this.pts[0][5] = this.tosubpixy(y2);
        this.curveOrQuadTo(6);
    }

    public void closePath() {
        this.lineTo(this.pix_sx0, this.pix_sy0);
    }

    public void pathDone() {
        this.closePath();
    }

    public long getNativeConsumer() {
        throw new InternalError("Renderer does not use a native consumer.");
    }

    private void _endRendering(int pix_bboxx0, int pix_bboxy0, int pix_bboxx1, int pix_bboxy1) {
        int mask = this.windingRule == 0 ? 1 : -1;
        int width = pix_bboxx1 - pix_bboxx0 + 1;
        int[] alpha = new int[width + 1];
        int bboxx0 = pix_bboxx0 << this.SUBPIXEL_LG_POSITIONS_X;
        int bboxx1 = pix_bboxx1 << this.SUBPIXEL_LG_POSITIONS_X;
        int pix_maxX = Integer.MIN_VALUE;
        int pix_minX = Integer.MAX_VALUE;
        int y = this.boundsMinY;
        ScanlineIterator it = new ScanlineIterator();
        while (it.hasNext()) {
            int numCrossings = it.next();
            int[] crossings = it.crossings;
            y = it.curY();
            if (numCrossings > 0) {
                int lowx = crossings[0] >> 1;
                int highx = crossings[numCrossings - 1] >> 1;
                int x0 = Math.max(lowx, bboxx0);
                int x1 = Math.min(highx, bboxx1);
                pix_minX = Math.min(pix_minX, x0 >> this.SUBPIXEL_LG_POSITIONS_X);
                pix_maxX = Math.max(pix_maxX, x1 >> this.SUBPIXEL_LG_POSITIONS_X);
            }
            int sum = 0;
            int prev = bboxx0;
            for (int i = 0; i < numCrossings; ++i) {
                int x1;
                int x0;
                int crorientation;
                int curxo = crossings[i];
                int curx = curxo >> 1;
                int n = crorientation = (curxo & 1) == 1 ? 1 : -1;
                if ((sum & mask) != 0 && (x0 = Math.max(prev, bboxx0)) < (x1 = Math.min(curx, bboxx1))) {
                    int pix_x = (x0 -= bboxx0) >> this.SUBPIXEL_LG_POSITIONS_X;
                    int pix_xmaxm1 = (x1 -= bboxx0) - 1 >> this.SUBPIXEL_LG_POSITIONS_X;
                    if (pix_x == pix_xmaxm1) {
                        int n2 = pix_x;
                        alpha[n2] = alpha[n2] + (x1 - x0);
                        int n3 = pix_x + 1;
                        alpha[n3] = alpha[n3] - (x1 - x0);
                    } else {
                        int pix_xmax = x1 >> this.SUBPIXEL_LG_POSITIONS_X;
                        int n4 = pix_x;
                        alpha[n4] = alpha[n4] + (this.SUBPIXEL_POSITIONS_X - (x0 & this.SUBPIXEL_MASK_X));
                        int n5 = pix_x + 1;
                        alpha[n5] = alpha[n5] + (x0 & this.SUBPIXEL_MASK_X);
                        int n6 = pix_xmax;
                        alpha[n6] = alpha[n6] - (this.SUBPIXEL_POSITIONS_X - (x1 & this.SUBPIXEL_MASK_X));
                        int n7 = pix_xmax + 1;
                        alpha[n7] = alpha[n7] - (x1 & this.SUBPIXEL_MASK_X);
                    }
                }
                sum += crorientation;
                prev = curx;
            }
            if ((y & this.SUBPIXEL_MASK_Y) != this.SUBPIXEL_MASK_Y) continue;
            this.emitRow(alpha, y >> this.SUBPIXEL_LG_POSITIONS_Y, pix_minX, pix_maxX);
            pix_minX = Integer.MAX_VALUE;
            pix_maxX = Integer.MIN_VALUE;
        }
        if (pix_maxX >= pix_minX) {
            this.emitRow(alpha, y >> this.SUBPIXEL_LG_POSITIONS_Y, pix_minX, pix_maxX);
        }
    }

    public void endRendering() {
        int bminx = this.boundsMinX >> this.SUBPIXEL_LG_POSITIONS_X;
        int bmaxx = this.boundsMaxX >> this.SUBPIXEL_LG_POSITIONS_X;
        int bminy = this.boundsMinY >> this.SUBPIXEL_LG_POSITIONS_Y;
        int bmaxy = this.boundsMaxY >> this.SUBPIXEL_LG_POSITIONS_Y;
        int eminx = (int)Math.floor(this.edgeMinX) >> this.SUBPIXEL_LG_POSITIONS_X;
        int emaxx = (int)Math.ceil(this.edgeMaxX) >> this.SUBPIXEL_LG_POSITIONS_X;
        int eminy = (int)Math.floor(this.edgeMinY) >> this.SUBPIXEL_LG_POSITIONS_Y;
        int emaxy = (int)Math.ceil(this.edgeMaxY) >> this.SUBPIXEL_LG_POSITIONS_Y;
        int minX = Math.max(bminx, eminx);
        int maxX = Math.min(bmaxx, emaxx);
        int minY = Math.max(bminy, eminy);
        int maxY = Math.min(bmaxy, emaxy);
        if (minX > maxX || minY > maxY) {
            this.cache = new PiscesCache(bminx, bminy, bmaxx, bmaxy);
            return;
        }
        this.cache = new PiscesCache(minX, minY, maxX, maxY);
        this._endRendering(minX, minY, maxX, maxY);
    }

    public PiscesCache getCache() {
        if (this.cache == null) {
            throw new InternalError("cache not yet initialized");
        }
        return this.cache;
    }

    private void emitRow(int[] alphaRow, int pix_y, int pix_from, int pix_to) {
        if (this.cache != null && pix_to >= pix_from) {
            this.cache.startRow(pix_y, pix_from);
            int from = pix_from - this.cache.bboxX0;
            int to = pix_to - this.cache.bboxX0;
            int runLen = 1;
            int startVal = alphaRow[from];
            for (int i = from + 1; i <= to; ++i) {
                int nextVal = startVal + alphaRow[i];
                if (nextVal == startVal) {
                    ++runLen;
                    continue;
                }
                this.cache.addRLERun(startVal, runLen);
                runLen = 1;
                startVal = nextVal;
            }
            this.cache.addRLERun(startVal, runLen);
        }
        Arrays.fill(alphaRow, 0);
    }

    private class ScanlineIterator {
        private int[] crossings = new int[10];
        private int minY;
        private int maxY;
        private int nextY;
        private int elo;
        private int ehi;
        private final int[] edgePtrs;
        private int qlo;
        private int qhi;
        private final int[] quadPtrs;
        private int clo;
        private int chi;
        private final int[] curvePtrs;
        private static final int INIT_CROSSINGS_SIZE = 10;

        private ScanlineIterator() {
            this.edgePtrs = new int[Renderer.this.numEdges];
            Helpers.fillWithIdxes(this.edgePtrs, 6);
            Renderer.qsort(Renderer.this.edges, this.edgePtrs, 0, 0, Renderer.this.numEdges - 1);
            this.quadPtrs = new int[Renderer.this.numQuads];
            Helpers.fillWithIdxes(this.quadPtrs, 14);
            Renderer.qsort(Renderer.this.quads, this.quadPtrs, 0, 0, Renderer.this.numQuads - 1);
            this.curvePtrs = new int[Renderer.this.numCurves];
            Helpers.fillWithIdxes(this.curvePtrs, 16);
            Renderer.qsort(Renderer.this.curves, this.curvePtrs, 0, 0, Renderer.this.numCurves - 1);
            this.nextY = this.minY = Math.max(Renderer.this.boundsMinY, (int)Math.ceil(Renderer.this.edgeMinY));
            this.maxY = Math.min(Renderer.this.boundsMaxY, (int)Math.ceil(Renderer.this.edgeMaxY));
            this.elo = 0;
            while (this.elo < Renderer.this.numEdges && Renderer.this.edges[this.edgePtrs[this.elo] + 1] <= (float)this.minY) {
                ++this.elo;
            }
            this.ehi = this.elo;
            while (this.ehi < Renderer.this.numEdges && Renderer.this.edges[this.edgePtrs[this.ehi] + 0] <= (float)this.minY) {
                Renderer.this.edgeSetCurY(this.edgePtrs[this.ehi], this.minY);
                ++this.ehi;
            }
            this.qlo = 0;
            while (this.qlo < Renderer.this.numQuads && Renderer.this.quads[this.quadPtrs[this.qlo] + 1] <= (float)this.minY) {
                ++this.qlo;
            }
            this.qhi = this.qlo;
            while (this.qhi < Renderer.this.numQuads && Renderer.this.quads[this.quadPtrs[this.qhi] + 0] <= (float)this.minY) {
                Renderer.this.quadSetCurY(this.quadPtrs[this.qhi], this.minY);
                ++this.qhi;
            }
            this.clo = 0;
            while (this.clo < Renderer.this.numCurves && Renderer.this.curves[this.curvePtrs[this.clo] + 1] <= (float)this.minY) {
                ++this.clo;
            }
            this.chi = this.clo;
            while (this.chi < Renderer.this.numCurves && Renderer.this.curves[this.curvePtrs[this.chi] + 0] <= (float)this.minY) {
                Renderer.this.curveSetCurY(this.curvePtrs[this.chi], this.minY);
                ++this.chi;
            }
        }

        private int next() {
            int ptr;
            int i;
            int crossingIdx = 0;
            for (i = this.elo; i < this.ehi; ++i) {
                if (!(Renderer.this.edges[this.edgePtrs[i] + 1] <= (float)this.nextY)) continue;
                this.edgePtrs[i] = this.edgePtrs[this.elo++];
            }
            for (i = this.qlo; i < this.qhi; ++i) {
                if (!(Renderer.this.quads[this.quadPtrs[i] + 1] <= (float)this.nextY)) continue;
                this.quadPtrs[i] = this.quadPtrs[this.qlo++];
            }
            for (i = this.clo; i < this.chi; ++i) {
                if (!(Renderer.this.curves[this.curvePtrs[i] + 1] <= (float)this.nextY)) continue;
                this.curvePtrs[i] = this.curvePtrs[this.clo++];
            }
            this.crossings = Helpers.widenArray(this.crossings, 0, this.ehi - this.elo + this.qhi - this.qlo + this.chi - this.clo);
            for (i = this.elo; i < this.ehi; ++i) {
                ptr = this.edgePtrs[i];
                this.addCrossing(this.nextY, (int)Renderer.this.edges[ptr + 2], Renderer.this.edges[ptr + 4], crossingIdx);
                Renderer.this.edgeGoToNextY(ptr);
                ++crossingIdx;
            }
            for (i = this.qlo; i < this.qhi; ++i) {
                ptr = this.quadPtrs[i];
                this.addCrossing(this.nextY, (int)Renderer.this.quads[ptr + 2], Renderer.this.quads[ptr + 4], crossingIdx);
                Renderer.this.quadGoToNextY(ptr);
                ++crossingIdx;
            }
            for (i = this.clo; i < this.chi; ++i) {
                ptr = this.curvePtrs[i];
                this.addCrossing(this.nextY, (int)Renderer.this.curves[ptr + 2], Renderer.this.curves[ptr + 4], crossingIdx);
                Renderer.this.curveGoToNextY(ptr);
                ++crossingIdx;
            }
            ++this.nextY;
            while (this.ehi < Renderer.this.numEdges && Renderer.this.edges[this.edgePtrs[this.ehi] + 0] <= (float)this.nextY) {
                Renderer.this.edgeSetCurY(this.edgePtrs[this.ehi], this.nextY);
                ++this.ehi;
            }
            while (this.qhi < Renderer.this.numQuads && Renderer.this.quads[this.quadPtrs[this.qhi] + 0] <= (float)this.nextY) {
                Renderer.this.quadSetCurY(this.quadPtrs[this.qhi], this.nextY);
                ++this.qhi;
            }
            while (this.chi < Renderer.this.numCurves && Renderer.this.curves[this.curvePtrs[this.chi] + 0] <= (float)this.nextY) {
                Renderer.this.curveSetCurY(this.curvePtrs[this.chi], this.nextY);
                ++this.chi;
            }
            Arrays.sort(this.crossings, 0, crossingIdx);
            return crossingIdx;
        }

        private boolean hasNext() {
            return this.nextY < this.maxY;
        }

        private int curY() {
            return this.nextY - 1;
        }

        private void addCrossing(int y, int x, float or, int idx) {
            this.crossings[idx] = or > 0.0f ? x | 1 : (x <<= 1);
        }
    }
}

