/*
 * Decompiled with CFR 0.152.
 */
package sun.security.pkcs11;

import java.lang.ref.PhantomReference;
import java.lang.ref.ReferenceQueue;
import java.util.Collections;
import java.util.Set;
import java.util.TreeSet;
import sun.security.pkcs11.P11Key;
import sun.security.pkcs11.Session;
import sun.security.pkcs11.wrapper.PKCS11Exception;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class SessionKeyRef
extends PhantomReference<P11Key>
implements Comparable<SessionKeyRef> {
    private static ReferenceQueue<P11Key> refQueue = new ReferenceQueue();
    private static Set<SessionKeyRef> refList = Collections.synchronizedSortedSet(new TreeSet());
    private long keyID;
    private Session session;

    static ReferenceQueue<P11Key> referenceQueue() {
        return refQueue;
    }

    private static void drainRefQueueBounded() {
        SessionKeyRef next;
        while ((next = (SessionKeyRef)refQueue.poll()) != null) {
            next.dispose();
        }
    }

    SessionKeyRef(P11Key key, long keyID, Session session) {
        super(key, refQueue);
        this.keyID = keyID;
        this.session = session;
        this.session.addObject();
        refList.add(this);
        SessionKeyRef.drainRefQueueBounded();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void dispose() {
        refList.remove(this);
        if (this.session.token.isValid()) {
            Session newSession = null;
            try {
                newSession = this.session.token.getOpSession();
                this.session.token.p11.C_DestroyObject(newSession.id(), this.keyID);
            }
            catch (PKCS11Exception pKCS11Exception) {
            }
            finally {
                this.clear();
                this.session.token.releaseSession(newSession);
                this.session.removeObject();
            }
        }
    }

    @Override
    public int compareTo(SessionKeyRef other) {
        if (this.keyID == other.keyID) {
            return 0;
        }
        return this.keyID < other.keyID ? -1 : 1;
    }
}

