/*
 * Decompiled with CFR 0.152.
 */
package javax.swing;

import java.util.Enumeration;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import javax.swing.UIDefaults;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class MultiUIDefaults
extends UIDefaults {
    private UIDefaults[] tables;

    public MultiUIDefaults(UIDefaults[] defaults) {
        this.tables = defaults;
    }

    public MultiUIDefaults() {
        this.tables = new UIDefaults[0];
    }

    @Override
    public Object get(Object key) {
        Object value = super.get(key);
        if (value != null) {
            return value;
        }
        for (int i = 0; i < this.tables.length; ++i) {
            UIDefaults table = this.tables[i];
            Object object = value = table != null ? table.get(key) : null;
            if (value == null) continue;
            return value;
        }
        return null;
    }

    @Override
    public Object get(Object key, Locale l) {
        Object value = super.get(key, l);
        if (value != null) {
            return value;
        }
        for (int i = 0; i < this.tables.length; ++i) {
            UIDefaults table = this.tables[i];
            Object object = value = table != null ? table.get(key, l) : null;
            if (value == null) continue;
            return value;
        }
        return null;
    }

    @Override
    public int size() {
        return this.entrySet().size();
    }

    @Override
    public boolean isEmpty() {
        return this.size() == 0;
    }

    @Override
    public Enumeration keys() {
        return new MultiUIDefaultsEnumerator(MultiUIDefaultsEnumerator.Type.KEYS, this.entrySet());
    }

    @Override
    public Enumeration elements() {
        return new MultiUIDefaultsEnumerator(MultiUIDefaultsEnumerator.Type.ELEMENTS, this.entrySet());
    }

    @Override
    public Set<Map.Entry<Object, Object>> entrySet() {
        HashSet<Map.Entry<Object, Object>> set = new HashSet<Map.Entry<Object, Object>>();
        for (int i = this.tables.length - 1; i >= 0; --i) {
            if (this.tables[i] == null) continue;
            set.addAll(this.tables[i].entrySet());
        }
        set.addAll(super.entrySet());
        return set;
    }

    @Override
    protected void getUIError(String msg) {
        if (this.tables.length > 0) {
            this.tables[0].getUIError(msg);
        } else {
            super.getUIError(msg);
        }
    }

    @Override
    public Object remove(Object key) {
        Object value = null;
        for (int i = this.tables.length - 1; i >= 0; --i) {
            Object v;
            if (this.tables[i] == null || (v = this.tables[i].remove(key)) == null) continue;
            value = v;
        }
        Object v = super.remove(key);
        if (v != null) {
            value = v;
        }
        return value;
    }

    @Override
    public void clear() {
        super.clear();
        for (int i = 0; i < this.tables.length; ++i) {
            UIDefaults table = this.tables[i];
            if (table == null) continue;
            table.clear();
        }
    }

    @Override
    public synchronized String toString() {
        StringBuffer buf = new StringBuffer();
        buf.append("{");
        Enumeration keys = this.keys();
        while (keys.hasMoreElements()) {
            Object key = keys.nextElement();
            buf.append(key + "=" + this.get(key) + ", ");
        }
        int length = buf.length();
        if (length > 1) {
            buf.delete(length - 2, length);
        }
        buf.append("}");
        return buf.toString();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class MultiUIDefaultsEnumerator
    implements Enumeration {
        private Iterator<Map.Entry<Object, Object>> iterator;
        private Type type;

        MultiUIDefaultsEnumerator(Type type, Set<Map.Entry<Object, Object>> entries) {
            this.type = type;
            this.iterator = entries.iterator();
        }

        @Override
        public boolean hasMoreElements() {
            return this.iterator.hasNext();
        }

        public Object nextElement() {
            switch (this.type) {
                case KEYS: {
                    return this.iterator.next().getKey();
                }
                case ELEMENTS: {
                    return this.iterator.next().getValue();
                }
            }
            return null;
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public static enum Type {
            KEYS,
            ELEMENTS;

        }
    }
}

