/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.plaf.metal;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.LayoutManager;
import java.awt.Rectangle;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JInternalFrame;
import javax.swing.JMenu;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import javax.swing.plaf.ColorUIResource;
import javax.swing.plaf.basic.BasicInternalFrameTitlePane;
import javax.swing.plaf.metal.MetalBumps;
import javax.swing.plaf.metal.MetalLookAndFeel;
import javax.swing.plaf.metal.MetalUtils;
import sun.swing.SwingUtilities2;

public class MetalInternalFrameTitlePane
extends BasicInternalFrameTitlePane {
    protected boolean isPalette = false;
    protected Icon paletteCloseIcon;
    protected int paletteTitleHeight;
    private static final Border handyEmptyBorder = new EmptyBorder(0, 0, 0, 0);
    private String selectedBackgroundKey;
    private String selectedForegroundKey;
    private String selectedShadowKey;
    private boolean wasClosable;
    int buttonsWidth = 0;
    MetalBumps activeBumps = new MetalBumps(0, 0, MetalLookAndFeel.getPrimaryControlHighlight(), MetalLookAndFeel.getPrimaryControlDarkShadow(), UIManager.get("InternalFrame.activeTitleGradient") != null ? null : MetalLookAndFeel.getPrimaryControl());
    MetalBumps inactiveBumps = new MetalBumps(0, 0, MetalLookAndFeel.getControlHighlight(), MetalLookAndFeel.getControlDarkShadow(), UIManager.get("InternalFrame.inactiveTitleGradient") != null ? null : MetalLookAndFeel.getControl());
    MetalBumps paletteBumps;
    private Color activeBumpsHighlight = MetalLookAndFeel.getPrimaryControlHighlight();
    private Color activeBumpsShadow = MetalLookAndFeel.getPrimaryControlDarkShadow();

    public MetalInternalFrameTitlePane(JInternalFrame f) {
        super(f);
    }

    @Override
    public void addNotify() {
        super.addNotify();
        this.updateOptionPaneState();
    }

    @Override
    protected void installDefaults() {
        super.installDefaults();
        this.setFont(UIManager.getFont("InternalFrame.titleFont"));
        this.paletteTitleHeight = UIManager.getInt("InternalFrame.paletteTitleHeight");
        this.paletteCloseIcon = UIManager.getIcon("InternalFrame.paletteCloseIcon");
        this.wasClosable = this.frame.isClosable();
        this.selectedBackgroundKey = null;
        this.selectedForegroundKey = null;
        if (MetalLookAndFeel.usingOcean()) {
            this.setOpaque(true);
        }
    }

    @Override
    protected void uninstallDefaults() {
        super.uninstallDefaults();
        if (this.wasClosable != this.frame.isClosable()) {
            this.frame.setClosable(this.wasClosable);
        }
    }

    @Override
    protected void createButtons() {
        super.createButtons();
        Boolean paintActive = this.frame.isSelected() ? Boolean.TRUE : Boolean.FALSE;
        this.iconButton.putClientProperty("paintActive", paintActive);
        this.iconButton.setBorder(handyEmptyBorder);
        this.maxButton.putClientProperty("paintActive", paintActive);
        this.maxButton.setBorder(handyEmptyBorder);
        this.closeButton.putClientProperty("paintActive", paintActive);
        this.closeButton.setBorder(handyEmptyBorder);
        this.closeButton.setBackground(MetalLookAndFeel.getPrimaryControlShadow());
        if (MetalLookAndFeel.usingOcean()) {
            this.iconButton.setContentAreaFilled(false);
            this.maxButton.setContentAreaFilled(false);
            this.closeButton.setContentAreaFilled(false);
        }
    }

    @Override
    protected void assembleSystemMenu() {
    }

    @Override
    protected void addSystemMenuItems(JMenu systemMenu) {
    }

    @Override
    protected void showSystemMenu() {
    }

    @Override
    protected void addSubComponents() {
        this.add(this.iconButton);
        this.add(this.maxButton);
        this.add(this.closeButton);
    }

    @Override
    protected PropertyChangeListener createPropertyChangeListener() {
        return new MetalPropertyChangeHandler();
    }

    @Override
    protected LayoutManager createLayout() {
        return new MetalTitlePaneLayout();
    }

    public void paintPalette(Graphics g) {
        boolean leftToRight = MetalUtils.isLeftToRight(this.frame);
        int width = this.getWidth();
        int height = this.getHeight();
        if (this.paletteBumps == null) {
            this.paletteBumps = new MetalBumps(0, 0, MetalLookAndFeel.getPrimaryControlHighlight(), MetalLookAndFeel.getPrimaryControlInfo(), MetalLookAndFeel.getPrimaryControlShadow());
        }
        ColorUIResource background = MetalLookAndFeel.getPrimaryControlShadow();
        ColorUIResource darkShadow = MetalLookAndFeel.getPrimaryControlDarkShadow();
        g.setColor(background);
        g.fillRect(0, 0, width, height);
        g.setColor(darkShadow);
        g.drawLine(0, height - 1, width, height - 1);
        int xOffset = leftToRight ? 4 : this.buttonsWidth + 4;
        int bumpLength = width - this.buttonsWidth - 8;
        int bumpHeight = this.getHeight() - 4;
        this.paletteBumps.setBumpArea(bumpLength, bumpHeight);
        this.paletteBumps.paintIcon(this, g, xOffset, 2);
    }

    @Override
    public void paintComponent(Graphics g) {
        int bumpXOffset;
        int bumpLength;
        String gradientKey;
        MetalBumps bumps;
        if (this.isPalette) {
            this.paintPalette(g);
            return;
        }
        boolean leftToRight = MetalUtils.isLeftToRight(this.frame);
        boolean isSelected = this.frame.isSelected();
        int width = this.getWidth();
        int height = this.getHeight();
        Color background = null;
        Color foreground = null;
        Color shadow = null;
        if (isSelected) {
            if (!MetalLookAndFeel.usingOcean()) {
                this.closeButton.setContentAreaFilled(true);
                this.maxButton.setContentAreaFilled(true);
                this.iconButton.setContentAreaFilled(true);
            }
            if (this.selectedBackgroundKey != null) {
                background = UIManager.getColor(this.selectedBackgroundKey);
            }
            if (background == null) {
                background = MetalLookAndFeel.getWindowTitleBackground();
            }
            if (this.selectedForegroundKey != null) {
                foreground = UIManager.getColor(this.selectedForegroundKey);
            }
            if (this.selectedShadowKey != null) {
                shadow = UIManager.getColor(this.selectedShadowKey);
            }
            if (shadow == null) {
                shadow = MetalLookAndFeel.getPrimaryControlDarkShadow();
            }
            if (foreground == null) {
                foreground = MetalLookAndFeel.getWindowTitleForeground();
            }
            this.activeBumps.setBumpColors(this.activeBumpsHighlight, this.activeBumpsShadow, UIManager.get("InternalFrame.activeTitleGradient") != null ? null : background);
            bumps = this.activeBumps;
            gradientKey = "InternalFrame.activeTitleGradient";
        } else {
            if (!MetalLookAndFeel.usingOcean()) {
                this.closeButton.setContentAreaFilled(false);
                this.maxButton.setContentAreaFilled(false);
                this.iconButton.setContentAreaFilled(false);
            }
            background = MetalLookAndFeel.getWindowTitleInactiveBackground();
            foreground = MetalLookAndFeel.getWindowTitleInactiveForeground();
            shadow = MetalLookAndFeel.getControlDarkShadow();
            bumps = this.inactiveBumps;
            gradientKey = "InternalFrame.inactiveTitleGradient";
        }
        if (!MetalUtils.drawGradient(this, g, gradientKey, 0, 0, width, height, true)) {
            g.setColor(background);
            g.fillRect(0, 0, width, height);
        }
        g.setColor(shadow);
        g.drawLine(0, height - 1, width, height - 1);
        g.drawLine(0, 0, 0, 0);
        g.drawLine(width - 1, 0, width - 1, 0);
        int titleLength = 0;
        int xOffset = leftToRight ? 5 : width - 5;
        String frameTitle = this.frame.getTitle();
        Icon icon = this.frame.getFrameIcon();
        if (icon != null) {
            if (!leftToRight) {
                xOffset -= icon.getIconWidth();
            }
            int iconY = height / 2 - icon.getIconHeight() / 2;
            icon.paintIcon(this.frame, g, xOffset, iconY);
            xOffset += leftToRight ? icon.getIconWidth() + 5 : -5;
        }
        if (frameTitle != null) {
            Font f = this.getFont();
            g.setFont(f);
            FontMetrics fm = SwingUtilities2.getFontMetrics(this.frame, g, f);
            int fHeight = fm.getHeight();
            g.setColor(foreground);
            int yOffset = (height - fm.getHeight()) / 2 + fm.getAscent();
            Rectangle rect = new Rectangle(0, 0, 0, 0);
            if (this.frame.isIconifiable()) {
                rect = this.iconButton.getBounds();
            } else if (this.frame.isMaximizable()) {
                rect = this.maxButton.getBounds();
            } else if (this.frame.isClosable()) {
                rect = this.closeButton.getBounds();
            }
            if (leftToRight) {
                if (rect.x == 0) {
                    rect.x = this.frame.getWidth() - this.frame.getInsets().right - 2;
                }
                int titleW = rect.x - xOffset - 4;
                frameTitle = this.getTitle(frameTitle, fm, titleW);
            } else {
                int titleW = xOffset - rect.x - rect.width - 4;
                frameTitle = this.getTitle(frameTitle, fm, titleW);
                xOffset -= SwingUtilities2.stringWidth(this.frame, fm, frameTitle);
            }
            titleLength = SwingUtilities2.stringWidth(this.frame, fm, frameTitle);
            SwingUtilities2.drawString((JComponent)this.frame, g, frameTitle, xOffset, yOffset);
            xOffset += leftToRight ? titleLength + 5 : -5;
        }
        if (leftToRight) {
            bumpLength = width - this.buttonsWidth - xOffset - 5;
            bumpXOffset = xOffset;
        } else {
            bumpLength = xOffset - this.buttonsWidth - 5;
            bumpXOffset = this.buttonsWidth + 5;
        }
        int bumpYOffset = 3;
        int bumpHeight = this.getHeight() - 2 * bumpYOffset;
        bumps.setBumpArea(bumpLength, bumpHeight);
        bumps.paintIcon(this, g, bumpXOffset, bumpYOffset);
    }

    public void setPalette(boolean b) {
        this.isPalette = b;
        if (this.isPalette) {
            this.closeButton.setIcon(this.paletteCloseIcon);
            if (this.frame.isMaximizable()) {
                this.remove(this.maxButton);
            }
            if (this.frame.isIconifiable()) {
                this.remove(this.iconButton);
            }
        } else {
            this.closeButton.setIcon(this.closeIcon);
            if (this.frame.isMaximizable()) {
                this.add(this.maxButton);
            }
            if (this.frame.isIconifiable()) {
                this.add(this.iconButton);
            }
        }
        this.revalidate();
        this.repaint();
    }

    private void updateOptionPaneState() {
        int type = -2;
        boolean closable = this.wasClosable;
        Object obj = this.frame.getClientProperty("JInternalFrame.messageType");
        if (obj == null) {
            return;
        }
        if (obj instanceof Integer) {
            type = (Integer)obj;
        }
        switch (type) {
            case 0: {
                this.selectedBackgroundKey = "OptionPane.errorDialog.titlePane.background";
                this.selectedForegroundKey = "OptionPane.errorDialog.titlePane.foreground";
                this.selectedShadowKey = "OptionPane.errorDialog.titlePane.shadow";
                closable = false;
                break;
            }
            case 3: {
                this.selectedBackgroundKey = "OptionPane.questionDialog.titlePane.background";
                this.selectedForegroundKey = "OptionPane.questionDialog.titlePane.foreground";
                this.selectedShadowKey = "OptionPane.questionDialog.titlePane.shadow";
                closable = false;
                break;
            }
            case 2: {
                this.selectedBackgroundKey = "OptionPane.warningDialog.titlePane.background";
                this.selectedForegroundKey = "OptionPane.warningDialog.titlePane.foreground";
                this.selectedShadowKey = "OptionPane.warningDialog.titlePane.shadow";
                closable = false;
                break;
            }
            case -1: 
            case 1: {
                this.selectedShadowKey = null;
                this.selectedForegroundKey = null;
                this.selectedBackgroundKey = null;
                closable = false;
                break;
            }
            default: {
                this.selectedShadowKey = null;
                this.selectedForegroundKey = null;
                this.selectedBackgroundKey = null;
            }
        }
        if (closable != this.frame.isClosable()) {
            this.frame.setClosable(closable);
        }
    }

    class MetalTitlePaneLayout
    extends BasicInternalFrameTitlePane.TitlePaneLayout {
        MetalTitlePaneLayout() {
        }

        @Override
        public void addLayoutComponent(String name, Component c) {
        }

        @Override
        public void removeLayoutComponent(Component c) {
        }

        @Override
        public Dimension preferredLayoutSize(Container c) {
            return this.minimumLayoutSize(c);
        }

        @Override
        public Dimension minimumLayoutSize(Container c) {
            int subtitle_w;
            int title_length;
            int width = 30;
            if (MetalInternalFrameTitlePane.this.frame.isClosable()) {
                width += 21;
            }
            if (MetalInternalFrameTitlePane.this.frame.isMaximizable()) {
                width += 16 + (MetalInternalFrameTitlePane.this.frame.isClosable() ? 10 : 4);
            }
            if (MetalInternalFrameTitlePane.this.frame.isIconifiable()) {
                width += 16 + (MetalInternalFrameTitlePane.this.frame.isMaximizable() ? 2 : (MetalInternalFrameTitlePane.this.frame.isClosable() ? 10 : 4));
            }
            FontMetrics fm = MetalInternalFrameTitlePane.this.frame.getFontMetrics(MetalInternalFrameTitlePane.this.getFont());
            String frameTitle = MetalInternalFrameTitlePane.this.frame.getTitle();
            int title_w = frameTitle != null ? SwingUtilities2.stringWidth(MetalInternalFrameTitlePane.this.frame, fm, frameTitle) : 0;
            int n = title_length = frameTitle != null ? frameTitle.length() : 0;
            width = title_length > 2 ? (width += title_w < (subtitle_w = SwingUtilities2.stringWidth(MetalInternalFrameTitlePane.this.frame, fm, MetalInternalFrameTitlePane.this.frame.getTitle().substring(0, 2) + "...")) ? title_w : subtitle_w) : (width += title_w);
            int height = 0;
            if (MetalInternalFrameTitlePane.this.isPalette) {
                height = MetalInternalFrameTitlePane.this.paletteTitleHeight;
            } else {
                int fontHeight = fm.getHeight();
                fontHeight += 7;
                Icon icon = MetalInternalFrameTitlePane.this.frame.getFrameIcon();
                int iconHeight = 0;
                if (icon != null) {
                    iconHeight = Math.min(icon.getIconHeight(), 16);
                }
                height = Math.max(fontHeight, iconHeight += 5);
            }
            return new Dimension(width, height);
        }

        @Override
        public void layoutContainer(Container c) {
            int spacing;
            boolean leftToRight = MetalUtils.isLeftToRight(MetalInternalFrameTitlePane.this.frame);
            int w = MetalInternalFrameTitlePane.this.getWidth();
            int x = leftToRight ? w : 0;
            int y = 2;
            int buttonHeight = MetalInternalFrameTitlePane.this.closeButton.getIcon().getIconHeight();
            int buttonWidth = MetalInternalFrameTitlePane.this.closeButton.getIcon().getIconWidth();
            if (MetalInternalFrameTitlePane.this.frame.isClosable()) {
                if (MetalInternalFrameTitlePane.this.isPalette) {
                    spacing = 3;
                    MetalInternalFrameTitlePane.this.closeButton.setBounds(x += leftToRight ? -spacing - (buttonWidth + 2) : spacing, y, buttonWidth + 2, MetalInternalFrameTitlePane.this.getHeight() - 4);
                    if (!leftToRight) {
                        x += buttonWidth + 2;
                    }
                } else {
                    spacing = 4;
                    MetalInternalFrameTitlePane.this.closeButton.setBounds(x += leftToRight ? -spacing - buttonWidth : spacing, y, buttonWidth, buttonHeight);
                    if (!leftToRight) {
                        x += buttonWidth;
                    }
                }
            }
            if (MetalInternalFrameTitlePane.this.frame.isMaximizable() && !MetalInternalFrameTitlePane.this.isPalette) {
                spacing = MetalInternalFrameTitlePane.this.frame.isClosable() ? 10 : 4;
                MetalInternalFrameTitlePane.this.maxButton.setBounds(x += leftToRight ? -spacing - buttonWidth : spacing, y, buttonWidth, buttonHeight);
                if (!leftToRight) {
                    x += buttonWidth;
                }
            }
            if (MetalInternalFrameTitlePane.this.frame.isIconifiable() && !MetalInternalFrameTitlePane.this.isPalette) {
                spacing = MetalInternalFrameTitlePane.this.frame.isMaximizable() ? 2 : (MetalInternalFrameTitlePane.this.frame.isClosable() ? 10 : 4);
                MetalInternalFrameTitlePane.this.iconButton.setBounds(x += leftToRight ? -spacing - buttonWidth : spacing, y, buttonWidth, buttonHeight);
                if (!leftToRight) {
                    x += buttonWidth;
                }
            }
            MetalInternalFrameTitlePane.this.buttonsWidth = leftToRight ? w - x : x;
        }
    }

    class MetalPropertyChangeHandler
    extends BasicInternalFrameTitlePane.PropertyChangeHandler {
        MetalPropertyChangeHandler() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            String prop = evt.getPropertyName();
            if (prop.equals("selected")) {
                Boolean b = (Boolean)evt.getNewValue();
                MetalInternalFrameTitlePane.this.iconButton.putClientProperty("paintActive", b);
                MetalInternalFrameTitlePane.this.closeButton.putClientProperty("paintActive", b);
                MetalInternalFrameTitlePane.this.maxButton.putClientProperty("paintActive", b);
            } else if ("JInternalFrame.messageType".equals(prop)) {
                MetalInternalFrameTitlePane.this.updateOptionPaneState();
                MetalInternalFrameTitlePane.this.frame.repaint();
            }
            super.propertyChange(evt);
        }
    }
}

