/*
 * Decompiled with CFR 0.152.
 */
package sun.awt.X11;

import java.awt.datatransfer.Transferable;
import java.io.IOException;
import java.util.Collections;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Map;
import java.util.Set;
import sun.awt.AppContext;
import sun.awt.SunToolkit;
import sun.awt.UNIXToolkit;
import sun.awt.X11.Native;
import sun.awt.X11.WindowPropertyGetter;
import sun.awt.X11.XAtom;
import sun.awt.X11.XClipboard;
import sun.awt.X11.XDataTransferer;
import sun.awt.X11.XEvent;
import sun.awt.X11.XEventDispatcher;
import sun.awt.X11.XPropertyEvent;
import sun.awt.X11.XSelectionClearEvent;
import sun.awt.X11.XSelectionEvent;
import sun.awt.X11.XSelectionRequestEvent;
import sun.awt.X11.XToolkit;
import sun.awt.X11.XWindow;
import sun.awt.X11.XWindowAttributes;
import sun.awt.X11.XlibWrapper;
import sun.awt.datatransfer.DataTransferer;

public class XSelection {
    private static final Hashtable<XAtom, XSelection> table = new Hashtable();
    private static final Object lock = new Object();
    private static final XAtom selectionPropertyAtom = XAtom.get("XAWT_SELECTION");
    public static final long MAX_LENGTH = 1000000L;
    public static final int MAX_PROPERTY_SIZE;
    private static long SELECTION_TIMEOUT;
    private static final XEventDispatcher incrementalTransferHandler;
    private static WindowPropertyGetter propertyGetter;
    private final XAtom selectionAtom;
    private final XClipboard clipboard;
    private Transferable contents = null;
    private Map formatMap = null;
    private long[] formats = null;
    private AppContext appContext = null;
    private static long lastRequestServerTime;
    private long ownershipTime = 0L;
    private boolean isOwner;
    private volatile XAtom targetsPropertyAtom;
    private static volatile Set targetsPropertyAtoms;
    private volatile boolean isSelectionNotifyProcessed;
    private long convertSelectionTime;

    static XSelection getSelection(XAtom atom) {
        return table.get(atom);
    }

    public XSelection(XAtom atom, XClipboard clpbrd) {
        if (atom == null) {
            throw new NullPointerException("Null atom");
        }
        this.selectionAtom = atom;
        this.clipboard = clpbrd;
        table.put(this.selectionAtom, this);
    }

    public XAtom getSelectionAtom() {
        return this.selectionAtom;
    }

    void initializeSelectionForTrackingChanges() {
        this.targetsPropertyAtom = XAtom.get("XAWT_TARGETS_OF_SELECTION:" + this.selectionAtom.getName());
        if (targetsPropertyAtoms == null) {
            targetsPropertyAtoms = Collections.synchronizedSet(new HashSet(2));
        }
        targetsPropertyAtoms.add(this.targetsPropertyAtom.getAtom());
        this.isSelectionNotifyProcessed = true;
    }

    void deinitializeSelectionForTrackingChanges() {
        if (targetsPropertyAtoms != null && this.targetsPropertyAtom != null) {
            targetsPropertyAtoms.remove(this.targetsPropertyAtom.getAtom());
        }
        this.isSelectionNotifyProcessed = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized boolean setOwner(Transferable contents, Map formatMap, long[] formats, long time) {
        block5: {
            boolean bl;
            long owner = XWindow.getXAWTRootWindow().getWindow();
            long selection = this.selectionAtom.getAtom();
            if (time == 0L) {
                time = XToolkit.getCurrentServerTime();
            }
            this.contents = contents;
            this.formatMap = formatMap;
            this.formats = formats;
            this.appContext = AppContext.getAppContext();
            this.ownershipTime = time;
            XToolkit.awtLock();
            try {
                XlibWrapper.XSetSelectionOwner(XToolkit.getDisplay(), selection, owner, time);
                if (XlibWrapper.XGetSelectionOwner(XToolkit.getDisplay(), selection) == owner) break block5;
                this.reset();
                bl = false;
                Object var12_9 = null;
            }
            catch (Throwable throwable) {
                Object var12_11 = null;
                XToolkit.awtUnlock();
                throw throwable;
            }
            XToolkit.awtUnlock();
            return bl;
        }
        this.isOwner = true;
        if (this.clipboard != null) {
            this.clipboard.checkChangeHere(contents);
        }
        boolean bl = true;
        Object var12_10 = null;
        XToolkit.awtUnlock();
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void waitForSelectionNotify(WindowPropertyGetter dataGetter) throws InterruptedException {
        long startTime = System.currentTimeMillis();
        XToolkit.awtLock();
        try {
            do {
                DataTransferer.getInstance().processDataConversionRequests();
                XToolkit.awtLockWait(250L);
                if (propertyGetter != dataGetter) break;
            } while (System.currentTimeMillis() < startTime + SELECTION_TIMEOUT);
            Object var4_2 = null;
        }
        catch (Throwable throwable) {
            Object var4_3 = null;
            XToolkit.awtUnlock();
            throw throwable;
        }
        XToolkit.awtUnlock();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive exception aggregation
     */
    public long[] getTargets(long time) {
        if (XToolkit.isToolkitThread()) {
            throw new Error("UNIMPLEMENTED");
        }
        long[] formats = null;
        Object object = lock;
        synchronized (object) {
            SELECTION_TIMEOUT = UNIXToolkit.getDatatransferTimeout();
            WindowPropertyGetter targetsGetter = new WindowPropertyGetter(XWindow.getXAWTRootWindow().getWindow(), selectionPropertyAtom, 0L, 1000000L, true, 0L);
            try {
                XToolkit.awtLock();
                propertyGetter = targetsGetter;
                lastRequestServerTime = time;
                XlibWrapper.XConvertSelection(XToolkit.getDisplay(), this.getSelectionAtom().getAtom(), XDataTransferer.TARGETS_ATOM.getAtom(), selectionPropertyAtom.getAtom(), XWindow.getXAWTRootWindow().getWindow(), time);
                try {
                    try {
                        XSelection.waitForSelectionNotify(targetsGetter);
                    }
                    catch (InterruptedException ie) {
                        long[] lArray = new long[]{};
                        {
                            Object var9_6 = null;
                            propertyGetter = null;
                        }
                        Object var11_10 = null;
                        XToolkit.awtUnlock();
                        Object var13_13 = null;
                        targetsGetter.dispose();
                        return lArray;
                    }
                    {
                        Object var9_5 = null;
                        propertyGetter = null;
                    }
                }
                catch (Throwable throwable) {
                    try {
                        Object var9_7 = null;
                        propertyGetter = null;
                        throw throwable;
                    }
                    catch (Throwable throwable2) {
                        Object var11_12 = null;
                        XToolkit.awtUnlock();
                        throw throwable2;
                    }
                }
                Object var11_11 = null;
                XToolkit.awtUnlock();
                formats = XSelection.getFormats(targetsGetter);
                Object var13_14 = null;
                targetsGetter.dispose();
            }
            catch (Throwable throwable) {
                Object var13_15 = null;
                targetsGetter.dispose();
                throw throwable;
            }
        }
        return formats;
    }

    private static long[] getFormats(WindowPropertyGetter targetsGetter) {
        int count;
        long[] formats = null;
        if (targetsGetter.isExecuted() && !targetsGetter.isDisposed() && (targetsGetter.getActualType() == 4L || targetsGetter.getActualType() == XDataTransferer.TARGETS_ATOM.getAtom()) && targetsGetter.getActualFormat() == 32 && (count = targetsGetter.getNumberOfItems()) > 0) {
            long atoms = targetsGetter.getData();
            formats = new long[count];
            for (int index = 0; index < count; ++index) {
                formats[index] = Native.getLong(atoms + (long)(index * XAtom.getAtomSize()));
            }
        }
        return formats != null ? formats : new long[]{};
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void getTargetsDelayed() {
        XToolkit.awtLock();
        try {
            long curTime = System.currentTimeMillis();
            if (this.isSelectionNotifyProcessed || curTime >= this.convertSelectionTime + SELECTION_TIMEOUT) {
                this.convertSelectionTime = curTime;
                XlibWrapper.XConvertSelection(XToolkit.getDisplay(), this.getSelectionAtom().getAtom(), XDataTransferer.TARGETS_ATOM.getAtom(), this.targetsPropertyAtom.getAtom(), XWindow.getXAWTRootWindow().getWindow(), 0L);
                this.isSelectionNotifyProcessed = false;
            }
            Object var4_2 = null;
        }
        catch (Throwable throwable) {
            Object var4_3 = null;
            XToolkit.awtUnlock();
            throw throwable;
        }
        XToolkit.awtUnlock();
    }

    /*
     * Exception decompiling
     */
    public byte[] getData(long format, long time) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    boolean isOwner() {
        return this.isOwner;
    }

    public void lostOwnership() {
        this.isOwner = false;
        if (this.clipboard != null) {
            this.clipboard.run();
        }
    }

    public synchronized void reset() {
        this.contents = null;
        this.formatMap = null;
        this.formats = null;
        this.appContext = null;
        this.ownershipTime = 0L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean convertAndStore(long requestor, long format, long property) {
        int dataFormat = 8;
        byte[] byteData = null;
        long nativeDataPtr = 0L;
        int count = 0;
        try {
            SunToolkit.insertTargetMapping(this, this.appContext);
            byteData = DataTransferer.getInstance().convertData(this, this.contents, format, this.formatMap, XToolkit.isToolkitThread());
        }
        catch (IOException ioe) {
            return false;
        }
        if (byteData == null) {
            return false;
        }
        count = byteData.length;
        try {
            if (count > 0) {
                if (count <= MAX_PROPERTY_SIZE) {
                    nativeDataPtr = Native.toData(byteData);
                } else {
                    new IncrementalDataProvider(requestor, property, format, 8, byteData);
                    nativeDataPtr = XlibWrapper.unsafe.allocateMemory(XAtom.getAtomSize());
                    Native.putLong(nativeDataPtr, count);
                    format = XDataTransferer.INCR_ATOM.getAtom();
                    dataFormat = 32;
                    count = 1;
                }
            }
            XToolkit.awtLock();
            try {
                XlibWrapper.XChangeProperty(XToolkit.getDisplay(), requestor, property, format, dataFormat, 0, nativeDataPtr, count);
                Object var14_9 = null;
            }
            catch (Throwable throwable) {
                Object var14_10 = null;
                XToolkit.awtUnlock();
                throw throwable;
            }
            XToolkit.awtUnlock();
            Object var16_12 = null;
            if (nativeDataPtr != 0L) {
                XlibWrapper.unsafe.freeMemory(nativeDataPtr);
                nativeDataPtr = 0L;
            }
        }
        catch (Throwable throwable) {
            Object var16_13 = null;
            if (nativeDataPtr != 0L) {
                XlibWrapper.unsafe.freeMemory(nativeDataPtr);
                nativeDataPtr = 0L;
            }
            throw throwable;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    private void handleSelectionRequest(XSelectionRequestEvent xsre) {
        property = xsre.get_property();
        requestor = xsre.get_requestor();
        requestTime = xsre.get_time();
        format = xsre.get_target();
        dataFormat = 0;
        conversionSucceeded = false;
        if (this.ownershipTime != 0L && (requestTime == 0L || requestTime >= this.ownershipTime)) {
            property = xsre.get_property();
            if (format == XDataTransferer.MULTIPLE_ATOM.getAtom()) {
                if (property != 0L) {
                    wpg = new WindowPropertyGetter(requestor, XAtom.get(property), 0L, 1000000L, false, 0L);
                    try {
                        wpg.execute();
                        if (wpg.getActualFormat() == 32 && wpg.getNumberOfItems() % 2 == 0) {
                            count = wpg.getNumberOfItems() / 2;
                            pairsPtr = wpg.getData();
                            writeBack = false;
                            i = 0;
                            while ((long)i < count) {
                                target = Native.getLong(pairsPtr, 2 * i);
                                if (!this.convertAndStore(requestor, target, prop = Native.getLong(pairsPtr, 2 * i + 1))) {
                                    Native.putLong(pairsPtr, 2 * i, 0L);
                                    writeBack = true;
                                }
                                ++i;
                            }
                            if (writeBack) {
                                XToolkit.awtLock();
                                try {
                                    XlibWrapper.XChangeProperty(XToolkit.getDisplay(), requestor, property, wpg.getActualType(), wpg.getActualFormat(), 0, wpg.getData(), wpg.getNumberOfItems());
                                    var24_18 = null;
                                }
                                catch (Throwable var23_20) {
                                    var24_19 = null;
                                    XToolkit.awtUnlock();
                                    throw var23_20;
                                }
                                XToolkit.awtUnlock();
                                {
                                }
                            }
                            conversionSucceeded = true;
                        }
                        var26_21 = null;
                        wpg.dispose();
                    }
                    catch (Throwable var25_23) {
                        var26_22 = null;
                        wpg.dispose();
                        throw var25_23;
                    }
                }
            } else {
                if (property == 0L) {
                    property = format;
                }
                if (format == XDataTransferer.TARGETS_ATOM.getAtom()) {
                    nativeDataPtr = 0L;
                    count = 0;
                    dataFormat = 32;
                    formatsLocal = this.formats;
                    if (formatsLocal == null) {
                        throw new IllegalStateException("Not an owner.");
                    }
                    count = formatsLocal.length;
                    try {
                        if (count > 0) {
                            nativeDataPtr = Native.allocateLongArray(count);
                            Native.put(nativeDataPtr, formatsLocal);
                        }
                        conversionSucceeded = true;
                        XToolkit.awtLock();
                        try {
                            XlibWrapper.XChangeProperty(XToolkit.getDisplay(), requestor, property, format, dataFormat, 0, nativeDataPtr, count);
                            var28_25 = null;
                        }
                        catch (Throwable var27_27) {
                            var28_26 = null;
                            XToolkit.awtUnlock();
                            throw var27_27;
                        }
                        XToolkit.awtUnlock();
                        var30_28 = null;
                        if (nativeDataPtr == 0L) ** GOTO lbl91
                        XlibWrapper.unsafe.freeMemory(nativeDataPtr);
                        nativeDataPtr = 0L;
                    }
                    catch (Throwable var29_30) {
                        var30_29 = null;
                        if (nativeDataPtr != 0L) {
                            XlibWrapper.unsafe.freeMemory(nativeDataPtr);
                            nativeDataPtr = 0L;
                        }
                        throw var29_30;
                    }
                } else {
                    conversionSucceeded = this.convertAndStore(requestor, format, property);
                }
            }
        }
lbl91:
        // 7 sources

        if (!conversionSucceeded) {
            property = 0L;
        }
        xse = new XSelectionEvent();
        try {
            xse.set_type(31);
            xse.set_send_event(true);
            xse.set_requestor(requestor);
            xse.set_selection(this.selectionAtom.getAtom());
            xse.set_target(format);
            xse.set_property(property);
            xse.set_time(requestTime);
            XToolkit.awtLock();
            try {
                XlibWrapper.XSendEvent(XToolkit.getDisplay(), requestor, false, 0L, xse.pData);
                var32_31 = null;
            }
            catch (Throwable var31_33) {
                var32_32 = null;
                XToolkit.awtUnlock();
                throw var31_33;
            }
            XToolkit.awtUnlock();
            var34_34 = null;
            xse.dispose();
        }
        catch (Throwable var33_36) {
            var34_35 = null;
            xse.dispose();
            throw var33_36;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void checkChange(XSelectionEvent xse) {
        if (targetsPropertyAtoms == null || targetsPropertyAtoms.isEmpty()) {
            return;
        }
        long propertyAtom = xse.get_property();
        long[] formats = null;
        if (propertyAtom == 0L) {
            formats = new long[]{};
        } else {
            if (!targetsPropertyAtoms.contains(propertyAtom)) {
                return;
            }
            WindowPropertyGetter targetsGetter = new WindowPropertyGetter(XWindow.getXAWTRootWindow().getWindow(), XAtom.get(propertyAtom), 0L, 1000000L, true, 0L);
            try {
                targetsGetter.execute();
                formats = XSelection.getFormats(targetsGetter);
                Object var6_4 = null;
                targetsGetter.dispose();
            }
            catch (Throwable throwable) {
                Object var6_5 = null;
                targetsGetter.dispose();
                throw throwable;
            }
        }
        XAtom selectionAtom = XAtom.get(xse.get_selection());
        XSelection selection = XSelection.getSelection(selectionAtom);
        if (selection != null) {
            selection.isSelectionNotifyProcessed = true;
            if (selection.clipboard != null) {
                selection.clipboard.checkChange(formats);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static {
        XToolkit.awtLock();
        try {
            MAX_PROPERTY_SIZE = (int)(XlibWrapper.XMaxRequestSize(XToolkit.getDisplay()) * 4L - 100L);
            Object var1 = null;
        }
        catch (Throwable throwable) {
            Object var1_1 = null;
            XToolkit.awtUnlock();
            throw throwable;
        }
        XToolkit.awtUnlock();
        SELECTION_TIMEOUT = UNIXToolkit.getDatatransferTimeout();
        incrementalTransferHandler = new IncrementalTransferHandler();
        propertyGetter = null;
        XToolkit.addEventDispatcher(XWindow.getXAWTRootWindow().getWindow(), new SelectionEventHandler());
    }

    private static class IncrementalTransferHandler
    implements XEventDispatcher {
        private IncrementalTransferHandler() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void dispatchEvent(XEvent ev) {
            switch (ev.get_type()) {
                case 28: {
                    XPropertyEvent xpe = ev.get_xproperty();
                    if (xpe.get_state() != 0 || xpe.get_atom() != selectionPropertyAtom.getAtom()) break;
                    XToolkit.awtLock();
                    try {
                        if (propertyGetter != null) {
                            propertyGetter.execute();
                            propertyGetter = null;
                        }
                        XToolkit.awtLockNotifyAll();
                        Object var4_3 = null;
                    }
                    catch (Throwable throwable) {
                        Object var4_4 = null;
                        XToolkit.awtUnlock();
                        throw throwable;
                    }
                    XToolkit.awtUnlock();
                    break;
                }
            }
        }
    }

    private static class IncrementalDataProvider
    implements XEventDispatcher {
        private final long requestor;
        private final long property;
        private final long target;
        private final int format;
        private final byte[] data;
        private int offset = 0;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public IncrementalDataProvider(long requestor, long property, long target, int format, byte[] data) {
            if (format != 8) {
                throw new IllegalArgumentException("Unsupported format: " + format);
            }
            this.requestor = requestor;
            this.property = property;
            this.target = target;
            this.format = format;
            this.data = data;
            XWindowAttributes wattr = new XWindowAttributes();
            try {
                XToolkit.awtLock();
                try {
                    XlibWrapper.XGetWindowAttributes(XToolkit.getDisplay(), requestor, wattr.pData);
                    XlibWrapper.XSelectInput(XToolkit.getDisplay(), requestor, wattr.get_your_event_mask() | 0x400000L);
                    Object var11_7 = null;
                }
                catch (Throwable throwable) {
                    Object var11_8 = null;
                    XToolkit.awtUnlock();
                    throw throwable;
                }
                XToolkit.awtUnlock();
                Object var13_10 = null;
                wattr.dispose();
            }
            catch (Throwable throwable) {
                Object var13_11 = null;
                wattr.dispose();
                throw throwable;
            }
            XToolkit.addEventDispatcher(requestor, this);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void dispatchEvent(XEvent ev) {
            switch (ev.get_type()) {
                case 28: {
                    XPropertyEvent xpe = ev.get_xproperty();
                    if (xpe.get_window() != this.requestor || xpe.get_state() != 1 || xpe.get_atom() != this.property) break;
                    int count = this.data.length - this.offset;
                    long nativeDataPtr = 0L;
                    if (count > MAX_PROPERTY_SIZE) {
                        count = MAX_PROPERTY_SIZE;
                    }
                    if (count > 0) {
                        nativeDataPtr = XlibWrapper.unsafe.allocateMemory(count);
                        for (int i = 0; i < count; ++i) {
                            Native.putByte(nativeDataPtr + (long)i, this.data[this.offset + i]);
                        }
                    } else {
                        assert (count == 0);
                        XToolkit.removeEventDispatcher(this.requestor, this);
                    }
                    XToolkit.awtLock();
                    try {
                        XlibWrapper.XChangeProperty(XToolkit.getDisplay(), this.requestor, this.property, this.target, this.format, 0, nativeDataPtr, count);
                        Object var8_6 = null;
                    }
                    catch (Throwable throwable) {
                        Object var8_7 = null;
                        XToolkit.awtUnlock();
                        throw throwable;
                    }
                    XToolkit.awtUnlock();
                    if (nativeDataPtr != 0L) {
                        XlibWrapper.unsafe.freeMemory(nativeDataPtr);
                        nativeDataPtr = 0L;
                    }
                    this.offset += count;
                }
            }
        }
    }

    private static class SelectionEventHandler
    implements XEventDispatcher {
        private SelectionEventHandler() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void dispatchEvent(XEvent ev) {
            switch (ev.get_type()) {
                case 31: {
                    XSelectionEvent xse = ev.get_xselection();
                    XSelection.checkChange(xse);
                    XToolkit.awtLock();
                    try {
                        if (propertyGetter != null && xse.get_time() == lastRequestServerTime) {
                            if (xse.get_property() == selectionPropertyAtom.getAtom()) {
                                propertyGetter.execute();
                                propertyGetter = null;
                            } else if (xse.get_property() == 0L) {
                                propertyGetter.dispose();
                                propertyGetter = null;
                            }
                        }
                        XToolkit.awtLockNotifyAll();
                        Object var4_5 = null;
                    }
                    catch (Throwable throwable) {
                        Object var4_6 = null;
                        XToolkit.awtUnlock();
                        throw throwable;
                    }
                    XToolkit.awtUnlock();
                    break;
                }
                case 30: {
                    XSelectionRequestEvent xsre = ev.get_xselectionrequest();
                    long atom = xsre.get_selection();
                    XSelection selection = XSelection.getSelection(XAtom.get(atom));
                    if (selection == null) break;
                    selection.handleSelectionRequest(xsre);
                    break;
                }
                case 29: {
                    XSelectionClearEvent xsce = ev.get_xselectionclear();
                    long atom = xsce.get_selection();
                    XSelection selection = XSelection.getSelection(XAtom.get(atom));
                    if (selection != null) {
                        selection.lostOwnership();
                    }
                    XToolkit.awtLock();
                    try {
                        XToolkit.awtLockNotifyAll();
                        Object var7_12 = null;
                    }
                    catch (Throwable throwable) {
                        Object var7_13 = null;
                        XToolkit.awtUnlock();
                        throw throwable;
                    }
                    XToolkit.awtUnlock();
                    break;
                }
            }
        }
    }
}

