/*
 * Decompiled with CFR 0.152.
 */
package sun.jvm.hotspot.asm.x86;

import sun.jvm.hotspot.asm.Instruction;
import sun.jvm.hotspot.asm.x86.FPArithmeticDecoder;
import sun.jvm.hotspot.asm.x86.FPInstructionDecoder;
import sun.jvm.hotspot.asm.x86.FPLoadDecoder;
import sun.jvm.hotspot.asm.x86.FPStoreDecoder;
import sun.jvm.hotspot.asm.x86.FloatGRPDecoder;
import sun.jvm.hotspot.asm.x86.InstructionDecoder;
import sun.jvm.hotspot.asm.x86.X86InstructionFactory;

public class FloatDecoder
extends FPInstructionDecoder {
    private static final FPInstructionDecoder[][] floatMapOne = new FPInstructionDecoder[][]{{new FPArithmeticDecoder("fadds", 1, 2, 0), new FPArithmeticDecoder("fmuls", 1, 2, 4), new FPInstructionDecoder("fcoms", 1, 2), new FPInstructionDecoder("fcomps", 1, 2), new FPArithmeticDecoder("fsubs", 1, 2, 2), new FPArithmeticDecoder("fsubrs", 1, 2, 2), new FPArithmeticDecoder("fdivs", 1, 2, 6), new FPArithmeticDecoder("fdivrs", 1, 2, 6)}, {new FPLoadDecoder("flds", 1, 2), null, new FPStoreDecoder("fsts", 1, 2), new FPStoreDecoder("fstps", 1, 2), new FPStoreDecoder("fldenv", 1, 2), new FPStoreDecoder("fldcw", 1, 2), new FPStoreDecoder("fNstenv", 1, 2), new FPStoreDecoder("fNstcw", 1, 2)}, {new FPArithmeticDecoder("fiaddl", 1, 2, 0), new FPArithmeticDecoder("fimull", 1, 2, 4), new FPInstructionDecoder("ficoml", 1, 2), new FPInstructionDecoder("ficompl", 1, 2), new FPArithmeticDecoder("fisubl", 1, 2, 2), new FPArithmeticDecoder("fisubrl", 1, 2, 2), new FPArithmeticDecoder("fidivl", 1, 2, 6), new FPArithmeticDecoder("fidivrl", 1, 2, 6)}, {new FPLoadDecoder("fildl", 1, 2), null, new FPStoreDecoder("fistl", 1, 2), new FPStoreDecoder("fistpl", 1, 2), null, new FPLoadDecoder("fldt", 1, 2), null, new FPStoreDecoder("fstpt", 1, 2)}, {new FPArithmeticDecoder("faddl", 1, 2, 0), new FPArithmeticDecoder("fmull", 1, 2, 4), new FPInstructionDecoder("fcoml", 1, 2), new FPInstructionDecoder("fcompl", 1, 2), new FPArithmeticDecoder("fsubl", 1, 2, 2), new FPArithmeticDecoder("fsubrl", 1, 2, 2), new FPArithmeticDecoder("fdivl", 1, 2, 6), new FPArithmeticDecoder("fdivrl", 1, 2, 6)}, {new FPLoadDecoder("fldl", 1, 2), null, new FPStoreDecoder("fstl", 1, 2), new FPStoreDecoder("fstpl", 1, 2), new FPStoreDecoder("frstor", 1, 2), null, new FPStoreDecoder("fNsave", 1, 2), new FPStoreDecoder("fNstsw", 1, 2)}, {new FPArithmeticDecoder("fiadd", 1, 2, 0), new FPArithmeticDecoder("fimul", 1, 2, 4), new FPInstructionDecoder("ficom", 1, 2), new FPInstructionDecoder("ficomp", 1, 2), new FPArithmeticDecoder("fisub", 1, 2, 2), new FPArithmeticDecoder("fisubr", 1, 2, 2), new FPArithmeticDecoder("fidiv", 1, 2, 6), new FPArithmeticDecoder("fidivr", 1, 2, 6)}, {new FPLoadDecoder("fild", 1, 2), null, new FPStoreDecoder("fist", 1, 2), new FPStoreDecoder("fistp", 1, 2), new FPLoadDecoder("fbld", 1, 2), new FPLoadDecoder("fildll", 1, 2), new FPStoreDecoder("fbstp", 1, 2), new FPStoreDecoder("fistpll", 1, 2)}};
    private static final FPInstructionDecoder[][] floatMapTwo = new FPInstructionDecoder[][]{{new FPArithmeticDecoder("fadd", 18, 0, 18, 1, 0), new FPArithmeticDecoder("fmul", 18, 0, 18, 1, 4), new FPInstructionDecoder("fcom", 18, 1), new FPInstructionDecoder("fcomp", 18, 1), new FPArithmeticDecoder("fsub", 18, 0, 18, 1, 2), new FPArithmeticDecoder("fsubr", 18, 0, 18, 1, 2), new FPArithmeticDecoder("fdiv", 18, 0, 18, 1, 6), new FPArithmeticDecoder("fdivr", 18, 0, 18, 1, 6)}, {new FPLoadDecoder("fld", 18, 1), new FPInstructionDecoder("fxch", 18, 1), new FloatGRPDecoder(null, 0), null, new FloatGRPDecoder(null, 1), new FloatGRPDecoder(null, 2), new FloatGRPDecoder(null, 3), new FloatGRPDecoder(null, 4)}, {null, null, null, null, null, new FloatGRPDecoder(null, 5), null, null}, {null, null, null, null, new FloatGRPDecoder(null, 6), null, null, null}, {new FPArithmeticDecoder("fadd", 18, 1, 18, 0, 0), new FPArithmeticDecoder("fmul", 18, 1, 18, 0, 4), null, null, new FPArithmeticDecoder("fsub", 18, 1, 18, 0, 2), new FPArithmeticDecoder("fsubr", 18, 1, 18, 0, 2), new FPArithmeticDecoder("fdiv", 18, 1, 18, 0, 6), new FPArithmeticDecoder("fdivr", 18, 1, 18, 0, 6)}, {new FPInstructionDecoder("ffree", 18, 1), null, new FPStoreDecoder("fst", 18, 1), new FPStoreDecoder("fstp", 18, 1), new FPInstructionDecoder("fucom", 18, 1), new FPInstructionDecoder("fucomp", 18, 1), null, null}, {new FPArithmeticDecoder("faddp", 18, 1, 18, 0, 0), new FPArithmeticDecoder("fmulp", 18, 1, 18, 0, 4), null, new FloatGRPDecoder(null, 7), new FPArithmeticDecoder("fsubrp", 18, 1, 18, 0, 2), new FPArithmeticDecoder("fsubp", 18, 1, 18, 0, 2), new FPArithmeticDecoder("fdivrp", 18, 1, 18, 0, 6), new FPArithmeticDecoder("fdivp", 18, 1, 18, 0, 6)}, {null, null, null, null, new FloatGRPDecoder(null, 7), null, null, null}};

    public FloatDecoder() {
        super(null);
    }

    public Instruction decode(byte[] bytesArray, int index, int instrStartIndex, int segmentOverride, int prefixes, X86InstructionFactory factory) {
        this.byteIndex = index;
        this.instrStartIndex = instrStartIndex;
        this.prefixes = prefixes;
        int ModRM = FloatDecoder.readByte(bytesArray, this.byteIndex);
        int reg = ModRM >> 3 & 7;
        int regOrOpcode = ModRM >> 3 & 7;
        int rm = ModRM & 7;
        int floatOpcode = InstructionDecoder.readByte(bytesArray, instrStartIndex);
        FPInstructionDecoder instrDecoder = null;
        instrDecoder = ModRM < 191 ? floatMapOne[floatOpcode - 216][reg] : floatMapTwo[floatOpcode - 216][reg];
        Instruction instr = null;
        if (instrDecoder != null) {
            instr = instrDecoder.decode(bytesArray, this.byteIndex, instrStartIndex, segmentOverride, prefixes, factory);
            this.byteIndex = instrDecoder.getCurrentIndex();
        } else {
            instr = factory.newIllegalInstruction();
        }
        return instr;
    }
}

