/*
 * Decompiled with CFR 0.152.
 */
package sun.jvm.hotspot.interpreter;

import sun.jvm.hotspot.interpreter.BytecodeStream;
import sun.jvm.hotspot.interpreter.BytecodeWithCPIndex;
import sun.jvm.hotspot.oops.ConstantPool;
import sun.jvm.hotspot.oops.ConstantPoolCache;
import sun.jvm.hotspot.oops.Klass;
import sun.jvm.hotspot.oops.Method;
import sun.jvm.hotspot.oops.Oop;
import sun.jvm.hotspot.oops.OopUtilities;
import sun.jvm.hotspot.oops.Symbol;
import sun.jvm.hotspot.runtime.VM;
import sun.jvm.hotspot.utilities.Assert;
import sun.jvm.hotspot.utilities.ConstantTag;

public class BytecodeLoadConstant
extends BytecodeWithCPIndex {
    BytecodeLoadConstant(Method method, int bci) {
        super(method, bci);
    }

    public boolean hasCacheIndex() {
        return this.javaCode() != this.code();
    }

    public int index() {
        int i;
        int n = i = this.javaCode() == 18 ? 0xFF & this.javaByteAt(1) : 0xFFFF & this.javaShortAt(1);
        if (this.hasCacheIndex()) {
            return 0xFFFF & VM.getVM().getBytes().swapShort((short)i);
        }
        return i;
    }

    public int poolIndex() {
        int i = this.index();
        if (this.hasCacheIndex()) {
            ConstantPoolCache cpCache = this.method().getConstants().getCache();
            return cpCache.getEntryAt(i).getConstantPoolIndex();
        }
        return i;
    }

    public int cacheIndex() {
        if (this.hasCacheIndex()) {
            return this.index();
        }
        return -1;
    }

    private Oop getCachedConstant() {
        int i = this.cacheIndex();
        if (i >= 0) {
            ConstantPoolCache cpCache = this.method().getConstants().getCache();
            return cpCache.getEntryAt(i).getF1();
        }
        return null;
    }

    public void verify() {
        if (Assert.ASSERTS_ENABLED) {
            Assert.that(this.isValid(), "check load constant");
        }
    }

    public boolean isValid() {
        boolean codeOk;
        int jcode = this.javaCode();
        boolean bl = codeOk = jcode == 18 || jcode == 19 || jcode == 20;
        if (!codeOk) {
            return false;
        }
        ConstantTag ctag = this.method().getConstants().getTagAt(this.index());
        if (jcode == 20) {
            return ctag.isDouble() || ctag.isLong();
        }
        return ctag.isUnresolvedString() || ctag.isString() || ctag.isUnresolvedKlass() || ctag.isKlass() || ctag.isMethodHandle() || ctag.isMethodType() || ctag.isInt() || ctag.isFloat();
    }

    public boolean isKlassConstant() {
        int jcode = this.javaCode();
        if (jcode == 20) {
            return false;
        }
        ConstantTag ctag = this.method().getConstants().getTagAt(this.index());
        return ctag.isKlass() || ctag.isUnresolvedKlass();
    }

    public Oop getKlass() {
        int cpIndex;
        ConstantPool cpool;
        Oop oop;
        if (Assert.ASSERTS_ENABLED) {
            Assert.that(this.isKlassConstant(), "not a klass literal");
        }
        if ((oop = (cpool = this.method().getConstants()).getObjAt(cpIndex = this.index())).isKlass()) {
            return (Klass)oop;
        }
        if (oop.isSymbol()) {
            return (Symbol)oop;
        }
        throw new RuntimeException("should not reach here");
    }

    public static BytecodeLoadConstant at(Method method, int bci) {
        BytecodeLoadConstant b = new BytecodeLoadConstant(method, bci);
        if (Assert.ASSERTS_ENABLED) {
            b.verify();
        }
        return b;
    }

    public static BytecodeLoadConstant atCheck(Method method, int bci) {
        BytecodeLoadConstant b = new BytecodeLoadConstant(method, bci);
        return b.isValid() ? b : null;
    }

    public static BytecodeLoadConstant at(BytecodeStream bcs) {
        return new BytecodeLoadConstant(bcs.method(), bcs.bci());
    }

    public String getConstantValue() {
        int cpIndex;
        ConstantPool cpool = this.method().getConstants();
        ConstantTag ctag = cpool.getTagAt(cpIndex = this.poolIndex());
        if (ctag.isInt()) {
            return "<int " + Integer.toString(cpool.getIntAt(cpIndex)) + ">";
        }
        if (ctag.isLong()) {
            return "<long " + Long.toString(cpool.getLongAt(cpIndex)) + "L>";
        }
        if (ctag.isFloat()) {
            return "<float " + Float.toString(cpool.getFloatAt(cpIndex)) + "F>";
        }
        if (ctag.isDouble()) {
            return "<double " + Double.toString(cpool.getDoubleAt(cpIndex)) + "D>";
        }
        if (ctag.isString() || ctag.isUnresolvedString()) {
            Oop obj = cpool.getObjAt(cpIndex);
            if (obj.isSymbol()) {
                Symbol sym = (Symbol)obj;
                return "<String \"" + sym.asString() + "\">";
            }
            if (obj.isInstance()) {
                return "<String \"" + OopUtilities.stringOopToString(obj) + "\">";
            }
            throw new RuntimeException("should not reach here");
        }
        if (ctag.isKlass() || ctag.isUnresolvedKlass()) {
            Oop obj = cpool.getObjAt(cpIndex);
            if (obj.isKlass()) {
                Klass k = (Klass)obj;
                return "<Class " + k.getName().asString() + "@" + k.getHandle() + ">";
            }
            if (obj.isSymbol()) {
                Symbol sym = (Symbol)obj;
                return "<Class " + sym.asString() + ">";
            }
            throw new RuntimeException("should not reach here");
        }
        if (ctag.isMethodHandle() || ctag.isMethodType()) {
            Oop x = this.getCachedConstant();
            int refidx = cpool.getMethodHandleIndexAt(cpIndex);
            int refkind = cpool.getMethodHandleRefKindAt(cpIndex);
            return "<MethodHandle kind=" + Integer.toString(refkind) + " ref=" + Integer.toString(refidx) + (x == null ? "" : " @" + x.getHandle()) + ">";
        }
        if (ctag.isMethodType()) {
            Oop x = this.getCachedConstant();
            int refidx = cpool.getMethodTypeIndexAt(cpIndex);
            return "<MethodType " + cpool.getSymbolAt(refidx).asString() + (x == null ? "" : " @" + x.getHandle()) + ">";
        }
        if (Assert.ASSERTS_ENABLED) {
            Assert.that(false, "invalid load constant type");
        }
        return null;
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        buf.append(this.getJavaBytecodeName());
        buf.append(" ");
        buf.append('#');
        buf.append(Integer.toString(this.poolIndex()));
        if (this.hasCacheIndex()) {
            buf.append('(');
            buf.append(Integer.toString(this.cacheIndex()));
            buf.append(')');
        }
        buf.append(" ");
        buf.append(this.getConstantValue());
        if (this.code() != this.javaCode()) {
            buf.append(" ");
            buf.append('[');
            buf.append(this.getBytecodeName());
            buf.append(']');
        }
        return buf.toString();
    }
}

