/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jnlp.security.viewer;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.FileOutputStream;
import java.io.PrintStream;
import java.security.KeyStore;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Enumeration;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.table.DefaultTableModel;
import net.sourceforge.jnlp.security.SecurityUtil;
import net.sourceforge.jnlp.security.SecurityWarningDialog;
import net.sourceforge.jnlp.tools.KeyTool;

public class CertificatePane
extends JPanel {
    private ArrayList<X509Certificate> certs = null;
    private String[][] issuedToAndBy = null;
    private final String[] columnNames = new String[]{"Issued To", "Issued By"};
    private JTable table;
    private JDialog parent;
    private JComponent defaultFocusComponent = null;
    private KeyStore keyStore = null;

    public CertificatePane(JDialog parent) {
        this.parent = parent;
        this.initializeKeyStore();
        this.addComponents();
    }

    private void initializeKeyStore() {
        try {
            this.keyStore = SecurityUtil.getUserKeyStore();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    protected void addComponents() {
        JButton button;
        int i;
        this.readKeyStore();
        JPanel main = new JPanel(new BorderLayout());
        JPanel tablePanel = new JPanel(new BorderLayout());
        DefaultTableModel tableModel = new DefaultTableModel(this.issuedToAndBy, this.columnNames);
        this.table = new JTable(tableModel);
        this.table.getTableHeader().setReorderingAllowed(false);
        this.table.setFillsViewportHeight(true);
        JScrollPane tablePane = new JScrollPane(this.table);
        tablePane.setPreferredSize(new Dimension(500, 200));
        tablePane.setSize(new Dimension(500, 200));
        tablePane.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        JTabbedPane tabbedPane = new JTabbedPane();
        tabbedPane.addTab("User", tablePane);
        JPanel buttonPanel = new JPanel(new FlowLayout());
        String[] buttonNames = new String[]{"Import", "Export", "Remove", "Details"};
        char[] buttonMnemonics = new char[]{'I', 'E', 'M', 'D'};
        ActionListener[] listeners = new ActionListener[]{new ImportButtonListener(), new ExportButtonListener(), new RemoveButtonListener(), new DetailsButtonListener()};
        int maxWidth = 0;
        for (i = 0; i < buttonNames.length; ++i) {
            button = new JButton(buttonNames[i]);
            maxWidth = Math.max(maxWidth, button.getMinimumSize().width);
        }
        for (i = 0; i < buttonNames.length; ++i) {
            button = new JButton(buttonNames[i]);
            button.setMnemonic(buttonMnemonics[i]);
            button.addActionListener(listeners[i]);
            button.setSize(maxWidth, button.getSize().height);
            buttonPanel.add(button);
        }
        tablePanel.add((Component)tabbedPane, "Center");
        tablePanel.add((Component)buttonPanel, "South");
        JPanel closePanel = new JPanel(new BorderLayout());
        closePanel.setBorder(BorderFactory.createEmptyBorder(7, 7, 7, 7));
        JButton closeButton = new JButton("Close");
        closeButton.addActionListener(new CloseButtonListener());
        this.defaultFocusComponent = closeButton;
        closePanel.add((Component)closeButton, "East");
        main.add((Component)tablePanel, "Center");
        main.add((Component)closePanel, "South");
        this.add(main);
    }

    private void readKeyStore() {
        Enumeration<String> aliases = null;
        this.certs = new ArrayList();
        try {
            aliases = this.keyStore.aliases();
            while (aliases.hasMoreElements()) {
                Certificate c = this.keyStore.getCertificate(aliases.nextElement());
                if (!(c instanceof X509Certificate)) continue;
                this.certs.add((X509Certificate)c);
            }
            this.issuedToAndBy = new String[this.certs.size()][2];
            for (int i = 0; i < this.certs.size(); ++i) {
                X509Certificate c = this.certs.get(i);
                this.issuedToAndBy[i][0] = SecurityUtil.getCN(c.getSubjectX500Principal().getName());
                this.issuedToAndBy[i][1] = SecurityUtil.getCN(c.getIssuerX500Principal().getName());
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void repopulateTable() {
        this.initializeKeyStore();
        this.readKeyStore();
        DefaultTableModel tableModel = new DefaultTableModel(this.issuedToAndBy, this.columnNames);
        this.table.setModel(tableModel);
        this.repaint();
    }

    public void focusOnDefaultButton() {
        if (this.defaultFocusComponent != null) {
            this.defaultFocusComponent.requestFocusInWindow();
        }
    }

    private class CloseButtonListener
    implements ActionListener {
        private CloseButtonListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            CertificatePane.this.parent.dispose();
        }
    }

    private class DetailsButtonListener
    implements ActionListener {
        private DetailsButtonListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            int selectedRow = CertificatePane.this.table.getSelectedRow();
            if (selectedRow != -1 && selectedRow >= 0) {
                X509Certificate c = (X509Certificate)CertificatePane.this.certs.get(selectedRow);
                SecurityWarningDialog.showSingleCertInfoDialog(c, CertificatePane.this.parent);
            }
        }
    }

    private class RemoveButtonListener
    implements ActionListener {
        private RemoveButtonListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            try {
                int selectedRow = CertificatePane.this.table.getSelectedRow();
                if (selectedRow != -1) {
                    int i;
                    String alias = CertificatePane.this.keyStore.getCertificateAlias((Certificate)CertificatePane.this.certs.get(selectedRow));
                    if (alias != null && (i = JOptionPane.showConfirmDialog(CertificatePane.this.parent, "Are you sure you want to remove the selected certificate?", "Confirmation - Remove Certificate?", 0)) == 0) {
                        CertificatePane.this.keyStore.deleteEntry(alias);
                        FileOutputStream fos = new FileOutputStream(SecurityUtil.getTrustedCertsFilename());
                        CertificatePane.this.keyStore.store(fos, SecurityUtil.getTrustedCertsPassword());
                        fos.close();
                    }
                    CertificatePane.this.repopulateTable();
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
    }

    private class ExportButtonListener
    implements ActionListener {
        private ExportButtonListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            try {
                String alias;
                JFileChooser chooser;
                int returnVal;
                int selectedRow = CertificatePane.this.table.getSelectedRow();
                if (selectedRow != -1 && (returnVal = (chooser = new JFileChooser()).showOpenDialog(CertificatePane.this.parent)) == 0 && (alias = CertificatePane.this.keyStore.getCertificateAlias((Certificate)CertificatePane.this.certs.get(selectedRow))) != null) {
                    Certificate c = CertificatePane.this.keyStore.getCertificate(alias);
                    PrintStream ps = new PrintStream(chooser.getSelectedFile().getAbsolutePath());
                    KeyTool.dumpCert(c, ps);
                    CertificatePane.this.repopulateTable();
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
    }

    private class ImportButtonListener
    implements ActionListener {
        private ImportButtonListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            JFileChooser chooser = new JFileChooser();
            int returnVal = chooser.showOpenDialog(CertificatePane.this.parent);
            if (returnVal == 0) {
                try {
                    KeyTool kt = new KeyTool();
                    kt.importCert(chooser.getSelectedFile());
                    CertificatePane.this.repopulateTable();
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
        }
    }
}

