/*
 * Decompiled with CFR 0.152.
 */
package sun.tools.jconsole.inspector;

import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.Vector;
import javax.swing.JTable;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableColumnModel;
import sun.tools.jconsole.inspector.XMBeanAttributes;

public class TableSorter
extends DefaultTableModel
implements MouseListener {
    private boolean ascending = true;
    private TableColumnModel columnModel;
    private JTable tableView;
    private Vector<TableModelListener> listenerList = new Vector();
    private int sortColumn = 0;
    private int[] invertedIndex;

    public TableSorter() {
    }

    public TableSorter(Object[] columnNames, int numRows) {
        super(columnNames, numRows);
    }

    public void newDataAvailable(TableModelEvent e) {
        super.newDataAvailable(e);
        this.invertedIndex = new int[this.getRowCount()];
        for (int i = 0; i < this.invertedIndex.length; ++i) {
            this.invertedIndex[i] = i;
        }
        this.sort(this.sortColumn);
    }

    public void addTableModelListener(TableModelListener l) {
        this.listenerList.add(l);
        super.addTableModelListener(l);
    }

    public void removeTableModelListener(TableModelListener l) {
        this.listenerList.remove(l);
        super.removeTableModelListener(l);
    }

    private void removeListeners() {
        for (TableModelListener tnl : this.listenerList) {
            super.removeTableModelListener(tnl);
        }
    }

    private void restoreListeners() {
        for (TableModelListener tnl : this.listenerList) {
            super.addTableModelListener(tnl);
        }
    }

    public int compare(Object o1, Object o2) {
        if (o1 == null) {
            return 1;
        }
        if (o2 == null) {
            return -1;
        }
        if (o1.getClass().equals(o2.getClass()) && o1 instanceof Comparable) {
            return ((Comparable)o1).compareTo(o2);
        }
        return o1.toString().compareTo(o2.toString());
    }

    public void sort(int column) {
        this.removeListeners();
        this.quickSort(0, this.getRowCount() - 1, column);
        this.restoreListeners();
        this.sortColumn = column;
        if (this.tableView instanceof XMBeanAttributes) {
            XMBeanAttributes attrs = (XMBeanAttributes)this.tableView;
            for (int i = 0; i < this.getRowCount(); ++i) {
                Vector data = (Vector)this.dataVector.elementAt(i);
                attrs.updateRowHeight(data.elementAt(1), i);
            }
        }
    }

    private synchronized boolean compareS(Object s1, Object s2) {
        if (this.ascending) {
            return this.compare(s1, s2) > 0;
        }
        return this.compare(s1, s2) < 0;
    }

    private synchronized boolean compareG(Object s1, Object s2) {
        if (this.ascending) {
            return this.compare(s1, s2) < 0;
        }
        return this.compare(s1, s2) > 0;
    }

    private synchronized void quickSort(int lo0, int hi0, int key) {
        int lo = lo0;
        int hi = hi0;
        if (hi0 > lo0) {
            Object mid = this.getValueAt((lo0 + hi0) / 2, key);
            while (lo <= hi) {
                while (lo < hi0 && this.compareS(mid, this.getValueAt(lo, key))) {
                    ++lo;
                }
                while (hi > lo0 && this.compareG(mid, this.getValueAt(hi, key))) {
                    --hi;
                }
                if (lo > hi) continue;
                this.swap(lo, hi, key);
                ++lo;
                --hi;
            }
            if (lo0 < hi) {
                this.quickSort(lo0, hi, key);
            }
            if (lo <= hi0) {
                this.quickSort(lo, hi0, key);
            }
        }
    }

    public void n2sort(int column) {
        for (int i = 0; i < this.getRowCount(); ++i) {
            for (int j = i + 1; j < this.getRowCount(); ++j) {
                if (this.compare(this.getValueAt(i, column), this.getValueAt(j, column)) != -1) continue;
                this.swap(i, j, column);
            }
        }
    }

    private Vector getRow(int row) {
        return (Vector)this.dataVector.elementAt(row);
    }

    private void setRow(Vector data, int row) {
        this.dataVector.setElementAt(data, row);
    }

    public void swap(int i, int j, int column) {
        Vector data = this.getRow(i);
        this.setRow(this.getRow(j), i);
        this.setRow(data, j);
        int a = this.invertedIndex[i];
        this.invertedIndex[i] = this.invertedIndex[j];
        this.invertedIndex[j] = a;
    }

    public void sortByColumn(int column) {
        this.sortByColumn(column, !this.ascending);
    }

    public void sortByColumn(int column, boolean ascending) {
        this.ascending = ascending;
        this.sort(column);
    }

    public int[] getInvertedIndex() {
        return this.invertedIndex;
    }

    public void addMouseListenerToHeaderInTable(JTable table) {
        this.tableView = table;
        this.columnModel = this.tableView.getColumnModel();
        JTableHeader th = this.tableView.getTableHeader();
        th.addMouseListener(this);
    }

    public void mouseClicked(MouseEvent e) {
        int viewColumn = this.columnModel.getColumnIndexAtX(e.getX());
        int column = this.tableView.convertColumnIndexToModel(viewColumn);
        if (e.getClickCount() == 1 && column != -1) {
            this.tableView.invalidate();
            this.sortByColumn(column);
            this.tableView.validate();
            this.tableView.repaint();
        }
    }

    public void mousePressed(MouseEvent e) {
    }

    public void mouseEntered(MouseEvent e) {
    }

    public void mouseExited(MouseEvent e) {
    }

    public void mouseReleased(MouseEvent e) {
    }
}

