/*
 * Decompiled with CFR 0.152.
 */
package com.sun.java.swing.plaf.nimbus;

import com.sun.java.swing.plaf.nimbus.AbstractRegionPainter;
import com.sun.java.swing.plaf.nimbus.ImageScalingHelper;
import com.sun.java.swing.plaf.nimbus.InnerShadowEffect;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Insets;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import javax.swing.JComponent;
import javax.swing.border.Border;

public class LoweredBorder
extends AbstractRegionPainter
implements Border {
    private static final int IMG_SIZE = 30;
    private static final int RADIUS = 13;
    private static final Insets INSETS = new Insets(10, 10, 10, 10);
    private static final AbstractRegionPainter.PaintContext PAINT_CONTEXT = new AbstractRegionPainter.PaintContext(INSETS, new Dimension(30, 30), false, AbstractRegionPainter.PaintContext.CacheMode.NINE_SQUARE_SCALE, 2.147483647E9, 2.147483647E9);

    @Override
    protected Object[] getExtendedCacheKeys(JComponent c) {
        return new Object[]{c.getBackground()};
    }

    @Override
    protected void doPaint(Graphics2D g, JComponent c, int width, int height, Object[] extendedCacheKeys) {
        BufferedImage img1 = new BufferedImage(30, 30, 2);
        BufferedImage img2 = new BufferedImage(30, 30, 2);
        Graphics2D g2 = (Graphics2D)img1.getGraphics();
        g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g2.setColor(c.getBackground());
        g2.fillRoundRect(2, 0, 26, 26, 13, 13);
        g2.dispose();
        InnerShadowEffect effect = new InnerShadowEffect();
        effect.setDistance(1);
        effect.setSize(3);
        effect.setColor(this.getLighter(c.getBackground(), 2.1f));
        effect.setAngle(90);
        effect.applyEffect(img1, img2, 30, 30);
        g2 = (Graphics2D)img2.getGraphics();
        g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g2.setClip(0, 28, 30, 1);
        g2.setColor(this.getLighter(c.getBackground(), 0.9f));
        g2.drawRoundRect(2, 1, 25, 25, 13, 13);
        g2.dispose();
        if (width != 30 || height != 30) {
            ImageScalingHelper.paint(g, 0, 0, width, height, img2, INSETS, INSETS, ImageScalingHelper.PaintType.PAINT9_STRETCH, 512);
        } else {
            g.drawImage((Image)img2, 0, 0, c);
        }
        img1 = null;
        img2 = null;
    }

    @Override
    protected AbstractRegionPainter.PaintContext getPaintContext() {
        return PAINT_CONTEXT;
    }

    @Override
    public Insets getBorderInsets(Component c) {
        return INSETS;
    }

    @Override
    public boolean isBorderOpaque() {
        return false;
    }

    @Override
    public void paintBorder(Component c, Graphics g, int x, int y, int width, int height) {
        JComponent comp;
        JComponent jComponent = comp = c instanceof JComponent ? (JComponent)c : null;
        if (g instanceof Graphics2D) {
            Graphics2D g2 = (Graphics2D)g;
            g2.translate(x, y);
            this.paint(g2, comp, width, height);
            g2.translate(-x, -y);
        } else {
            BufferedImage img = new BufferedImage(30, 30, 2);
            Graphics2D g2 = (Graphics2D)img.getGraphics();
            this.paint(g2, comp, width, height);
            g2.dispose();
            ImageScalingHelper.paint(g, x, y, width, height, img, INSETS, INSETS, ImageScalingHelper.PaintType.PAINT9_STRETCH, 512);
        }
    }

    private Color getLighter(Color c, float factor) {
        return new Color(Math.min((int)((float)c.getRed() / factor), 255), Math.min((int)((float)c.getGreen() / factor), 255), Math.min((int)((float)c.getBlue() / factor), 255));
    }
}

