/*
 * Decompiled with CFR 0.152.
 */
package com.sun.java.swing.plaf.nimbus;

import com.sun.java.swing.Painter;
import com.sun.java.swing.plaf.nimbus.NimbusLookAndFeel;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import javax.swing.JComponent;
import javax.swing.JMenu;
import javax.swing.JToolBar;
import javax.swing.UIManager;
import javax.swing.plaf.UIResource;
import javax.swing.plaf.synth.SynthContext;
import sun.swing.plaf.synth.SynthIcon;

class NimbusIcon
extends SynthIcon {
    private int width;
    private int height;
    private String prefix;
    private String key;

    NimbusIcon(String prefix, String key, int w, int h) {
        this.width = w;
        this.height = h;
        this.prefix = prefix;
        this.key = key;
    }

    @Override
    public void paintIcon(SynthContext context, Graphics g, int x, int y, int w, int h) {
        Painter painter = null;
        if (context != null) {
            painter = (Painter)context.getStyle().get(context, this.key);
        }
        if (painter == null) {
            painter = (Painter)UIManager.get(this.prefix + "[Enabled]." + this.key);
        }
        if (painter != null && context != null) {
            JComponent c = context.getComponent();
            boolean rotate = false;
            boolean flip = false;
            int translatex = 0;
            int translatey = 0;
            if (c instanceof JToolBar) {
                JToolBar toolbar = (JToolBar)c;
                rotate = toolbar.getOrientation() == 1;
                flip = !toolbar.getComponentOrientation().isLeftToRight();
                Object o = NimbusLookAndFeel.resolveToolbarConstraint(toolbar);
                if (toolbar.getBorder() instanceof UIResource) {
                    if (o == "South") {
                        translatey = 1;
                    } else if (o == "East") {
                        translatex = 1;
                    }
                }
            } else if (c instanceof JMenu) {
                boolean bl = flip = !c.getComponentOrientation().isLeftToRight();
            }
            if (g instanceof Graphics2D) {
                Graphics2D gfx = (Graphics2D)g;
                gfx.translate(x, y);
                gfx.translate(translatex, translatey);
                if (rotate) {
                    gfx.rotate(Math.toRadians(90.0));
                    gfx.translate(0, -w);
                    painter.paint(gfx, context.getComponent(), h, w);
                    gfx.translate(0, w);
                    gfx.rotate(Math.toRadians(-90.0));
                } else if (flip) {
                    gfx.scale(-1.0, 1.0);
                    gfx.translate(-w, 0);
                    painter.paint(gfx, context.getComponent(), w, h);
                    gfx.translate(w, 0);
                    gfx.scale(-1.0, 1.0);
                } else {
                    painter.paint(gfx, context.getComponent(), w, h);
                }
                gfx.translate(-translatex, -translatey);
                gfx.translate(-x, -y);
            } else {
                BufferedImage img = new BufferedImage(w, h, 2);
                Graphics2D gfx = img.createGraphics();
                if (rotate) {
                    gfx.rotate(Math.toRadians(90.0));
                    gfx.translate(0, -w);
                    painter.paint(gfx, context.getComponent(), h, w);
                } else if (flip) {
                    gfx.scale(-1.0, 1.0);
                    gfx.translate(-w, 0);
                    painter.paint(gfx, context.getComponent(), w, h);
                } else {
                    painter.paint(gfx, context.getComponent(), w, h);
                }
                gfx.dispose();
                g.drawImage(img, x, y, null);
                img = null;
            }
        }
    }

    @Override
    public void paintIcon(Component c, Graphics g, int x, int y) {
        Painter painter = (Painter)UIManager.get(this.prefix + "[Enabled]." + this.key);
        if (painter != null) {
            JComponent jc = c instanceof JComponent ? (JComponent)c : null;
            Graphics2D gfx = (Graphics2D)g;
            gfx.translate(x, y);
            painter.paint(gfx, jc, this.width, this.height);
            gfx.translate(-x, -y);
        }
    }

    @Override
    public int getIconWidth(SynthContext context) {
        if (context == null) {
            return this.width;
        }
        JComponent c = context.getComponent();
        if (c instanceof JToolBar && ((JToolBar)c).getOrientation() == 1) {
            if (c.getBorder() instanceof UIResource) {
                return c.getWidth() - 1;
            }
            return c.getWidth();
        }
        return this.scale(context, this.width);
    }

    @Override
    public int getIconHeight(SynthContext context) {
        if (context == null) {
            return this.height;
        }
        JComponent c = context.getComponent();
        if (c instanceof JToolBar) {
            JToolBar toolbar = (JToolBar)c;
            if (toolbar.getOrientation() == 0) {
                if (toolbar.getBorder() instanceof UIResource) {
                    return c.getHeight() - 1;
                }
                return c.getHeight();
            }
            return this.scale(context, this.width);
        }
        return this.scale(context, this.height);
    }

    private int scale(SynthContext context, int size) {
        if (context == null || context.getComponent() == null) {
            return size;
        }
        String scaleKey = (String)context.getComponent().getClientProperty("JComponent.sizeVariant");
        if (scaleKey != null) {
            if ("large".equals(scaleKey)) {
                size = (int)((double)size * 1.15);
            } else if ("small".equals(scaleKey)) {
                size = (int)((double)size * 0.857);
            } else if ("mini".equals(scaleKey)) {
                size = (int)((double)size * 0.784);
            }
        }
        return size;
    }
}

