/*
 * Decompiled with CFR 0.152.
 */
package com.sun.java.swing.plaf.windows;

import com.sun.java.swing.plaf.windows.TMSchema;
import com.sun.java.swing.plaf.windows.XPStyle;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Rectangle;
import java.util.HashSet;
import java.util.Set;
import javax.swing.JComponent;
import javax.swing.KeyStroke;
import javax.swing.UIManager;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicTabbedPaneUI;

public class WindowsTabbedPaneUI
extends BasicTabbedPaneUI {
    private static Set managingFocusForwardTraversalKeys;
    private static Set managingFocusBackwardTraversalKeys;
    private boolean contentOpaque = true;

    @Override
    protected void installDefaults() {
        super.installDefaults();
        this.contentOpaque = UIManager.getBoolean("TabbedPane.contentOpaque");
        if (managingFocusForwardTraversalKeys == null) {
            managingFocusForwardTraversalKeys = new HashSet();
            managingFocusForwardTraversalKeys.add(KeyStroke.getKeyStroke(9, 0));
        }
        this.tabPane.setFocusTraversalKeys(0, managingFocusForwardTraversalKeys);
        if (managingFocusBackwardTraversalKeys == null) {
            managingFocusBackwardTraversalKeys = new HashSet();
            managingFocusBackwardTraversalKeys.add(KeyStroke.getKeyStroke(9, 1));
        }
        this.tabPane.setFocusTraversalKeys(1, managingFocusBackwardTraversalKeys);
    }

    @Override
    protected void uninstallDefaults() {
        this.tabPane.setFocusTraversalKeys(0, null);
        this.tabPane.setFocusTraversalKeys(1, null);
        super.uninstallDefaults();
    }

    public static ComponentUI createUI(JComponent c) {
        return new WindowsTabbedPaneUI();
    }

    @Override
    protected void setRolloverTab(int index) {
        if (XPStyle.getXP() != null) {
            int oldRolloverTab = this.getRolloverTab();
            super.setRolloverTab(index);
            Rectangle r1 = null;
            Rectangle r2 = null;
            if (oldRolloverTab >= 0 && oldRolloverTab < this.tabPane.getTabCount()) {
                r1 = this.getTabBounds(this.tabPane, oldRolloverTab);
            }
            if (index >= 0) {
                r2 = this.getTabBounds(this.tabPane, index);
            }
            if (r1 != null) {
                if (r2 != null) {
                    this.tabPane.repaint(r1.union(r2));
                } else {
                    this.tabPane.repaint(r1);
                }
            } else if (r2 != null) {
                this.tabPane.repaint(r2);
            }
        }
    }

    @Override
    protected void paintContentBorder(Graphics g, int tabPlacement, int selectedIndex) {
        XPStyle.Skin skin;
        XPStyle xp = XPStyle.getXP();
        if (xp != null && (this.contentOpaque || this.tabPane.isOpaque()) && (skin = xp.getSkin(this.tabPane, TMSchema.Part.TABP_PANE)) != null) {
            Insets insets = this.tabPane.getInsets();
            Insets tabAreaInsets = UIManager.getInsets("TabbedPane.tabAreaInsets");
            int x = insets.left;
            int y = insets.top;
            int w = this.tabPane.getWidth() - insets.right - insets.left;
            int h = this.tabPane.getHeight() - insets.top - insets.bottom;
            if (tabPlacement == 2 || tabPlacement == 4) {
                int tabWidth = this.calculateTabAreaWidth(tabPlacement, this.runCount, this.maxTabWidth);
                if (tabPlacement == 2) {
                    x += tabWidth - tabAreaInsets.bottom;
                }
                w -= tabWidth - tabAreaInsets.bottom;
            } else {
                int tabHeight = this.calculateTabAreaHeight(tabPlacement, this.runCount, this.maxTabHeight);
                if (tabPlacement == 1) {
                    y += tabHeight - tabAreaInsets.bottom;
                }
                h -= tabHeight - tabAreaInsets.bottom;
            }
            this.paintRotatedSkin(g, skin, tabPlacement, x, y, w, h, null);
            return;
        }
        super.paintContentBorder(g, tabPlacement, selectedIndex);
    }

    @Override
    protected void paintTabBackground(Graphics g, int tabPlacement, int tabIndex, int x, int y, int w, int h, boolean isSelected) {
        if (XPStyle.getXP() == null) {
            super.paintTabBackground(g, tabPlacement, tabIndex, x, y, w, h, isSelected);
        }
    }

    @Override
    protected void paintTabBorder(Graphics g, int tabPlacement, int tabIndex, int x, int y, int w, int h, boolean isSelected) {
        XPStyle xp = XPStyle.getXP();
        if (xp != null) {
            TMSchema.Part part;
            int tabCount = this.tabPane.getTabCount();
            int tabRun = this.getRunForTab(tabCount, tabIndex);
            if (this.tabRuns[tabRun] == tabIndex) {
                part = TMSchema.Part.TABP_TABITEMLEFTEDGE;
            } else if (tabCount > 1 && this.lastTabInRun(tabCount, tabRun) == tabIndex) {
                part = TMSchema.Part.TABP_TABITEMRIGHTEDGE;
                if (isSelected) {
                    if (tabPlacement == 1 || tabPlacement == 3) {
                        ++w;
                    } else {
                        ++h;
                    }
                }
            } else {
                part = TMSchema.Part.TABP_TABITEM;
            }
            TMSchema.State state = TMSchema.State.NORMAL;
            if (isSelected) {
                state = TMSchema.State.SELECTED;
            } else if (tabIndex == this.getRolloverTab()) {
                state = TMSchema.State.HOT;
            }
            this.paintRotatedSkin(g, xp.getSkin(this.tabPane, part), tabPlacement, x, y, w, h, state);
        } else {
            super.paintTabBorder(g, tabPlacement, tabIndex, x, y, w, h, isSelected);
        }
    }

    private void paintRotatedSkin(Graphics g, XPStyle.Skin skin, int tabPlacement, int x, int y, int w, int h, TMSchema.State state) {
        Graphics2D g2d = (Graphics2D)g.create();
        g2d.translate(x, y);
        switch (tabPlacement) {
            case 4: {
                g2d.translate(w, 0);
                g2d.rotate(Math.toRadians(90.0));
                skin.paintSkin(g2d, 0, 0, h, w, state);
                break;
            }
            case 2: {
                g2d.scale(-1.0, 1.0);
                g2d.rotate(Math.toRadians(90.0));
                skin.paintSkin(g2d, 0, 0, h, w, state);
                break;
            }
            case 3: {
                g2d.translate(0, h);
                g2d.scale(-1.0, 1.0);
                g2d.rotate(Math.toRadians(180.0));
                skin.paintSkin(g2d, 0, 0, w, h, state);
                break;
            }
            default: {
                skin.paintSkin(g2d, 0, 0, w, h, state);
            }
        }
        g2d.dispose();
    }
}

