/*
 * Decompiled with CFR 0.152.
 */
package java.util.concurrent;

import java.util.AbstractQueue;
import java.util.Collection;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.PriorityQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.Delayed;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.ReentrantLock;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DelayQueue<E extends Delayed>
extends AbstractQueue<E>
implements BlockingQueue<E> {
    private final transient ReentrantLock lock = new ReentrantLock();
    private final transient Condition available = this.lock.newCondition();
    private final PriorityQueue<E> q = new PriorityQueue();

    public DelayQueue() {
    }

    public DelayQueue(Collection<? extends E> c) {
        this.addAll(c);
    }

    @Override
    public boolean add(E e) {
        return this.offer(e);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean offer(E e) {
        ReentrantLock lock = this.lock;
        lock.lock();
        try {
            Delayed first = (Delayed)this.q.peek();
            this.q.offer(e);
            if (first == null || e.compareTo((Delayed)first) < 0) {
                this.available.signalAll();
            }
            boolean bl = true;
            Object var6_5 = null;
            lock.unlock();
            return bl;
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            lock.unlock();
            throw throwable;
        }
    }

    @Override
    public void put(E e) {
        this.offer(e);
    }

    @Override
    public boolean offer(E e, long timeout, TimeUnit unit) {
        return this.offer(e);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public E poll() {
        ReentrantLock lock;
        block5: {
            E e;
            lock = this.lock;
            lock.lock();
            try {
                Delayed first = (Delayed)this.q.peek();
                if (first != null && first.getDelay(TimeUnit.NANOSECONDS) <= 0L) break block5;
                e = null;
                Object var6_5 = null;
                lock.unlock();
            }
            catch (Throwable throwable) {
                Object var6_7 = null;
                lock.unlock();
                throw throwable;
            }
            return e;
        }
        Delayed x = (Delayed)this.q.poll();
        assert (x != null);
        if (this.q.size() != 0) {
            this.available.signalAll();
        }
        Delayed delayed = x;
        Object var6_6 = null;
        lock.unlock();
        return (E)delayed;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public E take() throws InterruptedException {
        ReentrantLock lock = this.lock;
        lock.lockInterruptibly();
        try {
            while (true) {
                Delayed first;
                if ((first = (Delayed)this.q.peek()) == null) {
                    this.available.await();
                    continue;
                }
                long delay = first.getDelay(TimeUnit.NANOSECONDS);
                if (delay <= 0L) break;
                long tl = this.available.awaitNanos(delay);
            }
            Delayed x = (Delayed)this.q.poll();
            assert (x != null);
            if (this.q.size() != 0) {
                this.available.signalAll();
            }
            Delayed delayed = x;
            Object var8_7 = null;
            lock.unlock();
            return (E)delayed;
        }
        catch (Throwable throwable) {
            Object var8_8 = null;
            lock.unlock();
            throw throwable;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public E poll(long timeout, TimeUnit unit) throws InterruptedException {
        Delayed delayed;
        ReentrantLock lock;
        block10: {
            E e;
            block9: {
                long nanos = unit.toNanos(timeout);
                lock = this.lock;
                lock.lockInterruptibly();
                try {
                    while (true) {
                        Delayed first;
                        if ((first = (Delayed)this.q.peek()) == null) {
                            if (nanos <= 0L) {
                                E e2 = null;
                                Object var13_11 = null;
                                lock.unlock();
                                return e2;
                            }
                            nanos = this.available.awaitNanos(nanos);
                            continue;
                        }
                        long delay = first.getDelay(TimeUnit.NANOSECONDS);
                        if (delay <= 0L) break;
                        if (nanos <= 0L) {
                            e = null;
                            break block9;
                        }
                        if (delay > nanos) {
                            delay = nanos;
                        }
                        long timeLeft = this.available.awaitNanos(delay);
                        nanos -= delay - timeLeft;
                    }
                    Delayed x = (Delayed)this.q.poll();
                    assert (x != null);
                    if (this.q.size() != 0) {
                        this.available.signalAll();
                    }
                    delayed = x;
                    break block10;
                }
                catch (Throwable throwable) {
                    Object var13_14 = null;
                    lock.unlock();
                    throw throwable;
                }
            }
            Object var13_12 = null;
            lock.unlock();
            return e;
        }
        Object var13_13 = null;
        lock.unlock();
        return (E)delayed;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public E peek() {
        Delayed delayed;
        ReentrantLock lock = this.lock;
        lock.lock();
        try {
            delayed = (Delayed)this.q.peek();
            Object var4_3 = null;
            lock.unlock();
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            lock.unlock();
            throw throwable;
        }
        return (E)delayed;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int size() {
        ReentrantLock lock = this.lock;
        lock.lock();
        try {
            int n = this.q.size();
            Object var4_3 = null;
            lock.unlock();
            return n;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            lock.unlock();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int drainTo(Collection<? super E> c) {
        if (c == null) {
            throw new NullPointerException();
        }
        if (c == this) {
            throw new IllegalArgumentException();
        }
        ReentrantLock lock = this.lock;
        lock.lock();
        try {
            Delayed first;
            int n = 0;
            while ((first = (Delayed)this.q.peek()) != null && first.getDelay(TimeUnit.NANOSECONDS) <= 0L) {
                c.add(this.q.poll());
                ++n;
            }
            if (n > 0) {
                this.available.signalAll();
            }
            int n2 = n;
            Object var6_6 = null;
            lock.unlock();
            return n2;
        }
        catch (Throwable throwable) {
            Object var6_7 = null;
            lock.unlock();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int drainTo(Collection<? super E> c, int maxElements) {
        if (c == null) {
            throw new NullPointerException();
        }
        if (c == this) {
            throw new IllegalArgumentException();
        }
        if (maxElements <= 0) {
            return 0;
        }
        ReentrantLock lock = this.lock;
        lock.lock();
        try {
            Delayed first;
            int n;
            for (n = 0; n < maxElements && (first = (Delayed)this.q.peek()) != null && first.getDelay(TimeUnit.NANOSECONDS) <= 0L; ++n) {
                c.add(this.q.poll());
            }
            if (n > 0) {
                this.available.signalAll();
            }
            int n2 = n;
            Object var7_7 = null;
            lock.unlock();
            return n2;
        }
        catch (Throwable throwable) {
            Object var7_8 = null;
            lock.unlock();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clear() {
        ReentrantLock lock = this.lock;
        lock.lock();
        try {
            this.q.clear();
            Object var3_2 = null;
            lock.unlock();
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            lock.unlock();
            throw throwable;
        }
    }

    @Override
    public int remainingCapacity() {
        return Integer.MAX_VALUE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object[] toArray() {
        ReentrantLock lock = this.lock;
        lock.lock();
        try {
            Object[] objectArray = this.q.toArray();
            Object var4_3 = null;
            lock.unlock();
            return objectArray;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            lock.unlock();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> T[] toArray(T[] a) {
        ReentrantLock lock = this.lock;
        lock.lock();
        try {
            T[] TArray = this.q.toArray(a);
            Object var5_4 = null;
            lock.unlock();
            return TArray;
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            lock.unlock();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean remove(Object o) {
        ReentrantLock lock = this.lock;
        lock.lock();
        try {
            boolean bl = this.q.remove(o);
            Object var5_4 = null;
            lock.unlock();
            return bl;
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            lock.unlock();
            throw throwable;
        }
    }

    @Override
    public Iterator<E> iterator() {
        return new Itr(this.toArray());
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class Itr
    implements Iterator<E> {
        final Object[] array;
        int cursor;
        int lastRet = -1;

        Itr(Object[] array) {
            this.array = array;
        }

        @Override
        public boolean hasNext() {
            return this.cursor < this.array.length;
        }

        @Override
        public E next() {
            if (this.cursor >= this.array.length) {
                throw new NoSuchElementException();
            }
            this.lastRet = this.cursor;
            return (Delayed)this.array[this.cursor++];
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void remove() {
            if (this.lastRet < 0) {
                throw new IllegalStateException();
            }
            Object x = this.array[this.lastRet];
            this.lastRet = -1;
            DelayQueue.this.lock.lock();
            try {
                Iterator it = DelayQueue.this.q.iterator();
                while (it.hasNext()) {
                    if (it.next() != x) continue;
                    it.remove();
                    Object var4_3 = null;
                    DelayQueue.this.lock.unlock();
                    return;
                }
                Object var4_4 = null;
                DelayQueue.this.lock.unlock();
            }
            catch (Throwable throwable) {
                Object var4_5 = null;
                DelayQueue.this.lock.unlock();
                throw throwable;
            }
        }
    }
}

