/*
 * Decompiled with CFR 0.152.
 */
package javax.swing;

import java.applet.Applet;
import java.awt.AWTException;
import java.awt.BufferCapabilities;
import java.awt.Component;
import java.awt.Container;
import java.awt.Graphics;
import java.awt.ImageCapabilities;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.awt.image.BufferStrategy;
import java.lang.ref.WeakReference;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JComponent;
import javax.swing.JRootPane;
import javax.swing.RepaintManager;
import javax.swing.RootPaneContainer;
import javax.swing.SwingUtilities;
import sun.awt.SubRegionShowable;
import sun.java2d.SunGraphics2D;
import sun.security.action.GetPropertyAction;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class BufferStrategyPaintManager
extends RepaintManager.PaintManager {
    private static Method COMPONENT_CREATE_BUFFER_STRATEGY_METHOD;
    private static Method COMPONENT_GET_BUFFER_STRATEGY_METHOD;
    private static boolean TRY_FLIP;
    private static final Logger LOGGER;
    private ArrayList<BufferInfo> bufferInfos = new ArrayList(1);
    private boolean painting;
    private boolean showing;
    private int accumulatedX;
    private int accumulatedY;
    private int accumulatedMaxX;
    private int accumulatedMaxY;
    private JComponent rootJ;
    private Container root;
    private int xOffset;
    private int yOffset;
    private Graphics bsg;
    private BufferStrategy bufferStrategy;
    private BufferInfo bufferInfo;
    private boolean disposeBufferOnEnd;

    private static Method getGetBufferStrategyMethod() {
        if (COMPONENT_GET_BUFFER_STRATEGY_METHOD == null) {
            BufferStrategyPaintManager.getMethods();
        }
        return COMPONENT_GET_BUFFER_STRATEGY_METHOD;
    }

    private static Method getCreateBufferStrategyMethod() {
        if (COMPONENT_CREATE_BUFFER_STRATEGY_METHOD == null) {
            BufferStrategyPaintManager.getMethods();
        }
        return COMPONENT_CREATE_BUFFER_STRATEGY_METHOD;
    }

    private static void getMethods() {
        AccessController.doPrivileged(new PrivilegedAction<Object>(){

            @Override
            public Object run() {
                block4: {
                    try {
                        COMPONENT_CREATE_BUFFER_STRATEGY_METHOD = Component.class.getDeclaredMethod("createBufferStrategy", Integer.TYPE, BufferCapabilities.class);
                        COMPONENT_CREATE_BUFFER_STRATEGY_METHOD.setAccessible(true);
                        COMPONENT_GET_BUFFER_STRATEGY_METHOD = Component.class.getDeclaredMethod("getBufferStrategy", new Class[0]);
                        COMPONENT_GET_BUFFER_STRATEGY_METHOD.setAccessible(true);
                    }
                    catch (SecurityException e) {
                        assert (false);
                    }
                    catch (NoSuchMethodException nsme) {
                        if ($assertionsDisabled) break block4;
                        throw new AssertionError();
                    }
                }
                return null;
            }
        });
    }

    BufferStrategyPaintManager() {
    }

    @Override
    protected void dispose() {
        SwingUtilities.invokeLater(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                ArrayList bufferInfos;
                BufferStrategyPaintManager bufferStrategyPaintManager = BufferStrategyPaintManager.this;
                synchronized (bufferStrategyPaintManager) {
                    while (BufferStrategyPaintManager.this.showing) {
                        try {
                            this.wait();
                        }
                        catch (InterruptedException interruptedException) {}
                    }
                    bufferInfos = BufferStrategyPaintManager.this.bufferInfos;
                    BufferStrategyPaintManager.this.bufferInfos = null;
                }
                BufferStrategyPaintManager.this.dispose(bufferInfos);
            }
        });
    }

    private void dispose(List<BufferInfo> bufferInfos) {
        if (LOGGER.isLoggable(Level.FINER)) {
            LOGGER.log(Level.FINER, "BufferStrategyPaintManager disposed", new RuntimeException());
        }
        if (bufferInfos != null) {
            for (BufferInfo bufferInfo : bufferInfos) {
                bufferInfo.dispose();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean show(Container c, int x, int y, int w, int h) {
        block14: {
            block15: {
                BufferStrategyPaintManager bufferStrategyPaintManager;
                boolean bl;
                BufferStrategyPaintManager bufferStrategyPaintManager2 = this;
                synchronized (bufferStrategyPaintManager2) {
                    if (this.painting) {
                        return false;
                    }
                    this.showing = true;
                }
                try {
                    BufferStrategy bufferStrategy;
                    BufferInfo info = this.getBufferInfo(c);
                    if (info == null || info.usingFlip || !info.isInSync() || (bufferStrategy = info.getBufferStrategy(false)) == null) break block14;
                    SubRegionShowable bsSubRegion = (SubRegionShowable)((Object)bufferStrategy);
                    boolean paintAllOnExpose = info.getPaintAllOnExpose();
                    info.setPaintAllOnExpose(false);
                    if (!bsSubRegion.showIfNotLost(x, y, x + w, y + h)) break block15;
                    bl = !paintAllOnExpose;
                    Object var12_12 = null;
                    bufferStrategyPaintManager = this;
                }
                catch (Throwable throwable) {
                    Object var12_14 = null;
                    BufferStrategyPaintManager bufferStrategyPaintManager3 = this;
                    synchronized (bufferStrategyPaintManager3) {
                        this.showing = false;
                        this.notifyAll();
                    }
                    throw throwable;
                }
                synchronized (bufferStrategyPaintManager) {
                    this.showing = false;
                    this.notifyAll();
                }
                return bl;
            }
            this.bufferInfo.setContentsLostDuringExpose(true);
        }
        Object var12_13 = null;
        BufferStrategyPaintManager bufferStrategyPaintManager = this;
        synchronized (bufferStrategyPaintManager) {
            this.showing = false;
            this.notifyAll();
        }
        return false;
    }

    @Override
    public boolean paint(JComponent paintingComponent, JComponent bufferComponent, Graphics g, int x, int y, int w, int h) {
        if (this.prepare(paintingComponent, true, x, y, w, h)) {
            if (g instanceof SunGraphics2D && ((SunGraphics2D)g).getDestination() == this.root) {
                int cx = ((SunGraphics2D)this.bsg).constrainX;
                int cy = ((SunGraphics2D)this.bsg).constrainY;
                if (cx != 0 || cy != 0) {
                    this.bsg.translate(-cx, -cy);
                }
                ((SunGraphics2D)this.bsg).constrain(this.xOffset + cx, this.yOffset + cy, x + w, y + h);
                this.bsg.setClip(x, y, w, h);
                paintingComponent.paintToOffscreen(this.bsg, x, y, w, h, x + w, y + h);
                this.accumulate(this.xOffset + x, this.yOffset + y, w, h);
                return true;
            }
            this.bufferInfo.setInSync(false);
        }
        if (LOGGER.isLoggable(Level.FINER)) {
            LOGGER.finer("prepare failed");
        }
        return super.paint(paintingComponent, bufferComponent, g, x, y, w, h);
    }

    @Override
    public void copyArea(JComponent c, Graphics g, int x, int y, int w, int h, int deltaX, int deltaY, boolean clip) {
        if (this.prepare(c, false, 0, 0, 0, 0) && this.bufferInfo.isInSync()) {
            if (clip) {
                Rectangle cBounds = c.getVisibleRect();
                int relX = this.xOffset + x;
                int relY = this.yOffset + y;
                this.bsg.clipRect(this.xOffset + cBounds.x, this.yOffset + cBounds.y, cBounds.width, cBounds.height);
                this.bsg.copyArea(relX, relY, w, h, deltaX, deltaY);
            } else {
                this.bsg.copyArea(this.xOffset + x, this.yOffset + y, w, h, deltaX, deltaY);
            }
            this.accumulate(x + this.xOffset + deltaX, y + this.yOffset + deltaY, w, h);
        } else {
            if (LOGGER.isLoggable(Level.FINER)) {
                LOGGER.finer("copyArea: prepare failed or not in sync");
            }
            if (!this.flushAccumulatedRegion()) {
                this.rootJ.repaint();
            } else {
                super.copyArea(c, g, x, y, w, h, deltaX, deltaY, clip);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void beginPaint() {
        BufferStrategyPaintManager bufferStrategyPaintManager = this;
        synchronized (bufferStrategyPaintManager) {
            this.painting = true;
            while (this.showing) {
                try {
                    this.wait();
                }
                catch (InterruptedException interruptedException) {}
            }
        }
        if (LOGGER.isLoggable(Level.FINEST)) {
            LOGGER.finest("beginPaint");
        }
        this.resetAccumulated();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void endPaint() {
        if (LOGGER.isLoggable(Level.FINEST)) {
            LOGGER.finest("endPaint: region " + this.accumulatedX + " " + this.accumulatedY + " " + this.accumulatedMaxX + " " + this.accumulatedMaxY);
        }
        if (this.painting && !this.flushAccumulatedRegion()) {
            if (!this.isRepaintingRoot()) {
                this.repaintRoot(this.rootJ);
            } else {
                this.resetDoubleBufferPerWindow();
                this.rootJ.repaint();
            }
        }
        BufferInfo toDispose = null;
        BufferStrategyPaintManager bufferStrategyPaintManager = this;
        synchronized (bufferStrategyPaintManager) {
            this.painting = false;
            if (this.disposeBufferOnEnd) {
                this.disposeBufferOnEnd = false;
                toDispose = this.bufferInfo;
                this.bufferInfos.remove(toDispose);
            }
        }
        if (toDispose != null) {
            toDispose.dispose();
        }
    }

    private boolean flushAccumulatedRegion() {
        boolean success = true;
        if (this.accumulatedX != Integer.MAX_VALUE) {
            SubRegionShowable bsSubRegion = (SubRegionShowable)((Object)this.bufferStrategy);
            boolean contentsLost = this.bufferStrategy.contentsLost();
            if (!contentsLost) {
                bsSubRegion.show(this.accumulatedX, this.accumulatedY, this.accumulatedMaxX, this.accumulatedMaxY);
                contentsLost = this.bufferStrategy.contentsLost();
            }
            if (contentsLost) {
                if (LOGGER.isLoggable(Level.FINER)) {
                    LOGGER.finer("endPaint: contents lost");
                }
                this.bufferInfo.setInSync(false);
                success = false;
            }
        }
        this.resetAccumulated();
        return success;
    }

    private void resetAccumulated() {
        this.accumulatedX = Integer.MAX_VALUE;
        this.accumulatedY = Integer.MAX_VALUE;
        this.accumulatedMaxX = 0;
        this.accumulatedMaxY = 0;
    }

    @Override
    public void doubleBufferingChanged(final JRootPane rootPane) {
        if (!(rootPane.isDoubleBuffered() && rootPane.getUseTrueDoubleBuffering() || rootPane.getParent() == null)) {
            if (!SwingUtilities.isEventDispatchThread()) {
                Runnable updater = new Runnable(){

                    public void run() {
                        BufferStrategyPaintManager.this.doubleBufferingChanged0(rootPane);
                    }
                };
                SwingUtilities.invokeLater(updater);
            } else {
                this.doubleBufferingChanged0(rootPane);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doubleBufferingChanged0(JRootPane rootPane) {
        BufferInfo info;
        BufferStrategyPaintManager bufferStrategyPaintManager = this;
        synchronized (bufferStrategyPaintManager) {
            while (this.showing) {
                try {
                    this.wait();
                }
                catch (InterruptedException ie) {}
            }
            info = this.getBufferInfo(rootPane.getParent());
            if (this.painting && this.bufferInfo == info) {
                this.disposeBufferOnEnd = true;
                info = null;
            } else if (info != null) {
                this.bufferInfos.remove(info);
            }
        }
        if (info != null) {
            info.dispose();
        }
    }

    private boolean prepare(JComponent c, boolean isPaint, int x, int y, int w, int h) {
        if (this.bsg != null) {
            this.bsg.dispose();
            this.bsg = null;
        }
        this.bufferStrategy = null;
        if (this.fetchRoot(c)) {
            boolean contentsLost = false;
            BufferInfo bufferInfo = this.getBufferInfo(this.root);
            if (bufferInfo == null) {
                contentsLost = true;
                bufferInfo = new BufferInfo(this.root);
                this.bufferInfos.add(bufferInfo);
                if (LOGGER.isLoggable(Level.FINER)) {
                    LOGGER.finer("prepare: new BufferInfo: " + this.root);
                }
            }
            this.bufferInfo = bufferInfo;
            if (!bufferInfo.hasBufferStrategyChanged()) {
                this.bufferStrategy = bufferInfo.getBufferStrategy(true);
                if (this.bufferStrategy != null) {
                    this.bsg = this.bufferStrategy.getDrawGraphics();
                    if (this.bufferStrategy.contentsRestored()) {
                        contentsLost = true;
                        if (LOGGER.isLoggable(Level.FINER)) {
                            LOGGER.finer("prepare: contents restored in prepare");
                        }
                    }
                } else {
                    return false;
                }
                if (bufferInfo.getContentsLostDuringExpose()) {
                    contentsLost = true;
                    bufferInfo.setContentsLostDuringExpose(false);
                    if (LOGGER.isLoggable(Level.FINER)) {
                        LOGGER.finer("prepare: contents lost on expose");
                    }
                }
                if (isPaint && c == this.rootJ && x == 0 && y == 0 && c.getWidth() == w && c.getHeight() == h) {
                    bufferInfo.setInSync(true);
                } else if (contentsLost) {
                    bufferInfo.setInSync(false);
                    if (!this.isRepaintingRoot()) {
                        this.repaintRoot(this.rootJ);
                    } else {
                        this.resetDoubleBufferPerWindow();
                    }
                }
                return this.bufferInfos != null;
            }
        }
        return false;
    }

    private boolean fetchRoot(JComponent c) {
        boolean encounteredHW = false;
        this.rootJ = c;
        this.root = c;
        this.yOffset = 0;
        this.xOffset = 0;
        while (this.root != null && !(this.root instanceof Window) && !(this.root instanceof Applet)) {
            this.xOffset += this.root.getX();
            this.yOffset += this.root.getY();
            this.root = this.root.getParent();
            if (this.root == null) continue;
            if (this.root instanceof JComponent) {
                this.rootJ = (JComponent)this.root;
                continue;
            }
            if (this.root.isLightweight()) continue;
            if (!encounteredHW) {
                encounteredHW = true;
                continue;
            }
            return false;
        }
        return this.root instanceof RootPaneContainer && this.rootJ instanceof JRootPane && this.rootJ.isDoubleBuffered() && ((JRootPane)this.rootJ).getUseTrueDoubleBuffering();
    }

    private void resetDoubleBufferPerWindow() {
        if (this.bufferInfos != null) {
            this.dispose(this.bufferInfos);
            this.bufferInfos = null;
            this.repaintManager.setPaintManager(null);
        }
    }

    private BufferInfo getBufferInfo(Container root) {
        for (int counter = this.bufferInfos.size() - 1; counter >= 0; --counter) {
            BufferInfo bufferInfo = this.bufferInfos.get(counter);
            Container biRoot = bufferInfo.getRoot();
            if (biRoot == null) {
                this.bufferInfos.remove(counter);
                if (!LOGGER.isLoggable(Level.FINER)) continue;
                LOGGER.finer("BufferInfo pruned, root null");
                continue;
            }
            if (biRoot != root) continue;
            return bufferInfo;
        }
        return null;
    }

    private void accumulate(int x, int y, int w, int h) {
        this.accumulatedX = Math.min(x, this.accumulatedX);
        this.accumulatedY = Math.min(y, this.accumulatedY);
        this.accumulatedMaxX = Math.max(this.accumulatedMaxX, x + w);
        this.accumulatedMaxY = Math.max(this.accumulatedMaxY, y + h);
    }

    static {
        LOGGER = Logger.getLogger("javax.swing.BufferStrategyPaintManager");
        TRY_FLIP = "true".equals(AccessController.doPrivileged(new GetPropertyAction("swing.useFlipBufferStrategy", "false")));
    }

    private class BufferInfo
    extends ComponentAdapter
    implements WindowListener {
        private WeakReference<BufferStrategy> weakBS;
        private WeakReference<Container> root;
        private boolean usingFlip;
        private boolean inSync;
        private boolean contentsLostDuringExpose;
        private boolean paintAllOnExpose;

        public BufferInfo(Container root) {
            this.root = new WeakReference<Container>(root);
            root.addComponentListener(this);
            if (root instanceof Window) {
                ((Window)root).addWindowListener(this);
            }
        }

        public void setPaintAllOnExpose(boolean paintAllOnExpose) {
            this.paintAllOnExpose = paintAllOnExpose;
        }

        public boolean getPaintAllOnExpose() {
            return this.paintAllOnExpose;
        }

        public void setContentsLostDuringExpose(boolean value) {
            this.contentsLostDuringExpose = value;
        }

        public boolean getContentsLostDuringExpose() {
            return this.contentsLostDuringExpose;
        }

        public void setInSync(boolean inSync) {
            this.inSync = inSync;
        }

        public boolean isInSync() {
            return this.inSync;
        }

        public Container getRoot() {
            return this.root == null ? null : (Container)this.root.get();
        }

        public BufferStrategy getBufferStrategy(boolean create) {
            BufferStrategy bs;
            BufferStrategy bufferStrategy = bs = this.weakBS == null ? null : (BufferStrategy)this.weakBS.get();
            if (bs == null && create) {
                bs = this.createBufferStrategy();
                if (bs != null) {
                    this.weakBS = new WeakReference<BufferStrategy>(bs);
                }
                if (LOGGER.isLoggable(Level.FINER)) {
                    LOGGER.finer("getBufferStrategy: created bs: " + bs);
                }
            }
            return bs;
        }

        public boolean usingFlip() {
            return this.usingFlip;
        }

        public boolean hasBufferStrategyChanged() {
            Container root = this.getRoot();
            if (root != null) {
                BufferStrategy componentBS;
                BufferStrategy ourBS;
                block11: {
                    ourBS = null;
                    componentBS = null;
                    ourBS = this.getBufferStrategy(false);
                    if (root instanceof Window) {
                        componentBS = ((Window)root).getBufferStrategy();
                    } else {
                        try {
                            componentBS = (BufferStrategy)BufferStrategyPaintManager.getGetBufferStrategyMethod().invoke(root, new Object[0]);
                        }
                        catch (InvocationTargetException ite) {
                            assert (false);
                        }
                        catch (IllegalArgumentException iae) {
                            assert (false);
                        }
                        catch (IllegalAccessException iae2) {
                            if ($assertionsDisabled) break block11;
                            throw new AssertionError();
                        }
                    }
                }
                if (componentBS != ourBS) {
                    if (ourBS != null) {
                        ourBS.dispose();
                    }
                    this.weakBS = null;
                    return true;
                }
            }
            return false;
        }

        private BufferStrategy createBufferStrategy() {
            Container root = this.getRoot();
            if (root == null) {
                return null;
            }
            BufferStrategy bs = null;
            if (TRY_FLIP) {
                bs = this.createBufferStrategy(root, BufferCapabilities.FlipContents.COPIED);
                this.usingFlip = true;
                if (LOGGER.isLoggable(Level.FINER)) {
                    LOGGER.finer("createBufferStrategy: using flip strategy");
                }
            }
            if (bs == null) {
                bs = this.createBufferStrategy(root, null);
                this.usingFlip = false;
            }
            if (!(bs instanceof SubRegionShowable)) {
                bs = null;
            }
            return bs;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private BufferStrategy createBufferStrategy(Container root, BufferCapabilities.FlipContents type) {
            BufferCapabilities caps = new BufferCapabilities(new ImageCapabilities(true), new ImageCapabilities(true), type);
            BufferStrategy bs = null;
            if (root instanceof Applet) {
                try {
                    BufferStrategyPaintManager.getCreateBufferStrategyMethod().invoke(root, 2, caps);
                    return (BufferStrategy)BufferStrategyPaintManager.getGetBufferStrategyMethod().invoke(root, new Object[0]);
                }
                catch (InvocationTargetException ite) {
                    if (!LOGGER.isLoggable(Level.FINER)) return bs;
                    LOGGER.log(Level.FINER, "createBufferStratety failed", ite);
                    return bs;
                }
                catch (IllegalArgumentException iae) {
                    assert (false);
                    return bs;
                }
                catch (IllegalAccessException iae2) {
                    assert (false);
                    return bs;
                }
            } else {
                try {
                    ((Window)root).createBufferStrategy(2, caps);
                    return ((Window)root).getBufferStrategy();
                }
                catch (AWTException e) {
                    if (!LOGGER.isLoggable(Level.FINER)) return bs;
                    LOGGER.log(Level.FINER, "createBufferStratety failed", e);
                }
            }
            return bs;
        }

        public void dispose() {
            Container root = this.getRoot();
            if (LOGGER.isLoggable(Level.FINER)) {
                LOGGER.log(Level.FINER, "disposed BufferInfo for: " + root);
            }
            if (root != null) {
                BufferStrategy bs;
                root.removeComponentListener(this);
                if (root instanceof Window) {
                    ((Window)root).removeWindowListener(this);
                }
                if ((bs = this.getBufferStrategy(false)) != null) {
                    bs.dispose();
                }
            }
            this.root = null;
            this.weakBS = null;
        }

        public void componentHidden(ComponentEvent e) {
            Container root = this.getRoot();
            if (root != null && root.isVisible()) {
                root.repaint();
            } else {
                this.setPaintAllOnExpose(true);
            }
        }

        public void windowIconified(WindowEvent e) {
            this.setPaintAllOnExpose(true);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void windowClosed(WindowEvent e) {
            BufferStrategyPaintManager bufferStrategyPaintManager = BufferStrategyPaintManager.this;
            synchronized (bufferStrategyPaintManager) {
                while (BufferStrategyPaintManager.this.showing) {
                    try {
                        BufferStrategyPaintManager.this.wait();
                    }
                    catch (InterruptedException interruptedException) {}
                }
                BufferStrategyPaintManager.this.bufferInfos.remove(this);
            }
            this.dispose();
        }

        public void windowOpened(WindowEvent e) {
        }

        public void windowClosing(WindowEvent e) {
        }

        public void windowDeiconified(WindowEvent e) {
        }

        public void windowActivated(WindowEvent e) {
        }

        public void windowDeactivated(WindowEvent e) {
        }
    }
}

