/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.plaf.metal;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Insets;
import javax.swing.JTextField;
import javax.swing.border.AbstractBorder;
import javax.swing.plaf.basic.BasicComboBoxEditor;
import javax.swing.plaf.metal.MetalLookAndFeel;

public class MetalComboBoxEditor
extends BasicComboBoxEditor {
    protected static Insets editorBorderInsets = new Insets(2, 2, 2, 0);
    private static final Insets SAFE_EDITOR_BORDER_INSETS = new Insets(2, 2, 2, 0);

    public MetalComboBoxEditor() {
        this.editor = new JTextField("", 9){

            @Override
            public void setText(String s) {
                if (this.getText().equals(s)) {
                    return;
                }
                super.setText(s);
            }

            @Override
            public Dimension getPreferredSize() {
                Dimension pref = super.getPreferredSize();
                pref.height += 4;
                return pref;
            }

            @Override
            public Dimension getMinimumSize() {
                Dimension min = super.getMinimumSize();
                min.height += 4;
                return min;
            }
        };
        this.editor.setBorder(new EditorBorder());
    }

    public static class UIResource
    extends MetalComboBoxEditor
    implements javax.swing.plaf.UIResource {
    }

    class EditorBorder
    extends AbstractBorder {
        EditorBorder() {
        }

        @Override
        public void paintBorder(Component c, Graphics g, int x, int y, int w, int h) {
            g.translate(x, y);
            if (MetalLookAndFeel.usingOcean()) {
                g.setColor(MetalLookAndFeel.getControlDarkShadow());
                g.drawRect(0, 0, w, h - 1);
                g.setColor(MetalLookAndFeel.getControlShadow());
                g.drawRect(1, 1, w - 2, h - 3);
            } else {
                g.setColor(MetalLookAndFeel.getControlDarkShadow());
                g.drawLine(0, 0, w - 1, 0);
                g.drawLine(0, 0, 0, h - 2);
                g.drawLine(0, h - 2, w - 1, h - 2);
                g.setColor(MetalLookAndFeel.getControlHighlight());
                g.drawLine(1, 1, w - 1, 1);
                g.drawLine(1, 1, 1, h - 1);
                g.drawLine(1, h - 1, w - 1, h - 1);
                g.setColor(MetalLookAndFeel.getControl());
                g.drawLine(1, h - 2, 1, h - 2);
            }
            g.translate(-x, -y);
        }

        @Override
        public Insets getBorderInsets(Component c) {
            if (System.getSecurityManager() != null) {
                return SAFE_EDITOR_BORDER_INSETS;
            }
            return editorBorderInsets;
        }
    }
}

