/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.text.html;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Shape;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import javax.swing.JEditorPane;
import javax.swing.JScrollPane;
import javax.swing.JViewport;
import javax.swing.event.DocumentEvent;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import javax.swing.text.AttributeSet;
import javax.swing.text.ComponentView;
import javax.swing.text.Document;
import javax.swing.text.EditorKit;
import javax.swing.text.Element;
import javax.swing.text.JTextComponent;
import javax.swing.text.View;
import javax.swing.text.ViewFactory;
import javax.swing.text.html.FormSubmitEvent;
import javax.swing.text.html.FrameSetView;
import javax.swing.text.html.HTML;
import javax.swing.text.html.HTMLDocument;
import javax.swing.text.html.HTMLEditorKit;
import javax.swing.text.html.HTMLFrameHyperlinkEvent;
import sun.swing.text.html.FrameEditorPaneTag;

class FrameView
extends ComponentView
implements HyperlinkListener {
    JEditorPane htmlPane;
    JScrollPane scroller;
    boolean editable;
    float width;
    float height;
    URL src;
    private boolean createdComponent;

    public FrameView(Element elem) {
        super(elem);
    }

    protected Component createComponent() {
        Element elem = this.getElement();
        AttributeSet attributes = elem.getAttributes();
        String srcAtt = (String)attributes.getAttribute(HTML.Attribute.SRC);
        if (srcAtt != null && !srcAtt.equals("")) {
            try {
                Document doc;
                URL base = ((HTMLDocument)elem.getDocument()).getBase();
                this.src = new URL(base, srcAtt);
                this.htmlPane = new FrameEditorPane();
                this.htmlPane.addHyperlinkListener(this);
                JEditorPane host = this.getHostPane();
                boolean isAutoFormSubmission = true;
                if (host != null) {
                    HTMLEditorKit hostKit;
                    this.htmlPane.setEditable(host.isEditable());
                    String charset = (String)host.getClientProperty("charset");
                    if (charset != null) {
                        this.htmlPane.putClientProperty("charset", charset);
                    }
                    if ((hostKit = (HTMLEditorKit)host.getEditorKit()) != null) {
                        isAutoFormSubmission = hostKit.isAutoFormSubmission();
                    }
                }
                this.htmlPane.setPage(this.src);
                HTMLEditorKit kit = (HTMLEditorKit)this.htmlPane.getEditorKit();
                if (kit != null) {
                    kit.setAutoFormSubmission(isAutoFormSubmission);
                }
                if ((doc = this.htmlPane.getDocument()) instanceof HTMLDocument) {
                    ((HTMLDocument)doc).setFrameDocumentState(true);
                }
                this.setMargin();
                this.createScrollPane();
                this.setBorder();
            }
            catch (MalformedURLException e) {
                e.printStackTrace();
            }
            catch (IOException e1) {
                e1.printStackTrace();
            }
        }
        this.createdComponent = true;
        return this.scroller;
    }

    JEditorPane getHostPane() {
        Container c;
        for (c = this.getContainer(); c != null && !(c instanceof JEditorPane); c = c.getParent()) {
        }
        return (JEditorPane)c;
    }

    public void setParent(View parent) {
        if (parent != null) {
            JTextComponent t = (JTextComponent)parent.getContainer();
            this.editable = t.isEditable();
        }
        super.setParent(parent);
    }

    public void paint(Graphics g, Shape allocation) {
        Container host = this.getContainer();
        if (host != null && this.htmlPane != null && this.htmlPane.isEditable() != ((JTextComponent)host).isEditable()) {
            this.editable = ((JTextComponent)host).isEditable();
            this.htmlPane.setEditable(this.editable);
        }
        super.paint(g, allocation);
    }

    private void setMargin() {
        int margin = 0;
        Insets in = this.htmlPane.getMargin();
        boolean modified = false;
        AttributeSet attributes = this.getElement().getAttributes();
        String marginStr = (String)attributes.getAttribute(HTML.Attribute.MARGINWIDTH);
        Insets newInsets = in != null ? new Insets(in.top, in.left, in.right, in.bottom) : new Insets(0, 0, 0, 0);
        if (marginStr != null && (margin = Integer.parseInt(marginStr)) > 0) {
            newInsets.left = margin;
            newInsets.right = margin;
            modified = true;
        }
        if ((marginStr = (String)attributes.getAttribute(HTML.Attribute.MARGINHEIGHT)) != null && (margin = Integer.parseInt(marginStr)) > 0) {
            newInsets.top = margin;
            newInsets.bottom = margin;
            modified = true;
        }
        if (modified) {
            this.htmlPane.setMargin(newInsets);
        }
    }

    private void setBorder() {
        AttributeSet attributes = this.getElement().getAttributes();
        String frameBorder = (String)attributes.getAttribute(HTML.Attribute.FRAMEBORDER);
        if (frameBorder != null && (frameBorder.equals("no") || frameBorder.equals("0"))) {
            this.scroller.setBorder(null);
        }
    }

    private void createScrollPane() {
        AttributeSet attributes = this.getElement().getAttributes();
        String scrolling = (String)attributes.getAttribute(HTML.Attribute.SCROLLING);
        if (scrolling == null) {
            scrolling = "auto";
        }
        this.scroller = !scrolling.equals("no") ? (scrolling.equals("yes") ? new JScrollPane(22, 32) : new JScrollPane()) : new JScrollPane(21, 31);
        JViewport vp = this.scroller.getViewport();
        vp.add(this.htmlPane);
        vp.setBackingStoreEnabled(true);
        this.scroller.setMinimumSize(new Dimension(5, 5));
        this.scroller.setMaximumSize(new Dimension(Integer.MAX_VALUE, Integer.MAX_VALUE));
    }

    JEditorPane getOutermostJEditorPane() {
        View frameSetView = null;
        for (View parent = this.getParent(); parent != null; parent = parent.getParent()) {
            if (!(parent instanceof FrameSetView)) continue;
            frameSetView = (FrameSetView)parent;
        }
        if (frameSetView != null) {
            return (JEditorPane)frameSetView.getContainer();
        }
        return null;
    }

    private boolean inNestedFrameSet() {
        FrameSetView parent = (FrameSetView)this.getParent();
        return parent.getParent() instanceof FrameSetView;
    }

    public void hyperlinkUpdate(HyperlinkEvent evt) {
        JEditorPane c = this.getOutermostJEditorPane();
        if (c == null) {
            return;
        }
        if (!(evt instanceof HTMLFrameHyperlinkEvent)) {
            c.fireHyperlinkUpdate(evt);
            return;
        }
        HTMLFrameHyperlinkEvent e = (HTMLFrameHyperlinkEvent)evt;
        if (e.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
            String target;
            String postTarget = target = e.getTarget();
            if (target.equals("_parent") && !this.inNestedFrameSet()) {
                target = "_top";
            }
            if (evt instanceof FormSubmitEvent) {
                HTMLEditorKit kit = (HTMLEditorKit)c.getEditorKit();
                if (kit != null && kit.isAutoFormSubmission()) {
                    if (target.equals("_top")) {
                        try {
                            this.movePostData(c, postTarget);
                            c.setPage(e.getURL());
                        }
                        catch (IOException ex) {}
                    } else {
                        HTMLDocument doc = (HTMLDocument)c.getDocument();
                        doc.processHTMLFrameHyperlinkEvent(e);
                    }
                } else {
                    c.fireHyperlinkUpdate(evt);
                }
                return;
            }
            if (target.equals("_top")) {
                try {
                    c.setPage(e.getURL());
                }
                catch (IOException ex) {
                    // empty catch block
                }
            }
            if (!c.isEditable()) {
                c.fireHyperlinkUpdate(new HTMLFrameHyperlinkEvent(c, e.getEventType(), e.getURL(), e.getDescription(), this.getElement(), target));
            }
        }
    }

    public void changedUpdate(DocumentEvent e, Shape a, ViewFactory f) {
        Element elem = this.getElement();
        AttributeSet attributes = elem.getAttributes();
        URL oldPage = this.src;
        String srcAtt = (String)attributes.getAttribute(HTML.Attribute.SRC);
        URL base = ((HTMLDocument)elem.getDocument()).getBase();
        try {
            if (!this.createdComponent) {
                return;
            }
            Object postData = this.movePostData(this.htmlPane, null);
            this.src = new URL(base, srcAtt);
            if (oldPage.equals(this.src) && this.src.getRef() == null && postData == null) {
                return;
            }
            this.htmlPane.setPage(this.src);
            Document newDoc = this.htmlPane.getDocument();
            if (newDoc instanceof HTMLDocument) {
                ((HTMLDocument)newDoc).setFrameDocumentState(true);
            }
        }
        catch (MalformedURLException e1) {
        }
        catch (IOException e2) {
            // empty catch block
        }
    }

    private Object movePostData(JEditorPane targetPane, String frameName) {
        Object postData = null;
        JEditorPane p = this.getOutermostJEditorPane();
        if (p != null) {
            if (frameName == null) {
                frameName = (String)this.getElement().getAttributes().getAttribute(HTML.Attribute.NAME);
            }
            if (frameName != null) {
                String propName = "javax.swing.JEditorPane.postdata." + frameName;
                Document d = p.getDocument();
                postData = d.getProperty(propName);
                if (postData != null) {
                    targetPane.getDocument().putProperty("javax.swing.JEditorPane.postdata", postData);
                    d.putProperty(propName, null);
                }
            }
        }
        return postData;
    }

    public float getMinimumSpan(int axis) {
        return 5.0f;
    }

    public float getMaximumSpan(int axis) {
        return 2.1474836E9f;
    }

    class FrameEditorPane
    extends JEditorPane
    implements FrameEditorPaneTag {
        FrameEditorPane() {
        }

        public EditorKit getEditorKitForContentType(String type) {
            EditorKit editorKit = super.getEditorKitForContentType(type);
            JEditorPane outerMostJEditorPane = null;
            outerMostJEditorPane = FrameView.this.getOutermostJEditorPane();
            if (outerMostJEditorPane != null) {
                EditorKit inheritedEditorKit = outerMostJEditorPane.getEditorKitForContentType(type);
                if (!editorKit.getClass().equals(inheritedEditorKit.getClass())) {
                    editorKit = (EditorKit)inheritedEditorKit.clone();
                    this.setEditorKitForContentType(type, editorKit);
                }
            }
            return editorKit;
        }

        FrameView getFrameView() {
            return FrameView.this;
        }
    }
}

