/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.undo;

import java.util.Enumeration;
import java.util.Vector;
import javax.swing.UIManager;
import javax.swing.event.UndoableEditEvent;
import javax.swing.event.UndoableEditListener;
import javax.swing.undo.CannotRedoException;
import javax.swing.undo.CannotUndoException;
import javax.swing.undo.CompoundEdit;
import javax.swing.undo.UndoableEdit;

public class UndoManager
extends CompoundEdit
implements UndoableEditListener {
    int indexOfNextAdd = 0;
    int limit = 100;

    public UndoManager() {
        this.edits.ensureCapacity(this.limit);
    }

    public synchronized int getLimit() {
        return this.limit;
    }

    public synchronized void discardAllEdits() {
        Enumeration cursor = this.edits.elements();
        while (cursor.hasMoreElements()) {
            UndoableEdit e = (UndoableEdit)cursor.nextElement();
            e.die();
        }
        this.edits = new Vector();
        this.indexOfNextAdd = 0;
    }

    protected void trimForLimit() {
        int size;
        if (this.limit >= 0 && (size = this.edits.size()) > this.limit) {
            int halfLimit = this.limit / 2;
            int keepTo = this.indexOfNextAdd - 1 + halfLimit;
            int keepFrom = this.indexOfNextAdd - 1 - halfLimit;
            if (keepTo - keepFrom + 1 > this.limit) {
                ++keepFrom;
            }
            if (keepFrom < 0) {
                keepTo -= keepFrom;
                keepFrom = 0;
            }
            if (keepTo >= size) {
                int delta = size - keepTo - 1;
                keepTo += delta;
                keepFrom += delta;
            }
            this.trimEdits(keepTo + 1, size - 1);
            this.trimEdits(0, keepFrom - 1);
        }
    }

    protected void trimEdits(int from, int to) {
        if (from <= to) {
            for (int i = to; from <= i; --i) {
                UndoableEdit e = (UndoableEdit)this.edits.elementAt(i);
                e.die();
                this.edits.removeElementAt(i);
            }
            if (this.indexOfNextAdd > to) {
                this.indexOfNextAdd -= to - from + 1;
            } else if (this.indexOfNextAdd >= from) {
                this.indexOfNextAdd = from;
            }
        }
    }

    public synchronized void setLimit(int l) {
        if (!this.inProgress) {
            throw new RuntimeException("Attempt to call UndoManager.setLimit() after UndoManager.end() has been called");
        }
        this.limit = l;
        this.trimForLimit();
    }

    protected UndoableEdit editToBeUndone() {
        int i = this.indexOfNextAdd;
        while (i > 0) {
            UndoableEdit edit;
            if (!(edit = (UndoableEdit)this.edits.elementAt(--i)).isSignificant()) continue;
            return edit;
        }
        return null;
    }

    protected UndoableEdit editToBeRedone() {
        int count = this.edits.size();
        int i = this.indexOfNextAdd;
        while (i < count) {
            UndoableEdit edit;
            if (!(edit = (UndoableEdit)this.edits.elementAt(i++)).isSignificant()) continue;
            return edit;
        }
        return null;
    }

    protected void undoTo(UndoableEdit edit) throws CannotUndoException {
        boolean done = false;
        while (!done) {
            UndoableEdit next = (UndoableEdit)this.edits.elementAt(--this.indexOfNextAdd);
            next.undo();
            done = next == edit;
        }
    }

    protected void redoTo(UndoableEdit edit) throws CannotRedoException {
        boolean done = false;
        while (!done) {
            UndoableEdit next = (UndoableEdit)this.edits.elementAt(this.indexOfNextAdd++);
            next.redo();
            done = next == edit;
        }
    }

    public synchronized void undoOrRedo() throws CannotRedoException, CannotUndoException {
        if (this.indexOfNextAdd == this.edits.size()) {
            this.undo();
        } else {
            this.redo();
        }
    }

    public synchronized boolean canUndoOrRedo() {
        if (this.indexOfNextAdd == this.edits.size()) {
            return this.canUndo();
        }
        return this.canRedo();
    }

    @Override
    public synchronized void undo() throws CannotUndoException {
        if (this.inProgress) {
            UndoableEdit edit = this.editToBeUndone();
            if (edit == null) {
                throw new CannotUndoException();
            }
            this.undoTo(edit);
        } else {
            super.undo();
        }
    }

    @Override
    public synchronized boolean canUndo() {
        if (this.inProgress) {
            UndoableEdit edit = this.editToBeUndone();
            return edit != null && edit.canUndo();
        }
        return super.canUndo();
    }

    @Override
    public synchronized void redo() throws CannotRedoException {
        if (this.inProgress) {
            UndoableEdit edit = this.editToBeRedone();
            if (edit == null) {
                throw new CannotRedoException();
            }
            this.redoTo(edit);
        } else {
            super.redo();
        }
    }

    @Override
    public synchronized boolean canRedo() {
        if (this.inProgress) {
            UndoableEdit edit = this.editToBeRedone();
            return edit != null && edit.canRedo();
        }
        return super.canRedo();
    }

    @Override
    public synchronized boolean addEdit(UndoableEdit anEdit) {
        this.trimEdits(this.indexOfNextAdd, this.edits.size() - 1);
        boolean retVal = super.addEdit(anEdit);
        if (this.inProgress) {
            retVal = true;
        }
        this.indexOfNextAdd = this.edits.size();
        this.trimForLimit();
        return retVal;
    }

    @Override
    public synchronized void end() {
        super.end();
        this.trimEdits(this.indexOfNextAdd, this.edits.size() - 1);
    }

    public synchronized String getUndoOrRedoPresentationName() {
        if (this.indexOfNextAdd == this.edits.size()) {
            return this.getUndoPresentationName();
        }
        return this.getRedoPresentationName();
    }

    @Override
    public synchronized String getUndoPresentationName() {
        if (this.inProgress) {
            if (this.canUndo()) {
                return this.editToBeUndone().getUndoPresentationName();
            }
            return UIManager.getString("AbstractUndoableEdit.undoText");
        }
        return super.getUndoPresentationName();
    }

    @Override
    public synchronized String getRedoPresentationName() {
        if (this.inProgress) {
            if (this.canRedo()) {
                return this.editToBeRedone().getRedoPresentationName();
            }
            return UIManager.getString("AbstractUndoableEdit.redoText");
        }
        return super.getRedoPresentationName();
    }

    @Override
    public void undoableEditHappened(UndoableEditEvent e) {
        this.addEdit(e.getEdit());
    }

    @Override
    public String toString() {
        return super.toString() + " limit: " + this.limit + " indexOfNextAdd: " + this.indexOfNextAdd;
    }
}

