/*
 * Decompiled with CFR 0.152.
 */
package sun.awt.X11;

import java.nio.ByteOrder;
import java.util.Arrays;
import sun.awt.X11.Native;
import sun.awt.X11.WindowPropertyGetter;
import sun.awt.X11.XAtom;
import sun.awt.X11.XErrorHandler;
import sun.awt.X11.XException;
import sun.awt.X11.XSelection;
import sun.awt.X11.XSetWindowAttributes;
import sun.awt.X11.XToolkit;
import sun.awt.X11.XlibWrapper;
import sun.misc.Unsafe;

class MotifDnDConstants {
    private static final Unsafe unsafe = XlibWrapper.unsafe;
    static final XAtom XA_MOTIF_ATOM_0 = XAtom.get("_MOTIF_ATOM_0");
    static final XAtom XA_MOTIF_DRAG_WINDOW = XAtom.get("_MOTIF_DRAG_WINDOW");
    static final XAtom XA_MOTIF_DRAG_TARGETS = XAtom.get("_MOTIF_DRAG_TARGETS");
    static final XAtom XA_MOTIF_DRAG_INITIATOR_INFO = XAtom.get("_MOTIF_DRAG_INITIATOR_INFO");
    static final XAtom XA_MOTIF_DRAG_RECEIVER_INFO = XAtom.get("_MOTIF_DRAG_RECEIVER_INFO");
    static final XAtom XA_MOTIF_DRAG_AND_DROP_MESSAGE = XAtom.get("_MOTIF_DRAG_AND_DROP_MESSAGE");
    static final XAtom XA_XmTRANSFER_SUCCESS = XAtom.get("XmTRANSFER_SUCCESS");
    static final XAtom XA_XmTRANSFER_FAILURE = XAtom.get("XmTRANSFER_FAILURE");
    static final XSelection MotifDnDSelection = new XSelection(XA_MOTIF_ATOM_0, null);
    public static final byte MOTIF_DND_PROTOCOL_VERSION = 0;
    public static final int MOTIF_PREFER_PREREGISTER_STYLE = 2;
    public static final int MOTIF_PREFER_DYNAMIC_STYLE = 4;
    public static final int MOTIF_DYNAMIC_STYLE = 5;
    public static final int MOTIF_PREFER_RECEIVER_STYLE = 6;
    public static final int MOTIF_INITIATOR_INFO_SIZE = 8;
    public static final int MOTIF_RECEIVER_INFO_SIZE = 16;
    public static final byte MOTIF_MESSAGE_REASON_MASK = 127;
    public static final byte MOTIF_MESSAGE_SENDER_MASK = -128;
    public static final byte MOTIF_MESSAGE_FROM_RECEIVER = -128;
    public static final byte MOTIF_MESSAGE_FROM_INITIATOR = 0;
    public static final int MOTIF_DND_ACTION_MASK = 15;
    public static final int MOTIF_DND_ACTION_SHIFT = 0;
    public static final int MOTIF_DND_STATUS_MASK = 240;
    public static final int MOTIF_DND_STATUS_SHIFT = 4;
    public static final int MOTIF_DND_ACTIONS_MASK = 3840;
    public static final int MOTIF_DND_ACTIONS_SHIFT = 8;
    public static final byte TOP_LEVEL_ENTER = 0;
    public static final byte TOP_LEVEL_LEAVE = 1;
    public static final byte DRAG_MOTION = 2;
    public static final byte DROP_SITE_ENTER = 3;
    public static final byte DROP_SITE_LEAVE = 4;
    public static final byte DROP_START = 5;
    public static final byte DROP_FINISH = 6;
    public static final byte DRAG_DROP_FINISH = 7;
    public static final byte OPERATION_CHANGED = 8;
    public static final int MOTIF_DND_NOOP = 0;
    public static final int MOTIF_DND_MOVE = 1;
    public static final int MOTIF_DND_COPY = 2;
    public static final int MOTIF_DND_LINK = 4;
    public static final byte MOTIF_NO_DROP_SITE = 1;
    public static final byte MOTIF_INVALID_DROP_SITE = 2;
    public static final byte MOTIF_VALID_DROP_SITE = 3;

    MotifDnDConstants() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static long readMotifWindow() throws XException {
        long defaultScreenNumber = XlibWrapper.DefaultScreen(XToolkit.getDisplay());
        long defaultRootWindow = XlibWrapper.RootWindow(XToolkit.getDisplay(), defaultScreenNumber);
        long motifWindow = 0L;
        WindowPropertyGetter wpg = new WindowPropertyGetter(defaultRootWindow, XA_MOTIF_DRAG_WINDOW, 0L, 1L, false, 0L);
        try {
            int status = wpg.execute(XErrorHandler.IgnoreBadWindowHandler.getInstance());
            if (status == 0 && wpg.getData() != 0L && wpg.getActualType() == 33L && wpg.getActualFormat() == 32 && wpg.getNumberOfItems() == 1) {
                long data = wpg.getData();
                motifWindow = Native.getLong(data);
            }
            long l = motifWindow;
            Object var11_6 = null;
            wpg.dispose();
            return l;
        }
        catch (Throwable throwable) {
            Object var11_7 = null;
            wpg.dispose();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled aggressive exception aggregation
     */
    private static long createMotifWindow() throws XException {
        long l;
        long data;
        XSetWindowAttributes xwa;
        assert (XToolkit.isAWTLockHeldByCurrentThread());
        long defaultScreenNumber = XlibWrapper.DefaultScreen(XToolkit.getDisplay());
        long defaultRootWindow = XlibWrapper.RootWindow(XToolkit.getDisplay(), defaultScreenNumber);
        long motifWindow = 0L;
        long displayString = XlibWrapper.XDisplayString(XToolkit.getDisplay());
        if (displayString == 0L) {
            throw new XException("XDisplayString returns NULL");
        }
        long newDisplay = XlibWrapper.XOpenDisplay(displayString);
        if (newDisplay == 0L) {
            throw new XException("XOpenDisplay returns NULL");
        }
        XlibWrapper.XGrabServer(newDisplay);
        try {
            XlibWrapper.XSetCloseDownMode(newDisplay, 1);
            xwa = new XSetWindowAttributes();
            xwa.set_override_redirect(true);
            xwa.set_event_mask(0x400000L);
            motifWindow = XlibWrapper.XCreateWindow(newDisplay, defaultRootWindow, -10, -10, 1, 1, 0, 0, 2L, 0L, 2560L, xwa.pData);
            if (motifWindow == 0L) {
                throw new XException("XCreateWindow returns NULL");
            }
            XlibWrapper.XMapWindow(newDisplay, motifWindow);
            data = Native.allocateLongArray(1);
            Native.putLong(data, motifWindow);
            XToolkit.WITH_XERROR_HANDLER(XErrorHandler.VerifyChangePropertyHandler.getInstance());
            XlibWrapper.XChangeProperty(XToolkit.getDisplay(), defaultRootWindow, XA_MOTIF_DRAG_WINDOW.getAtom(), 33L, 32, 0, data, 1);
            XToolkit.RESTORE_XERROR_HANDLER();
            if (XToolkit.saved_error != null && XToolkit.saved_error.get_error_code() != 0) {
                throw new XException("Cannot write motif drag window handle.");
            }
            l = motifWindow;
            {
                Object var16_8 = null;
                unsafe.freeMemory(data);
            }
            Object var18_10 = null;
            xwa.dispose();
            Object var20_12 = null;
        }
        catch (Throwable throwable) {
            Object var20_13 = null;
            XlibWrapper.XUngrabServer(newDisplay);
            XlibWrapper.XCloseDisplay(newDisplay);
            throw throwable;
        }
        XlibWrapper.XUngrabServer(newDisplay);
        XlibWrapper.XCloseDisplay(newDisplay);
        {
            return l;
            {
                catch (Throwable throwable) {
                    try {
                        Object var16_9 = null;
                        unsafe.freeMemory(data);
                        throw throwable;
                    }
                    catch (Throwable throwable2) {
                        Object var18_11 = null;
                        xwa.dispose();
                        throw throwable2;
                    }
                }
            }
        }
    }

    private static long getMotifWindow() throws XException {
        long motifWindow = MotifDnDConstants.readMotifWindow();
        if (motifWindow == 0L) {
            motifWindow = MotifDnDConstants.createMotifWindow();
        }
        return motifWindow;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static long[][] getTargetListTable(long motifWindow) throws XException {
        long data;
        WindowPropertyGetter wpg;
        block14: {
            block13: {
                wpg = new WindowPropertyGetter(motifWindow, XA_MOTIF_DRAG_TARGETS, 0L, 100000L, false, XA_MOTIF_DRAG_TARGETS.getAtom());
                int status = wpg.execute(XErrorHandler.IgnoreBadWindowHandler.getInstance());
                if (status == 0 && wpg.getActualType() == XA_MOTIF_DRAG_TARGETS.getAtom() && wpg.getData() != 0L) break block13;
                long[][] lArray = null;
                Object var18_5 = null;
                wpg.dispose();
                return lArray;
            }
            data = wpg.getData();
            if (unsafe.getByte(data + 1L) == 0) break block14;
            long[][] lArray = null;
            Object var18_6 = null;
            wpg.dispose();
            return lArray;
        }
        try {
            boolean swapNeeded = unsafe.getByte(data + 0L) != MotifDnDConstants.getByteOrderByte();
            short numTargetLists = unsafe.getShort(data + 2L);
            if (swapNeeded) {
                numTargetLists = Swapper.swap(numTargetLists);
            }
            long[][] table = new long[numTargetLists][];
            ByteOrder byteOrder = ByteOrder.nativeOrder();
            if (swapNeeded) {
                byteOrder = byteOrder == ByteOrder.LITTLE_ENDIAN ? ByteOrder.BIG_ENDIAN : ByteOrder.LITTLE_ENDIAN;
            }
            long bufptr = data + 8L;
            for (short i = 0; i < numTargetLists; i = (short)(i + 1)) {
                short numTargets = unsafe.getShort(bufptr);
                bufptr += 2L;
                if (swapNeeded) {
                    numTargets = Swapper.swap(numTargets);
                }
                table[i] = new long[numTargets];
                for (short j = 0; j < numTargets; j = (short)(j + 1)) {
                    int idx;
                    int target = 0;
                    if (byteOrder == ByteOrder.LITTLE_ENDIAN) {
                        for (idx = 0; idx < 4; ++idx) {
                            target |= unsafe.getByte(bufptr + (long)idx) << 8 * idx & 255 << 8 * idx;
                        }
                    } else {
                        for (idx = 0; idx < 4; ++idx) {
                            target |= unsafe.getByte(bufptr + (long)idx) << 8 * (3 - idx) & 255 << 8 * (3 - idx);
                        }
                    }
                    table[i][j] = target;
                    bufptr += 4L;
                }
            }
            long[][] lArrayArray = table;
            Object var18_7 = null;
            wpg.dispose();
            return lArrayArray;
        }
        catch (Throwable throwable) {
            Object var18_8 = null;
            wpg.dispose();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void putTargetListTable(long motifWindow, long[][] table) throws XException {
        assert (XToolkit.isAWTLockHeldByCurrentThread());
        int tableSize = 8;
        for (int i = 0; i < table.length; ++i) {
            tableSize += table[i].length * 4 + 2;
        }
        long data = unsafe.allocateMemory(tableSize);
        try {
            unsafe.putByte(data + 0L, MotifDnDConstants.getByteOrderByte());
            unsafe.putByte(data + 1L, (byte)0);
            unsafe.putShort(data + 2L, (short)table.length);
            unsafe.putInt(data + 4L, tableSize);
            long bufptr = data + 8L;
            for (int i = 0; i < table.length; ++i) {
                unsafe.putShort(bufptr, (short)table[i].length);
                bufptr += 2L;
                for (int j = 0; j < table[i].length; ++j) {
                    byte b;
                    int idx;
                    int target = (int)table[i][j];
                    if (ByteOrder.nativeOrder() == ByteOrder.LITTLE_ENDIAN) {
                        for (idx = 0; idx < 4; ++idx) {
                            b = (byte)((target & 255 << 8 * idx) >> 8 * idx);
                            unsafe.putByte(bufptr + (long)idx, b);
                        }
                    } else {
                        for (idx = 0; idx < 4; ++idx) {
                            b = (byte)((target & 255 << 8 * idx) >> 8 * idx);
                            unsafe.putByte(bufptr + (long)(3 - idx), b);
                        }
                    }
                    bufptr += 4L;
                }
            }
            XToolkit.WITH_XERROR_HANDLER(XErrorHandler.VerifyChangePropertyHandler.getInstance());
            XlibWrapper.XChangeProperty(XToolkit.getDisplay(), motifWindow, XA_MOTIF_DRAG_TARGETS.getAtom(), XA_MOTIF_DRAG_TARGETS.getAtom(), 8, 0, data, tableSize);
            XToolkit.RESTORE_XERROR_HANDLER();
            if (XToolkit.saved_error != null && XToolkit.saved_error.get_error_code() != 0) {
                motifWindow = MotifDnDConstants.createMotifWindow();
                XToolkit.WITH_XERROR_HANDLER(XErrorHandler.VerifyChangePropertyHandler.getInstance());
                XlibWrapper.XChangeProperty(XToolkit.getDisplay(), motifWindow, XA_MOTIF_DRAG_TARGETS.getAtom(), XA_MOTIF_DRAG_TARGETS.getAtom(), 8, 0, data, tableSize);
                XToolkit.RESTORE_XERROR_HANDLER();
                if (XToolkit.saved_error != null && XToolkit.saved_error.get_error_code() != 0) {
                    throw new XException("Cannot write motif drag targets property.");
                }
            }
            Object var14_11 = null;
            unsafe.freeMemory(data);
        }
        catch (Throwable throwable) {
            Object var14_12 = null;
            unsafe.freeMemory(data);
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    static int getIndexForTargetList(long[] formats) throws XException {
        int n;
        assert (XToolkit.isAWTLockHeldByCurrentThread());
        if (formats.length > 0) {
            formats = (long[])formats.clone();
            Arrays.sort(formats);
        }
        long motifWindow = MotifDnDConstants.getMotifWindow();
        XlibWrapper.XGrabServer(XToolkit.getDisplay());
        try {
            Object table = MotifDnDConstants.getTargetListTable(motifWindow);
            if (table != null) {
                for (int i = 0; i < ((long[][])table).length; ++i) {
                    boolean equals = true;
                    if (table[i].length == formats.length) {
                        for (int j = 0; j < table[i].length; ++j) {
                            if (table[i][j] == formats[j]) continue;
                            equals = false;
                            break;
                        }
                    } else {
                        equals = false;
                    }
                    if (!equals) continue;
                    XlibWrapper.XUngrabServer(XToolkit.getDisplay());
                    int n2 = i;
                    Object var8_7 = null;
                    XlibWrapper.XUngrabServer(XToolkit.getDisplay());
                    return n2;
                }
            } else {
                table = new long[2][];
                table[0] = new long[]{0L};
                table[1] = new long[]{31L};
            }
            long[][] new_table = new long[((long[][])table).length + 1][];
            for (int i = 0; i < ((long[][])table).length; ++i) {
                new_table[i] = table[i];
            }
            new_table[new_table.length - 1] = formats;
            MotifDnDConstants.putTargetListTable(motifWindow, new_table);
            n = new_table.length - 1;
        }
        catch (Throwable throwable) {
            Object var8_9 = null;
            XlibWrapper.XUngrabServer(XToolkit.getDisplay());
            throw throwable;
        }
        Object var8_8 = null;
        XlibWrapper.XUngrabServer(XToolkit.getDisplay());
        return n;
    }

    static long[] getTargetListForIndex(int index) {
        long motifWindow = MotifDnDConstants.getMotifWindow();
        long[][] table = MotifDnDConstants.getTargetListTable(motifWindow);
        if (index < 0 || index >= table.length) {
            return new long[0];
        }
        return table[index];
    }

    static byte getByteOrderByte() {
        return ByteOrder.nativeOrder() == ByteOrder.LITTLE_ENDIAN ? (byte)108 : 66;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void writeDragInitiatorInfoStruct(long window, int index) throws XException {
        assert (XToolkit.isAWTLockHeldByCurrentThread());
        long structData = unsafe.allocateMemory(8L);
        try {
            unsafe.putByte(structData, MotifDnDConstants.getByteOrderByte());
            unsafe.putByte(structData + 1L, (byte)0);
            unsafe.putShort(structData + 2L, (short)index);
            unsafe.putInt(structData + 4L, (int)XA_MOTIF_ATOM_0.getAtom());
            XToolkit.WITH_XERROR_HANDLER(XErrorHandler.VerifyChangePropertyHandler.getInstance());
            XlibWrapper.XChangeProperty(XToolkit.getDisplay(), window, XA_MOTIF_ATOM_0.getAtom(), XA_MOTIF_DRAG_INITIATOR_INFO.getAtom(), 8, 0, structData, 8);
            XToolkit.RESTORE_XERROR_HANDLER();
            if (XToolkit.saved_error != null && XToolkit.saved_error.get_error_code() != 0) {
                throw new XException("Cannot write drag initiator info");
            }
            Object var6_3 = null;
            unsafe.freeMemory(structData);
        }
        catch (Throwable throwable) {
            Object var6_4 = null;
            unsafe.freeMemory(structData);
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void writeDragReceiverInfoStruct(long window) throws XException {
        assert (XToolkit.isAWTLockHeldByCurrentThread());
        int dataSize = 16;
        long data = unsafe.allocateMemory(dataSize);
        try {
            unsafe.putByte(data, MotifDnDConstants.getByteOrderByte());
            unsafe.putByte(data + 1L, (byte)0);
            unsafe.putByte(data + 2L, (byte)5);
            unsafe.putByte(data + 3L, (byte)0);
            unsafe.putInt(data + 4L, (int)window);
            unsafe.putShort(data + 8L, (short)0);
            unsafe.putShort(data + 10L, (short)0);
            unsafe.putInt(data + 12L, dataSize);
            XToolkit.WITH_XERROR_HANDLER(XErrorHandler.VerifyChangePropertyHandler.getInstance());
            XlibWrapper.XChangeProperty(XToolkit.getDisplay(), window, XA_MOTIF_DRAG_RECEIVER_INFO.getAtom(), XA_MOTIF_DRAG_RECEIVER_INFO.getAtom(), 8, 0, data, dataSize);
            XToolkit.RESTORE_XERROR_HANDLER();
            if (XToolkit.saved_error != null && XToolkit.saved_error.get_error_code() != 0) {
                throw new XException("Cannot write Motif receiver info property");
            }
            Object var6_3 = null;
            unsafe.freeMemory(data);
        }
        catch (Throwable throwable) {
            Object var6_4 = null;
            unsafe.freeMemory(data);
            throw throwable;
        }
    }

    public static int getMotifActionsForJavaActions(int javaActions) {
        int motifActions = 0;
        if ((javaActions & 2) != 0) {
            motifActions |= 1;
        }
        if ((javaActions & 1) != 0) {
            motifActions |= 2;
        }
        if ((javaActions & 0x40000000) != 0) {
            motifActions |= 4;
        }
        return motifActions;
    }

    public static int getJavaActionsForMotifActions(int motifActions) {
        int javaActions = 0;
        if ((motifActions & 1) != 0) {
            javaActions |= 2;
        }
        if ((motifActions & 2) != 0) {
            javaActions |= 1;
        }
        if ((motifActions & 4) != 0) {
            javaActions |= 0x40000000;
        }
        return javaActions;
    }

    public static final class Swapper {
        public static short swap(short s) {
            return (short)((s & 0xFF00) >>> 8 | (s & 0xFF) << 8);
        }

        public static int swap(int i) {
            return (i & 0xFF000000) >>> 24 | (i & 0xFF0000) >>> 8 | (i & 0xFF00) << 8 | (i & 0xFF) << 24;
        }

        public static short getShort(long data, byte order) {
            short s = unsafe.getShort(data);
            if (order != MotifDnDConstants.getByteOrderByte()) {
                return Swapper.swap(s);
            }
            return s;
        }

        public static int getInt(long data, byte order) {
            int i = unsafe.getInt(data);
            if (order != MotifDnDConstants.getByteOrderByte()) {
                return Swapper.swap(i);
            }
            return i;
        }
    }
}

