/*
 * Decompiled with CFR 0.152.
 */
package sun.awt.X11;

import java.awt.Component;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.ComponentEvent;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import sun.awt.ComponentAccessor;
import sun.awt.X11.WindowDimensions;
import sun.awt.X11.XConstants;
import sun.awt.X11.XCreateWindowParams;
import sun.awt.X11.XDecoratedPeer;
import sun.awt.X11.XEvent;
import sun.awt.X11.XFramePeer;
import sun.awt.X11.XToolkit;
import sun.awt.X11.XWindow;

public class XContentWindow
extends XWindow
implements XConstants {
    private static Logger insLog = Logger.getLogger("sun.awt.X11.insets.XContentWindow");
    XDecoratedPeer parentFrame;
    private List<SavedExposeEvent> iconifiedExposeEvents = new ArrayList<SavedExposeEvent>();

    XContentWindow(XDecoratedPeer parentFrame, Rectangle bounds) {
        super((Component)parentFrame.getTarget(), parentFrame.getShell(), bounds);
        this.parentFrame = parentFrame;
    }

    void preInit(XCreateWindowParams params) {
        super.preInit(params);
        params.putIfNull((Object)"bit gravity", (Object)1);
        Long eventMask = (Long)params.get("event mask");
        if (eventMask != null) {
            eventMask = eventMask & 0xFFFFFFFFFFFDFFFFL;
            params.put("event mask", eventMask);
        }
    }

    void initialize() {
        this.xSetVisible(true);
    }

    protected String getWMName() {
        return "Content window";
    }

    protected boolean isEventDisabled(XEvent e) {
        switch (e.get_type()) {
            case 7: 
            case 8: {
                return false;
            }
            case 22: {
                return true;
            }
            case 18: 
            case 19: {
                return true;
            }
        }
        return super.isEventDisabled(e) || this.parentFrame.isEventDisabled(e);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setContentBounds(WindowDimensions dims) {
        XToolkit.awtLock();
        try {
            Rectangle newBounds = dims.getBounds();
            Insets in = dims.getInsets();
            if (in != null) {
                newBounds.setLocation(-in.left, -in.top);
            }
            if (insLog.isLoggable(Level.FINE)) {
                insLog.log(Level.FINE, "Setting content bounds {0}, old bounds {1}", new Object[]{String.valueOf(newBounds), String.valueOf(this.getBounds())});
            }
            boolean needHandleResize = !newBounds.equals(this.getBounds());
            this.reshape(newBounds);
            if (needHandleResize) {
                insLog.fine("Sending RESIZED");
                this.handleResize(newBounds);
            }
            Object var6_5 = null;
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            XToolkit.awtUnlock();
            throw throwable;
        }
        XToolkit.awtUnlock();
        this.validateSurface();
    }

    public void handleResize(Rectangle bounds) {
        ComponentAccessor.setWidth(this.target, bounds.width);
        ComponentAccessor.setHeight(this.target, bounds.height);
        this.postEvent(new ComponentEvent(this.target, 101));
    }

    public void handleExposeEvent(Component target, int x, int y, int w, int h) {
        if (this.parentFrame instanceof XFramePeer && (((XFramePeer)this.parentFrame).getState() & 1) != 0) {
            this.iconifiedExposeEvents.add(new SavedExposeEvent(target, x, y, w, h));
        } else {
            super.handleExposeEvent(target, x, y, w, h);
        }
    }

    void purgeIconifiedExposeEvents() {
        for (SavedExposeEvent evt : this.iconifiedExposeEvents) {
            super.handleExposeEvent(evt.target, evt.x, evt.y, evt.w, evt.h);
        }
        this.iconifiedExposeEvents.clear();
    }

    public String toString() {
        return this.getClass().getName() + "[" + this.getBounds() + "]";
    }

    private static class SavedExposeEvent {
        Component target;
        int x;
        int y;
        int w;
        int h;

        SavedExposeEvent(Component target, int x, int y, int w, int h) {
            this.target = target;
            this.x = x;
            this.y = y;
            this.w = w;
            this.h = h;
        }
    }
}

