/*
 * Decompiled with CFR 0.152.
 */
package sun.awt.X11;

import java.awt.datatransfer.Transferable;
import java.awt.dnd.InvalidDnDOperationException;
import java.util.Map;
import sun.awt.X11.XClientMessageEvent;
import sun.awt.X11.XDragSourceProtocolListener;
import sun.awt.X11.XErrorHandler;
import sun.awt.X11.XException;
import sun.awt.X11.XToolkit;
import sun.awt.X11.XWindow;
import sun.awt.X11.XWindowAttributes;
import sun.awt.X11.XlibWrapper;

abstract class XDragSourceProtocol {
    private final XDragSourceProtocolListener listener;
    private boolean initialized = false;
    private long targetWindow = 0L;
    private long targetProxyWindow = 0L;
    private int targetProtocolVersion = 0;
    private long targetWindowMask = 0L;

    static long getDragSourceWindow() {
        return XWindow.getXAWTRootWindow().getWindow();
    }

    protected XDragSourceProtocol(XDragSourceProtocolListener listener) {
        if (listener == null) {
            throw new NullPointerException("Null XDragSourceProtocolListener");
        }
        this.listener = listener;
    }

    protected final XDragSourceProtocolListener getProtocolListener() {
        return this.listener;
    }

    public abstract String getProtocolName();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void initializeDrag(int actions2, Transferable contents, Map formatMap, long[] formats) throws InvalidDnDOperationException, IllegalArgumentException, XException {
        XToolkit.awtLock();
        try {
            try {
                if (this.initialized) {
                    throw new InvalidDnDOperationException("Already initialized");
                }
                this.initializeDragImpl(actions2, contents, formatMap, formats);
                this.initialized = true;
                Object var6_5 = null;
                if (!this.initialized) {
                    this.cleanup();
                }
            }
            catch (Throwable throwable) {
                Object var6_6 = null;
                if (!this.initialized) {
                    this.cleanup();
                }
                throw throwable;
            }
            Object var8_8 = null;
        }
        catch (Throwable throwable) {
            Object var8_9 = null;
            XToolkit.awtUnlock();
            throw throwable;
        }
        XToolkit.awtUnlock();
    }

    protected abstract void initializeDragImpl(int var1, Transferable var2, Map var3, long[] var4) throws InvalidDnDOperationException, IllegalArgumentException, XException;

    public void cleanup() {
        this.initialized = false;
        this.cleanupTargetInfo();
    }

    public void cleanupTargetInfo() {
        this.targetWindow = 0L;
        this.targetProxyWindow = 0L;
        this.targetProtocolVersion = 0;
    }

    public abstract boolean processClientMessage(XClientMessageEvent var1) throws XException;

    public final boolean attachTargetWindow(long window, long time) {
        assert (XToolkit.isAWTLockHeldByCurrentThread());
        TargetWindowInfo info = this.getTargetWindowInfo(window);
        if (info == null) {
            return false;
        }
        this.targetWindow = window;
        this.targetProxyWindow = info.getProxyWindow();
        this.targetProtocolVersion = info.getProtocolVersion();
        return true;
    }

    public abstract TargetWindowInfo getTargetWindowInfo(long var1);

    public abstract void sendEnterMessage(long[] var1, int var2, int var3, long var4);

    public abstract void sendMoveMessage(int var1, int var2, int var3, int var4, long var5);

    public abstract void sendLeaveMessage(long var1);

    protected abstract void sendDropMessage(int var1, int var2, int var3, int var4, long var5);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void initiateDrop(int xRoot, int yRoot, int sourceAction, int sourceActions, long time) {
        XWindowAttributes wattr = new XWindowAttributes();
        try {
            XToolkit.WITH_XERROR_HANDLER(XErrorHandler.IgnoreBadWindowHandler.getInstance());
            int status = XlibWrapper.XGetWindowAttributes(XToolkit.getDisplay(), this.targetWindow, wattr.pData);
            XToolkit.RESTORE_XERROR_HANDLER();
            if (status == 0 || XToolkit.saved_error != null && XToolkit.saved_error.get_error_code() != 0) {
                throw new XException("XGetWindowAttributes failed");
            }
            this.targetWindowMask = wattr.get_your_event_mask();
            Object var10_8 = null;
            wattr.dispose();
        }
        catch (Throwable throwable) {
            Object var10_9 = null;
            wattr.dispose();
            throw throwable;
        }
        XToolkit.WITH_XERROR_HANDLER(XErrorHandler.IgnoreBadWindowHandler.getInstance());
        XlibWrapper.XSelectInput(XToolkit.getDisplay(), this.targetWindow, this.targetWindowMask | 0x20000L);
        XToolkit.RESTORE_XERROR_HANDLER();
        if (XToolkit.saved_error != null && XToolkit.saved_error.get_error_code() != 0) {
            throw new XException("XSelectInput failed");
        }
        this.sendDropMessage(xRoot, yRoot, sourceAction, sourceActions, time);
    }

    protected final void finalizeDrop() {
        XToolkit.WITH_XERROR_HANDLER(XErrorHandler.IgnoreBadWindowHandler.getInstance());
        XlibWrapper.XSelectInput(XToolkit.getDisplay(), this.targetWindow, this.targetWindowMask);
        XToolkit.RESTORE_XERROR_HANDLER();
    }

    public abstract boolean processProxyModeEvent(XClientMessageEvent var1, long var2);

    protected final long getTargetWindow() {
        return this.targetWindow;
    }

    protected final long getTargetProxyWindow() {
        if (this.targetProxyWindow != 0L) {
            return this.targetProxyWindow;
        }
        return this.targetWindow;
    }

    protected final int getTargetProtocolVersion() {
        return this.targetProtocolVersion;
    }

    public static class TargetWindowInfo {
        private final long proxyWindow;
        private final int protocolVersion;

        public TargetWindowInfo(long proxy, int version) {
            this.proxyWindow = proxy;
            this.protocolVersion = version;
        }

        public long getProxyWindow() {
            return this.proxyWindow;
        }

        public int getProtocolVersion() {
            return this.protocolVersion;
        }
    }
}

