/*
 * Decompiled with CFR 0.152.
 */
package sun.awt.X11;

import java.awt.GraphicsEnvironment;
import java.awt.Point;
import java.awt.Rectangle;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import sun.awt.X11.Native;
import sun.awt.X11.WindowPropertyGetter;
import sun.awt.X11.XBaseWindow;
import sun.awt.X11.XDecoratedPeer;
import sun.awt.X11.XEmbeddedFramePeer;
import sun.awt.X11.XErrorHandler;
import sun.awt.X11.XQueryTree;
import sun.awt.X11.XToolkit;
import sun.awt.X11.XTranslateCoordinates;
import sun.awt.X11.XWM;
import sun.awt.X11.XWindowAttributes;
import sun.awt.X11.XWindowPeer;
import sun.awt.X11.XlibWrapper;
import sun.awt.X11GraphicsEnvironment;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XlibUtil {
    static Boolean isShapingSupported = null;

    private XlibUtil() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static long getRootWindow(int screenNumber) {
        block3: {
            long l;
            XToolkit.awtLock();
            try {
                X11GraphicsEnvironment x11ge = (X11GraphicsEnvironment)GraphicsEnvironment.getLocalGraphicsEnvironment();
                if (!x11ge.runningXinerama()) break block3;
                l = XlibWrapper.RootWindow(XToolkit.getDisplay(), 0L);
                Object var5_4 = null;
            }
            catch (Throwable throwable) {
                Object var5_6 = null;
                XToolkit.awtUnlock();
                throw throwable;
            }
            XToolkit.awtUnlock();
            return l;
        }
        long l = XlibWrapper.RootWindow(XToolkit.getDisplay(), screenNumber);
        Object var5_5 = null;
        XToolkit.awtUnlock();
        return l;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static boolean isRoot(long rootCandidate, long screenNumber) {
        long root;
        XToolkit.awtLock();
        try {
            root = XlibWrapper.RootWindow(XToolkit.getDisplay(), screenNumber);
            Object var7_3 = null;
        }
        catch (Throwable throwable) {
            Object var7_4 = null;
            XToolkit.awtUnlock();
            throw throwable;
        }
        XToolkit.awtUnlock();
        return root == rootCandidate;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static Rectangle getWindowGeometry(long window) {
        block3: {
            Rectangle rectangle;
            XToolkit.awtLock();
            try {
                int res = XlibWrapper.XGetGeometry(XToolkit.getDisplay(), window, XlibWrapper.larg1, XlibWrapper.larg2, XlibWrapper.larg3, XlibWrapper.larg4, XlibWrapper.larg5, XlibWrapper.larg6, XlibWrapper.larg7);
                if (res != 0) break block3;
                rectangle = null;
                Object var11_4 = null;
            }
            catch (Throwable throwable) {
                Object var11_6 = null;
                XToolkit.awtUnlock();
                throw throwable;
            }
            XToolkit.awtUnlock();
            return rectangle;
        }
        int x = Native.getInt(XlibWrapper.larg2);
        int y = Native.getInt(XlibWrapper.larg3);
        long width = Native.getUInt(XlibWrapper.larg4);
        long height = Native.getUInt(XlibWrapper.larg5);
        Rectangle rectangle = new Rectangle(x, y, (int)width, (int)height);
        Object var11_5 = null;
        XToolkit.awtUnlock();
        return rectangle;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static Point translateCoordinates(long src, long dst, Point p) {
        Point translated = null;
        XToolkit.awtLock();
        try {
            XTranslateCoordinates xtc = new XTranslateCoordinates(src, dst, p.x, p.y);
            try {
                int status = xtc.execute(XErrorHandler.IgnoreBadWindowHandler.getInstance());
                if (status != 0 && (XToolkit.saved_error == null || XToolkit.saved_error.get_error_code() == 0)) {
                    translated = new Point(xtc.get_dest_x(), xtc.get_dest_y());
                }
                Object var9_6 = null;
                xtc.dispose();
            }
            catch (Throwable throwable) {
                Object var9_7 = null;
                xtc.dispose();
                throw throwable;
            }
            Object var11_9 = null;
        }
        catch (Throwable throwable) {
            Object var11_10 = null;
            XToolkit.awtUnlock();
            throw throwable;
        }
        XToolkit.awtUnlock();
        return translated;
    }

    static Rectangle translateCoordinates(long src, long dst, Rectangle r) {
        Point translatedLoc = XlibUtil.translateCoordinates(src, dst, r.getLocation());
        if (translatedLoc == null) {
            return null;
        }
        return new Rectangle(translatedLoc, r.getSize());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    static long getParentWindow(long window) {
        long l;
        block11: {
            long l2;
            block10: {
                long l3;
                block9: {
                    XToolkit.awtLock();
                    try {
                        XBaseWindow pbw;
                        XBaseWindow bw = XToolkit.windowToXWindow(window);
                        if (bw != null && (pbw = bw.getParentWindow()) != null) {
                            l3 = pbw.getWindow();
                            Object var9_6 = null;
                            break block9;
                        }
                        XQueryTree qt = new XQueryTree(window);
                        try {
                            if (qt.execute() == 0) {
                                l2 = 0L;
                                Object var7_10 = null;
                                qt.dispose();
                                break block10;
                            }
                        }
                        catch (Throwable throwable) {
                            Object var7_12 = null;
                            qt.dispose();
                            throw throwable;
                        }
                        {
                            l = qt.get_parent();
                            Object var7_11 = null;
                            qt.dispose();
                        }
                        break block11;
                    }
                    catch (Throwable throwable) {
                        Object var9_9 = null;
                        XToolkit.awtUnlock();
                        throw throwable;
                    }
                }
                XToolkit.awtUnlock();
                return l3;
            }
            Object var9_7 = null;
            XToolkit.awtUnlock();
            return l2;
        }
        Object var9_8 = null;
        XToolkit.awtUnlock();
        return l;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    static Set<Long> getChildWindows(long window) {
        XToolkit.awtLock();
        try {
            HashSet<Long> hashSet;
            long children;
            XQueryTree xqt;
            block9: {
                block8: {
                    XBaseWindow bw = XToolkit.windowToXWindow(window);
                    if (bw != null) {
                        Set<Long> set = bw.getChildren();
                        Object var13_4 = null;
                        XToolkit.awtUnlock();
                        return set;
                    }
                    xqt = new XQueryTree(window);
                    int status = xqt.execute();
                    if (status != 0) break block8;
                    Set<Long> set = Collections.emptySet();
                    Object var11_12 = null;
                    xqt.dispose();
                    Object var13_5 = null;
                    XToolkit.awtUnlock();
                    return set;
                }
                children = xqt.get_children();
                if (children != 0L) break block9;
                Set<Long> set = Collections.emptySet();
                Object var11_13 = null;
                xqt.dispose();
                Object var13_6 = null;
                XToolkit.awtUnlock();
                return set;
            }
            try {
                int childrenCount = xqt.get_nchildren();
                HashSet<Long> childrenSet = new HashSet<Long>(childrenCount);
                for (int i = 0; i < childrenCount; ++i) {
                    childrenSet.add(Native.getWindow(children, i));
                }
                hashSet = childrenSet;
                Object var11_14 = null;
                xqt.dispose();
            }
            catch (Throwable throwable) {
                Object var11_15 = null;
                xqt.dispose();
                throw throwable;
            }
            Object var13_7 = null;
            XToolkit.awtUnlock();
            return hashSet;
        }
        catch (Throwable throwable) {
            Object var13_8 = null;
            XToolkit.awtUnlock();
            throw throwable;
        }
    }

    static boolean isXAWTToplevelWindow(long window) {
        return XToolkit.windowToXWindow(window) instanceof XWindowPeer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    static boolean isToplevelWindow(long window) {
        boolean bl;
        if (XToolkit.windowToXWindow(window) instanceof XDecoratedPeer) {
            return true;
        }
        XToolkit.awtLock();
        try {
            WindowPropertyGetter wpg;
            block6: {
                boolean bl2;
                wpg = new WindowPropertyGetter(window, XWM.XA_WM_STATE, 0L, 1L, false, XWM.XA_WM_STATE);
                try {
                    wpg.execute(XErrorHandler.IgnoreBadWindowHandler.getInstance());
                    if (wpg.getActualType() != XWM.XA_WM_STATE.getAtom()) break block6;
                    bl2 = true;
                    Object var5_4 = null;
                    wpg.dispose();
                }
                catch (Throwable throwable) {
                    Object var5_6 = null;
                    wpg.dispose();
                    throw throwable;
                }
                Object var7_7 = null;
                XToolkit.awtUnlock();
                return bl2;
            }
            Object var5_5 = null;
            wpg.dispose();
            bl = false;
            Object var7_8 = null;
        }
        catch (Throwable throwable) {
            Object var7_9 = null;
            XToolkit.awtUnlock();
            throw throwable;
        }
        XToolkit.awtUnlock();
        return bl;
    }

    static boolean isTrueToplevelWindow(long window) {
        if (XToolkit.windowToXWindow(window) instanceof XEmbeddedFramePeer) {
            return false;
        }
        return XlibUtil.isToplevelWindow(window);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static int getWindowMapState(long window) {
        XWindowAttributes wattr;
        block3: {
            int n;
            XToolkit.awtLock();
            wattr = new XWindowAttributes();
            try {
                XToolkit.WITH_XERROR_HANDLER(XErrorHandler.IgnoreBadWindowHandler.getInstance());
                int status = XlibWrapper.XGetWindowAttributes(XToolkit.getDisplay(), window, wattr.pData);
                XToolkit.RESTORE_XERROR_HANDLER();
                if (status == 0 || XToolkit.saved_error != null && XToolkit.saved_error.get_error_code() != 0) break block3;
                n = wattr.get_map_state();
                Object var6_4 = null;
                wattr.dispose();
            }
            catch (Throwable throwable) {
                Object var6_6 = null;
                wattr.dispose();
                XToolkit.awtUnlock();
                throw throwable;
            }
            XToolkit.awtUnlock();
            return n;
        }
        Object var6_5 = null;
        wattr.dispose();
        XToolkit.awtUnlock();
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static synchronized boolean isShapingSupported() {
        if (isShapingSupported == null) {
            XToolkit.awtLock();
            try {
                isShapingSupported = XlibWrapper.XShapeQueryExtension(XToolkit.getDisplay(), XlibWrapper.larg1, XlibWrapper.larg2);
                Object var1 = null;
            }
            catch (Throwable throwable) {
                Object var1_1 = null;
                XToolkit.awtUnlock();
                throw throwable;
            }
            XToolkit.awtUnlock();
            {
            }
        }
        return isShapingSupported;
    }
}

