/*
 * Decompiled with CFR 0.152.
 */
package sun.java2d.x11;

import java.awt.GraphicsConfiguration;
import java.awt.ImageCapabilities;
import java.awt.image.ColorModel;
import sun.awt.X11GraphicsConfig;
import sun.awt.image.SunVolatileImage;
import sun.awt.image.VolatileSurfaceManager;
import sun.java2d.SurfaceData;
import sun.java2d.x11.X11SurfaceData;

public class X11VolatileSurfaceManager
extends VolatileSurfaceManager {
    private boolean accelerationEnabled;

    public X11VolatileSurfaceManager(SunVolatileImage vImg, Object context) {
        super(vImg, context);
        boolean bl = this.accelerationEnabled = X11SurfaceData.isAccelerationEnabled() && vImg.getTransparency() == 1;
        if (context != null && !this.accelerationEnabled) {
            this.accelerationEnabled = true;
            this.sdCurrent = this.sdAccel = this.initAcceleratedSurface();
            if (this.sdBackup != null) {
                this.sdBackup = null;
            }
        }
    }

    protected boolean isAccelerationEnabled() {
        return this.accelerationEnabled;
    }

    protected SurfaceData initAcceleratedSurface() {
        X11SurfaceData.X11PixmapSurfaceData sData;
        try {
            X11GraphicsConfig gc = (X11GraphicsConfig)this.vImg.getGraphicsConfig();
            ColorModel cm = gc.getColorModel();
            long drawable = 0L;
            if (this.context instanceof Long) {
                drawable = (Long)this.context;
            }
            sData = X11SurfaceData.createData(gc, this.vImg.getWidth(), this.vImg.getHeight(), cm, this.vImg, drawable, 1);
        }
        catch (NullPointerException ex) {
            sData = null;
        }
        catch (OutOfMemoryError er) {
            sData = null;
        }
        return sData;
    }

    protected boolean isConfigValid(GraphicsConfiguration gc) {
        return gc == null || gc == this.vImg.getGraphicsConfig();
    }

    public ImageCapabilities getCapabilities(GraphicsConfiguration gc) {
        if (this.isConfigValid(gc) && this.isAccelerationEnabled()) {
            return new ImageCapabilities(true);
        }
        return new ImageCapabilities(false);
    }
}

