/*
 * Decompiled with CFR 0.152.
 */
package sun.net.www;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.FileNameMap;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import java.util.StringTokenizer;
import sun.net.www.MimeEntry;
import sun.net.www.URLConnection;

public class MimeTable
implements FileNameMap {
    private Hashtable entries = new Hashtable();
    private Hashtable extensionMap = new Hashtable();
    private static String tempFileTemplate;
    private static final String filePreamble = "sun.net.www MIME content-types table";
    private static final String fileMagic = "#sun.net.www MIME content-types table";
    private static MimeTable defaultInstance;
    protected static String[] mailcapLocations;

    MimeTable() {
        this.load();
    }

    public static MimeTable getDefaultTable() {
        if (defaultInstance == null) {
            AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    defaultInstance = new MimeTable();
                    URLConnection.setFileNameMap(defaultInstance);
                    return null;
                }
            });
        }
        return defaultInstance;
    }

    public static FileNameMap loadTable() {
        MimeTable mt = MimeTable.getDefaultTable();
        return mt;
    }

    public synchronized int getSize() {
        return this.entries.size();
    }

    public synchronized String getContentTypeFor(String fileName) {
        MimeEntry entry = this.findByFileName(fileName);
        if (entry != null) {
            return entry.getType();
        }
        return null;
    }

    public synchronized void add(MimeEntry m) {
        this.entries.put(m.getType(), m);
        String[] exts = m.getExtensions();
        if (exts == null) {
            return;
        }
        for (int i = 0; i < exts.length; ++i) {
            this.extensionMap.put(exts[i], m);
        }
    }

    public synchronized MimeEntry remove(String type) {
        MimeEntry entry = (MimeEntry)this.entries.get(type);
        return this.remove(entry);
    }

    public synchronized MimeEntry remove(MimeEntry entry) {
        String[] extensionKeys = entry.getExtensions();
        if (extensionKeys != null) {
            for (int i = 0; i < extensionKeys.length; ++i) {
                this.extensionMap.remove(extensionKeys[i]);
            }
        }
        return (MimeEntry)this.entries.remove(entry.getType());
    }

    public synchronized MimeEntry find(String type) {
        MimeEntry entry = (MimeEntry)this.entries.get(type);
        if (entry == null) {
            Enumeration e = this.entries.elements();
            while (e.hasMoreElements()) {
                MimeEntry wild = (MimeEntry)e.nextElement();
                if (!wild.matches(type)) continue;
                return wild;
            }
        }
        return entry;
    }

    public MimeEntry findByFileName(String fname) {
        String ext = "";
        int i = fname.lastIndexOf(35);
        if (i > 0) {
            fname = fname.substring(0, i - 1);
        }
        i = fname.lastIndexOf(46);
        i = Math.max(i, fname.lastIndexOf(47));
        if ((i = Math.max(i, fname.lastIndexOf(63))) != -1 && fname.charAt(i) == '.') {
            ext = fname.substring(i).toLowerCase();
        }
        return this.findByExt(ext);
    }

    public synchronized MimeEntry findByExt(String fileExtension) {
        return (MimeEntry)this.extensionMap.get(fileExtension);
    }

    public synchronized MimeEntry findByDescription(String description) {
        Enumeration e = this.elements();
        while (e.hasMoreElements()) {
            MimeEntry entry = (MimeEntry)e.nextElement();
            if (!description.equals(entry.getDescription())) continue;
            return entry;
        }
        return this.find(description);
    }

    String getTempFileTemplate() {
        return tempFileTemplate;
    }

    public synchronized Enumeration elements() {
        return this.entries.elements();
    }

    public synchronized void load() {
        Properties entries = new Properties();
        File file = null;
        try {
            String userTablePath = System.getProperty("content.types.user.table");
            if (userTablePath != null) {
                file = new File(userTablePath);
                if (!file.exists()) {
                    file = new File(System.getProperty("java.home") + File.separator + "lib" + File.separator + "content-types.properties");
                }
            } else {
                file = new File(System.getProperty("java.home") + File.separator + "lib" + File.separator + "content-types.properties");
            }
            BufferedInputStream is = new BufferedInputStream(new FileInputStream(file));
            entries.load(is);
            ((InputStream)is).close();
        }
        catch (IOException e) {
            System.err.println("Warning: default mime table not found: " + file.getPath());
            return;
        }
        this.parse(entries);
    }

    void parse(Properties entries) {
        String tempFileTemplate = (String)entries.get("temp.file.template");
        if (tempFileTemplate != null) {
            entries.remove("temp.file.template");
            MimeTable.tempFileTemplate = tempFileTemplate;
        }
        Enumeration<?> types = entries.propertyNames();
        while (types.hasMoreElements()) {
            String type = (String)types.nextElement();
            String attrs = entries.getProperty(type);
            this.parse(type, attrs);
        }
    }

    void parse(String type, String attrs) {
        MimeEntry newEntry = new MimeEntry(type);
        StringTokenizer tokenizer = new StringTokenizer(attrs, ";");
        while (tokenizer.hasMoreTokens()) {
            String pair = tokenizer.nextToken();
            this.parse(pair, newEntry);
        }
        this.add(newEntry);
    }

    void parse(String pair, MimeEntry entry) {
        String name = null;
        String value = null;
        boolean gotName = false;
        StringTokenizer tokenizer = new StringTokenizer(pair, "=");
        while (tokenizer.hasMoreTokens()) {
            if (gotName) {
                value = tokenizer.nextToken().trim();
                continue;
            }
            name = tokenizer.nextToken().trim();
            gotName = true;
        }
        this.fill(entry, name, value);
    }

    void fill(MimeEntry entry, String name, String value) {
        if ("description".equalsIgnoreCase(name)) {
            entry.setDescription(value);
        } else if ("action".equalsIgnoreCase(name)) {
            entry.setAction(this.getActionCode(value));
        } else if ("application".equalsIgnoreCase(name)) {
            entry.setCommand(value);
        } else if ("icon".equalsIgnoreCase(name)) {
            entry.setImageFileName(value);
        } else if ("file_extensions".equalsIgnoreCase(name)) {
            entry.setExtensions(value);
        }
    }

    String[] getExtensions(String list) {
        StringTokenizer tokenizer = new StringTokenizer(list, ",");
        int n = tokenizer.countTokens();
        String[] extensions = new String[n];
        for (int i = 0; i < n; ++i) {
            extensions[i] = tokenizer.nextToken();
        }
        return extensions;
    }

    int getActionCode(String action) {
        for (int i = 0; i < MimeEntry.actionKeywords.length; ++i) {
            if (!action.equalsIgnoreCase(MimeEntry.actionKeywords[i])) continue;
            return i;
        }
        return 0;
    }

    public synchronized boolean save(String filename) {
        if (filename == null) {
            filename = System.getProperty("user.home" + File.separator + "lib" + File.separator + "content-types.properties");
        }
        return this.saveAsProperties(new File(filename));
    }

    public Properties getAsProperties() {
        Properties properties = new Properties();
        Enumeration e = this.elements();
        while (e.hasMoreElements()) {
            MimeEntry entry = (MimeEntry)e.nextElement();
            properties.put(entry.getType(), entry.toProperty());
        }
        return properties;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected boolean saveAsProperties(File file) {
        FileOutputStream os;
        block9: {
            os = null;
            os = new FileOutputStream(file);
            Properties properties = this.getAsProperties();
            properties.put("temp.file.template", tempFileTemplate);
            String user = System.getProperty("user.name");
            if (user != null) {
                String tag = "; customized for " + user;
                properties.save(os, filePreamble + tag);
                break block9;
            }
            properties.save(os, filePreamble);
        }
        Object var7_8 = null;
        if (os == null) return true;
        try {
            os.close();
            return true;
        }
        catch (IOException e2) {}
        return true;
        {
            catch (IOException e) {
                e.printStackTrace();
                boolean bl = false;
                Object var7_9 = null;
                if (os == null) return bl;
                try {
                    os.close();
                    return bl;
                }
                catch (IOException e2) {
                    // empty catch block
                }
                return bl;
            }
        }
        catch (Throwable throwable) {
            Object var7_10 = null;
            if (os == null) throw throwable;
            try {
                os.close();
                throw throwable;
            }
            catch (IOException e2) {
                // empty catch block
            }
            throw throwable;
        }
    }

    static {
        AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                tempFileTemplate = System.getProperty("content.types.temp.file.template", "/tmp/%s");
                mailcapLocations = new String[]{System.getProperty("user.mailcap"), System.getProperty("user.home") + "/.mailcap", "/etc/mailcap", "/usr/etc/mailcap", "/usr/local/etc/mailcap", System.getProperty("hotjava.home", "/usr/local/hotjava") + "/lib/mailcap"};
                return null;
            }
        });
        defaultInstance = null;
    }
}

