/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jnlp;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Hashtable;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Random;
import net.sourceforge.jnlp.AppletDesc;
import net.sourceforge.jnlp.InformationDesc;
import net.sourceforge.jnlp.JARDesc;
import net.sourceforge.jnlp.JNLPFile;
import net.sourceforge.jnlp.ResourcesDesc;
import net.sourceforge.jnlp.SecurityDesc;
import net.sourceforge.jnlp.Version;
import net.sourceforge.jnlp.runtime.JNLPRuntime;

public class PluginBridge
extends JNLPFile {
    String name;
    String[] jars = new String[0];
    String[] cacheJars = new String[0];
    String[] cacheExJars = new String[0];
    Hashtable<String, String> atts;

    public PluginBridge(URL codebase, URL documentBase, String jar, String main, int width, int height, Hashtable<String, String> atts) throws Exception {
        String cacheArchiveEx;
        String cacheArchive;
        this.specVersion = new Version("1.0");
        this.fileVersion = new Version("1.1");
        this.codeBase = codebase;
        this.sourceLocation = documentBase;
        if (atts.containsKey("jnlp_href")) {
            try {
                URL jnlp = new URL(this.codeBase.toExternalForm() + atts.get("jnlp_href"));
                JNLPFile jnlpFile = new JNLPFile(jnlp);
                Map<String, String> jnlpParams = jnlpFile.getApplet().getParameters();
                for (Map.Entry<String, String> entry : jnlpParams.entrySet()) {
                    atts.put(entry.getKey().toLowerCase(), entry.getValue());
                }
            }
            catch (MalformedURLException e) {
                System.err.println("Unable to get JNLP file at: " + this.codeBase.toExternalForm() + atts.get("jnlp_href"));
            }
        }
        if ((cacheArchive = atts.get("cache_archive")) != null && cacheArchive.length() > 0) {
            String[] versions = new String[]{};
            String cacheVersion = atts.get("cache_version");
            if (cacheVersion != null) {
                versions = cacheVersion.split(",");
            }
            String[] jars = cacheArchive.split(",");
            this.cacheJars = new String[jars.length];
            for (int i = 0; i < jars.length; ++i) {
                this.cacheJars[i] = jars[i].trim();
                if (versions.length <= 0) continue;
                int n = i;
                this.cacheJars[n] = this.cacheJars[n] + ";" + versions[i].trim();
            }
        }
        if ((cacheArchiveEx = atts.get("cache_archive_ex")) != null && cacheArchiveEx.length() > 0) {
            this.cacheExJars = cacheArchiveEx.split(",");
        }
        if (jar != null && jar.length() > 0) {
            this.jars = jar.split(",");
            for (int i = 0; i < this.jars.length; ++i) {
                this.jars[i] = this.jars[i].trim();
            }
            if (JNLPRuntime.isDebug()) {
                System.err.println("Jar string: " + jar);
                System.err.println("jars length: " + this.jars.length);
            }
        }
        this.atts = atts;
        this.name = atts.get("name");
        this.name = this.name == null ? "Applet" : this.name + " applet";
        if (main.endsWith(".class")) {
            main = main.substring(0, main.length() - 6);
        }
        this.launchType = new AppletDesc(this.name, main, documentBase, width, height, atts);
        this.security = main.endsWith(".class") ? new SecurityDesc(this, SecurityDesc.SANDBOX_PERMISSIONS, codebase.getHost()) : null;
        this.uniqueKey = Calendar.getInstance().getTimeInMillis() + "-" + Math.abs(new Random().nextInt()) + "-" + documentBase;
    }

    @Override
    public String getTitle() {
        return this.name;
    }

    @Override
    public InformationDesc getInformation(Locale locale) {
        return new InformationDesc(this, new Locale[]{locale}){

            @Override
            protected List<Object> getItems(Object key) {
                return new ArrayList<Object>();
            }
        };
    }

    @Override
    public ResourcesDesc getResources(Locale locale, String os, String arch) {
        return new ResourcesDesc(this, new Locale[]{locale}, new String[]{os}, new String[]{arch}){

            @Override
            public <T> List<T> getResources(Class<T> launchType) {
                if (launchType.equals(JARDesc.class)) {
                    try {
                        Version version;
                        String jar;
                        int i;
                        ArrayList<JARDesc> jarDescs = new ArrayList<JARDesc>();
                        jarDescs.addAll(PluginBridge.this.sharedResources.getResources(JARDesc.class));
                        for (int i2 = 0; i2 < PluginBridge.this.jars.length; ++i2) {
                            if (PluginBridge.this.jars[i2].length() <= 0) continue;
                            jarDescs.add(new JARDesc(new URL(PluginBridge.this.codeBase, PluginBridge.this.jars[i2]), null, null, false, true, false, true));
                        }
                        boolean cacheable = true;
                        String cacheOption = PluginBridge.this.atts.get("cache_option");
                        if (cacheOption != null && cacheOption.equalsIgnoreCase("no")) {
                            cacheable = false;
                        }
                        for (i = 0; i < PluginBridge.this.cacheJars.length; ++i) {
                            String[] jarAndVer = PluginBridge.this.cacheJars[i].split(";");
                            jar = jarAndVer[0];
                            version = null;
                            if (jar.length() == 0) continue;
                            if (jarAndVer.length > 1) {
                                version = new Version(jarAndVer[1]);
                            }
                            jarDescs.add(new JARDesc(new URL(PluginBridge.this.codeBase, jar), version, null, false, true, false, cacheable));
                        }
                        for (i = 0; i < PluginBridge.this.cacheExJars.length; ++i) {
                            if (PluginBridge.this.cacheExJars[i].length() == 0) continue;
                            String[] jarInfo = PluginBridge.this.cacheExJars[i].split(";");
                            jar = jarInfo[0].trim();
                            version = null;
                            boolean lazy = true;
                            if (jarInfo.length > 1) {
                                if (jarInfo[1].equals("preload")) {
                                    lazy = false;
                                } else {
                                    version = new Version(jarInfo[1].trim());
                                }
                                if (jarInfo.length > 2) {
                                    lazy = false;
                                    version = new Version(jarInfo[2].trim());
                                }
                            }
                            jarDescs.add(new JARDesc(new URL(PluginBridge.this.codeBase, jar), version, null, lazy, true, false, false));
                        }
                        ArrayList<JARDesc> result = jarDescs;
                        return result;
                    }
                    catch (MalformedURLException malformedURLException) {
                        // empty catch block
                    }
                }
                return PluginBridge.this.sharedResources.getResources(launchType);
            }

            @Override
            public JARDesc[] getJARs() {
                List<JARDesc> jarDescs = this.getResources(JARDesc.class);
                return jarDescs.toArray(new JARDesc[jarDescs.size()]);
            }

            @Override
            public void addResource(Object resource) {
                PluginBridge.this.sharedResources.addResource(resource);
            }
        };
    }

    @Override
    public boolean isApplet() {
        return true;
    }

    @Override
    public boolean isApplication() {
        return false;
    }

    @Override
    public boolean isComponent() {
        return false;
    }

    @Override
    public boolean isInstaller() {
        return false;
    }
}

