/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jnlp.cache;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FilePermission;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.nio.channels.FileChannel;
import java.security.Permission;
import java.util.ArrayList;
import javax.jnlp.DownloadServiceListener;
import net.sourceforge.jnlp.Version;
import net.sourceforge.jnlp.cache.CacheEntry;
import net.sourceforge.jnlp.cache.DownloadIndicator;
import net.sourceforge.jnlp.cache.ResourceTracker;
import net.sourceforge.jnlp.cache.UpdatePolicy;
import net.sourceforge.jnlp.runtime.ApplicationInstance;
import net.sourceforge.jnlp.runtime.JNLPRuntime;
import net.sourceforge.jnlp.runtime.Translator;
import net.sourceforge.jnlp.util.FileUtils;

public class CacheUtil {
    public static boolean urlEquals(URL u1, URL u2) {
        if (u1 == u2) {
            return true;
        }
        if (u1 == null || u2 == null) {
            return false;
        }
        return CacheUtil.compare(u1.getProtocol(), u2.getProtocol(), true) && CacheUtil.compare(u1.getHost(), u2.getHost(), true) && CacheUtil.compare(u1.getPath(), u2.getPath(), false) && CacheUtil.compare(u1.getQuery(), u2.getQuery(), false) && CacheUtil.compare(u1.getRef(), u2.getRef(), false);
    }

    public static URL getCachedResource(URL location, Version version, UpdatePolicy policy) {
        ResourceTracker rt = new ResourceTracker();
        rt.addResource(location, version, policy);
        try {
            File f = rt.getCacheFile(location);
            return f.toURL();
        }
        catch (MalformedURLException ex) {
            return location;
        }
    }

    private static boolean compare(String s1, String s2, boolean ignore) {
        if (s1 == s2) {
            return true;
        }
        if (s1 == null || s2 == null) {
            return false;
        }
        if (ignore) {
            return s1.equalsIgnoreCase(s2);
        }
        return s1.equals(s2);
    }

    public static Permission getReadPermission(URL location, Version version) {
        if (CacheUtil.isCacheable(location, version)) {
            File file = CacheUtil.getCacheFile(location, version);
            return new FilePermission(file.getPath(), "read");
        }
        try {
            return location.openConnection().getPermission();
        }
        catch (IOException ioe) {
            if (JNLPRuntime.isDebug()) {
                ioe.printStackTrace();
            }
            return null;
        }
    }

    public static void clearCache() {
        if (!CacheUtil.okToClearCache()) {
            System.err.println(Translator.R("CCannotClearCache"));
            return;
        }
        File cacheDir = new File(JNLPRuntime.getConfiguration().getProperty("deployment.user.cachedir"));
        if (!cacheDir.isDirectory()) {
            return;
        }
        if (JNLPRuntime.isDebug()) {
            System.err.println("Clearing cache directory: " + cacheDir);
        }
        try {
            cacheDir = cacheDir.getCanonicalFile();
            FileUtils.recursiveDelete(cacheDir, cacheDir);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static boolean okToClearCache() {
        File otherJavawsRunning = new File(JNLPRuntime.getConfiguration().getProperty("deployment.user.runningfile"));
        try {
            if (!otherJavawsRunning.isFile()) {
                if (!JNLPRuntime.isDebug()) return true;
                System.out.println("No instance file found");
                return true;
            }
            FileOutputStream fis = new FileOutputStream(otherJavawsRunning);
            try {
                FileChannel channel = fis.getChannel();
                if (channel.tryLock() == null) {
                    if (JNLPRuntime.isDebug()) {
                        System.out.println("Other instances of netx are running");
                    }
                    boolean bl = false;
                    return bl;
                }
                if (JNLPRuntime.isDebug()) {
                    System.out.println("No other instances of netx are running");
                }
                boolean bl = true;
                return bl;
            }
            finally {
                fis.close();
            }
        }
        catch (IOException e) {
            return false;
        }
    }

    public static boolean isCurrent(URL source, Version version, URLConnection connection) {
        if (!CacheUtil.isCacheable(source, version)) {
            throw new IllegalArgumentException(Translator.R("CNotCacheable", source));
        }
        try {
            if (connection == null) {
                connection = source.openConnection();
            }
            connection.connect();
            CacheEntry entry = new CacheEntry(source, version);
            boolean result = entry.isCurrent(connection);
            if (JNLPRuntime.isDebug()) {
                System.out.println("isCurrent: " + source + " = " + result);
            }
            return result;
        }
        catch (Exception ex) {
            if (JNLPRuntime.isDebug()) {
                ex.printStackTrace();
            }
            return CacheUtil.isCached(source, version);
        }
    }

    public static boolean isCached(URL source, Version version) {
        if (!CacheUtil.isCacheable(source, version)) {
            throw new IllegalArgumentException(Translator.R("CNotCacheable", source));
        }
        CacheEntry entry = new CacheEntry(source, version);
        boolean result = entry.isCached();
        if (JNLPRuntime.isDebug()) {
            System.out.println("isCached: " + source + " = " + result);
        }
        return result;
    }

    public static boolean isCacheable(URL source, Version version) {
        if (source == null) {
            return false;
        }
        if (source.getProtocol().equals("file")) {
            return false;
        }
        return !source.getProtocol().equals("jar");
    }

    public static File getCacheFile(URL source, Version version) {
        if (!CacheUtil.isCacheable(source, version)) {
            throw new IllegalArgumentException(Translator.R("CNotCacheable", source));
        }
        try {
            String cacheDir = JNLPRuntime.getConfiguration().getProperty("deployment.user.cachedir");
            File localFile = CacheUtil.urlToPath(source, cacheDir);
            localFile.getParentFile().mkdirs();
            return localFile;
        }
        catch (Exception ex) {
            if (JNLPRuntime.isDebug()) {
                ex.printStackTrace();
            }
            return null;
        }
    }

    public static OutputStream getOutputStream(URL source, Version version) throws IOException {
        File localFile = CacheUtil.getCacheFile(source, version);
        FileOutputStream out = new FileOutputStream(localFile);
        return new BufferedOutputStream(out);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void streamCopy(InputStream is, OutputStream os) throws IOException {
        if (!(is instanceof BufferedInputStream)) {
            is = new BufferedInputStream(is);
        }
        if (!(os instanceof BufferedOutputStream)) {
            os = new BufferedOutputStream(os);
        }
        try {
            int c;
            byte[] b = new byte[4096];
            while ((c = is.read(b, 0, b.length)) != -1) {
                os.write(b, 0, c);
            }
        }
        finally {
            is.close();
            os.close();
        }
    }

    public static File urlToPath(URL location, String subdir) {
        if (subdir == null) {
            throw new NullPointerException();
        }
        StringBuffer path = new StringBuffer();
        path.append(subdir);
        path.append(File.separatorChar);
        path.append(location.getProtocol());
        path.append(File.separatorChar);
        path.append(location.getHost());
        path.append(File.separatorChar);
        path.append(location.getPath().replace('/', File.separatorChar));
        return new File(FileUtils.sanitizePath(path.toString()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void waitForResources(ApplicationInstance app, ResourceTracker tracker, URL[] resources, String title) {
        DownloadIndicator indicator = JNLPRuntime.getDefaultDownloadIndicator();
        DownloadServiceListener listener = null;
        try {
            if (indicator == null) {
                tracker.waitForResources(resources, 0L);
                return;
            }
            if (tracker.waitForResources(resources, indicator.getInitialDelay())) {
                return;
            }
            ArrayList<URL> urlList = new ArrayList<URL>();
            for (int i = 0; i < resources.length; ++i) {
                if (tracker.checkResource(resources[i])) continue;
                urlList.add(resources[i]);
            }
            URL[] undownloaded = urlList.toArray(new URL[urlList.size()]);
            listener = indicator.getListener(app, title, undownloaded);
            do {
                long read = 0L;
                long total = 0L;
                for (int i = 0; i < undownloaded.length; ++i) {
                    total += tracker.getTotalSize(undownloaded[i]);
                    read += tracker.getAmountRead(undownloaded[i]);
                }
                int percent = (int)(100L * read / Math.max(1L, total));
                for (int i = 0; i < undownloaded.length; ++i) {
                    listener.progress(undownloaded[i], "version", tracker.getAmountRead(undownloaded[i]), tracker.getTotalSize(undownloaded[i]), percent);
                }
            } while (!tracker.waitForResources(resources, indicator.getUpdateRate()));
            for (int i = 0; i < undownloaded.length; ++i) {
                listener.progress(undownloaded[i], "version", tracker.getTotalSize(undownloaded[i]), tracker.getTotalSize(undownloaded[i]), 100);
            }
            if (listener != null) {
                indicator.disposeListener(listener);
            }
        }
        catch (InterruptedException ex) {
            if (JNLPRuntime.isDebug()) {
                ex.printStackTrace();
            }
        }
        finally {
            if (listener != null) {
                indicator.disposeListener(listener);
            }
        }
    }
}

